/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;

public class PostgresConnection {
    private static final String USAGE = "Usage:\nrun [options] \n -h <DB host>\n -p <DB port>\n -db <DB database>\n -u <DB user>\n -pwd <DB password>\n -sslmode <DB sslmode>, default value is \"disable\" \n -ca <ssl server ca cert pem file>, must have when sslmode is \"verify-ca\" \n -clientcert <ssl client cert pem file>, must have when sslmode is \"verify-ca\" \n -clientkey <ssl client key pkcs8 file>, sslmode is \"verify-ca\" \n";

    private static void printUsage(String string, int n) {
        if (string != null) {
            System.out.println(string);
        }
        System.out.print(USAGE);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "disable";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if ("-help".equals(string)) {
                PostgresConnection.printUsage(null, 0);
                continue;
            }
            if (string.equals("-h")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no DB host", 1);
                }
                string2 = stringArray[i];
                continue;
            }
            if (string.equals("-p")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no DB port", 1);
                }
                string3 = stringArray[i];
                continue;
            }
            if (string.equals("-db")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no DB database", 1);
                }
                string4 = stringArray[i];
                continue;
            }
            if (string.equals("-u")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no DB user", 1);
                }
                string5 = stringArray[i];
                continue;
            }
            if (string.equals("-pwd")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no DB password", 1);
                }
                string6 = stringArray[i];
                continue;
            }
            if (string.equals("-sslmode")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no sslmode", 1);
                }
                string7 = stringArray[i];
                continue;
            }
            if (string.equals("-ca")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no server ca file", 1);
                }
                string8 = stringArray[i];
                continue;
            }
            if (string.equals("-clientcert")) {
                if (++i >= stringArray.length) {
                    PostgresConnection.printUsage("Invalid arguments, no clientcert file", 1);
                }
                string9 = stringArray[i];
                continue;
            }
            if (!string.equals("-clientkey")) continue;
            if (++i >= stringArray.length) {
                PostgresConnection.printUsage("Invalid arguments, no clientkey file", 1);
            }
            string10 = stringArray[i];
        }
        System.out.println(string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6 + " " + string7 + " " + string8 + " " + string9 + " " + string10);
        if (string2.isEmpty()) {
            PostgresConnection.printUsage("DB host not specified!! ", 1);
        }
        if (string3.isEmpty()) {
            PostgresConnection.printUsage("DB port not specified!! ", 1);
        }
        if (string4.isEmpty()) {
            PostgresConnection.printUsage("DB database not specified!! ", 1);
        }
        if (string5.isEmpty()) {
            PostgresConnection.printUsage("DB user not specified!! ", 1);
        }
        if (string6.isEmpty()) {
            PostgresConnection.printUsage("DB password not specified!! ", 1);
        }
        if (string7.equals("verify-ca") && string8.isEmpty()) {
            PostgresConnection.printUsage("DB sslmode is verify-ca, so server ca file is must!! ", 1);
        }
        if (string7.equals("verify-full") && string9.isEmpty()) {
            PostgresConnection.printUsage("DB sslmode is verify-ca, so server ca file is must!! ", 1);
        }
        Connection connection = null;
        string = "jdbc:postgresql://" + string2 + ":" + string3 + "/" + string4 + "?sslmode=" + string7;
        if (string7.equals("verify-full")) {
            string = string + "&sslrootcert=" + string8;
        } else if (string7.equals("verify-ca")) {
            string = string + "&sslrootcert=" + string8;
        }
        if (string9.equals("") || string10.equals("")) {
            System.out.println("verify with password for no client cert file");
        } else {
            string = string + "&sslkey=" + string10 + "&sslcert=" + string9;
        }
        System.out.println(string);
        try {
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(string, string5, string6);
            if (connection != null) {
                System.out.println("Connected to the database Success!");
                long l = System.nanoTime();
                double d = (double)l / 1.0E9;
                double d2 = (double)l % 1.0E9 / 1000000.0;
                connection.isValid(5);
                l = System.nanoTime();
                d = (double)l / 1.0E9;
                double d3 = (double)l % 1.0E9 / 1000000.0;
                System.out.println("Round Trip time: " + (d3 -= d2) + " ms");
            } else {
                System.out.println("Failed to make connection!");
            }
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

