/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SQLConnection {
    private static final String USAGE = "Usage:\nrun [options] \n -h <DB host>\n -p <DB port>\n -d <DB dbname>\n -u <DB user>\n -pwd <DB password>";

    private static void printUsage(String string, int n) {
        if (string != null) {
            System.out.println(string);
        }
        System.out.print(USAGE);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        for (int n = 0; n < stringArray.length; n = (int)((byte)(n + 1))) {
            object = stringArray[n];
            if ("-help".equals(object)) {
                SQLConnection.printUsage(null, 0);
                continue;
            }
            if (((String)object).equals("-h")) {
                if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                    SQLConnection.printUsage("Invalid arguments, no DB host", 1);
                }
                string = stringArray[n];
                continue;
            }
            if (((String)object).equals("-p")) {
                if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                    SQLConnection.printUsage("Invalid arguments, no DB port", 1);
                }
                string2 = stringArray[n];
                continue;
            }
            if (((String)object).equals("-d")) {
                if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                    SQLConnection.printUsage("Invalid arguments, no DB dbname", 1);
                }
                string5 = stringArray[n];
                continue;
            }
            if (((String)object).equals("-u")) {
                if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                    SQLConnection.printUsage("Invalid arguments, no DB user", 1);
                }
                string3 = stringArray[n];
                continue;
            }
            if (((String)object).equals("-pwd")) {
                if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                    SQLConnection.printUsage("Invalid arguments, no DB password", 1);
                }
                string4 = stringArray[n];
                continue;
            }
            if (!((String)object).equals("-ssl")) continue;
            if ((n = (int)((byte)(n + 1))) >= stringArray.length) {
                SQLConnection.printUsage("Invalid arguments, no ssl connection string", 1);
            }
            string7 = stringArray[n];
        }
        if (string.isEmpty()) {
            SQLConnection.printUsage("DB host not specified!! ", 1);
        }
        if (string2.isEmpty()) {
            SQLConnection.printUsage("DB port not specified!! ", 1);
        }
        if (string3.isEmpty()) {
            SQLConnection.printUsage("DB user not specified!! ", 1);
        }
        if (string4.isEmpty()) {
            SQLConnection.printUsage("DB password not specified!! ", 1);
        }
        if (string5.isEmpty()) {
            SQLConnection.printUsage("Database  not specified!! ", 1);
        }
        string6 = string.contains(":") ? "jdbc:sqlserver://;serverName=" + string + ";port=" + string2 + ";database=" + string5 + ";user=" + string3 + ";password=" + string4 : "jdbc:sqlserver://" + string + ":" + string2 + ";database=" + string5 + ";user=" + string3 + ";password=" + string4;
        if (string7 != null && !string7.isEmpty()) {
            string6 = string6 + ";" + string7;
            System.out.println("URL - SSL enabled = " + string6);
        } else {
            System.out.println("URL - SSL disabled = " + string6);
        }
        try {
            Connection connection = DriverManager.getConnection(string6);
            object = null;
            try {
                if (connection != null) {
                    System.out.println("Connected to the database Success!");
                    System.out.println("url=" + string6);
                    long l = System.nanoTime();
                    double d = (double)l / 1.0E9;
                    double d2 = (double)l % 1.0E9 / 1000000.0;
                    connection.isValid(5);
                    l = System.nanoTime();
                    d = (double)l / 1.0E9;
                    double d3 = (double)l % 1.0E9 / 1000000.0;
                    System.out.println("Round Trip time: " + (d3 -= d2) + " ms");
                } else {
                    System.out.println("Failed to connect to the database!");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.format("SQL State: %s\n%s", sQLException.getSQLState(), sQLException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

