/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.exception;

import com.filenet.api.exception.ErrorLoggingLevel;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.LString;
import com.filenet.apiimpl.util.LocaleUtils;
import com.filenet.apiimpl.util.SubSystem;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExceptionCode
extends LString
implements Serializable {
    private static final String RES_BASE_NAME = "res/ExceptionCode";
    private static final BaseLogger stLogger = BaseLogger.getBaseLogger(ExceptionCode.class, SubSystem.API);
    private static Map mapNameToExceptionCodeInstance = new HashMap();
    private transient boolean isFatal = false;
    private transient ErrorLoggingLevel mErrorLoggingLevel = ErrorLoggingLevel.Required;
    public static final Locale stDefaultLocale = Locale.getDefault();
    private String id;
    public static final ExceptionCode API_AFTER_LAST_PAGE_ELEMENT = new ExceptionCode("API_AFTER_LAST_PAGE_ELEMENT", "An attempt was made to get the current page or element count before moving past the last page.", "FNRCA0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_BEFORE_FIRST_PAGE_ELEMENT = new ExceptionCode("API_BEFORE_FIRST_PAGE_ELEMENT", "An attempt was made to get the current page or element count before moving to the first page.", "FNRCA0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_BEFORE_NEXT_PAGE_ELEMENT = new ExceptionCode("API_BEFORE_NEXT_PAGE_ELEMENT", "An attempt was made to get the current page or element count before moving to the next page after a reset operation.", "FNRCA0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EMPTY_BATCH = new ExceptionCode("API_EMPTY_BATCH", "There are no objects in this batch to process.", "FNRCA0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EXPECTED_UNEVALUATED_STATE = new ExceptionCode("API_EXPECTED_UNEVALUATED_STATE", "The property {0} must be in an unevaluated state", "FNRCA0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FETCH_MERGE_PROPERTY_ERROR = new ExceptionCode("API_FETCH_MERGE_PROPERTY_ERROR", "An attempt was made to fetch and merge new property values on an object that has been modified on the server since it was last retrieved. Refresh the object before retrying this operation.", "FNRCA0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FROM_INIT_OR_QUERY_STRING_NOT_SET = new ExceptionCode("API_FROM_INIT_OR_QUERY_STRING_NOT_SET", "Either the setFromClauseInitialValue or setQueryString method must be called prior to calling this method to retrieve the SQL statement.", "FNRCA0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_FROM_INIT_VALUE_NOT_SET = new ExceptionCode("API_FROM_INIT_VALUE_NOT_SET", "The setFromClauseInitialValue method must be called before an additional join using this method can be added.", "FNRCA0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INDEX_OUT_OF_BOUNDS = new ExceptionCode("API_INDEX_OUT_OF_BOUNDS", "The specified index is outside the bounds of the collection.", "FNRCA0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INITIALIZED = new ExceptionCode("API_INITIALIZED", "The API may only be initialized once and is already initialized.", "FNRCA0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_CONFIGURATION_PARAMETER = new ExceptionCode("API_INVALID_CONFIGURATION_PARAMETER", "Invalid configuration parameter: {0}.", "FNRCA0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_CONNECTION_PARAMETER = new ExceptionCode("API_INVALID_CONNECTION_PARAMETER", "Invalid connection parameter: {0}.", "FNRCA0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_METADATA_CACHE_PARAMETER = new ExceptionCode("API_INVALID_METADATA_CACHE_PARAMETER", "This exception code is not used as of CE 4.5.1", "FNRCA0013");
    public static final ExceptionCode API_INVALID_PROPERTY_TYPE = new ExceptionCode("API_INVALID_PROPERTY_TYPE", "Invalid property type {0} expected {1}.", "FNRCA0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_INVALID_URI = new ExceptionCode("API_INVALID_URI", "An invalid URI was found for connection {0}.", "FNRCA0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_J2EE_UTIL_INIT_FAILED = new ExceptionCode("API_J2EE_UTIL_INIT_FAILED", "Failed to initialize the J2EE util class. The class {0} either cannot be found or is not a subclass of J2EEUtil.", "FNRCA0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_METHOD_NO_DEPENDENT_SUPPORT = new ExceptionCode("API_METHOD_NO_DEPENDENT_SUPPORT", "The use of method {0} is not supported for dependent objects {1}.", "FNRCA0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_MULTIPLY_FILED_IN_FOLDER = new ExceptionCode("API_MULTIPLY_FILED_IN_FOLDER", "The specified containee is filed multiple times in this folder, and the operation is unable to determine which occurrence to unfile.", "FNRCA0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_A_CONTENT_TRANSFER = new ExceptionCode("API_NOT_A_CONTENT_TRANSFER", "The referenced ContentElement, {0}, is not a ContentTransfer. It is probably a ContentReference.", "FNRCA0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_A_RESERVATION = new ExceptionCode("API_NOT_A_RESERVATION", "This operation requires a reservation object.", "FNRCA0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NOT_FILED_IN_FOLDER = new ExceptionCode("API_NOT_FILED_IN_FOLDER", "The specified containee is not filed in this folder.", "FNRCA0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_NO_CONTENT_ELEMENTS = new ExceptionCode("API_NO_CONTENT_ELEMENTS", "This exception code is not used as of CE 4.5.1", "FNRCA0022");
    public static final ExceptionCode API_PROPERTY_FETCH_FAILED = new ExceptionCode("API_PROPERTY_FETCH_FAILED", "An attempt was made to get the value of property {0} using one of the fetch methods for the property object. The server request failed.", "FNRCA0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_PROPERTY_NOT_IN_CACHE = new ExceptionCode("API_PROPERTY_NOT_IN_CACHE", "The {0} property was not found in the properties collection.", "FNRCA0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_PROPERTY_TEMPLATE_NOT_FOUND = new ExceptionCode("API_PROPERTY_TEMPLATE_NOT_FOUND", "The PropertyTemplate {0} not found in the property template collection.", "FNRCA0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_READ_ONLY_COLLECTION = new ExceptionCode("API_READ_ONLY_COLLECTION", "This exception code is not used as of CE 4.5.1", "FNRCA0026");
    public static final ExceptionCode API_SAVE_BEFORE_REFRESH = new ExceptionCode("API_SAVE_BEFORE_REFRESH", "This exception code is not used as of CE 4.5.1", "FNRCA0027");
    public static final ExceptionCode API_SESSION_CLASS_NOT_FOUND = new ExceptionCode("API_SESSION_CLASS_NOT_FOUND", "This exception code is not used as of CE 4.5.1", "FNRCA0028");
    public static final ExceptionCode API_SESSION_NOT_IMPL_CORRECTLY = new ExceptionCode("API_SESSION_NOT_IMPL_CORRECTLY", "The internal session class {0}, used to communicate with the server, is not implemented correctly.", "FNRCA0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_SESSION_NOT_SET = new ExceptionCode("API_SESSION_NOT_SET", "This exception code is not used as of CE 4.5.1", "FNRCA0030");
    public static final ExceptionCode API_UNABLE_TO_USE_CONNECTION = new ExceptionCode("API_UNABLE_TO_USE_CONNECTION", "The URI for server communication cannot be determined from the connection object {0}.", "FNRCA0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNEXPECTED_JNDI_ERROR = new ExceptionCode("API_UNEXPECTED_JNDI_ERROR", "The JNDI cannot be accessed.", "FNRCA0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNSUPPORTED_API_CLASS = new ExceptionCode("API_UNSUPPORTED_API_CLASS", "The indicated API class {0} is not supported. This exception is logged.", "FNRCA0033", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_UNSUPPORTED_PROPERTY_TYPE = new ExceptionCode("API_UNSUPPORTED_PROPERTY_TYPE", "An attempt was made to put a property value into the properties collection using a generic Java Object. The object is not of a supported type: {0}.", "FNRCA0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PASSWORD_IS_EMPTY_ERROR = new ExceptionCode("PASSWORD_IS_EMPTY_ERROR", "The password was null or empty when trying to create JAAS Subject.", "FNRCA0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CONFLICTING_CLIENT_CONTEXT = new ExceptionCode("API_CONFLICTING_CLIENT_CONTEXT", "The call to {0} is not permitted because a conflicting client context has already been established. The developer tried to mix proceess, thread and/or dynamic client contexts.", "FNRCA0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CHECKPOINT_UNSUPPORTED = new ExceptionCode("API_CHECKPOINT_UNSUPPORTED", "The PageIterator does not support PageIterator checkpoints.", "FNRCA0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_SEARCH_REQUIRED_VALUES_NULL = new ExceptionCode("API_SEARCH_REQUIRED_VALUES_NULL", "Required parameters for a Stored Search query are null. A Stored Search query requires a Stored Search document reference and a FROM class must be specified.", "FNRCA0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_REMOTE_JB6EAP_EJB_CONTEXT_FAILED = new ExceptionCode("API_REMOTE_JB6EAP_EJB_CONTEXT_FAILED", "The EJB Context lookup on a JBoss EAP 6 remote client failed. This is likely because of a bad connection URL or some other setting in the JNDI environment : {0}.", "FNRCA0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_REMOTE_JB6EAP_BAD_CONNECTION_URI = new ExceptionCode("API_REMOTE_JB6EAP_BAD_CONNECTION_URI", "The CE connection URI for this JBoss EAP 6 remote client is invalid as it must have \"remote:\" at the beginning : {0}.", "FNRCA0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CRCL_CONFIG = new ExceptionCode("API_CRCL_CONFIG", "There was a configuration problem related to Cross-Release ClassLoading.", "FNRCA0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CRCL_REFLECTION_FAIL = new ExceptionCode("API_CRCL_REFLECTION_FAIL", "An exception was thrown during an attempted reflection call. Method signature: {0}.", "FNRCA0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CRCL_REFLECTION_NOSUCH = new ExceptionCode("API_CRCL_REFLECTION_NOSUCH", "A method or constructor could not be found. Method signature: {0}.", "FNRCA0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_CONTENT_STREAM_TO_BYTES_SIZE_MISMATCH = new ExceptionCode("API_CONTENT_STREAM_TO_BYTES_SIZE_MISMATCH", "There was a mismatch in the amount of content read from an input stream to the expected buffer size.  Expected {0}, but read {1}.", "FNRCA0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EXTENDED_STREAM_SIZE_UNAVAILABLE = new ExceptionCode("API_EXTENDED_STREAM_SIZE_UNAVAILABLE", "Content size is unavailable.", "FNRCA0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode API_EXTENDED_STREAM_INVALID_POSITION = new ExceptionCode("API_EXTENDED_STREAM_INVALID_POSITION", "The input stream cannot be set to a position less than zero.  Position attempted was {0}.", "FNRCA0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_ADDON_CREATION_FAILED = new ExceptionCode("PERSIST_ADDON_CREATION_FAILED", "A failure occurred while creating AddOn \"{0}\" in Domain \"{1}\".", "FNRCP0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_ADDON_INSTALLATION_FAILED = new ExceptionCode("PERSIST_ADDON_INSTALLATION_FAILED", "The installation of the AddOn {0} into the object store {1} failed.", "FNRCP0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_BAD_FILTERED_PROPERTY_ID = new ExceptionCode("PERSIST_BAD_FILTERED_PROPERTY_ID", "Bad filtered property ID \"{0}\".", "FNRCP0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANNOT_GET_DATABASE_VERSION = new ExceptionCode("PERSIST_CANNOT_GET_DATABASE_VERSION", "The database version could not be identified.", "FNRCP0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CBR_ENABLE = new ExceptionCode("PERSIST_CANT_CBR_ENABLE", "Cannot set CBREnabled equal to true until the object store has been enabled for CBR.", "FNRCP0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CBR_LOCALE_NOT_SET = new ExceptionCode("PERSIST_CBR_LOCALE_NOT_SET", "The CBRLocale property of the object store must be set before any IndexAreas are created", "FNRCP0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_COMPOUND_DOCUMENT_INTEGRITY = new ExceptionCode("PERSIST_COMPOUND_DOCUMENT_INTEGRITY", "An attempted operation would violate compound document integrity rules.", "FNRCP0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_DATABASE_CHARSET = new ExceptionCode("PERSIST_INVALID_DATABASE_CHARSET", "The character set for this database is invalid.", "FNRCP0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_JOB_IDX_ID = new ExceptionCode("PERSIST_INVALID_JOB_IDX_ID", "The IndexationId {0} property of the IndexJobCollectionItem object does not refer to an existing CmTextSearchIndex object.", "FNRCP0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_SUBSCRIPTION_TARGET = new ExceptionCode("PERSIST_INVALID_SUBSCRIPTION_TARGET", "The specified subscription target is invalid.", "FNRCP0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_NO_COLUMN = new ExceptionCode("PERSIST_NO_COLUMN", "No database column is defined for property ''{0}'' on class ''{1}''. Either the property is not defined as a persistent property or its column definition does not exist.", "FNRCP0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_OBJSTR_DATABASE_TABLES_EXIST = new ExceptionCode("PERSIST_OBJSTR_DATABASE_TABLES_EXIST", "Database tables already exist for ObjectStore: {0}.", "FNRCP0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_SINGLETON_CLASS = new ExceptionCode("PERSIST_SINGLETON_CLASS", "Only one instance of class {0} can be created.  The existing instance must be deleted before a new one can be created.", "FNRCP0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNEXPECTED_PROPERTY_CARDINALITY = new ExceptionCode("PERSIST_UNEXPECTED_PROPERTY_CARDINALITY", "The property cardinality value was unexpected.", "FNRCP0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_DATABASE = new ExceptionCode("PERSIST_UNSUPPORTED_DATABASE", "Unsupported database, type {0}.", "FNRCP0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_DATABASE_VERSION = new ExceptionCode("PERSIST_UNSUPPORTED_DATABASE_VERSION", "Unsupported database version {0} (must have at least {1}).", "FNRCP0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PATH = new ExceptionCode("PERSIST_INVALID_PATH", "Property {0} contains a path name ({1}) that does not exist in the file system of the CE server.", "FNRCP0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PATH_NO_WRITE = new ExceptionCode("PERSIST_INVALID_PATH_NO_WRITE", "Property {0} contains a path name ({1}) that exists in the file system of the CE server, but cannot be written.", "FNRCP0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_USE_ZERO_GUID = new ExceptionCode("PERSIST_CANT_USE_ZERO_GUID", "Creating an object with a Id of all zeroes is not allowed.  Class of object in create attempt was {0}", "FNRCP0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_UNSUPPORTED_FEDERATED_OP = new ExceptionCode("PERSIST_UNSUPPORTED_FEDERATED_OP", "The current operation ({0}) is not supported or invalid for the federated document.", "FNRCP0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_AUDIT_FILTERING_FILTER_EXPRESSION = new ExceptionCode("PERSIST_INVALID_AUDIT_FILTERING_FILTER_EXPRESSION", "The filter expression value {1} is invalid for the audit definition {0}.", "FNRCP0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_AUDIT_FILTERING_FILTERED_PROPERTY = new ExceptionCode("PERSIST_INVALID_AUDIT_FILTERING_FILTERED_PROPERTY", "The filter expression value {1} is invalid for the audit definition property {0}.", "FNRCP0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_PRECONDITION = new ExceptionCode("PERSIST_INVALID_PRECONDITION", "The precondition expression {0} is invalid.", "FNRCP0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_INVALID_POSTCONDITION = new ExceptionCode("PERSIST_INVALID_POSTCONDITION", "The postcondition expression {0} is invalid.", "FNRCP0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_ROOT_DIRECTORY_PATH_NOT_SET = new ExceptionCode("PERSIST_TS_ROOT_DIRECTORY_PATH_NOT_SET", "IBM Content Search Services could not set the root directory path for the {0} index area.", "FNRCP0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TASK_RELATIONSHIP_INTEGRITY = new ExceptionCode("PERSIST_TASK_RELATIONSHIP_INTEGRITY", "An attempted operation would violate task relationship integrity rules.", "FNRCP0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_BAD_AUDIT_DISPOSITION_RULE = new ExceptionCode("PERSIST_BAD_AUDIT_DISPOSITION_RULE", "The specified disposition rule contains a syntax error or an invalid property name:  {0}", "FNRCP0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_TEXTSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_DELETE_TEXTSEARCH_INDEX", "Application code that calls the Content Engine API methods could not delete an index for IBM Content Search Services. The index is in the {0} index area for the {1} object store.", "FNRCP0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_INUSE_TEXTSEARCH_INDEX_AREA = new ExceptionCode("PERSIST_CANT_DELETE_INUSE_TEXTSEARCH_INDEX_AREA", "Application code that calls the Content Engine API methods could not delete the {0} index area that belongs to the {1} object store. An IBM Content Search Services index area cannot be deleted if it contains index data.", "FNRCP0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_SAVE_TEXTSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_SAVE_TEXTSEARCH_INDEX", "Application code that calls the Content Engine API methods could not create an IBM Content Search Services index.", "FNRCP0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_ROOT_DIRECTORY_PATH = new ExceptionCode("PERSIST_TS_INVALID_ROOT_DIRECTORY_PATH", "IBM Content Search Services could not set the root directory path for the {0} index area. The following specified path for the root directory does not exist in the file system or is not accessible to IBM Content Search Services servers: {1}.", "FNRCP0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_MAX_INDEXES_CHANGE = new ExceptionCode("PERSIST_TS_INVALID_MAX_INDEXES_CHANGE", "IBM Content Search Services could not set the maximum number of indexes for the {1} index area. The specified maximum number is less than {0}, which is the current number of indexes in the index area.", "FNRCP0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_ROOT_DIRECTORY_PATH_NO_WRITE = new ExceptionCode("PERSIST_TS_ROOT_DIRECTORY_PATH_NO_WRITE", "IBM Content Search Services could not write index information to the {1} index area with the following root directory path: {0}.", "FNRCP0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INDEXING_LANGUAGE_NOT_SET = new ExceptionCode("PERSIST_TS_INDEXING_LANGUAGE_NOT_SET", "Content Engine could not create an index area because the value of the Indexing Language property is null.", "FNRCP0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_INVALID_INDEXING_LANGUAGE = new ExceptionCode("PERSIST_TS_INVALID_INDEXING_LANGUAGE", "Content Engine could not save the following value for the Indexing Language property because the value is not valid: {0}.", "FNRCP0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_COMPATIBILITY_MODE = new ExceptionCode("PERSIST_RETENTION_COMPATIBILITY_MODE", "The default retention period of the fixed storage area is invalid for an area operating in retention compatibility mode, : Storage area {0} Default Period {1}.", "FNRCP0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_CLOCK_SKEW = new ExceptionCode("PERSIST_RETENTION_CLOCK_SKEW", "The system and RDBMS clocks are skewed, event based retention cannot be applied: skew seconds {0}.", "FNRCP0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_CONSTRAINT_VIOLATED = new ExceptionCode("PERSIST_RETENTION_CONSTRAINT_VIOLATED", "The retention date of the object cannot be altered due to a retention constraint.", "FNRCP0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_DELETE_PREVENTED = new ExceptionCode("PERSIST_RETENTION_DELETE_PREVENTED", "The object cannot be deleted due to a retention constraint.", "FNRCP0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_PERIOD_PREVENTED = new ExceptionCode("PERSIST_RETENTION_PERIOD_PREVENTED", "The Retention Period property of the Storage Area cannot be changed to any value except NOT_ALLOWED: period {0}.", "FNRCP0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_CHANGE_INDEX_REQUEST_STATUS = new ExceptionCode("PERSIST_CANT_CHANGE_INDEX_REQUEST_STATUS", "Content Engine ignored the requested operation to change the status of the \"{0}\" index request.", "FNRCP0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RETENTION_NOT_SUPPORTED = new ExceptionCode("PERSIST_RETENTION_NOT_SUPPORTED", "The retention feature is not supported.", "FNRCP0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_NOT_ALLOWED_INDEX_REQUEST_OPERATION_CHANGE = new ExceptionCode("PERSIST_NOT_ALLOWED_INDEX_REQUEST_OPERATION_CHANGE", "Content Engine ignored the requested change to the operation of the \"{0}\" index request.", "FNRCP0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_TS_CANT_CHANGE_INDEXING_LANGUAGE = new ExceptionCode("PERSIST_TS_CANT_CHANGE_INDEXING_LANGUAGE", "Content Engine could not update the Indexing Language property because the property is deprecated and replaced with the Indexing Languages list property. The Indexing Languages list property already has one or more values set.", "FNRCP0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_NOT_ALLOWED_CBR_ENABLE_CLASS_INDEX_REQUEST = new ExceptionCode("PERSIST_NOT_ALLOWED_CBR_ENABLE_CLASS_INDEX_REQUEST", "Changing the IsCBREnabled property of a class definition for an IndexRequest class is not allowed.", "FNRCP0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RECOVERYITEM_OBJECT_SERIALIZATION_FAILED = new ExceptionCode("PERSIST_RECOVERYITEM_OBJECT_SERIALIZATION_FAILED", "The objects failed to be serialized into a byte array. The id of the object marked for deletion is {0}.", "FNRCP0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RECOVERYITEM_OBJECT_DESERIALIZATION_FAILED = new ExceptionCode("PERSIST_RECOVERYITEM_OBJECT_DESERIALIZATION_FAILED", "The objects failed to be deserialized from a byte array. The id of the object marked for deletion is {0}.", "FNRCP0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RECOVERYITEM_NOT_SUPPORTED = new ExceptionCode("PERSIST_RECOVERYITEM_NOT_SUPPORTED", "A recovery item cannot be created because the original object is not supported for mark for deletion.", "FNRCP0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_RECOVERYITEM_OBJECT_ALREADY_MARKED = new ExceptionCode("PERSIST_RECOVERYITEM_OBJECT_ALREADY_MARKED", "A recovery item cannot be created because the specified original object is already marked for deletion.", "FNRCP0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_DELETE_ELASTICSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_DELETE_ELASTICSEARCH_INDEX", "Application code that calls the Content Engine API methods could not delete an index for Elastic Search. The index is in the {0} index area for the {1} object store.", "FNRCP0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_ES_INVALID_MAX_INDEXES_CHANGE = new ExceptionCode("PERSIST_ES_INVALID_MAX_INDEXES_CHANGE", "IBM Elastic Search Services could not set the maximum number of indexes for the {1} index area. The specified maximum number is less than {0}, which is the current number of indexes in the index area.", "FNRCP0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_CANT_SAVE_ELASTICSEARCH_INDEX = new ExceptionCode("PERSIST_CANT_SAVE_ELASTICSEARCH_INDEX", "Application code that calls the Content Engine API methods could not create an IBM Elastic Search Services index.", "FNRCP0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PERSIST_DOMAIN_LOCKOUT = new ExceptionCode("PERSIST_DOMAIN_LOCKOUT", "The Permissions update may leave no-one with administrative access to the domain. Ensure that at least one permission is present granting Write and Write Permission access to a valid user or group.", "FNRCP0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_CANT_WRITE_CONTENT_FILE = new ExceptionCode("CBR_CANT_WRITE_CONTENT_FILE", "Can''t write content file for element sequence #{0} for object {1}, class {2}, output directory {3}, index area {4}", "FNRCB0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_FILENAME_FOR_CONTENT = new ExceptionCode("CBR_NO_FILENAME_FOR_CONTENT", "Unable to get content element filename for element sequence #{0} for object {1}, class {2}", "FNRCB0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INDEX_NON_REPOSITORY_OBJECT = new ExceptionCode("CBR_INDEX_NON_REPOSITORY_OBJECT", "Single item to full text index with array element #{0} is not a repository object", "FNRCB0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INDEX_BAD_OBJECT_STORE = new ExceptionCode("CBR_INDEX_BAD_OBJECT_STORE", "Single item to full text index with array element #{0} does not have the same object store as the IndexJob", "FNRCB0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NOT_INDEXABLE = new ExceptionCode("CBR_NOT_INDEXABLE", "Item to full text index with array element #{0} is not indexable.", "FNRCB0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_INDEX_AREA_AVAILABLE = new ExceptionCode("CBR_NO_INDEX_AREA_AVAILABLE", "No index area is available to handle full text index request on object store {0}", "FNRCB0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_INDEX_SERVER_AVAILABLE = new ExceptionCode("CBR_NO_INDEX_SERVER_AVAILABLE", "No index server is available to handle full text indexing requests on IndexArea {0}, ObjectStore {1}", "FNRCB0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_UNSUPPORTED_KEY = new ExceptionCode("CBR_UNSUPPORTED_KEY", "Old full text index key encountered -- re-indexation is required with this release.", "FNRCB0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_FULLTEXTROWLIMIT_EXCEEDED = new ExceptionCode("CBR_FULLTEXTROWLIMIT_EXCEEDED", "The FullTextRowLimit has been exceeded. Not all results matching query were returned. Either increase FullTextRowLimit, or refine your full text query to return fewer rows.", "FNRCB0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NOT_INDEXED = new ExceptionCode("CBR_NOT_INDEXED", "Documents submitted to be indexed were not processed (request will be retried).", "FNRCB0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_LOAD_TRANSLATORS_EXCEPTION = new ExceptionCode("CBR_LOAD_TRANSLATORS_EXCEPTION", "An exception occurred while attempting to load translation providers.", "FNRCB0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_DIALECT_NOT_SUPPORTED = new ExceptionCode("CBR_DIALECT_NOT_SUPPORTED", "The full text query dialect ''{0}'' is not supported in the current configuration.", "FNRCB0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_QUERY_PARSE_ERROR = new ExceptionCode("CBR_QUERY_PARSE_ERROR", "An error was detected while parsing the {0} full-text query. {1}", "FNRCB0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INSO_INSTALL_ERROR = new ExceptionCode("CBR_INSO_INSTALL_ERROR", "An error was detected while installing INSO binaries", "FNRCB0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INSO_INSTALL_BINARY_NOT_FOUND = new ExceptionCode("CBR_INSO_INSTALL_BINARY_NOT_FOUND", "INSO binaries files not found", "FNRCB0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ERROR_GETTING_CONTENT_FILE = new ExceptionCode("CBR_ERROR_GETTING_CONTENT_FILE", "Could not get content file for element sequence #{0} for object {1}, class {2}, output directory {3}, index area {4}, status {5}", "FNRCB0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_NO_TEXT_SEARCH_SERVER_FOR_SEARCH = new ExceptionCode("CBR_NO_TEXT_SEARCH_SERVER_FOR_SEARCH", "IBM Content Search Services could not run a query because no search server could be found to run the query. IBM Content Search Services might not be able to communicate with the servers for the {0} object store.", "FNRCB0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ACCESSING_INDEX_FAILED = new ExceptionCode("CBR_TS_ACCESSING_INDEX_FAILED", "An IBM Content Search Services server could not access the {0} index or the directory that contains the index.", "FNRCB0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ACCESSING_TEXT_SEARCH_SERVER_FAILED = new ExceptionCode("CBR_TS_ACCESSING_TEXT_SEARCH_SERVER_FAILED", "IBM Content Search Services could not communicate with the server that runs on the {0}:{1} host and port.", "FNRCB0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_EXEC_SEARCH_QUERY_FAILED = new ExceptionCode("CBR_TS_EXEC_SEARCH_QUERY_FAILED", "An IBM Content Search Services server could not run the following full-text search: {0}.", "FNRCB0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_CREATE_FAILED = new ExceptionCode("CBR_TS_INDEX_CREATE_FAILED", "An IBM Content Search Services server could not create an index.", "FNRCB0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ADMIN_ACTION_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_ADMIN_ACTION_FAILED_EXCEPTION", "IBM Content Search Services could not perform administrative functions for the server that runs on the {0}:{1} host and port.", "FNRCB0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_INDEXING_FAILED_EXCEPTION", "An IBM Content Search Services server could not complete an indexing operation while accessing the {0} index for the server that runs on the {1}:{2} host and port.", "FNRCB0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_QUERY_FAILED_EXCEPTION = new ExceptionCode("CBR_TS_QUERY_FAILED_EXCEPTION", "An IBM Content Search Services server could not run a full-text search. See the Content Engine system log file for the error message stack that includes this error for more information on the specific cause of the error. For information about the location of this log, see \"Viewing the IBM FileNet P8 log files\" in IBM Knowledge Center. If you cannot determine the cause of the error, restart the server. If the error continues to occur, contact IBM Software Support.", "FNRCB0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NULL_PARAM = new ExceptionCode("CBR_TS_NULL_PARAM", "An IBM Content Search Services server could not perform a requested operation because the {0} parameter had a null value.", "FNRCB0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_CTOR = new ExceptionCode("CBR_TS_INDEX_CTOR", "The IBM Content Search Services server that runs on the {0}:{1} host and port could not index a document.", "FNRCB0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_INDEX_FOUND_FOR_INDEXATION_ID = new ExceptionCode("CBR_TS_NO_INDEX_FOUND_FOR_INDEXATION_ID", "The IBM Content Search Services index is missing for objects with indexation ID {0}.", "FNRCB0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_CONN_PARAMS = new ExceptionCode("CBR_TS_INVALID_SERVER_CONN_PARAMS", "The connection parameters for the following IBM Content Search Services server are invalid or missing: host={0}, port={1}.", "FNRCB0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_CREDENTIAL = new ExceptionCode("CBR_TS_INVALID_SERVER_CREDENTIAL", "The IBM Content Search Services server connection token is invalid or missing.", "FNRCB0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_CANNOT_CONNECT_TO_SERVER = new ExceptionCode("CBR_TS_CANNOT_CONNECT_TO_SERVER", "The Content Engine server cannot connect to the IBM Content Search Services server {0} located on host {1}, port {2}.", "FNRCB0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_SERVER_STATUS_CHANGE = new ExceptionCode("CBR_TS_INVALID_SERVER_STATUS_CHANGE", "The IBM Content Search Services server status cannot be set to UNAVAILABLE by using the API.", "FNRCB0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INVALID_SEARCH_DIALECT = new ExceptionCode("CBR_INVALID_SEARCH_DIALECT", "Content Engine could not run a query because the following invalid dialect was passed to the CONTAINS function: {0}.", "FNRCB0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_EMPTY_SEARCH_CRITERIA = new ExceptionCode("CBR_EMPTY_SEARCH_CRITERIA", "Content Engine could not run a query because the SQL statement for the query is not valid.", "FNRCB0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_STATUS = new ExceptionCode("CBR_TS_INVALID_INDEX_STATUS", "The resource status of the IBM Content Search Services index {0} cannot be changed to {1}.", "FNRCB0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_EXCEEDS_MAX_SIZE = new ExceptionCode("CBR_TS_INDEX_EXCEEDS_MAX_SIZE", "The resource status of the IBM Content Search Services index {0} cannot be changed to OPEN because its current size of {1} KB exceeds the maximum size of {2} KB specified by its index area {3}.", "FNRCB0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_EXCEEDS_MAX_INDEXED_OBJECTS = new ExceptionCode("CBR_TS_INDEX_EXCEEDS_MAX_INDEXED_OBJECTS", "The resource status of the IBM Content Search Services index {0} cannot be changed to OPEN because the current number of its indexed objects, {1}, exceeds the maximum of {2} specified on its index area {3}.", "FNRCB0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_INVALID_SEARCH = new ExceptionCode("CBR_INVALID_SEARCH", "Content Engine cannot run a query because the following invalid dialect was passed to the CONTAINS function: {0}. The dialect must be appropriate for the following content search engine that is currently enabled: {1}.", "FNRCB0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_AREA_STATUS = new ExceptionCode("CBR_TS_INVALID_INDEX_AREA_STATUS", "The IBM Content Search Services index area {0} cannot be changed to status: {1}.", "FNRCB0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_BATCH_FAILED = new ExceptionCode("CBR_TS_BATCH_FAILED", "The batch operation for indexing objects to IBM Content Search Services has failed.", "FNRCB0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_ABORTED = new ExceptionCode("CBR_TS_INDEXING_ABORTED", "The IBM Content Search Services indexing operation for indexation ID {0}, index path {1} has stopped.", "FNRCB0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_TIMEOUT = new ExceptionCode("CBR_TS_INDEXING_TIMEOUT", "An indexing operation for indexation ID {0}, index path {1} was stopped because it timed out after {2} seconds.", "FNRCB0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_UNEXPECTED_SERVER_FOR_INDEX = new ExceptionCode("CBR_TS_UNEXPECTED_SERVER_FOR_INDEX", "The IBM Content Search Services server {0} was expected, but server {1} was found instead. The current indexing batch for IBM Content Search Services index {3} was stopped.", "FNRCB0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_MISSING_INDEX_LEASE_EXPIRY_TIME = new ExceptionCode("CBR_TS_MISSING_INDEX_LEASE_EXPIRY_TIME", "The IBM Content Search Services index does not have an expiration time. The current indexing batch for index {0} will be stopped.", "FNRCB0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_DEFER_INDEXING = new ExceptionCode("CBR_TS_DEFER_INDEXING", "IBM Content Search Services indexing is deferred for index {0} on index area {1} and object store {2}. {3}", "FNRCB0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_CANNOT_CREATE_INDEX_IN_INDEX_AREA = new ExceptionCode("CBR_TS_CANNOT_CREATE_INDEX_IN_INDEX_AREA", "IBM Content Search Services is unable to create an index in index area {0} of object store {1}.", "FNRCB0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_INDEX_AREA_FOUND_FOR_INDEXATION_ID = new ExceptionCode("CBR_TS_NO_INDEX_AREA_FOUND_FOR_INDEXATION_ID", "The IBM Content Search Services index area is missing for objects with indexation ID {0}.", "FNRCB0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_MIGRATION_JOB_DELETE_NOT_ALLOWED = new ExceptionCode("CBR_MIGRATION_JOB_DELETE_NOT_ALLOWED", "Content Engine could not delete migration index job {0}.", "FNRCB0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_MIGRATION_JOB_ABORT_NOT_ALLOWED = new ExceptionCode("CBR_MIGRATION_JOB_ABORT_NOT_ALLOWED", "Content Engine could not stop migration index job {0}.", "FNRCB0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INVALID_INDEX_AREA_SITE = new ExceptionCode("CBR_TS_INVALID_INDEX_AREA_SITE", "The site for the IBM Content Search Services index area is not valid.", "FNRCB0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_DELETE_FAILED = new ExceptionCode("CBR_TS_INDEX_DELETE_FAILED", "An IBM Content Search Services server could not delete an index.", "FNRCB0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_TEXT_SEARCH_ENABLING_FAILED = new ExceptionCode("CBR_TS_TEXT_SEARCH_ENABLING_FAILED", "IBM Content Search Services was not enabled for the {0} object store because no index areas exist. Create an index area before attempting to enable IBM Content Search Services again.", "FNRCB0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_DELETE = new ExceptionCode("CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_DELETE", "IBM Content Search Services could not delete index {0} in object store {1}.", "FNRCB0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_JOB_PAUSE_NOT_ALLOWED = new ExceptionCode("CBR_TS_JOB_PAUSE_NOT_ALLOWED", "Content Engine did not pause the \"{0}\" index job. The index job has a status of {1} and a JobAbortRequested value of \"{2}\". To be paused, an index job must have a status of PENDING or IN_PROGRESS, and its JobAbortRequested property value must be null or false.", "FNRCB0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_DATA_DELETE_FAILED = new ExceptionCode("CBR_TS_INDEX_DATA_DELETE_FAILED", "IBM Content Search Services did not delete the \"{0}\" index as part of the reindexing that was performed for an index job. The reindexing completed successfully except for the deletion of the index. The index is no longer used and does not need to be reindexed again. To reclaim disk space, delete the index. For information about deleting the index, see \"Deleting an unused index\" in the IBM Knowledge Center.", "FNRCB0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_VALIDATION_FAILED = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_VALIDATION_FAILED", "Content Engine did not save the entered \"{0}\" value for the Indexing Language property because it was not validated by IBM Content Search Services.", "FNRCB0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_REISSUE_INDEX_REQUEST_FAILED = new ExceptionCode("CBR_TS_REISSUE_INDEX_REQUEST_FAILED", "The processing of some index requests was delayed because IBM Content Search Services reassigned the requests to another index.", "FNRCB0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_JOB_RESUME_NOT_ALLOWED = new ExceptionCode("CBR_TS_JOB_RESUME_NOT_ALLOWED", "Content Engine did not resume the \"{0}\" index job. The index job has a status of {1}. To be resumed, an index job must have a status of PAUSED.", "FNRCB0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INSO_FILTER_MISSING_FOR_TEXT_EXTRACTION = new ExceptionCode("CBR_TS_INSO_FILTER_MISSING_FOR_TEXT_EXTRACTION", "Content Engine did not submit index requests to IBM Content Search Services because the required client files are not installed.", "FNRCB0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INSO_FILTER_MISSING_FOR_INDEXING = new ExceptionCode("CBR_TS_INSO_FILTER_MISSING_FOR_INDEXING", "Content Engine did not complete the submission of index requests to IBM Content Search Services because the required client files are not installed.", "FNRCB0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_WARNING = new ExceptionCode("CBR_TS_INDEXING_WARNING", "IBM Content Search Services generated a warning while accessing the \"{0}\" index for an otherwise successful indexing operation.", "FNRCB0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_ICC_CHECK = new ExceptionCode("CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_ICC_CHECK", "IBM Content Search Services could not perform a check for ICC dual migration state on ObjectStore {0}.", "FNRCB0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_NOT_SET = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_NOT_SET", "CBR indexing and searching on object store \"{0}\" cannot proceed until one or more values are set for the TextSearchIndexingLanguages property.", "FNRCB0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEX_AREA_ROOT_DIRECTORY_VALIDATION_FAILED = new ExceptionCode("CBR_TS_INDEX_AREA_ROOT_DIRECTORY_VALIDATION_FAILED", "The Content Engine server did not accept the entered value \"{0}\" for the root directory that was specified for index area \"{1}\" because no IBM Content Search Services servers are available for validation.", "FNRCB0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_ACCESSING_COLLECTION_FAILED = new ExceptionCode("CBR_TS_ACCESSING_COLLECTION_FAILED", "The IBM Content Search Services server failed to access the index on the file system. CSS server: {0}, Object store: {1}, index area: {2}, index: {3}.", "FNRCB0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_DEFER_INDEXING_REBALANCING = new ExceptionCode("CBR_TS_DEFER_INDEXING_REBALANCING", "IBM Content Search Services indexing is rebalancing index {0} on index area {1} and object store {2} to another server. {3}", "FNRCB0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_TEXT_SEARCH_NOT_ENABLED_LCSE_CONFIGURED = new ExceptionCode("CBR_TS_TEXT_SEARCH_NOT_ENABLED_LCSE_CONFIGURED", "IBM Content Search Services cannot be enabled for the {0} object store because LCSE is configured.  Legacy Content Engine (LCSE) objects are configured on the object store but LCSE is not supported in this release. Please check the documentation for the procedure to decommission LCSE and delete the appropriate objects.", "FNRCB0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_REPLACING_INDEX_STATUS_CHANGE = new ExceptionCode("CBR_TS_REPLACING_INDEX_STATUS_CHANGE", "The resource status of the IBM Content Search Services index {0} cannot be changed to {1}.", "FNRCB0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_LANGUAGE_VALIDATION = new ExceptionCode("CBR_TS_NO_TEXT_SEARCH_SERVER_FOR_LANGUAGE_VALIDATION", "IBM Content Search Services cannot validate the indexing languages. No IBM Content Search Services servers are available to validate the specified indexing languages. There might not be any servers configured or the IBM Content Search Services might not be able to communicate with the servers.", "FNRCB0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_NULL = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_NULL", "One or more values must be set for the TextSearchIndexingLanguages property when IBM Content Search Services is enabled on the object store.", "FNRCB0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_UNAVAILABLE_INDEX_STATUS_CHANGE = new ExceptionCode("CBR_TS_UNAVAILABLE_INDEX_STATUS_CHANGE", "The resource status of the IBM Content Search Services index {0} cannot be changed to {1}.", "FNRCB0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_COST_ESTIMATION_QUERY_TIMEOUT = new ExceptionCode("CBR_TS_COST_ESTIMATION_QUERY_TIMEOUT", "A timeout was received from the IBM Content Search Services server while it was running a cost estimation query \"{0}\" against IBM Content Search Services index {1}.", "FNRCB0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_HAS_TIMEDOUT = new ExceptionCode("CBR_TS_INDEXING_HAS_TIMEDOUT", "An indexing operation has been terminated because an index batch timeout occurred.", "FNRCB0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_STATIC_SUMMARY_INVALID_INDEXING_SIZE = new ExceptionCode("CBR_TS_STATIC_SUMMARY_INVALID_INDEXING_SIZE", "The summary indexing size for IBM Content Search Services must be between {0} and {1}. The entered value is {2}.", "FNRCB0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_UNAVAILABLE_INVALID_DURING_RESYNC = new ExceptionCode("CBR_TS_UNAVAILABLE_INVALID_DURING_RESYNC", "The resource status of the IBM Content Search Services index {0} cannot be changed to UNAVAILABLE because a resync index job is in progress on this index.", "FNRCB0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TEXT_PREPROCESSOR_INVALID_OUTPUT_TYPE = new ExceptionCode("CBR_TEXT_PREPROCESSOR_INVALID_OUTPUT_TYPE", "The text indexing preprocessor returned an invalid output type of {0} and a value of text/plain or text/xml was expected", "FNRCB0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TEXT_PREPROCESSOR_DEF_ONE_XML_ALLOWED = new ExceptionCode("CBR_TEXT_PREPROCESSOR_DEF_ONE_XML_ALLOWED", "Only one text indexing preprocessor can be associated to a class when the output type is XML", "FNRCB0097", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_PREPROCESSOR_TIMEOUT = new ExceptionCode("CBR_TS_PREPROCESSOR_TIMEOUT", "An indexing operation was stopped because the text indexing preprocesors timed out after {0} seconds.", "FNRCB0098", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TEXT_PREPROCESSOR_EXTRACT_RETRY = new ExceptionCode("CBR_TEXT_PREPROCESSOR_EXTRACT_RETRY", "The text indexing preprocessor has called for content to be extracted for object {0} class {1} and the call will be retried. {3}", "FNRCB0099", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_EXTRACTION_TIMEOUT = new ExceptionCode("CBR_TS_EXTRACTION_TIMEOUT", "An indexing operation was stopped because text extraction timed out after {0} seconds.", "FNRCB0100", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_FAILED_TEMPFILE_EXCEPTION = new ExceptionCode("CBR_TS_INDEXING_FAILED_TEMPFILE_EXCEPTION", "An IBM Content Search Services server could not complete an indexing operation for index {0} for the server that runs on the {1}:{2} host and port. Failure occurred adding file to the {3} temporary-file directory.", "FNRCB0101", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_REST_API_ERROR = new ExceptionCode("CBR_ES_REST_API_ERROR", "The Elasticsearch REST API call ({0}) failed with error code {1} for URL {3}. The response text is {4}.", "FNRCB0102", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_HTTP_REST_API_EXCEPTION = new ExceptionCode("CBR_ES_HTTP_REST_API_EXCEPTION", "The Elasticsearch HTTP REST method ({0}) failed for URL {1}. The exception message is {2}.", "FNRCB0103", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INDEX_READ_STREAM_ERROR = new ExceptionCode("CBR_ES_INDEX_READ_STREAM_ERROR", "Elasticsearch indexing failed to read content input stream for object id {0}. The exception message is {1}.", "FNRCB0104", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INDEX_CONVERT_STREAM_ERROR = new ExceptionCode("CBR_ES_INDEX_CONVERT_STREAM_ERROR", "Elasticsearch indexing failed to convert content input stream to string for object id {0}. The exception message is {1}.", "FNRCB0105", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_UNEXPECTED_BEGIN_END_BATCH = new ExceptionCode("CBR_ES_UNEXPECTED_BEGIN_END_BATCH", "Elasticsearch indexing received an unexpected and out of sequence {0} batch marker.", "FNRCB0106", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_UNEXPECTED_CONTINUATION = new ExceptionCode("CBR_ES_UNEXPECTED_CONTINUATION", "Elasticsearch query received an unexpected continuation {0} for a non-continuation query.", "FNRCB0107", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_PARSE_CONTINUATION_ERROR = new ExceptionCode("CBR_ES_PARSE_CONTINUATION_ERROR", "Elasticsearch query failed to parse the continuation {0}.  The exception message is {1}.", "FNRCB0108", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_PARSE_JSON_RESPONSE_ERROR = new ExceptionCode("CBR_ES_PARSE_JSON_RESPONSE_ERROR", "Elasticsearch failed to parse json response for {0}.  The exception message is {1}.", "FNRCB0109", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INVALID_NODE_NAMES = new ExceptionCode("CBR_ES_INVALID_NODE_NAMES", "The node names parameter for the Elastic Search Cluster [{0}] are invalid or missing.", "FNRCB0110", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_CANNOT_CONNECT_TO_CLUSTER = new ExceptionCode("CBR_ES_CANNOT_CONNECT_TO_CLUSTER", "The Content Engine server cannot connect to the Elastic Search Cluster {0} located on host {1}.", "FNRCB0111", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_NO_CLUSTER = new ExceptionCode("CBR_ES_NO_CLUSTER", "There is no Elastic Search Cluster in the Domain.", "FNRCB0112", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_ERROR = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_ERROR", "Content Engine did not save the supplied value for the Indexing Language property because there is no Text Search Index Area.", "FNRCB0113", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INDEXING_ANALYZER_ERROR = new ExceptionCode("CBR_ES_INDEXING_ANALYZER_ERROR", "Content Engine did not save the supplied value for the Analyzers property because there is no Elastic Search Index Area.", "FNRCB0114", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INDEXING_ANALYZER_VALIDATION_FAILED = new ExceptionCode("CBR_ES_INDEXING_ANALYZER_VALIDATION_FAILED", "Content Engine did not save the entered \"{0}\" value for the Analyzer property because it was not validated by IBM Content Engine.", "FNRCB0115", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_ANALYZER_NOT_SET = new ExceptionCode("CBR_ES_ANALYZER_NOT_SET", "Content Engine cannot enable Text Search because the Analyzers property is not set on the Object Store.", "FNRCB0116", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_LANGUAGE_NOT_SET = new ExceptionCode("CBR_TS_LANGUAGE_NOT_SET", "Content Engine cannot enable Text Search because the Indexing Languages property is not set on the Object Store.", "FNRCB0117", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_CLUSTER_NO_ANALYZERS = new ExceptionCode("CBR_ES_CLUSTER_NO_ANALYZERS", "The Elastic Search Cluster contains no Analyzers.", "FNRCB0118", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_NULL_ANALYZERS = new ExceptionCode("CBR_ES_NULL_ANALYZERS", "One or more values must be set for the Analyzers property when Elastic Search indexing is enabled on the object store.", "FNRCB0119", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_NO_INDEX_AREA = new ExceptionCode("CBR_ES_NO_INDEX_AREA", "Elastic Search indexing cannot be enabled since there is no Elastic Search Index Area for the object store \"{0}\".", "FNRCB0120", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_UNSUPPORTED_VERSION = new ExceptionCode("CBR_ES_UNSUPPORTED_VERSION", "The Elastic Search Cluster software version [{0}] is not supported.", "FNRCB0121", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_RESYNC_JOB_NOT_SUPPORTED = new ExceptionCode("CBR_ES_RESYNC_JOB_NOT_SUPPORTED", "Elastic Search does not support index resync job items.", "FNRCB0122", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_CANNOT_DELETE_CLUSTER = new ExceptionCode("CBR_ES_CANNOT_DELETE_CLUSTER", "The Content Engine server cannot delete the Elastic Search Cluster {0} until all Elasticsearch Index Areas have been deleted.", "FNRCB0123", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_POINT_IN_TIME_SEARCH_NOT_SUPPORTED = new ExceptionCode("CBR_ES_POINT_IN_TIME_SEARCH_NOT_SUPPORTED", "Paged CBR query with rank order terminated because the Elastic Search Cluster {0} does not support point in time search.", "FNRCB0124", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_TS_INDEXING_LANGUAGE_FAILED_NO_INDEXAREA = new ExceptionCode("CBR_TS_INDEXING_LANGUAGE_FAILED_NO_INDEXAREA", "Content Engine did not save the entered \"{0}\" value for the Indexing Language property, it was not validated by IBM Content Search Services either because no Content Search Services server is running or no index area has been created.", "FNRCB0125", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INDEX_NOT_CREATED = new ExceptionCode("CBR_ES_INDEX_NOT_CREATED", "The Elastic Search Index {0} has not yet been created, submit at least one object for indexing before altering the index settings.", "FNRCB0126", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_INVALID_ALTER_INDEX = new ExceptionCode("CBR_ES_INVALID_ALTER_INDEX", "The Elastic Search Index {0} settings cannot be altered due to the supplied combination of IndexShards, IndexReplicas, and MaximumResultsWindow properties being invalid.", "FNRCB0127", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CBR_ES_CANNOT_INITIATE_ALTER_INDEX = new ExceptionCode("CBR_ES_CANNOT_INITIATE_ALTER_INDEX", "The Elastic Search Index {0} alter operation could not be initiated since another alter operation is in progress.", "FNRCB0128", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONVERSION_HANDLER_THREW = new ExceptionCode("CONVERSION_HANDLER_THREW", "An exception occurred in the content conversion handler.", "FNRCN0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONVERSION_HANDLER_NOT_FOUND = new ExceptionCode("CONVERSION_HANDLER_NOT_FOUND", "Content conversion handler capable of converting content from {0} to {1} could not be found.", "FNRCN0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONVERSION_SETTINGS_NOT_FOUND = new ExceptionCode("CONTENT_CONVERSION_SETTINGS_NOT_FOUND", "An RmsTranscriptionSettings property must be set on a Transcription Sweep Job, sweep job {0} does not have an RmsTranscriptionSettings property.", "FNRCN0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONVERSION_CAN_NOT_RESUME = new ExceptionCode("CONTENT_CONVERSION_CAN_NOT_RESUME", "The Content Platform Engine server cannot resume the content conversion operation, the content conversion settings class is {0}.", "FNRCN0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_ACTION_NO_HANDLER = new ExceptionCode("EVENT_ACTION_NO_HANDLER", "Unable to get the EventAction handler for {0}.", "FNRCV0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_BAD_EVENT_TYPE = new ExceptionCode("EVENT_BAD_EVENT_TYPE", "Bad event type {0}.", "FNRCV0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_BAD_SUBSCRIPTION_TYPE = new ExceptionCode("EVENT_BAD_SUBSCRIPTION_TYPE", "Bad subscription type {0}.", "FNRCV0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_RESERVATION_NOT_ALLOWED = new ExceptionCode("EVENT_CM_RESERVATION_NOT_ALLOWED", "Code module value for Action object does not permit a reservation.", "FNRCV0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_EXTERNAL_FAILURE = new ExceptionCode("EVENT_EXTERNAL_FAILURE", "The Event handler threw an external failure.", "FNRCV0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_HANDLER_THREW = new ExceptionCode("EVENT_HANDLER_THREW", "An exception occurred in the event handler.", "FNRCV0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_NO_SCRIPT = new ExceptionCode("EVENT_NO_SCRIPT", "There is no script defined for the event action \"{0}\", id={1}.", "FNRCV0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_QUEUEITEM_NO_HANDLER = new ExceptionCode("EVENT_QUEUEITEM_NO_HANDLER", "Unable to get a handler for the QueueItem {0}.", "FNRCV0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_QUEUEITEM_UNKNOWN_CLASS = new ExceptionCode("EVENT_QUEUEITEM_UNKNOWN_CLASS", "Unknown QueueItem class {0}.", "FNRCV0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_HANDLER_VALIDATION_FAILED = new ExceptionCode("EVENT_HANDLER_VALIDATION_FAILED", "Unable to load event handler class from either associated code module or system classpath: {0}.", "FNRCV0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_USER_ABORT = new ExceptionCode("EVENT_USER_ABORT", "The event action is aborted by user.", "FNRCV0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_CONTENTREFERENCE_NOT_ALLOWED = new ExceptionCode("EVENT_CM_CONTENTREFERENCE_NOT_ALLOWED", "Code module does not permit ContentReference object as content element.", "FNRCV0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_INFINITE_LOOP_DETECTED = new ExceptionCode("EVENT_INFINITE_LOOP_DETECTED", "Infinite loop in synchronous event processing detected. A maximum of {0} recursive event handler invocation is allowed within one execution thread.", "FNRCV0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_DUPLICATE_LIST_SUBSCRIBED_EVENT = new ExceptionCode("EVENT_DUPLICATE_LIST_SUBSCRIBED_EVENT", "A duplicate entry was detected in the subscribed event list.", "FNRCV0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_INCOMPATIBLE_JAVA_VERSION = new ExceptionCode("EVENT_CM_INCOMPATIBLE_JAVA_VERSION", "Incompatible Java class: {0} detected in code module. JVM version for application server is: {1}. Please make sure that all Java classes in code module are compiled with compatible JDK (same or older version than application server JVM version).", "FNRCV0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_CIRCULARITY = new ExceptionCode("EVENT_CM_CIRCULARITY", "The Java Runtime Environment detected a cirularity error when trying to define Code Module class {0} from content element {1}. That is usually caused by unusual classpath arrangements, unsual class dependencies, or duplicate items on the classpath.", "FNRCV0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_CLASS_FORMAT = new ExceptionCode("EVENT_CM_CLASS_FORMAT", "The Java Runtime Environment detected a format error when trying to define Code Module class {0} from content element {1}. Either the Code Module content element does not contain a Java class file, or the Java class file was compiled with a newer version of Java than that of the application server Java Runtime Environment.", "FNRCV0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_CACHE_LOOP = new ExceptionCode("EVENT_CM_CACHE_LOOP", "The Code Module classloader tried and failed {0} times to cache a JAR or ZIP file from a content element to a temporary file in directory {1}.", "FNRCV0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_UNEXPECTED_OBJECT = new ExceptionCode("EVENT_CM_UNEXPECTED_OBJECT", "An object with content was expected, which is limited to Document class, Annotation class, and their subclasses. An object of class {0} was found for URI {1}.", "FNRCV0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_ELTNO_NOT_FOUND = new ExceptionCode("EVENT_CM_ELTNO_NOT_FOUND", "There is no content element number {0} for the object identified by URI {1}.", "FNRCV0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_ESN_NOT_FOUND = new ExceptionCode("EVENT_CM_ESN_NOT_FOUND", "There is no content element sequence number {0} for the object identified by URI {1}.", "FNRCV0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_ELT_NUMBERING_MISMATCH = new ExceptionCode("EVENT_CM_ELT_NUMBERING_MISMATCH", "A content element numbering inconsistency was found. Element {0} did not have the element sequence number {1} for URI {2}.", "FNRCV0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_CM_ELT_NOT_CT = new ExceptionCode("EVENT_CM_ELT_NOT_CT", "The content element identified by URI {0} is not a Content Transfer element.", "FNRCV0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode EVENT_DISPATCH_EXTERNAL = new ExceptionCode("EVENT_DISPATCH_EXTERNAL", "Failure to dispatch the external event .", "FNRCV0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ACCESS_DENIED = new ExceptionCode("E_ACCESS_DENIED", "The requester has insufficient access rights to perform the requested operation.", "FNRCE0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_CLASSID = new ExceptionCode("E_BAD_CLASSID", "Class \"{0}\" not found.", "FNRCE0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_FILTER_EXPRESSION = new ExceptionCode("E_BAD_FILTER_EXPRESSION", "Bad filter expression \"{0}\".", "FNRCE0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_INDEX = new ExceptionCode("E_BAD_INDEX", "The index specified does not reference a valid property or list element.", "FNRCE0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_OBJECT = new ExceptionCode("E_BAD_OBJECT", "An inappropriate object was passed as parameter to this function. For example, the object does not support a required interface or is of an inappropriate class.", "FNRCE0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_OPERATOR = new ExceptionCode("E_BAD_OPERATOR", "The operator \"{0}\" is not defined in the metadata of the current scope.", "FNRCE0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_PARAMETER = new ExceptionCode("E_BAD_PARAMETER", "Invalid input parameter: Name={0}, Value={1}.", "FNRCE0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_PROPERTYID = new ExceptionCode("E_BAD_PROPERTYID", "The property identifier {0} is not valid for class {1}.", "FNRCE0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_URL = new ExceptionCode("E_BAD_URL", "The resource URL is not syntactically valid.", "FNRCE0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BAD_VALUE = new ExceptionCode("E_BAD_VALUE", "The value given for a property or list element lies outside the permitted range or value set, or exceeds the maximum length allowed.", "FNRCE0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLASS_LOADING_ERROR = new ExceptionCode("E_CLASS_LOADING_ERROR", "Unable to load class: {0}.", "FNRCE0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLASS_NOT_SEARCHABLE = new ExceptionCode("E_CLASS_NOT_SEARCHABLE", "The class \"{0}\" referred to in the FROM Expression is not searchable.", "FNRCE0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CLOSED_STREAM = new ExceptionCode("E_CLOSED_STREAM", "An operation was attempted on a stream that has been closed.", "FNRCE0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CONFLICTING_OPERATION = new ExceptionCode("E_CONFLICTING_OPERATION", "The combination of operations specified for the object is invalid.", "FNRCE0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_CONSTRAINT_VIOLATED = new ExceptionCode("E_CONSTRAINT_VIOLATED", "The operation violates a constraint of the implementation.", "FNRCE0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATABASE_ERROR = new ExceptionCode("E_DATABASE_ERROR", "The operation was unable to read from or write to the database.", "FNRCE0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATABASE_FULL = new ExceptionCode("E_DATABASE_FULL", "The database is full.", "FNRCE0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DATATYPE_MISMATCH = new ExceptionCode("E_DATATYPE_MISMATCH", "The method invoked is inappropriate for the datatype of the property.", "FNRCE0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DEADLOCK_ERROR = new ExceptionCode("E_DEADLOCK_ERROR", "The operation could not be completed due to a deadlock error. A retry might be appropriate.", "FNRCE0019", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DUPLICATE_LIST_UPDATE = new ExceptionCode("E_DUPLICATE_LIST_UPDATE", "A duplicate entry was detected in the list update operation at the position {0}.", "FNRCE0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ENUM_NAME_KEY_MATCH_FAILED = new ExceptionCode("E_ENUM_NAME_KEY_MATCH_FAILED", "The enum field name \"{0}\" does not match a resource key \"{1}\" for the ExceptionCode fields.", "FNRCE0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_EXCEPTION_RETRY = new ExceptionCode("E_EXCEPTION_RETRY", "There was a problem communicating with the client application. The exception is not fatal and the request can be resubmitted to the server.", "FNRCE0022", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode E_FAILED = new ExceptionCode("E_FAILED", "The operation failed.", "FNRCE0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_FAILED_TO_GET_DATASOURCE = new ExceptionCode("E_FAILED_TO_GET_DATASOURCE", "The server cannot get the data source {0}.", "FNRCE0024", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_FOREIGN_OBJECT = new ExceptionCode("E_FOREIGN_OBJECT", "The property does not allow a reference to an object from a different object store.", "FNRCE0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_HEAP_FAILURE = new ExceptionCode("E_HEAP_FAILURE", "The operation ran out of memory.", "FNRCE0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_ILLEGAL_OPERATION = new ExceptionCode("E_ILLEGAL_OPERATION", "The operation is disallowed by the DMA Specification.", "FNRCE0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ARGUMENT = new ExceptionCode("E_INVALID_ARGUMENT", "An internal problem occurred when a method was called with an invalid argument: {0}", "FNRCE0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ENUM_VALUE = new ExceptionCode("E_INVALID_ENUM_VALUE", "An attempt was made to create an enum with a value that is not allowed for this enum. The invalid value is {0}.", "FNRCE0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_ID = new ExceptionCode("E_INVALID_ID", "An attempt was made to create an EngineObject, but the ID value specified is invalid. An ID in the form of GUID, Path, or Name is required.", "FNRCE0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_LOCALE_FORMAT = new ExceptionCode("E_INVALID_LOCALE_FORMAT", "The format of the provided locale \"{0}\" does not resemble that defined in RFC 3066.", "FNRCE0031", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJECT_ADDRESS = new ExceptionCode("E_INVALID_OBJECT_ADDRESS", "An unsupported implementation of ObjectAddress was found {0}.", "FNRCE0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJECT_TYPE = new ExceptionCode("E_INVALID_OBJECT_TYPE", "Invalid object type {0}.", "FNRCE0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_OBJ_FOR_SERIALIZATION = new ExceptionCode("E_INVALID_OBJ_FOR_SERIALIZATION", "Invalid object for serialization {0}.", "FNRCE0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_PROPERTY_MERGE = new ExceptionCode("E_INVALID_PROPERTY_MERGE", "A property merge of PropertyUpdateList requires a corresponding engine object collection value {0}; from {1} to {2}.", "FNRCE0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_REQUEST = new ExceptionCode("E_INVALID_REQUEST", "The parameter is incorrect.", "FNRCE0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_JBOSS_INVALID_CONFIGURATION = new ExceptionCode("E_JBOSS_INVALID_CONFIGURATION", "The JBoss configuration is invalid.", "FNRCE0037", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_LDAP_INVALID_CONFIGURATION = new ExceptionCode("E_LDAP_INVALID_CONFIGURATION", "Cannot detect LDAP vendor.  Check LDAP configuration.", "FNRCE0038", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_METHOD_NOT_IMPLEMENTED = new ExceptionCode("E_METHOD_NOT_IMPLEMENTED", "The method that was called is not implemented.", "FNRCE0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_AUTHENTICATED = new ExceptionCode("E_NOT_AUTHENTICATED", "The user is not authenticated.", "FNRCE0040", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_CREATABLE = new ExceptionCode("E_NOT_CREATABLE", "Creation of objects of the specified class is not supported.", "FNRCE0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_SUPPORTED = new ExceptionCode("E_NOT_SUPPORTED", "This method is not supported in the context of this session or object.", "FNRCE0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_UNIQUE = new ExceptionCode("E_NOT_UNIQUE", "A uniqueness requirement has been violated.", "FNRCE0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NO_CURRENT_VERSION = new ExceptionCode("E_NO_CURRENT_VERSION", "The version series has no current version.", "FNRCE0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NULL_ARGUMENT = new ExceptionCode("E_NULL_ARGUMENT", "Argument \"{0}\" is null.", "FNRCE0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NULL_OR_INVALID_PARAM_VALUE = new ExceptionCode("E_NULL_OR_INVALID_PARAM_VALUE", "Parameter {0} is either null or has an invalid value.", "FNRCE0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_CLONE_FAILED = new ExceptionCode("E_OBJECT_CLONE_FAILED", "Failed to clone object {0}.", "FNRCE0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_DELETED = new ExceptionCode("E_OBJECT_DELETED", "The object {0} has been deleted since it was retrieved.", "FNRCE0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_LOCKED = new ExceptionCode("E_OBJECT_LOCKED", "The lock(s) on the persistent object {0} prohibit the attempted operation.", "FNRCE0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_MODIFIED = new ExceptionCode("E_OBJECT_MODIFIED", "The object {0} of class {1} was not changed or deleted because it was modified one or more times in the repository since the application retrieved it.", "FNRCE0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_NOT_FOUND = new ExceptionCode("E_OBJECT_NOT_FOUND", "The requested item was not found.", "FNRCE0051", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode E_OBJECT_NOT_LOCKABLE = new ExceptionCode("E_OBJECT_NOT_LOCKABLE", "The object cannot be locked. Only Document, Folder, and CustomObject objects can be locked.", "FNRCE0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_NOT_LOCKED = new ExceptionCode("E_OBJECT_NOT_LOCKED", "The object {0} is not locked.", "FNRCE0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_REFERENCED = new ExceptionCode("E_OBJECT_REFERENCED", "The object cannot be deleted because it is referenced by other objects.", "FNRCE0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_REFERENCES_OTHERS = new ExceptionCode("E_OBJECT_REFERENCES_OTHERS", "The object cannot be deleted because it holds references to other objects.", "FNRCE0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_PROPERTY_NOT_SEARCHABLE = new ExceptionCode("E_PROPERTY_NOT_SEARCHABLE", "Property {0} referred to in the Query Expression is not searchable.", "FNRCE0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_READ_ONLY = new ExceptionCode("E_READ_ONLY", "The method failed because an object or property is read-only.", "FNRCE0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_REQUIRED_VALUE_ABSENT = new ExceptionCode("E_REQUIRED_VALUE_ABSENT", "A required property value has not been set.", "FNRCE0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESERVATION_EXISTS = new ExceptionCode("E_RESERVATION_EXISTS", "The document is already checked out.", "FNRCE0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESOURCE_LOADING_ERROR = new ExceptionCode("E_RESOURCE_LOADING_ERROR", "An error occurred during loading of the resource file {0}.", "FNRCE0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_RESOURCE_NOT_FOUND = new ExceptionCode("E_RESOURCE_NOT_FOUND", "The indicated resource was not found.", "FNRCE0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_SERVER_ERROR = new ExceptionCode("E_SERVER_ERROR", "An error was returned from the server.", "FNRCE0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TEMP_FILES_DIR_ERROR = new ExceptionCode("E_TEMP_FILES_DIR_ERROR", "Unable to create temporary files directory \"{0}\"", "FNRCE0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TRANSACTION_TIMEOUT = new ExceptionCode("E_TRANSACTION_TIMEOUT", "The query was stopped because the time limit was exceeded.", "FNRCE0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNEXPECTED = new ExceptionCode("E_UNEXPECTED", "An unexpected error occurred.", "FNRCE0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNEXPECTED_EXCEPTION = new ExceptionCode("E_UNEXPECTED_EXCEPTION", "An unexpected exception occurred.", "FNRCE0066", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UNSUPPORTED_STREAM = new ExceptionCode("E_UNSUPPORTED_STREAM", "An unsupported stream was detected; version {0} type {1}.", "FNRCE0067", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_URL_PROTOCOL_NOT_SUPPORTED = new ExceptionCode("E_URL_PROTOCOL_NOT_SUPPORTED", "The URL protocol specified in the reference is not supported.", "FNRCE0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_EXCEPTION_READING_OBJECT = new ExceptionCode("E_UTIL_EXCEPTION_READING_OBJECT", "An exception occurred while reading a serialized Object.", "FNRCE0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_EXCEPTION_WRITING_OBJECT = new ExceptionCode("E_UTIL_EXCEPTION_WRITING_OBJECT", "Exception serializing an Object {0}.", "FNRCE0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UTIL_LITTLE_ENDIAN_CONVERSION_FAILED = new ExceptionCode("E_UTIL_LITTLE_ENDIAN_CONVERSION_FAILED", "An exception occurred while reading a little endian byte stream.", "FNRCE0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_VALUE_NOT_SET = new ExceptionCode("E_VALUE_NOT_SET", "The requested property currently has no value.", "FNRCE0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_WEBLOGIC_INVALID_CONFIGURATION = new ExceptionCode("E_WEBLOGIC_INVALID_CONFIGURATION", "The WebLogic configuration is invalid.", "FNRCE0073", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_WEBSPHERE_INVALID_CONFIGURATION = new ExceptionCode("E_WEBSPHERE_INVALID_CONFIGURATION", "The WebSphere configuration is invalid.", "FNRCE0074", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TRANSACTION_FAILURE = new ExceptionCode("E_TRANSACTION_FAILURE", "A transaction failure has occurred due to an invalid state or timeout.", "FNRCE0075", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_INVALID_CONTEXT = new ExceptionCode("E_INVALID_CONTEXT", "The method that was called is not valid in the current call context. This error is logged.", "FNRCE0076", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_NOT_IN_USER_TRANSACTION = new ExceptionCode("E_NOT_IN_USER_TRANSACTION", "The operation requires that a user (distributed) transaction be in effect.", "FNRCE0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_UPGRADE_REQUIRED = new ExceptionCode("E_UPGRADE_REQUIRED", "Object store \"{0}\" has an incompatible schema revision in the database - expected=\"{1}\", actual=\"{2}\".  This object store will be upgraded or an upgrade is already in progress.", "FNRCE0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TASK_CHANGESTATE_PRECONDITION = new ExceptionCode("E_TASK_CHANGESTATE_PRECONDITION", "The precondition is not satisfied: {0}.", "FNRCE0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TASK_CHANGESTATE_POSTCONDITION = new ExceptionCode("E_TASK_CHANGESTATE_POSTCONDITION", "The postcondition is not satisfied: {0}.", "FNRCE0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BACKGROUND_TASK_EXECUTOR_SHUTDOWN = new ExceptionCode("E_BACKGROUND_TASK_EXECUTOR_SHUTDOWN", "The background task executor has terminated: {0}.", "FNRCE0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_BACKGROUND_TASK_TERMINATED = new ExceptionCode("E_BACKGROUND_TASK_TERMINATED", "The  background task has been terminated: {0}.", "FNRCE0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_OBJECT_STORE_UPGRADE_NOT_SUPPORTED = new ExceptionCode("E_OBJECT_STORE_UPGRADE_NOT_SUPPORTED", "Object store \"{0}\" cannot be upgraded because its revision ({1}) is not associated with a supported release.  Upgrade this object store first to a supported release, then upgrade again to this release.", "FNRCE0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DOMAIN_UPGRADE_NOT_SUPPORTED = new ExceptionCode("E_DOMAIN_UPGRADE_NOT_SUPPORTED", "The domain cannot be upgraded because its version ({0}) is not associated with a supported release.  Upgrade this domain first to a supported release, then upgrade again to this release.", "FNRCE0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_SWEEP_QUERY_TIMEOUT = new ExceptionCode("E_SWEEP_QUERY_TIMEOUT", "The sweep query of class ({0}) timed out after ({1}) milliseconds.", "FNRCE0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TRANSACTION_STATE_UNKNOWN = new ExceptionCode("E_TRANSACTION_STATE_UNKNOWN", "Transaction state unknown, typically due to network error or timeout. The transaction may have been committed before network error happens.", "FNRCE0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_DOWNLEVEL_SERVER = new ExceptionCode("E_DOWNLEVEL_SERVER", "This server is running a version of the Content Platform Engine software that is not fully compatible with other servers.", "FNRCE0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode E_TENANT_NOT_FOUND = new ExceptionCode("E_TENANT_NOT_FOUND", "The request could not be completed because the tenant corresponding to Id ''{0}'' was not found.  If this tenant was recently created, retry the request; otherwise check the Id to ensure it corresponds to a valid tenant.", "FNRCE0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_ERROR = new ExceptionCode("SCRIPT_ERROR", "There was an error running the script.", "FNRCZ0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_LOAD_INVOKE_ERROR = new ExceptionCode("SCRIPT_LOAD_INVOKE_ERROR", "There was an error loading or invoking the script engine.", "FNRCZ0002", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_NO_SUCH_METHOD = new ExceptionCode("SCRIPT_NO_SUCH_METHOD", "No such method in script: {0}", "FNRCZ0003", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SCRIPT_SYNTAX_ERROR = new ExceptionCode("SCRIPT_SYNTAX_ERROR", "There was an error loading the script.", "FNRCZ0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_ACTION_NOT_FOUND = new ExceptionCode("CLASSIFY_ACTION_NOT_FOUND", "The DocumentClassificationAction object not found for MIME type {0}.", "FNRCL0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_COMPONENT_NOT_REGISTERED = new ExceptionCode("CLASSIFY_COMPONENT_NOT_REGISTERED", "Neither class name nor script text is set for mime type {0}. The classification component is not registered.", "FNRCL0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DOCUMENT_NOT_FOUND = new ExceptionCode("CLASSIFY_DOCUMENT_NOT_FOUND", "Cannot find document object for queue item {0}. The document object does not exist.", "FNRCL0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_HANDLER_THREW = new ExceptionCode("CLASSIFY_HANDLER_THREW", "Document classification handler threw an exception.", "FNRCL0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFIER_THREW = new ExceptionCode("CLASSIFIER_THREW", "The document classifier threw an exception.", "FNRCL0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFICATION_DATETIME_PARSE_FAILED = new ExceptionCode("CLASSIFICATION_DATETIME_PARSE_FAILED", "Failed to parse date/time value during XML classification. Date/time string is {0} and pattern used is {1}.", "FNRCL0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFICATION_DATETIME_PARSE_FAILED_SIMPLE = new ExceptionCode("CLASSIFICATION_DATETIME_PARSE_FAILED_SIMPLE", "Failed to parse date/time value during XML classification.", "FNRCL0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_NO_CONTENT_TO_CLASSIFY = new ExceptionCode("CLASSIFY_NO_CONTENT_TO_CLASSIFY", "There is no content to classify for the document with id {0}.", "FNRCL0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_STATUS_UPDATE_FAILURE = new ExceptionCode("CLASSIFY_STATUS_UPDATE_FAILURE", "Failed updating classification status of document with id {0}.", "FNRCL0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_UNKNOWN_MIME_TYPE = new ExceptionCode("CLASSIFY_UNKNOWN_MIME_TYPE", "The MIME type is unrecognized for the document with id {0}.", "FNRCL0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_AUDITDEF_PARENT = new ExceptionCode("METADATA_BAD_AUDITDEF_PARENT", "Bad parent_id in AuditDefinition with event_class_id {0}", "FNRCM0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_CARDINALITY_ON_MERGE = new ExceptionCode("METADATA_BAD_CARDINALITY_ON_MERGE", "Merged properties don''t have same cardinality.  Property name: {0}", "FNRCM0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_MERGE_SCOPE = new ExceptionCode("METADATA_BAD_MERGE_SCOPE", "Multiple object store searches must have at least two object stores.", "FNRCM0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_SUBTREE_CLASS = new ExceptionCode("METADATA_BAD_SUBTREE_CLASS", "Read class \"{0}\" not in subtree \"{1}\"", "FNRCM0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_TYPES_ON_MERGE = new ExceptionCode("METADATA_BAD_TYPES_ON_MERGE", "Merged properties don''t have same datatype.  Property name: {0}.", "FNRCM0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_CACHE_SERIALIZE = new ExceptionCode("METADATA_CACHE_SERIALIZE", "Serialization error of metadata cache {0}.", "FNRCM0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DDSTATE_NULL = new ExceptionCode("METADATA_DDSTATE_NULL", "The record in DDState has a null column or columns.", "FNRCM0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_CLASS_ALIAS = new ExceptionCode("METADATA_DUP_CLASS_ALIAS", "Duplicate alias id: {0}, on class {1}.", "FNRCM0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_OBJECT_STORE_IN_SCOPE = new ExceptionCode("METADATA_DUP_OBJECT_STORE_IN_SCOPE", "The multiple object store search has the same object store in it multiple times.", "FNRCM0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_DUP_PROP_ALIAS = new ExceptionCode("METADATA_DUP_PROP_ALIAS", "Duplicate alias id: {0}, on property {1}.", "FNRCM0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_FAILURE_READING_METADATA_FILE = new ExceptionCode("METADATA_FAILURE_READING_METADATA_FILE", "Failed to read static metadata file:  {0}.", "FNRCM0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INCOMPATIBLE_REVISIONS = new ExceptionCode("METADATA_INCOMPATIBLE_REVISIONS", "Incompatible schema revisions: \"{0}\" and \"{1}\"", "FNRCM0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INCOMPATIBLE_REVISION_ID_DB = new ExceptionCode("METADATA_INCOMPATIBLE_REVISION_ID_DB", "The schema revision for the database of object store \"{0}\" is \"{2}\", which is incompatible with the schema revision \"{1}\" of the Content Engine software.", "FNRCM0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_CVL = new ExceptionCode("METADATA_INVALID_CVL", "The value for CVL is invalid.", "FNRCM0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_DEFAULT = new ExceptionCode("METADATA_INVALID_DEFAULT", "Invalid default value for property {0}", "FNRCM0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_INVALID_SEARCH_MD_RESULT = new ExceptionCode("METADATA_INVALID_SEARCH_MD_RESULT", "Server error; get search metata was expected to return a single value for {0}", "FNRCM0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_LOAD_CLASS_ERROR = new ExceptionCode("METADATA_LOAD_CLASS_ERROR", "Unable to load class: {0}.", "FNRCM0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_DDSTATE = new ExceptionCode("METADATA_NO_DDSTATE", "There is no record in DDState.", "FNRCM0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_ROOT_CLASS = new ExceptionCode("METADATA_NO_ROOT_CLASS", "Root class not in static metadata: {0}.", "FNRCM0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_NO_SUBCLASS_PROPS = new ExceptionCode("METADATA_NO_SUBCLASS_PROPS", "Subclass properties on this class are unknown: {0}.", "FNRCM0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_PERSISTER_NOT_DEFINED = new ExceptionCode("METADATA_PERSISTER_NOT_DEFINED", "No persister defined for class {0}.", "FNRCM0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_PRIMARY_ID_NULL = new ExceptionCode("METADATA_PRIMARY_ID_NULL", "Primary Id of property {0} is null.", "FNRCM0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_REFLECTIVE_PROPERTY_INVALID = new ExceptionCode("METADATA_REFLECTIVE_PROPERTY_INVALID", "Reflective property {0} (in \"Constraint\" column) of metadata is invalid for class {1}, property {2}", "FNRCM0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_REQUIRED_CLASS_INVALID = new ExceptionCode("METADATA_REQUIRED_CLASS_INVALID", "Required class {0} (in \"DefaultValue\" column) of metadata is invalid for class {1}, property {2}.", "FNRCM0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVER_METADATA_CACHE_MERGE_FAIL = new ExceptionCode("METADATA_RETRIEVER_METADATA_CACHE_MERGE_FAIL", "Class {0} cannot be merged into cache due to a duplicate name/id.  Class to merge has name \"{1}\", ids: ({2}).  Class already present has name \"{3}\", ids: ({4})", "FNRCM0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVER_NOT_DEFINED = new ExceptionCode("METADATA_RETRIEVER_NOT_DEFINED", "No retriever defined for class {0}.", "FNRCM0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_RETRIEVE_ABOVE_ROOT_IN_DB = new ExceptionCode("METADATA_RETRIEVE_ABOVE_ROOT_IN_DB", "Found class in DB that is above root of subtree (system error) {0}", "FNRCM0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_ROOT_NOT_IN_DB = new ExceptionCode("METADATA_ROOT_NOT_IN_DB", "Root class not in database: {0}.", "FNRCM0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_STATIC_LOAD_FAILED = new ExceptionCode("METADATA_STATIC_LOAD_FAILED", "An error occurred while loading static metadata.", "FNRCM0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_TOO_MANY_ROOTS = new ExceptionCode("METADATA_TOO_MANY_ROOTS", "Too many root classes in metadata.  Offender is: {0}", "FNRCM0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_UNEXPECTED_CREATE_ERROR = new ExceptionCode("METADATA_UNEXPECTED_CREATE_ERROR", "Unexpected exception creating ObjectStoreCache: {0}.", "FNRCM0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_OS_CACHE_LOAD_ERROR = new ExceptionCode("METADATA_OS_CACHE_LOAD_ERROR", "The object store cache failed to load for object store {0}.", "FNRCM0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_STALE_CACHE = new ExceptionCode("METADATA_STALE_CACHE", "The metadata cache for object store {0} is stale.  The Content Engine will retry this request against a refreshed cache.", "FNRCM0033", true, ErrorLoggingLevel.Optional);
    public static final ExceptionCode METADATA_BAD_CHANGEPREPROCESSORDEF_PARENT = new ExceptionCode("METADATA_BAD_CHANGEPREPROCESSORDEF_PARENT", "The change or text preprocessor definition identified by ActionId {0} and DisplayName {1} has a bad parent_id {3}.", "FNRCM0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode METADATA_BAD_ROLEACCESSDEF_PARENT = new ExceptionCode("METADATA_BAD_ROLEACCESSDEF_PARENT", "A role access definition for the controlled class {0} had a bad parent_id {1}.", "FNRCM0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_BATCH_RESULT = new ExceptionCode("DB_BAD_BATCH_RESULT", "The batch statement did not return the appropriate number of results.", "FNRCD0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_DATABASE_VENDOR = new ExceptionCode("DB_BAD_DATABASE_VENDOR", "The database vendor cannot be determined from the JNDI data source or is an unsupported type. Check the data source and verify the database connection.", "FNRCD0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_DATATYPE = new ExceptionCode("DB_BAD_DATATYPE", "An incompatible data type from the expected data type was encountered: {0}", "FNRCD0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_INPUT_BINDING_INDEX = new ExceptionCode("DB_BAD_INPUT_BINDING_INDEX", "The index into the input bindings is invalid.", "FNRCD0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_BAD_OUTPUT_BINDING_TYPE = new ExceptionCode("DB_BAD_OUTPUT_BINDING_TYPE", "The output binding datatype is invalid.", "FNRCD0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_CANT_EXTRACT_CONNECTION_PARAMETERS = new ExceptionCode("DB_CANT_EXTRACT_CONNECTION_PARAMETERS", "The database parameters cannot be extracted from the connection.", "FNRCD0006", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_COLUMN_DOES_NOT_EXIST = new ExceptionCode("DB_COLUMN_DOES_NOT_EXIST", "The referenced database column does not exist on specified table.", "FNRCD0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_CONNECTION_REESTABLISHED = new ExceptionCode("DB_CONNECTION_REESTABLISHED", "The connection to the database failed but has been reestablished.", "FNRCD0008", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_ERROR = new ExceptionCode("DB_ERROR", "The database access failed with the following error: ErrorCode {0}, Message ''{1}''", "FNRCD0009", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_ERROR_R = new ExceptionCode("DB_ERROR_R", "This exception code is not used as of CE 5.0", "FNRCD0010");
    public static final ExceptionCode DB_FINISH_EXECUTE = new ExceptionCode("DB_FINISH_EXECUTE", "The prior execution must finish before starting a new execution.", "FNRCD0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_EXECUTION = new ExceptionCode("DB_INVALID_EXECUTION", "The attempt to add more execution statements is invalid.", "FNRCD0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_STATEMENT = new ExceptionCode("DB_INVALID_STATEMENT", "The following statement is considered invalid by the implementation: {0}", "FNRCD0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NOTHING_TO_INSERT = new ExceptionCode("DB_NOTHING_TO_INSERT", "There is nothing to insert.", "FNRCD0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NOT_UNIQUE = new ExceptionCode("DB_NOT_UNIQUE", "The update or insert failed due to an attempt to create a duplicate value in a unique index.", "FNRCD0015", false, ErrorLoggingLevel.Optional);
    public static final ExceptionCode DB_NO_COUNT_IN_RESULT = new ExceptionCode("DB_NO_COUNT_IN_RESULT", "The database result does not have a count.", "FNRCD0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_INSERT_TABLE = new ExceptionCode("DB_NO_INSERT_TABLE", "A table name must be specified for the insert operation.", "FNRCD0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_RESULT = new ExceptionCode("DB_NO_RESULT", "The given statement did not return any result.", "FNRCD0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_OBJECT_DOES_NOT_EXIST = new ExceptionCode("DB_OBJECT_DOES_NOT_EXIST", "The referenced database object cannot be located.", "FNRCD0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_OUT_OF_MEMORY = new ExceptionCode("DB_OUT_OF_MEMORY", "The underlying database does not have enough memory or heap space to process the current command.", "FNRCD0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_SEQUENCE_EXHAUSTED = new ExceptionCode("DB_SEQUENCE_EXHAUSTED", "The range of values for the sequence is exhausted.  The sequence must be updated with a larger range of values.", "FNRCD0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_ROWLENGTH_LIMIT_EXCEEDED = new ExceptionCode("DB_ROWLENGTH_LIMIT_EXCEEDED", "The summation of column lengths exceeds the capacity of the underlying database.", "FNRCD0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_TABLE_DOES_NOT_EXIST = new ExceptionCode("DB_TABLE_DOES_NOT_EXIST", "The table that was referenced in the database query cannot be found.", "FNRCD0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_UNABLE_TO_ALTER_COLUMN = new ExceptionCode("DB_UNABLE_TO_ALTER_COLUMN", "The column cannot be altered via the application server.  Ask your DBA to issue the following statement against database {0}, then re-attempt the operation.", "FNRCD0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_UNEXPECTED_SQL_RESULT = new ExceptionCode("DB_UNEXPECTED_SQL_RESULT", "One of the SQL statements did not return an expected result.", "FNRCD0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_NO_TABLESPACE_VERSIONS = new ExceptionCode("DB_NO_TABLESPACE_VERSIONS", "The ALTER operation failed because the zOS table space in database ''{0}'' is out of versions.  The z/OS DBA must run the REORG TABLESPACE, MODIFY RECOVERY and COPY utilities against the table space pertaining to the table listed in the following SQL command.  Once these commands have completed (in the order listed), the offending operation can be retried and general use of the table can resume.  It is recommended that the Content Engine application be stopped during this period.", "FNRCD0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_QUERY_COLUMN_LENGTH_EXCEEDED = new ExceptionCode("DB_QUERY_COLUMN_LENGTH_EXCEEDED", "The length of the query value exceeds the length of the underlying column in the database.", "FNRCD0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_COLUMN_DATATYPE_NOT_SUPPORTED = new ExceptionCode("DB_COLUMN_DATATYPE_NOT_SUPPORTED", "A column''s datatype is not supported in the context of the database operation.", "FNRCD0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_INDEX_CREATION = new ExceptionCode("DB_INVALID_INDEX_CREATION", "Non-keyed columns are not permitted in expression-based indexes on DB2 for z/OS. Set CmIndexDefinition.ForceCaseInsensitiveSearch to FALSE or set a SortOrder value other than NONE to every indexed column when creating the index definition.", "FNRCD0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_COMPRESSION_NOT_SUPPORTED = new ExceptionCode("DB_COMPRESSION_NOT_SUPPORTED", "Database compression is not supported via the CPE API on this database platform or version.", "FNRCD0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INVALID_CONNECTION = new ExceptionCode("DB_INVALID_CONNECTION", "The database connection has been determined to be invalid for data source ''{0}''.  This is probably due to an inconsistency between the connection pool and the database.  Retry the operation.", "FNRCD0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_TRANSACTION_LOG_FULL = new ExceptionCode("DB_TRANSACTION_LOG_FULL", "The database transaction log is full.  The operation should be retried.  If the problem persists the issue should be forwarded to the DBA and include the subsequent error message text that contains the database vendor''s error code.", "FNRCD0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_FILESYSTEM_FULL = new ExceptionCode("DB_FILESYSTEM_FULL", "The database fileystem is full.  The operation should be retried.  If the problem persists the issue should be forwarded to the DBA including the subsequent error message text that contains the database vendor''s error code.", "FNRCD0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_DISK_ERROR = new ExceptionCode("DB_DISK_ERROR", "The disk on the database server has encountered an error.  The issue should be forwarded to the DBA including the subsequent error message text that contains the database vendor''s error code.", "FNRCD0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode DB_INCONSISTENT_STATE = new ExceptionCode("DB_INCONSISTENT_STATE", "The database has detected an inconsistent state.  The issue should be forwarded to the DBA including the subsequent error message text that contains the database vendor''s error code.", "FNRCD0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_AFTER_END_OF_RESULTSET_ERROR = new ExceptionCode("JDBC_AFTER_END_OF_RESULTSET_ERROR", "The setting specified is after the end of the result set.", "FNRCJ0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_BEFORE_START_OF_RESULTSET_ERROR = new ExceptionCode("JDBC_BEFORE_START_OF_RESULTSET_ERROR", "The setting specified is before the start of the result set.", "FNRCJ0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CANNOT_ABSOLUTE_ERROR = new ExceptionCode("JDBC_CANNOT_ABSOLUTE_ERROR", "An absolute position cannot be used for the initial row.", "FNRCJ0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_COLUMN_NOT_FOUND_ERROR = new ExceptionCode("JDBC_COLUMN_NOT_FOUND_ERROR", "Column {0} not found", "FNRCJ0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECTION_IS_READONLY_ERROR = new ExceptionCode("JDBC_CONNECTION_IS_READONLY_ERROR", "The Content Engine JDBC driver is read-only. Queries leading to data modification are not allowed.", "FNRCJ0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECT_ERROR = new ExceptionCode("JDBC_CONNECT_ERROR", "Connection could not be established with CE Server; The URL passed to JDBC Driver is : {0} ...", "FNRCJ0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_DRIVER_STATIC_ERROR = new ExceptionCode("JDBC_DRIVER_STATIC_ERROR", "The Content Engine JBDC Driver could not be registered.", "FNRCJ0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_ILLEGAL_FETCH_DIRECTION_ERROR = new ExceptionCode("JDBC_ILLEGAL_FETCH_DIRECTION_ERROR", "The value specified for the fetch direction is invalid.", "FNRCJ0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_ILLEGAL_OPERATION_ON_RESULTSET_ERROR = new ExceptionCode("JDBC_ILLEGAL_OPERATION_ON_RESULTSET_ERROR", "An illegal operation was performed on an empty result set.", "FNRCJ0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_NOT_SUPPORTED_ERROR = new ExceptionCode("JDBC_NOT_SUPPORTED_ERROR", "JDBC method not supported or not implemented in driver: {0}.{1}", "FNRCJ0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_OBJECTSTORE_IS_EMPTY_ERROR = new ExceptionCode("JDBC_OBJECTSTORE_IS_EMPTY_ERROR", "The Object store property is not found in JDBC driver URL.", "FNRCJ0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_OBJECT_STORE_NOT_FOUND_ERROR = new ExceptionCode("JDBC_OBJECT_STORE_NOT_FOUND_ERROR", "{0} Object Store in URL is not found...", "FNRCJ0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_PASSWORD_IS_EMPTY_ERROR = new ExceptionCode("JDBC_PASSWORD_IS_EMPTY_ERROR", "The Password is null or empty in the JDBC URL", "FNRCJ0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_QUERY_GENERTED_NO_FIELDS_ERROR = new ExceptionCode("JDBC_QUERY_GENERTED_NO_FIELDS_ERROR", "The query generated no fields for ResultSet.", "FNRCJ0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_QUERY_NOT_EXECUTED_ERROR = new ExceptionCode("JDBC_QUERY_NOT_EXECUTED_ERROR", "Cannot execute query {0}...", "FNRCJ0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_RESULTSETMETADATA_COLUMN_INDEX_ERROR = new ExceptionCode("JDBC_RESULTSETMETADATA_COLUMN_INDEX_ERROR", "The column index is out of range.", "FNRCJ0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_RESULTSET_CLOSED_ERROR = new ExceptionCode("JDBC_RESULTSET_CLOSED_ERROR", "The operation is not allowed after the ResultSet is closed.", "FNRCJ0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_CLOSED_ERROR = new ExceptionCode("JDBC_STATEMENT_CLOSED_ERROR", "No operations are allowed after the statement has closed.", "FNRCJ0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_FETCH_DIRECTION_ERROR = new ExceptionCode("JDBC_STATEMENT_FETCH_DIRECTION_ERROR", "The value for setFetchDirection() is invalid.", "FNRCJ0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_FETCH_SIZE_ERROR = new ExceptionCode("JDBC_STATEMENT_FETCH_SIZE_ERROR", "The value for setFetchSize() is invalid.", "FNRCJ0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR = new ExceptionCode("JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR", "The query cannot be empty or null.", "FNRCJ0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_URI_IS_EMPTY_ERROR = new ExceptionCode("JDBC_URI_IS_EMPTY_ERROR", "The URL found in the JDBC URL string is not valid.", "FNRCJ0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_USER_IS_EMPTY_ERROR = new ExceptionCode("JDBC_USER_IS_EMPTY_ERROR", "The Username is null or empty in the JDBC URL", "FNRCJ0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_VALUE_GENERATED_ERROR = new ExceptionCode("JDBC_VALUE_GENERATED_ERROR", "The value must be between 0 and getMaxRows().", "FNRCJ0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_INVALID_CURSOR_OPERATION = new ExceptionCode("JDBC_INVALID_CURSOR_OPERATION", "Operation not allowed for TYPE_FORWARD_ONLY ResultSet objects", "FNRCJ0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode JDBC_CONNECT_ACCESS_ERROR = new ExceptionCode("JDBC_CONNECT_ACCESS_ERROR", "Access denied connecting to ObjectStore {0}", "FNRCJ0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CALL_CONTEXT_ALREADY_SETUP = new ExceptionCode("TRANSPORT_CALL_CONTEXT_ALREADY_SETUP", "The current thread already has a call context associated with it. This exception is logged.", "FNRCT0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CALL_CONTEXT_NOT_SETUP = new ExceptionCode("TRANSPORT_CALL_CONTEXT_NOT_SETUP", "The current thread has no call context associated with it. This exception is logged.", "FNRCT0002", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_CORRELATION_ID_MISSING = new ExceptionCode("TRANSPORT_CORRELATION_ID_MISSING", "The server returned a response and the correlation ID is missing.", "FNRCT0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE = new ExceptionCode("TRANSPORT_EXECUTE_CHG_MISSING_RESPONSE", "The server did not return a response to a Content Engine Web Services execute change request call.", "FNRCT0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_CLASS_DESCRIPTION = new ExceptionCode("TRANSPORT_EXPECTED_CLASS_DESCRIPTION", "The server was expected to return a class description set result for a metadata search request. There was no response.", "FNRCT0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_ENGINEOBJECTCOLLECTION_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_ENGINEOBJECTCOLLECTION_RESPONSE", "The request to the server for an engine object collection did not return an engine object collection.", "FNRCT0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_ENGINEOBJECT_RESPONSE", "The request to the server for an engine object returned no information.", "FNRCT0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_PROPERTY_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_PROPERTY_RESPONSE", "The server was expected to return the value of the specified property {0}.", "FNRCT0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EXPECTED_REPOSITORYROWCOLLECTION_RESPONSE = new ExceptionCode("TRANSPORT_EXPECTED_REPOSITORYROWCOLLECTION_RESPONSE", "The request to the server for a repository row collection did not return a repository row collection.", "FNRCT0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_FAILED_SERVER_CALL_CONTEXT_CREATE = new ExceptionCode("TRANSPORT_FAILED_SERVER_CALL_CONTEXT_CREATE", "The server can not create the internal call context. There is generally a chained exception explaining why the problem occurred.", "FNRCT0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_INVALID_CORRELATION_ID = new ExceptionCode("TRANSPORT_INVALID_CORRELATION_ID", "The server returned a correlation id of {0} and there is no corresponding request.", "FNRCT0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_INVALID_SEARCH_REQUEST = new ExceptionCode("TRANSPORT_INVALID_SEARCH_REQUEST", "Invalid search request {0}.", "FNRCT0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_MISSING_SERVER_RESPONSE = new ExceptionCode("TRANSPORT_MISSING_SERVER_RESPONSE", "The server failed to return a response for each request.", "FNRCT0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_MUST_BE_SUBCLASS = new ExceptionCode("TRANSPORT_MUST_BE_SUBCLASS", "The class {0} must be a subclass of {1}.", "FNRCT0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_NO_INITIAL_CONTEXT = new ExceptionCode("TRANSPORT_NO_INITIAL_CONTEXT", "A J2EE JNDI initial context could not be created.", "FNRCT0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_CANNOT_GET_USER_TRANSACTION = new ExceptionCode("TRANSPORT_SCC_CANNOT_GET_USER_TRANSACTION", "This exception code is not used as of CE 4.5.1", "FNRCT0016");
    public static final ExceptionCode TRANSPORT_SCC_DISALLOWED_MULTIPLE_TX_SUSPENSION = new ExceptionCode("TRANSPORT_SCC_DISALLOWED_MULTIPLE_TX_SUSPENSION", "The attempted suspension of multiple transaction was not allowed.", "FNRCT0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_FAILED_REGISTER_SYNC = new ExceptionCode("TRANSPORT_SCC_FAILED_REGISTER_SYNC", "The attempt to register the synchronization listener failed.", "FNRCT0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_SCC_NO_TRANSACTION = new ExceptionCode("TRANSPORT_SCC_NO_TRANSACTION", "No transaction exists in the current context.", "FNRCT0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_UNABLE_TO_LOCATE_EJB = new ExceptionCode("TRANSPORT_UNABLE_TO_LOCATE_EJB", "Unable to locate the servers EJB interface given the end point {0}.", "FNRCT0020", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_UNABLE_TO_LOCATE_EJB_SESSION = new ExceptionCode("TRANSPORT_UNABLE_TO_LOCATE_EJB_SESSION", "This exception code is not used as of CE 4.5.1", "FNRCT0021");
    public static final ExceptionCode TRANSPORT_WAITING_QUEUE_FULL = new ExceptionCode("TRANSPORT_WAITING_QUEUE_FULL", "Waiting queue exceeds upper limit {0}.", "FNRCT0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_COLLECTION_RESPONSE_EXPECTED = new ExceptionCode("TRANSPORT_WSI_COLLECTION_RESPONSE_EXPECTED", "This exception code is not used as of CE 4.5.1", "FNRCT0023");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_EXPECTED = new ExceptionCode("TRANSPORT_WSI_CONTENT_EXPECTED", "This exception code is not used as of CE 4.5.1", "FNRCT0024");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_GET_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_GET_FAILED", "An error occurred while retreiving content data for property {0}.", "FNRCT0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_RETRIEVAL_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_RETRIEVAL_FAILED", "This exception code is not used as of CE 4.5.1", "FNRCT0026");
    public static final ExceptionCode TRANSPORT_WSI_CONTENT_SEND_FAILED = new ExceptionCode("TRANSPORT_WSI_CONTENT_SEND_FAILED", "This exception code is not used as of CE 4.5.1", "FNRCT0027");
    public static final ExceptionCode TRANSPORT_WSI_CREATE_ACTION_TYPE_FAILURE = new ExceptionCode("TRANSPORT_WSI_CREATE_ACTION_TYPE_FAILURE", "An error occurred creating action type {0}.", "FNRCT0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_DESERIALIZATION_ERROR = new ExceptionCode("TRANSPORT_WSI_DESERIALIZATION_ERROR", "A web services instance of {0} could not be deserialized. The error is located at: {1}", "FNRCT0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_END_TOKEN_EXPECTED = new ExceptionCode("TRANSPORT_WSI_END_TOKEN_EXPECTED", "A Java object from a Content Engine Web Services XML element could not be deserialized.", "FNRCT0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_HEADER_REGISTRATION_FAILURE = new ExceptionCode("TRANSPORT_WSI_HEADER_REGISTRATION_FAILURE", "This exception code is not used as of CE 4.5.1", "FNRCT0031");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_DEPENDENT_OBJ_ACTION = new ExceptionCode("TRANSPORT_WSI_INVALID_DEPENDENT_OBJ_ACTION", "An invalid dependent object action type {0} was detected.", "FNRCT0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_HEADER_VALUE = new ExceptionCode("TRANSPORT_WSI_INVALID_HEADER_VALUE", "The SOAP header or XML element {0} must have a value.", "FNRCT0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_INDEPENDENT = new ExceptionCode("TRANSPORT_WSI_INVALID_INDEPENDENT", "This exception code is not used as of CE 4.5.1", "FNRCT0034");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_LIST_UPDATE_MODS = new ExceptionCode("TRANSPORT_WSI_INVALID_LIST_UPDATE_MODS", "The list of dependent objects was not correctly represented by the internal update list class during an execute change call.", "FNRCT0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_MESSAGE_CONTEXT = new ExceptionCode("TRANSPORT_WSI_INVALID_MESSAGE_CONTEXT", "This exception code is not used as of CE 4.5.1", "FNRCT0036");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_OBJECT_VALUE_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_OBJECT_VALUE_TYPE", "An invalid object value of type {0} was received from the server for property {1}.", "FNRCT0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_RESPONSE_NO_EO = new ExceptionCode("TRANSPORT_WSI_INVALID_RESPONSE_NO_EO", "The server response was invalid. An engine object was expected.", "FNRCT0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_SEARCH_REQUEST_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_SEARCH_REQUEST_TYPE", "An ExecuteSearchRequest has an unrecognized search type: {0}.", "FNRCT0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_LOOKUP_FAILURE = new ExceptionCode("TRANSPORT_WSI_LOOKUP_FAILURE", "This exception code is not used as of CE 4.5.1", "FNRCT0040");
    public static final ExceptionCode TRANSPORT_WSI_MISSING_ACTION_TYPE = new ExceptionCode("TRANSPORT_WSI_MISSING_ACTION_TYPE", "The PendingAction {0} does not have a corresponding ActionType", "FNRCT0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_NETWORK_ERROR = new ExceptionCode("TRANSPORT_WSI_NETWORK_ERROR", "A network error occurred when processing a Web service request or response. The nested exceptions might provide more information on possible causes of the problem.", "FNRCT0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_ERROR = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_ERROR", "Error serializing a web services instance of {0}.", "FNRCT0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_HANDLER_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_HANDLER_NOT_FOUND", "The web services serialization handler for the XML element {0} was not found.", "FNRCT0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SERIALIZATION_REGISTRY_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_SERIALIZATION_REGISTRY_NOT_FOUND", "The Content Engine Web Services WSDL URI {0} is not registered for Java-to-XML serialization.", "FNRCT0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_START_TOKEN_EXPECTED = new ExceptionCode("TRANSPORT_WSI_START_TOKEN_EXPECTED", "The web services opening element was expected, but it was not found.", "FNRCT0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNEXPECTED_RESPONSE = new ExceptionCode("TRANSPORT_WSI_UNEXPECTED_RESPONSE", "An unexpected CEWS response of object type {0} was received from the server.", "FNRCT0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNKNOWN_LIFECYCLE_CHANGE_TYPE = new ExceptionCode("TRANSPORT_WSI_UNKNOWN_LIFECYCLE_CHANGE_TYPE", "Unknown life cycle action type {0}.", "FNRCT0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNKNOWN_RESERVATION_TYPE = new ExceptionCode("TRANSPORT_WSI_UNKNOWN_RESERVATION_TYPE", "Unknown reservation type {0}.", "FNRCT0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNSUPPORTED_PROPERTY_TYPE = new ExceptionCode("TRANSPORT_WSI_UNSUPPORTED_PROPERTY_TYPE", "Unsupported property type {0}.", "FNRCT0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_VALUE_EXPECTED = new ExceptionCode("TRANSPORT_WSI_VALUE_EXPECTED", "A required value for an XML element or attribute was missing: {0}", "FNRCT0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_WSDL_FILE_NOT_FOUND = new ExceptionCode("TRANSPORT_WSI_WSDL_FILE_NOT_FOUND", "This exception code is not used as of CE 4.5.1", "FNRCT0052");
    public static final ExceptionCode TRANSPORT_WSI_INVALID_ENUM_VALUE = new ExceptionCode("TRANSPORT_WSI_INVALID_ENUM_VALUE", "The value {0} specified for the web services XML attribute {1} is not one of the permitted values in the WSDL", "FNRCT0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_CONTENT_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_CONTENT_TYPE", "The content attachment type {0} is not recognized.", "FNRCT0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE = new ExceptionCode("TRANSPORT_WSI_INVALID_CONTENT_RESPONSE_TYPE", "The ContentResponse type {0} is not recognized.", "FNRCT0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_CLASS_MISSING = new ExceptionCode("TRANSPORT_WSI_CLASS_MISSING", "This exception code is not used as of CE 5.0", "FNRCT0056");
    public static final ExceptionCode TRANSPORT_WSI_MULTIPART_PROBLEM = new ExceptionCode("TRANSPORT_WSI_MULTIPART_PROBLEM", "A multipart SOAP request or response could not be deserialized.", "FNRCT0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_UNEXPECTED_REQUEST = new ExceptionCode("TRANSPORT_WSI_UNEXPECTED_REQUEST", "An unexpected CEWS request of object type {0} was received from a client.", "FNRCT0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_SOAP_HEADER_NOT_UNDERSTOOD = new ExceptionCode("TRANSPORT_WSI_SOAP_HEADER_NOT_UNDERSTOOD", "A SOAP request included a header {0} with the mustUnderstand attribute, but that SOAP header is not understood by Content Engine Web Services (CEWS).", "FNRCT0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_HTTPS_REQUIRED = new ExceptionCode("TRANSPORT_WSI_HTTPS_REQUIRED", "A connection cannot be made to the server using the specified URI ''{0}''. HTTPS is required.", "FNRCT0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_NO_RUNTIME = new ExceptionCode("TRANSPORT_WSI_NO_RUNTIME", "The operation cannot be completed because a supported web service runtime is not present. Either Microsoft Web Services Extensions (WSE) 3.0 or the Windows Communication Foundation (WCF) is required.", "FNRCT0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_MALFORMED_VALUE = new ExceptionCode("TRANSPORT_WSI_MALFORMED_VALUE", "The deserialization parsing of data type {0} failed for the value {1}.", "FNRCT0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_DIME_UNSUPPORTED = new ExceptionCode("TRANSPORT_WSI_DIME_UNSUPPORTED", "This exception code is not used as of CE 5.1.1", "FNRCT0063");
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_UPLOAD_EJB", "Enterprise Java Bean (EJB) cannot be created to upload content. Server affinity is {0}.  EJB Home type is {1}.  EJB Home value is {2}.", "FNRCT0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CREATE_CONTENT_DOWNLOAD_EJB", "Enterprise Java Bean (EJB) cannot be created to retrieve content. Server affinity is {0}.  EJB Home type is {1}.  EJB Home value is {2}.", "FNRCT0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_EJB_UNABLE_TO_CONNECT = new ExceptionCode("TRANSPORT_EJB_UNABLE_TO_CONNECT", "Unable to connect to Content Engine.", "FNRCT0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_FNCEWS35_UNSUPPORTED = new ExceptionCode("TRANSPORT_WSI_FNCEWS35_UNSUPPORTED", "The FNCEWS35 endpoints are not supported for CEWS. CEWS applications must be ported to use the FNCEWS40 endpoints.  The attempted CE URI was {0}.", "FNRCT0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode TRANSPORT_WSI_INVALID_CLIENT_CERT = new ExceptionCode("TRANSPORT_WSI_INVALID_CLIENT_CERT", "The specified client certificate ''{0}'' cannot be found.", "FNRCT0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_COMPONENT_FILED_IN_MULTIPLE_FOLDERS = new ExceptionCode("CLASSIFY_DITA_COMPONENT_FILED_IN_MULTIPLE_FOLDERS", "DITA component filed in multiple folders {0}.", "FNRCQ0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_COMPONENT_NOT_FILED_IN_ANY_FOLDER = new ExceptionCode("CLASSIFY_DITA_COMPONENT_NOT_FILED_IN_ANY_FOLDER", "DITA component not filed in any folder {0}.", "FNRCQ0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_INVALID_PATH = new ExceptionCode("CLASSIFY_DITA_INVALID_PATH", "The path is malformed {0}.", "FNRCQ0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_UNSUPPORTED_TYPE = new ExceptionCode("CLASSIFY_DITA_UNSUPPORTED_TYPE", "The DITA classifier does not support this DITA type {0}.", "FNRCQ0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_REQUIRED_VALUE_NOT_FOUND = new ExceptionCode("CLASSIFY_DITA_REQUIRED_VALUE_NOT_FOUND", "A required DITA value was not found {0}.", "FNRCQ0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CLASSIFY_DITA_INVALID_NODE_TEXT_FORMAT = new ExceptionCode("CLASSIFY_DITA_INVALID_NODE_TEXT_FORMAT", "Invalid format for node text data, expected a name:value pair {0}.", "FNRCQ0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_RENDER_FAILED = new ExceptionCode("PUBLISH_DITA_RENDER_FAILED", "The DITA Open Toolkit render operation failed. It return value {0}.", "FNRCQ0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_WORKSPACE_FOLDER = new ExceptionCode("PUBLISH_DITA_INVALID_WORKSPACE_FOLDER", "The DITA temp workspace folder exists but is not a folder {0}.", "FNRCQ0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_UNABLE_TO_DELETE = new ExceptionCode("PUBLISH_DITA_UNABLE_TO_DELETE", "After a render operation, the deletion of the DITA temp file or folder failed {0}.", "FNRCQ0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_UNABLE_TO_CREATE = new ExceptionCode("PUBLISH_DITA_UNABLE_TO_CREATE", "Unable to create temp DITA file or folder {0}.", "FNRCQ0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_JAVA_HOME_UNDEFINED = new ExceptionCode("PUBLISH_DITA_JAVA_HOME_UNDEFINED", "The JAVA_HOME environment variable is not defined.", "FNRCQ0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAVAL = new ExceptionCode("PUBLISH_DITA_INVALID_DITAVAL", "DITAVAL file requires DocumentTitle, ContentSize, and ContentElement properties.", "FNRCQ0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAOT_LIB = new ExceptionCode("PUBLISH_DITA_INVALID_DITAOT_LIB", "The DITA Open Toolkit lib folder was not found or is invalid.", "FNRCQ0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_INVALID_DITAOT = new ExceptionCode("PUBLISH_DITA_INVALID_DITAOT", "The DITA Open Toolkit is not installed in the specified DITAHome location, {0}, specified in the DITA Rendition Engine Connection.", "FNRCQ0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_DITA_PUBLICATION_NOT_FOUND = new ExceptionCode("PUBLISH_DITA_PUBLICATION_NOT_FOUND", "The DITA publication file was not found {0}.", "FNRCQ0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PE_SERIALIZATION_ERROR = new ExceptionCode("PE_SERIALIZATION_ERROR", "A PE serialization problem happened {0}.", "FNRAC1001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ALL_PROPS_FROM_SAME_CLASS = new ExceptionCode("RETRIEVE_ALL_PROPS_FROM_SAME_CLASS", "When returning objects all properties selected must be from same class.", "FNRCR0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_AMBIGUOUS_PROPERTY = new ExceptionCode("RETRIEVE_AMBIGUOUS_PROPERTY", "Ambiguous property has no table specifier: {0}.", "FNRCR0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_APPEND_ACTIVE_CLAUSE = new ExceptionCode("RETRIEVE_BAD_APPEND_ACTIVE_CLAUSE", "The call to SelectStatementEx.appendActiveClause is invalid.", "FNRCR0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTENT_ELEMENT_ID = new ExceptionCode("RETRIEVE_BAD_CONTENT_ELEMENT_ID", "Bad element id in Content table.  Document: {0}.", "FNRCR0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTENT_ELEMENT_ORDINAL = new ExceptionCode("RETRIEVE_BAD_CONTENT_ELEMENT_ORDINAL", "Invalid ordinal {0} in element_id of content.  Document {1}.", "FNRCR0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_CONTINUATION_STRING = new ExceptionCode("RETRIEVE_BAD_CONTINUATION_STRING", "The continuation string is invalid: {0}.", "FNRCR0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_GET_OBJECT_PARAMETERS = new ExceptionCode("RETRIEVE_BAD_GET_OBJECT_PARAMETERS", "The getObject parameters are invalid.", "FNRCR0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_GLOBAL_IDENTITY = new ExceptionCode("RETRIEVE_BAD_GLOBAL_IDENTITY", "The global identity is invalid or was not found.", "FNRCR0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_MULTI_SELECT_DISTINCT = new ExceptionCode("RETRIEVE_BAD_MULTI_SELECT_DISTINCT", "Cannot use select distinct if selected property not defined in all object stores of multi object store query: {0}.", "FNRCR0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_NAME_PROPERTY = new ExceptionCode("RETRIEVE_BAD_NAME_PROPERTY", "Name property not set up correctly in system metadata on class {0} (system error).", "FNRCR0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_OBJECT_ADDRESS = new ExceptionCode("RETRIEVE_BAD_OBJECT_ADDRESS", "The ObjectAddress is invalid.", "FNRCR0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_OBJECT_COLUMN_TYPE = new ExceptionCode("RETRIEVE_BAD_OBJECT_COLUMN_TYPE", "Invalid column type for object property {0}.", "FNRCR0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_ORDERBY_DATATYPE = new ExceptionCode("RETRIEVE_BAD_ORDERBY_DATATYPE", "The datatype for the ORDER BY clause is invalid.", "FNRCR0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_PROPERTY_FILTER_TYPE = new ExceptionCode("RETRIEVE_BAD_PROPERTY_FILTER_TYPE", "Unknown property type in PropertyFilter: {0}.", "FNRCR0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_BAD_REPOSITORY_SEARCH = new ExceptionCode("RETRIEVE_BAD_REPOSITORY_SEARCH", "AdHocClassRetriever.executeSearch can be called only for a repository search.", "FNRCR0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_COMPARE_TYPES = new ExceptionCode("RETRIEVE_CANT_COMPARE_TYPES", "Cannot compare dissimilar data types.  Near position: {0}.", "FNRCR0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_CREATE_RETRIEVER = new ExceptionCode("RETRIEVE_CANT_CREATE_RETRIEVER", "Cannot create retriever: {0}.", "FNRCR0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_CREATE_SEARCH_TEMP_DIR = new ExceptionCode("RETRIEVE_CANT_CREATE_SEARCH_TEMP_DIR", "Can''t create temp file directory {0} for use with content search.", "FNRCR0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_GET_LOCAL_HOST = new ExceptionCode("RETRIEVE_CANT_GET_LOCAL_HOST", "The local host cannot be opened.", "FNRCR0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_GET_OBJECT_ID = new ExceptionCode("RETRIEVE_CANT_GET_OBJECT_ID", "The object is not an independent or global object.  The object id is not found.", "FNRCR0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_MODIFY_ROOT_FOLDER = new ExceptionCode("RETRIEVE_CANT_MODIFY_ROOT_FOLDER", "The root folder cannot be modified.", "FNRCR0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_SELECT_DISTINCT_PROP_WITH_NO_COLUMN = new ExceptionCode("RETRIEVE_CANT_SELECT_DISTINCT_PROP_WITH_NO_COLUMN", "No column defined on property used with \"distinct\": {0}.", "FNRCR0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_SELECT_WITH_DISTINCT = new ExceptionCode("RETRIEVE_CANT_SELECT_WITH_DISTINCT", "Can''t select property with \"distinct\": {0}.", "FNRCR0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_NOT_TRANSFER = new ExceptionCode("RETRIEVE_CONTENT_NOT_TRANSFER", "Content for document {0}, ordinal {1} is not ContentTransfer.", "FNRCR0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_AND = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_AND", "A SQL statement that is constructed with the CONTAINS operator must include the AND operator if a ContentSearch class is joined with an inner join.", "FNRCR0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_FAILED = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_FAILED", "The content search failed for search string=\"{0}\", type={1}, property=\"{2}\", class=\"{3}\", and object store=\"{4}\".", "FNRCR0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_SEARCH_OR = new ExceptionCode("RETRIEVE_CONTENT_SEARCH_OR", "A SQL statement that is constructed with the CONTAINS operator must include the OR operator if a ContentSearch class is not joined with an inner join.", "FNRCR0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_DBCONTEXT_NULL = new ExceptionCode("RETRIEVE_DBCONTEXT_NULL", "The database context is unexpectedly null.", "FNRCR0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_EXCEEDED_BLOB_BUFFER = new ExceptionCode("RETRIEVE_EXCEEDED_BLOB_BUFFER", "Exceeded maximum length of blob buffer {0}.", "FNRCR0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_EXPECTED_ID = new ExceptionCode("RETRIEVE_EXPECTED_ID", "Expected id property (system error)", "FNRCR0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_CLASSID_FOR_PROP = new ExceptionCode("RETRIEVE_INVALID_CLASSID_FOR_PROP", "Invalid class id ({0}) for property {1}.", "FNRCR0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_DEPENDENT_FETCH = new ExceptionCode("RETRIEVE_INVALID_DEPENDENT_FETCH", "Attempt to get a dependent property by item index when property is not a dependent list: {0}", "FNRCR0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_ISCLASS_ALIAS = new ExceptionCode("RETRIEVE_INVALID_ISCLASS_ALIAS", "Invalid class alias in isclass test {0}.", "FNRCR0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_LIST_DATATYPE = new ExceptionCode("RETRIEVE_INVALID_LIST_DATATYPE", "Invalid list datatype for property {0}.", "FNRCR0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_OPERATOR_FOR_CONTAINS = new ExceptionCode("RETRIEVE_INVALID_OPERATOR_FOR_CONTAINS", "Invalid operator used with CONTAINS/FREETEXT: {0}.", "FNRCR0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_PROPERTY_VALUE = new ExceptionCode("RETRIEVE_INVALID_PROPERTY_VALUE", "Invalid property value type for property {0}.", "FNRCR0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ITEM_INDEX_NEGATIVE = new ExceptionCode("RETRIEVE_ITEM_INDEX_NEGATIVE", "The item index is negative in the request to retrieve a dependent object.", "FNRCR0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MISSING_CONTENTSEARCH_JOIN = new ExceptionCode("RETRIEVE_MISSING_CONTENTSEARCH_JOIN", "A SQL statement that is constructed with the CONTAINS operator must include a FROM clause with a ContentSearch table joined to another table.", "FNRCR0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MORE_THAN_ONE_CONTENT_TABLE = new ExceptionCode("RETRIEVE_MORE_THAN_ONE_CONTENT_TABLE", "Cannot have more than one ContentSearch table joined into a search.", "FNRCR0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_COLUMN_NAMES = new ExceptionCode("RETRIEVE_MULTIPLE_COLUMN_NAMES", "Two properties with same table have different column names.  Property 1: {0}, Property 2: {1}, Table name: {2}.", "FNRCR0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_CONTAINSORFREETEXT = new ExceptionCode("RETRIEVE_MULTIPLE_CONTAINSORFREETEXT", "A SQL statement cannot have more than one CONTAINS clause.", "FNRCR0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_DATATYPES = new ExceptionCode("RETRIEVE_MULTIPLE_DATATYPES", "Two properties with same table have different data types.  Property 1: {0}, Property 2: {1}, Table name: {2}.", "FNRCR0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTIPLE_ON_CONTENT = new ExceptionCode("RETRIEVE_MULTIPLE_ON_CONTENT", "An ON condition that references content search tables more than once is invalid.", "FNRCR0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NEED_SEARCH_SERVER = new ExceptionCode("RETRIEVE_NEED_SEARCH_SERVER", "Must have at least one search server specified for index area {0}", "FNRCR0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NOT_IMPLEMENTED = new ExceptionCode("RETRIEVE_NOT_IMPLEMENTED", "Not Implemented.", "FNRCR0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NOT_OBJECT = new ExceptionCode("RETRIEVE_NOT_OBJECT", "Property for getObject must be object: {0}.", "FNRCR0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_DISTINCT_MERGE = new ExceptionCode("RETRIEVE_NO_DISTINCT_MERGE", "The DISTINCT operator is not supported in merged scope queries.", "FNRCR0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_ITEM_INDEX = new ExceptionCode("RETRIEVE_NO_ITEM_INDEX", "No item index in request to retrieve dependent object.", "FNRCR0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_REQUIRED_CLASS = new ExceptionCode("RETRIEVE_NO_REQUIRED_CLASS", "Persistent property {0} has no required class.", "FNRCR0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_ROOT_FOLDER = new ExceptionCode("RETRIEVE_NO_ROOT_FOLDER", "The root folder is not in the cache.", "FNRCR0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_SELECTED_PROPERTY = new ExceptionCode("RETRIEVE_NO_SELECTED_PROPERTY", "The selected property was not found in the property list.", "FNRCR0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_CONTENTSEARCH_JOIN = new ExceptionCode("RETRIEVE_NULL_CONTENTSEARCH_JOIN", "A null row cannot be joined to ContentSearch. For example, \"select ... from ContentSearch left outer join Document ... \" is not allowed, because the Document table row may be null when ContentSearch is not null.", "FNRCR0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_TABLE_LIST = new ExceptionCode("RETRIEVE_NULL_TABLE_LIST", "Cannot use property ({0}) with null table for list cardinality.", "FNRCR0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ORDER_BY_NOT_SELECTED = new ExceptionCode("RETRIEVE_ORDER_BY_NOT_SELECTED", "Order by property must be in selection list: {0}.", "FNRCR0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_ORDER_CLAUSE_PARSE_FAILURE = new ExceptionCode("RETRIEVE_ORDER_CLAUSE_PARSE_FAILURE", "Expected one child node of order property (system error).", "FNRCR0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_CARDINALITY = new ExceptionCode("RETRIEVE_PARSE_BAD_CARDINALITY", "The cardinality (list or single-valued property) does not match the cardinality of the operator expression for property {0}.", "FNRCR0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_CHILD_COUNT = new ExceptionCode("RETRIEVE_PARSE_BAD_CHILD_COUNT", "Unexpected number of child elements of \"{0}\".", "FNRCR0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_LONG_STRING = new ExceptionCode("RETRIEVE_PARSE_BAD_LONG_STRING", "Long string property {0} not allowed with given operator.", "FNRCR0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_BAD_ROOT_CHILD = new ExceptionCode("RETRIEVE_PARSE_BAD_ROOT_CHILD", "The child of the root query node is unrecognized.", "FNRCR0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_CANT_COMPARE_CONSTANTS = new ExceptionCode("RETRIEVE_PARSE_CANT_COMPARE_CONSTANTS", "An attempt was made to compare two constants that are dates, booleans, or GUIDs.", "FNRCR0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_CONSTANT_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_CONSTANT_NOT_ALLOWED", "Constant not allowed with operator {0}.  Near: {1}.", "FNRCR0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_EXPRESSION_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_EXPRESSION_NOT_ALLOWED", "Expression not allowed with operator {0}.  Near: {1}.", "FNRCR0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_FOLDER_SYNTAX = new ExceptionCode("RETRIEVE_PARSE_INVALID_FOLDER_SYNTAX", "Invalid folder syntax: {0}.", "FNRCR0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_FREETEXT_PROPERTY = new ExceptionCode("RETRIEVE_PARSE_INVALID_FREETEXT_PROPERTY", "The property used as the first argument of the FREETEXT operator is invalid. FREETEXT cannot search individual properties, and only supports \"*\".", "FNRCR0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_NODE_TYPE = new ExceptionCode("RETRIEVE_PARSE_INVALID_NODE_TYPE", "Invalid node type: \"{0}\".", "FNRCR0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_OBJECT_FUNCTION = new ExceptionCode("RETRIEVE_PARSE_INVALID_OBJECT_FUNCTION", "Invalid argument to object function: {0}.", "FNRCR0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_QUERY_PROPERTY = new ExceptionCode("RETRIEVE_PARSE_INVALID_QUERY_PROPERTY", "Invalid property in query: {0}.", "FNRCR0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_RHS_FOLDER_OPERAND = new ExceptionCode("RETRIEVE_PARSE_INVALID_RHS_FOLDER_OPERAND", "The operand on the right side of INFOLDER is invalid.", "FNRCR0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_NO_COLUMN_DEFINED = new ExceptionCode("RETRIEVE_PARSE_NO_COLUMN_DEFINED", "Property searched for ({0}) has no column defined.", "FNRCR0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_NO_FROM_CLAUSE = new ExceptionCode("RETRIEVE_PARSE_NO_FROM_CLAUSE", "No FROM clause was specified in the query.", "FNRCR0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_OBJECT_IN_FROM = new ExceptionCode("RETRIEVE_PARSE_OBJECT_IN_FROM", "The OBJECT function is not allowed in a FROM clause.", "FNRCR0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_PROPERTY_NEEDS_CLASS = new ExceptionCode("RETRIEVE_PARSE_PROPERTY_NEEDS_CLASS", "Property {0} must be qualified by a class name.", "FNRCR0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_PROPERTY_NOT_ALLOWED = new ExceptionCode("RETRIEVE_PARSE_PROPERTY_NOT_ALLOWED", "Property {0} not allowed with operator {1}.", "FNRCR0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_UNEXPECTED_NODE = new ExceptionCode("RETRIEVE_PARSE_UNEXPECTED_NODE", "Unexpected node type in \"{0}\".", "FNRCR0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_UNEXPECTED_OPERATOR_DATATYPE = new ExceptionCode("RETRIEVE_PARSE_UNEXPECTED_OPERATOR_DATATYPE", "Unexpected datatype for operator: {0}.  Near: {1}.", "FNRCR0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PATH_SLASH = new ExceptionCode("RETRIEVE_PATH_SLASH", "The path \"{0}\" does not start with the required forward or reverse slash.", "FNRCR0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PROPERTY_NOT_DEFINED = new ExceptionCode("RETRIEVE_PROPERTY_NOT_DEFINED", "The property {0} is not defined.", "FNRCR0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PROPERTY_NOT_ORDERABLE = new ExceptionCode("RETRIEVE_PROPERTY_NOT_ORDERABLE", "Property not orderable: {0}.", "FNRCR0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SQL_SYNTAX_ERROR = new ExceptionCode("RETRIEVE_SQL_SYNTAX_ERROR", "There was a syntax error in an SQL query or filter expression at line {0}, position {1}.  Read \"{2}\" but expected {3}.  The original query was: {4}.", "FNRCR0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNEXPECTED_PROP_CONSTRAINT = new ExceptionCode("RETRIEVE_UNEXPECTED_PROP_CONSTRAINT", "Unexpected property has constraint: {0}.", "FNRCR0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNEXPECTED_SELECTION = new ExceptionCode("RETRIEVE_UNEXPECTED_SELECTION", "The object property selection was unexpected.", "FNRCR0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNRECOGNIZED_QUERY_DATE = new ExceptionCode("RETRIEVE_UNRECOGNIZED_QUERY_DATE", "Unrecognized query date \"{0}\".", "FNRCR0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNSELECT_ORDER_BY = new ExceptionCode("RETRIEVE_UNSELECT_ORDER_BY", "An unselected property in the ORDER BY clause can be only the id column. All properties in the ORDER BY clause must be in the select list, with the exception of an Id property.", "FNRCR0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_MULTI_OBJECT_STORE_IN_TRAN = new ExceptionCode("RETRIEVE_MULTI_OBJECT_STORE_IN_TRAN", "Doing a multiple object store search while in a distributed transaction, such as executing inside event action, is not supported.", "FNRCR0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CONTENT_JOIN_INVALID = new ExceptionCode("RETRIEVE_CONTENT_JOIN_INVALID", "Join on content search is invalid.  A content search of class \"X\" must contain \"... JOIN ON ContentSearch.QueriedObject = X.This\".", "FNRCR0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NEED_MULTIPLE_OBJECT_STORES = new ExceptionCode("RETRIEVE_NEED_MULTIPLE_OBJECT_STORES", "At least two object stores must be supplied to a merged scope query.  #Supplied={0}.", "FNRCR0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NULL_ENUM_COLUMN = new ExceptionCode("RETRIEVE_NULL_ENUM_COLUMN", "Attempt to retrieve an enumeration property that has a reflective property with no column defined.  Class={0}, Enumeration property={1}, Reflective property of enumeration={2}", "FNRCR0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_INVALID_REFLECTIVE_PROP = new ExceptionCode("RETRIEVE_INVALID_REFLECTIVE_PROP", "Invalid Reflective property(={0}) specified for Enum Propeorty(={1}). Reflective Property should present in either the \"Required Class\" or its sub classes.", "FNRCR0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_NO_TEXTSEARCH_INDEX = new ExceptionCode("RETRIEVE_NO_TEXTSEARCH_INDEX", "No Text search Index for index id: {0}", "FNRCR0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_NOT_PRESENT", "The XML to use for the search is incomplete. The required element or attribute {0} is not present.", "FNRCA0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_HAS_NO_VALUE = new ExceptionCode("RETRIEVE_SEARCH_XML_REQUIRED_ELEMENT_OR_ATTRIBUTE_HAS_NO_VALUE", "The XML to use for the search is invalid. The required element or attribute {0} does not have a value assigned.", "FNRCA0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_ATTRIBUTE_VALUE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_ATTRIBUTE_VALUE", "The XML to use for the search is invalid. The {0} value assigned to the {1} attribute is invalid.", "FNRCA0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_CHILD_NODE_COUNT = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_CHILD_NODE_COUNT", "The XML to use for the search is not well-formed. There should be {1} child nodes for {0}, but {2} were found.", "FNRCA0097", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_CONTENT_ITEM_COUNT = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_CONTENT_ITEM_COUNT", "The XML to use for the search is invalid. You have attempted to add more content items than are allowed.", "FNRCA0098", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_RESET_OF_CONTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_RESET_OF_CONTENT_ITEM", "The XML to use for the search is invalid. You have attempted improperly to reset an existing content item.", "FNRCA0099", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_RETRIEVE_OF_CONTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_RETRIEVE_OF_CONTENT_ITEM", "The XML to use for the search is invalid. You have attempted to retrieve a nonexistent content item.", "FNRCA0100", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_GROUPACTION_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_GROUPACTION_ATTRIBUTE", "The XML to use for the search is invalid. When no operator is present, the groupaction attribute value must be \"none\".", "FNRCA0101", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_WORKVARIATION_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_WORKVARIATION_ATTRIBUTE", "The XML to use for the search is invalid. The specified wordvariation attribute value is not allowed with a case attribute value of {0}.", "FNRCA0102", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_CLAUSE_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_CLAUSE_NOT_FOUND", "The XML to use for the search is invalid. You have attempted to execute a query that does not contain a search clause for the {0} class.", "FNRCA0103", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_FOLDER_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_FOLDER_NOT_FOUND", "The XML to use for the search is invalid. The folder specified with the itemid {0} was not found in the search XML when merging the search parameters.", "FNRCA0104", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_SUBCLASS_NOT_FOUND = new ExceptionCode("RETRIEVE_SEARCH_SUBCLASS_NOT_FOUND", "The XML to use for the search is invalid. The subclass specified with the itemid {0} was not found in the search XML when merging the search parameters.", "FNRCA0105", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_MIMETYPE = new ExceptionCode("RETRIEVE_SEARCH_INVALID_MIMETYPE", "The XML to use for the search is invalid. The mimetype attribute value {0} is not valid. Valid mimetype values are: application/x-filenet-searchtemplate or application/x-filenet-search.", "FNRCA0106", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_XML_QUERY_FROM_CLASS = new ExceptionCode("RETRIEVE_SEARCH_INVALID_XML_QUERY_FROM_CLASS", "The XML to use for the search is invalid. The class attribute value {0} specified for the from clause is not valid. Valid values are document, folder and customobject.", "FNRCA0107", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_PARAMETER_QUERY_FROM_CLASS = new ExceptionCode("RETRIEVE_SEARCH_INVALID_PARAMETER_QUERY_FROM_CLASS", "The searchClauseFromClass parameter for the SearchScope method to execute the stored search is invalid. The class {0} specified for the searchClauseFromClass parameter is invalid.", "FNRCA0108", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_REQUIRED_MERGE_DATA_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_REQUIRED_MERGE_DATA_NOT_PRESENT", "The templateData parameter for the SearchScope method to execute the stored search is invalid. The SearchTemplateParameters instance did not contain the required value {1} in the {0} object.", "FNRCA0109", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_EXCLUDE_TARGET_NOT_PRESENT = new ExceptionCode("RETRIEVE_SEARCH_EXCLUDE_TARGET_NOT_PRESENT", "An object specified to be excluded from the search XML does not exist. The {0} object having itemId {1} was not found.", "FNRCA0110", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_ADD_ITEM_VALUES_NOT_SET = new ExceptionCode("RETRIEVE_SEARCH_ADD_ITEM_VALUES_NOT_SET", "An item to be added to the search XML does not have all of the required attribute values set. The {0} object having itemId {1} does not have all of the required values specified.", "FNRCA0111", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_CANNOT_MODIFY_NONEXISTENT_ITEM = new ExceptionCode("RETRIEVE_SEARCH_CANNOT_MODIFY_NONEXISTENT_ITEM", "An item to be modified was not found in the search XML. The {0} object having itemId {1} was not found.", "FNRCA0112", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_ATTRIBUTE = new ExceptionCode("RETRIEVE_SEARCH_INVALID_ATTRIBUTE", "An attribute in search XML was assigned an invalid value. The {1} attribute on the {0} object was assigned a value of {2}. This value is not valid.", "FNRCA0113", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_GROUPING = new ExceptionCode("RETRIEVE_SEARCH_INVALID_GROUPING", "A range for the search modifier was not specified in the search XML. The search modifier requires an associated search modifier range value for the {0} object having an itemId of {1} and a search modifier of {2}.", "FNRCA0114", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_XML = new ExceptionCode("RETRIEVE_SEARCH_INVALID_XML", "The search XML is invalid. The XML does not conform to the Stored Search schema. The error was triggered when {0} was found, and {1} was expected.", "FNRCA0115", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_SORT_LEVEL = new ExceptionCode("RETRIEVE_SEARCH_INVALID_SORT_LEVEL", "The sort level specified in the search XML is invalid. A non-sequential sort level was found. The sort level must be sequential.", "FNRCA0116", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_INVALID_VERSION = new ExceptionCode("RETRIEVE_SEARCH_INVALID_VERSION", "The version specified in the search XML is invalid. The dtd attribute value specified was {0}, and should be ''3.0''. The searchobject attribute value specified was {1}, and should be ''3''.", "FNRCA0117", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_FUZZY_MODIFIER = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_FUZZY_MODIFIER", "Invalid value for fuzzy search parameter, must be greater then 0.0 and less then 1.0, value = {0}.", "FNRCA0118", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_SEARCH_XML_INVALID_PROXIMITY_MODIFIER = new ExceptionCode("RETRIEVE_SEARCH_XML_INVALID_PROXIMITY_MODIFIER", "Invalid value for proximity search parameter, value = {0}.", "FNRCA0119", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_OUTER_JOIN = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_OUTER_JOIN", "An outer join to the ContentSearch class is not allowed in a search that uses a CBR optimization SQL option other than CBR_CONTENT_FIRST.", "FNRCA0120", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_PROPERTY_CONDITIONS = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_PROPERTY_CONDITIONS", "ContentSearch property conditions are not allowed in a search that uses a CBR optimization SQL option other than CBR_CONTENT_FIRST.", "FNRCA0121", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_MULTIPLE_JOIN = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_MULTIPLE_JOIN", "A multiple join containing an outer join in which the ContentSearch join is not the last join on the right is not allowed in a search that uses a CBR optimization SQL option other than CBR_CONTENT_FIRST.", "FNRCA0122", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_RANK_ORDER = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_RANK_ORDER", "A CBR search that is ordered by rank and uses a CBR optimization SQL option of CBR_DB_FIRST is not allowed.", "FNRCA0123", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_CBR_SUBQUERY = new ExceptionCode("RETRIEVE_PARSE_INVALID_CBR_SUBQUERY", "A CBR search cannot be performed in a subquery.", "FNRCA0124", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_SELECT_DISTINCT = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_SELECT_DISTINCT", "A CBR optimization SQL option is not allowed in a SQL statement that uses the DISTINCT keyword with the RANK keyword in a select list.", "FNRCA0125", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_UNSUPPORTED_OBJECT_RETRIEVAL = new ExceptionCode("RETRIEVE_UNSUPPORTED_OBJECT_RETRIEVAL", "The object cannot be retrieved because its class is unsupported for object retrieval. Class: {0}.", "FNRCA0126", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_OPTIMIZED_SEARCH_INVALID_MERGED_SCOPE_RANK_ORDER = new ExceptionCode("RETRIEVE_OPTIMIZED_SEARCH_INVALID_MERGED_SCOPE_RANK_ORDER", "A merged scope CBR search is not allowed when you use a SQL statement that orders by rank and has a CBR optimization SQL option of CBR_DYNAMIC_THRESHOLD unless one or more object stores included in the search have their CBRQueryRankOverride property set to Required.", "FNRCA0127", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_PARSE_INVALID_ACCESSGRANTED = new ExceptionCode("RETRIEVE_PARSE_INVALID_ACCESSGRANTED", "The access granted search keyword is not allowed in a {0}.", "FNRCA0128", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode RETRIEVE_CANT_SELECT_DISTINCT_RANK_WITH_OVERRIDE_REQUIRED = new ExceptionCode("RETRIEVE_CANT_SELECT_DISTINCT_RANK_WITH_OVERRIDE_REQUIRED", "A CBR search is not allowed when you use a SQL statement that selects the CBR rank property and has the keyword DISTINCT when the object store property CBRQueryRankOverride is set to Required.", "FNRCA0129", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_IMPORT_CAN_NOT_FIND_CONTENT = new ExceptionCode("IMEX_IMPORT_CAN_NOT_FIND_CONTENT", "The import process can not find the content {0} for an object {1}", "FNRCX0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_OBJECTSTORE_REFERENCE_NOT_AVAILABLE = new ExceptionCode("IMEX_OBJECTSTORE_REFERENCE_NOT_AVAILABLE", "The ObjectStore reference is not available for given IndependentObject", "FNRCX0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_MANIFEST_MISSING_OBJECT_STORE = new ExceptionCode("IMEX_EXPORT_MANIFEST_MISSING_OBJECT_STORE", "The Export Manifest file is missing the ObjectStore information. The SavedManifest node in the XML file is missing the primaryObjectStore attribute.", "FNRCX0003", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_DRIVER_CLASS_NOT_FOUND = new ExceptionCode("IMEX_EXPORT_DERBY_DRIVER_CLASS_NOT_FOUND", "The Apache Derby driver class was not found. This class is needed to create the export disk cache.", "FNRCX0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_SQL_EXCEPTION = new ExceptionCode("IMEX_EXPORT_DERBY_SQL_EXCEPTION", "Apache Derby experienced a sql exception.", "FNRCX0005", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_EXPORT_DERBY_STARTUP_EXCEPTION = new ExceptionCode("IMEX_EXPORT_DERBY_STARTUP_EXCEPTION", "Apache Derby experienced a startup exception.", "FNRCX0006", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode IMEX_IMPORT_INVALID_XML_START = new ExceptionCode("IMEX_IMPORT_INVALID_XML_START", "The import process encountered an invalid dataset. The {0} XML tag was not found in the expected location. You might have selected the export manifest file instead of the converted deploy dataset file.", "FNRCX0007", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode REPLICATION_LATER_VERSION_EXISTS = new ExceptionCode("REPLICATION_LATER_VERSION_EXISTS", "Can not replicate version {0}.{1} because a later version of {2}.{3} already exists in the target object store.", "FNRCY0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_ANONYMOUS_DISALLOWED = new ExceptionCode("SECURITY_ANONYMOUS_DISALLOWED", "Access to Content Platform Engine was not allowed because the request was made anonymously instead of by an authenticated user.", "FNRCS0001", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_EXCEPTION_READING_OBJECT = new ExceptionCode("SECURITY_EXCEPTION_READING_OBJECT", "An exception occurred while reading a SecurityDescriptor (ACE or ACL).", "FNRCS0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_EXCEPTION_WRITING_OBJECT = new ExceptionCode("SECURITY_EXCEPTION_WRITING_OBJECT", "An exception occurred while writing a SecurityDescriptor (ACE or ACL).", "FNRCS0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_CONFIGURATION = new ExceptionCode("SECURITY_INVALID_CONFIGURATION", "One or more Content Engine directory configurations are missing or invalid.", "FNRCS0004", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_CREDENTIALS = new ExceptionCode("SECURITY_INVALID_CREDENTIALS", "Access to the Content Engine was not allowed because the Content Engine API library or the Web Service Interface (WSI) Listener could not find the required security context information.", "FNRCS0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_DN = new ExceptionCode("SECURITY_INVALID_DN", "Invalid Distinguished Name: {0}", "FNRCS0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_SECURITY_DESCRIPTOR = new ExceptionCode("SECURITY_INVALID_SECURITY_DESCRIPTOR", "An invalid security descriptor was found", "FNRCS0007", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_SID_STRING = new ExceptionCode("SECURITY_INVALID_SID_STRING", "The Security Id string {0} is not a valid Security Id.", "FNRCS0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_DEFAULT_INSTANCE_SECURITY = new ExceptionCode("SECURITY_MISSING_DEFAULT_INSTANCE_SECURITY", "The default instance security for class {0} is missing", "FNRCS0010", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_SECURITY_ID = new ExceptionCode("SECURITY_MISSING_SECURITY_ID", "The security ID {0} cannot be found in the security descriptor table.", "FNRCS0011", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_SORT_TYPE_DESCENDING_NOT_SUPPORTED = new ExceptionCode("SECURITY_SORT_TYPE_DESCENDING_NOT_SUPPORTED", "Sort type specified {0} is not supported in eDirectory.", "FNRCS0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_TOO_MANY_MATCHES = new ExceptionCode("SECURITY_TOO_MANY_MATCHES", "More than one user or group {0} was found in the configured realms for the given attribute {1} and value {2}.", "FNRCS0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_UNEXPECTED_ACE_TYPE = new ExceptionCode("SECURITY_UNEXPECTED_ACE_TYPE", "Unexpected ACE type {0}.", "FNRCS0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_UNEXPECTED_VERSION = new ExceptionCode("SECURITY_UNEXPECTED_VERSION", "Unexpected Security Descriptor, ACL or ACE version {0}.", "FNRCS0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED = new ExceptionCode("SECURITY_WSI_NO_LOGIN_MODULES_SUCCEEDED", "The Content Engine Web Services login failed since no login modules succeeded.", "FNRCS0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_KERBEROS_CREDENTIAL_INVALID = new ExceptionCode("SECURITY_WSI_KERBEROS_CREDENTIAL_INVALID", "Web services Kerberos credential invalid: {0}.", "FNRCS0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_WSI_KERBEROS_LOGIN_FAILED = new ExceptionCode("SECURITY_WSI_KERBEROS_LOGIN_FAILED", "Web services Kerberos login failed: {0}.", "FNRCS0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DOMAIN_ENCRYPTION_UNDEFINED = new ExceptionCode("SECURITY_DOMAIN_ENCRYPTION_UNDEFINED", "The {0} property is undefined for this domain.  This property is automatically defined when the domain object is created, so if you have an old GCD, you may want to recreate the GCD.", "FNRCS0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_EXCEPTION = new ExceptionCode("SECURITY_DEFAULT_CONFIG_EXCEPTION", "An unexpected exception occurred while parsing the default JAAS configuration file. Line number: {0}, Exception: {1}.", "FNRCS0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_EXPAND_ERROR = new ExceptionCode("SECURITY_DEFAULT_CONFIG_EXPAND_ERROR", "Cannot expand Java system property {0} in the default JAAS configuration file. Line number: {1}.", "FNRCS0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_DEFAULT_CONFIG_PARSE_ERROR = new ExceptionCode("SECURITY_DEFAULT_CONFIG_PARSE_ERROR", "Error parsing the default JAAS configuration file. Line number: {0}, Expected token: {1}.", "FNRCS0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_INHERITANCE = new ExceptionCode("SECURITY_INVALID_INHERITANCE", "This object {0} was designated as one that has inherited security and has no inheritable security object values.", "FNRCS0024", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_PROVIDER_FAILED = new ExceptionCode("SECURITY_LDAP_PROVIDER_FAILED", "The server was not able to access the LDAP provider while attempting the operation {0} for the security principal {1}. The cause of the error is: {2}", "FNRCS0025", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_UNSUPPORTED_OPERATION = new ExceptionCode("SECURITY_LDAP_UNSUPPORTED_OPERATION", "LDAP operation ''{0}'' not supported for principal ''{1}''. Root cause: {2}", "FNRCS0026", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_AUTHENTICATION_FAILED = new ExceptionCode("SECURITY_LDAP_AUTHENTICATION_FAILED", "LDAP authentication failed when performing ''{0}'' for principal ''{1}''. Root cause: {2}", "FNRCS0027", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_SID_ATTRIBUTE_VALUE_SIZELIMIT_EXCEEDED = new ExceptionCode("SECURITY_SID_ATTRIBUTE_VALUE_SIZELIMIT_EXCEEDED", "The size of SID attribute {0} exceeded limitation of {1} bytes.", "FNRCS0066", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_REQUIRED_LDAP_ATTRIBUTE_VALUE = new ExceptionCode("SECURITY_MISSING_REQUIRED_LDAP_ATTRIBUTE_VALUE", "A null or empty value encountered during retrieval of a required LDAP attribute value.", "FNRCS0067", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_IMPERSONATION_REGION_ID = new ExceptionCode("SECURITY_MISSING_IMPERSONATION_REGION_ID", "The CE isolated region object was not found. PEInit -K must be run on this isolated region to make it available to the CE. Isolated region ID: {0}", "FNRCS0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_BAD_DOMAIN_REALM = new ExceptionCode("SECURITY_BAD_DOMAIN_REALM", "A user {0} from realm {1} tried to access domain {2} but that realm is not allowed by that domain.", "FNRCS0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_LDAP_CONNECTIVITY_FAILURE = new ExceptionCode("SECURITY_LDAP_CONNECTIVITY_FAILURE", "Failed connecting to LDAP server.", "FNRCS0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_KEY_SERVICE_TYPE = new ExceptionCode("SECURITY_INVALID_KEY_SERVICE_TYPE", "The key service type {0} is not supported.", "FNRCS0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_INVALID_KEY_IDENTIFIER_LENGTH = new ExceptionCode("SECURITY_INVALID_KEY_IDENTIFIER_LENGTH", "The length {1} of a key identifier returned returned by the {0} key service exceeds the maximum {2} allowed.", "FNRCS0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_INVALID_FIELD = new ExceptionCode("SECURITY_KMIP_INVALID_FIELD", "The data item in the message had an invalid value: {0}", "FNRCS0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_SSL_CONNECTION_ERROR = new ExceptionCode("SECURITY_KMIP_SSL_CONNECTION_ERROR", "An unexpected error happened during make SSL connection to host : {0} port :{1}", "FNRCS0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_INVALID_MESSAGE = new ExceptionCode("SECURITY_KMIP_INVALID_MESSAGE", "The message is not valid: {0}", "FNRCS0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_OPERATION_NOT_SUPPORTED = new ExceptionCode("SECURITY_KMIP_OPERATION_NOT_SUPPORTED", "The operation requested by the request message was not supported by the server: {0}", "FNRCS0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_FEATURE_NOT_SUPPORTED = new ExceptionCode("SECURITY_KMIP_FEATURE_NOT_SUPPORTED", "An optional feature specified in the request was not supported: {0}", "FNRCS0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_UNEXPECTED_ERROR = new ExceptionCode("SECURITY_KMIP_UNEXPECTED_ERROR", "An Unexpected error happened while processing the KMIP request: {0}", "FNRCS0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_TRANSPORT_ERROR = new ExceptionCode("SECURITY_KMIP_TRANSPORT_ERROR", "An Unexpected error happened while connecting to the KMIP server: {0}", "FNRCS0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMIP_KEY_CERT_ERROR = new ExceptionCode("SECURITY_KMIP_KEY_CERT_ERROR", "An Unexpected error happened while retrieving the key or certificate: {0}", "FNRCS0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_KEY_SERVICE = new ExceptionCode("SECURITY_MISSING_KEY_SERVICE", "The key identifier provided by an external service was found, but no service is configured.", "FNRCS0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KEYPROTECT_INITIALIZATION_ERROR = new ExceptionCode("SECURITY_KEYPROTECT_INITIALIZATION_ERROR", "Error in initialize connection to KeyProtect services", "FNRCS0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KEYPROTECT_UNEXPECTED_ERROR = new ExceptionCode("SECURITY_KEYPROTECT_UNEXPECTED_ERROR", "Unexpected Error with KeyProtect service", "FNRCS0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_ACCOUNT_DISABLED = new ExceptionCode("SECURITY_ACCOUNT_DISABLED", "The managed user account for {0} is disabled. Contact an administrator.", "FNRCS0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KERBEROS_LOGIN_FAILURE = new ExceptionCode("SECURITY_KERBEROS_LOGIN_FAILURE", "Error in Kerberos login. principal : {0}, ccache file {1}", "FNRCS0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_MISSING_KERBEROS_DOMAIN = new ExceptionCode("SECURITY_MISSING_KERBEROS_DOMAIN", "Missing Kerberos Domain name environment variable: com.filenet.Krb5Domain", "FNRCS0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_KMS_UNEXPECTED_ERROR = new ExceptionCode("SECURITY_KMS_UNEXPECTED_ERROR", "Unexpected Error with AWS KMS service", "FNRCS0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_CLASS_NOT_FOUND = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_CLASS_NOT_FOUND", "The Java class {0} specified for the Credentials Manager ''{1}'' could not be loaded.", "FNRCS0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_INIT_ERROR = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_INIT_ERROR", "The Credentials Manager ''{0}'' failed to initialize.", "FNRCS0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_GET_ERROR = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_GET_ERROR", "The Credentials Manager implementation in {0} reported an error returning credentials for object {1} of class {2}.", "FNRCS0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_CONSUMER_ERROR = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_CONSUMER_ERROR", "The Credentials Manager implementation in {0} is not supported for the consumer class {1}.", "FNRCS0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_CONFIG_PARAMETER_ERROR = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_CONFIG_PARAMETER_ERROR", "The Credentials Manager implementation in {0} reported an error of the configuration parameter {1}.", "FNRCS0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode SECURITY_CREDENTIALS_MANAGER_MISSING_CONFIG_PARAMETER_ERROR = new ExceptionCode("SECURITY_CREDENTIALS_MANAGER_MISSING_CONFIG_PARAMETER_ERROR", "The Credentials Manager implementation in {0} is missing the required configuration parameter {1}.", "FNRCS0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_DOMAIN_ALREADY_EXISTS = new ExceptionCode("GCD_DOMAIN_ALREADY_EXISTS", "An attempt was made to create a FileNet P8 domain when the Content Platform Engine server has detected that another domain already exists.", "FNRCG0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_LOAD = new ExceptionCode("GCD_CANNOT_LOAD", "The GCD cannot be loaded.", "FNRCG0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_LOCK = new ExceptionCode("GCD_CANNOT_LOCK", "Cannot lock the GCD for updates: {0}.", "FNRCG0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_CANNOT_SAVE = new ExceptionCode("GCD_CANNOT_SAVE", "The GCD cannot be saved.", "FNRCG0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_DOMAIN_DOES_NOT_EXIST = new ExceptionCode("GCD_DOMAIN_DOES_NOT_EXIST", "An operation is being performed that assumes the existence of a FileNet P8 domain, but the domain does not exist.", "FNRCG0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_INVALID_CONFIGURATION = new ExceptionCode("GCD_INVALID_CONFIGURATION", "The GCD configuration is invalid.", "FNRCG0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_INVALID_EPOCH_ID = new ExceptionCode("GCD_INVALID_EPOCH_ID", "Invalid epoch id {0}, expected {1}.", "FNRCG0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_JNDI_FAILURE = new ExceptionCode("GCD_JNDI_FAILURE", "The GCD configuration string cannot be retrieved from JNDI.", "FNRCG0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_MISSING_CONFIGURATION = new ExceptionCode("GCD_MISSING_CONFIGURATION", "The GCD configuration is missing.", "FNRCG0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_NO_REPLACE_COLLECTION = new ExceptionCode("GCD_NO_REPLACE_COLLECTION", "The specified node does not support replaceCollection.", "FNRCG0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_NO_SERVER_CALL_CONTEXT = new ExceptionCode("GCD_NO_SERVER_CALL_CONTEXT", "No server call context has been established.", "FNRCG0011", true, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_OBJECT_ALREADY_EXISTS = new ExceptionCode("GCD_OBJECT_ALREADY_EXISTS", "The object {0} already exists.", "FNRCG0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_UNEXPECTED_STATE = new ExceptionCode("GCD_UNEXPECTED_STATE", "The state of the GCD was found to be inconsistent. Contact customer support.", "FNRCG0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode GCD_DATABASE_UNAVAILABLE = new ExceptionCode("GCD_DATABASE_UNAVAILABLE", "The GCD database is currently not available. A file-based, read-only image of the GCD will be used in its place. All update operations will be disallowed until database availability has been restored.", "FNRCG0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLASS_MAPPING_PARSE_ERROR = new ExceptionCode("IS_CLASS_MAPPING_PARSE_ERROR", "An error occurred while parsing the XML contained in the DocClassAndPropertyMappingXML property.", "FNRCI0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ACTION_NOT_SUP = new ExceptionCode("IS_PD_ACTION_NOT_SUP", "Catalog Export Log action {0} is not supported.", "FNRCI0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_ERROR = new ExceptionCode("IS_PD_ANNOT_ERROR", "A CFS-IS Import Agent exception occurred during annotation processing.", "FNRCI0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_IRRECOVERABLE_ERR = new ExceptionCode("IS_PD_ANNOT_IRRECOVERABLE_ERR", "A CFS-IS Import Agent exception occurred during annotation processing. The annotation log will be deleted from the Image Service system. Fix the problem and re-export the annotation.", "FNRCI0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_ADD_COMPENT = new ExceptionCode("IS_PD_CANNOT_ADD_COMPENT", "CFS-IS document {0} cannot be added to the list of completed entries.", "FNRCI0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_CLEAR_INX_SHM = new ExceptionCode("IS_PD_CANNOT_CLEAR_INX_SHM", "The document processing data on the Image Services system cannot be cleared when the Content Engine is being shutdown.", "FNRCI0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_FIND_COMPENT = new ExceptionCode("IS_PD_CANNOT_FIND_COMPENT", "The completed entry for document {0} canont be found.", "FNRCI0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_GET_COMPENT = new ExceptionCode("IS_PD_CANNOT_GET_COMPENT", "The completed entry for document {0} cannot be retrieved.", "FNRCI0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CANNOT_RECOVER_DOC = new ExceptionCode("IS_PD_CANNOT_RECOVER_DOC", "Document {0} cannot be recovered.", "FNRCI0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_PROP_TYPE_NOT_SUP = new ExceptionCode("IS_PD_CE_PROP_TYPE_NOT_SUP", "Content Engine property type {0} is not supported.", "FNRCI0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_UNEXPECTED_PROP_TYPE = new ExceptionCode("IS_PD_CE_UNEXPECTED_PROP_TYPE", "The property type for Content Engine property {0} in document {1} is not expected.", "FNRCI0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_COMMIT_ERROR = new ExceptionCode("IS_PD_COMMIT_ERROR", "Got {0} catalog entries, only completed {1} entries.", "FNRCI0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_ELEMENT_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_ELEMENT_ERROR", "The content element object cannot be created.", "FNRCI0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_REF_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_REF_ERROR", "The content reference object cannot be created.", "FNRCI0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CREATE_CONTENT_XFER_ERROR = new ExceptionCode("IS_PD_CREATE_CONTENT_XFER_ERROR", "The content transfer object cannot be created.", "FNRCI0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_ID_NOT_FOUND = new ExceptionCode("IS_PD_DCL_ID_NOT_FOUND", "The ID for the external document class [{0}] cannot be obtained.", "FNRCI0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_NOT_MAPPED = new ExceptionCode("IS_PD_DCL_NOT_MAPPED", "The external document {0} cannot be processed. The external document class ID {1} is not mapped to a Content Engine document class.", "FNRCI0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_NOT_MATCH = new ExceptionCode("IS_PD_DCL_NOT_MATCH", "The update of the external document {0} to the Content Engine document {1} was rejected because the Content Engine document class ID {2} does not match the current document class mapping. The external document class {3} is mapped to the Content Engine document class {4} (ID={5}).", "FNRCI0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DCL_TO_ID_ERROR = new ExceptionCode("IS_PD_DCL_TO_ID_ERROR", "The list of IDs for the Image Services document classes could not be retrieved.", "FNRCI0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DELETE_DOC_ERROR = new ExceptionCode("IS_PD_DELETE_DOC_ERROR", "The Content Engine document {0} cannot be deleted.", "FNRCI0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DN_NOT_FOUND = new ExceptionCode("IS_PD_DN_NOT_FOUND", "The Distinguished Name [{0}] cannot be found.", "FNRCI0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_DOC_ERROR = new ExceptionCode("IS_PD_DOC_ERROR", "A CFS-IS Import Agent exception occurred during document processing.", "FNRCI0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_ANNOTATED_DOC_ERROR = new ExceptionCode("IS_PD_FETCH_ANNOTATED_DOC_ERROR", "The annotated document {0} cannot be retrieved.", "FNRCI0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_CUSTOM_OBJ_ERROR = new ExceptionCode("IS_PD_FETCH_CUSTOM_OBJ_ERROR", "The Custom Object {0} cannot be retrieved.", "FNRCI0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_FETCH_DOC_ERROR = new ExceptionCode("IS_PD_FETCH_DOC_ERROR", "The document {0} cannot be retrieved.", "FNRCI0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_LOG_ERROR = new ExceptionCode("IS_PD_GET_LOG_ERROR", "Federated entries from the Image Services system {0} cannot be retrieved. The operation is being retried.", "FNRCI0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_MAPPING_NOT_INIT = new ExceptionCode("IS_PD_MAPPING_NOT_INIT", "Document Class and Properties mapping have not been initialized.", "FNRCI0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_MISC_ERROR = new ExceptionCode("IS_PD_MISC_ERROR", "A CFS-IS Import Agent exception occurred.", "FNRCI0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NEW_DIR_MISMATCH = new ExceptionCode("IS_PD_NEW_DIR_MISMATCH", "The Content Engine property value does not match the CFS-IS current catalog value.", "FNRCI0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NO_DN = new ExceptionCode("IS_PD_NO_DN", "The Distinguished Name for the Image Services principal ID {0} cannot be retrieved.", "FNRCI0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_NO_FSA = new ExceptionCode("IS_PD_NO_FSA", "The Fixed Storage Area for the Fixed Content Device {0} cannot be found.", "FNRCI0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_OLD_DIR_MISMATCH = new ExceptionCode("IS_PD_OLD_DIR_MISMATCH", "The Content Engine property value does not match the CFS-IS previous catalog value.", "FNRCI0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_OS_GUID = new ExceptionCode("IS_PD_OS_GUID", "Failed to set up FN_IS_GUID for object store {0}.", "FNRCI0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PARSER_ERROR = new ExceptionCode("IS_PD_PARSER_ERROR", "An error occurred while parsing the XML in the Custom Object {0}.", "FNRCI0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROP_ID_NOT_FOUND = new ExceptionCode("IS_PD_PROP_ID_NOT_FOUND", "The ID for the Image Services property [{0}] cannot be found.", "FNRCI0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROP_TO_ID_ERROR = new ExceptionCode("IS_PD_PROP_TO_ID_ERROR", "The list of IDs for the Image Services properties could not be retrieved.", "FNRCI0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SAVE_BATCH_ERROR = new ExceptionCode("IS_PD_SAVE_BATCH_ERROR", "An error occurred while saving a batch of catalog entries.", "FNRCI0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SAVE_DOC_ERROR = new ExceptionCode("IS_PD_SAVE_DOC_ERROR", "An error occurred while saving the Content Engine document {0}.", "FNRCI0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_SSI_LOGON_ERROR = new ExceptionCode("IS_PD_SSI_LOGON_ERROR", "SSI Logon to {0} failed, retrying.", "FNRCI0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UNEXPECTED_INDEX_TYPE = new ExceptionCode("IS_PD_UNEXPECTED_INDEX_TYPE", "Image Services index type {0} in document {1} is not expected.", "FNRCI0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UPDATE_DOC_ERROR = new ExceptionCode("IS_PD_UPDATE_DOC_ERROR", "Inbound update of the Image Services document ID {0} failed.", "FNRCI0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_XML_LEN_ERROR = new ExceptionCode("IS_PD_XML_LEN_ERROR", "The XML string in the Custom Object {0} is less than the minimum length of {1}.", "FNRCI0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_XML_VERSION_ERROR = new ExceptionCode("IS_PD_XML_VERSION_ERROR", "Wrong XMLVERSION in the Custom Object {0}. Expect {1}, got {2}.", "FNRCI0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_DOC_BUILDER_ERROR = new ExceptionCode("IS_PS_DOC_BUILDER_ERROR", "newDocumentBuilder method failed; object ''{0}. . .'' (retry in {1} minutes).", "FNRCI0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_PARSE_IO_ERROR = new ExceptionCode("IS_PS_PARSE_IO_ERROR", "I/O exception while parsing custom object; object: ''{0}. . .'' (retry in {1} minutes).", "FNRCI0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PS_PARSE_SAX_ERROR = new ExceptionCode("IS_PS_PARSE_SAX_ERROR", "SAX exception while parsing custom object; object: ''{0}. . .'' (retry in {1} minutes).", "FNRCI0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLOSE_NOT_ALLOWED = new ExceptionCode("IS_CLOSE_NOT_ALLOWED", "Image Services Replication cannot be shutdown.", "FNRCI0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ALL_PUSH_WORKERS_BUSY = new ExceptionCode("IS_ALL_PUSH_WORKERS_BUSY", "The maximum number of push workers was exceeded.  Too many threads are running.", "FNRCI0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULL_WORKER_CALLED_WHILE_BUSY = new ExceptionCode("IS_PULL_WORKER_CALLED_WHILE_BUSY", "The index for a pullWork call refers to a worker that is still busy from a previous call.", "FNRCI0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPLICATION_PROVIDER_NOT_INITIALIZED = new ExceptionCode("IS_REPLICATION_PROVIDER_NOT_INITIALIZED", "The Image Services replication provider must be initialized before calling any of its functions.", "FNRCI0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED = new ExceptionCode("IS_REPLICATION_PROVIDER_ALREADY_INITIALIZED", "The Image Services replication provider has already been initialized and can only be initialized once.", "FNRCI0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULL_WORKER_INDEX_INVALID = new ExceptionCode("IS_PULL_WORKER_INDEX_INVALID", "An inbound worker was requested that does not exist.", "FNRCI0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_SSI_LOGON_ERROR = new ExceptionCode("IS_SSI_LOGON_ERROR", "SSI Logon failed for {0}.", "FNRCI0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_SSI_LOGOFF_ERROR = new ExceptionCode("IS_SSI_LOGOFF_ERROR", "SSI Logoff failed for {0}.", "FNRCI0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CONNECT_ERROR = new ExceptionCode("IS_CONNECT_ERROR", "Failed to connect to the Image Services system {0} due to a network or cache resource problem.", "FNRCI0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_OUTBOUND_REPL_ERROR = new ExceptionCode("IS_OUTBOUND_REPL_ERROR", "Error encountered during outbound replication to IS.", "FNRCI0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CANNOT_GET_DCL_MAPPING = new ExceptionCode("IS_CANNOT_GET_DCL_MAPPING", "The Image Services document class or properties mapping for Object Store {0} and {1} cannot be retrieved.", "FNRCI0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_DATE_PARSE_ERR = new ExceptionCode("IS_DATE_PARSE_ERR", "Error occurred while parsing the date {0}. Create or update action for document {1} will not be replicated. Image Services date string must conform to the ISO format of \"yyyy-MM-dd\" GMT.", "FNRCI0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PULLWORKER_ERROR = new ExceptionCode("IS_PULLWORKER_ERROR", "An error occurred in a CFS-IS inbound replication worker.", "FNRCI0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_CE_PROP_UPDATED = new ExceptionCode("IS_PD_CE_PROP_UPDATED", "The property {1} in the document {0} will be overridden by the value from the Image Services system.", "FNRCI0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_GROUP_UNEXPECTED_EXCEPTION = new ExceptionCode("IS_REPL_GROUP_UNEXPECTED_EXCEPTION", "An unexpected exception occurred in a {0} function for Replication Group {1} and Image Services system {2}.", "FNRCI0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_GROUP_FUNCTION_ERROR = new ExceptionCode("IS_REPL_GROUP_FUNCTION_ERROR", "An error {0} occurred in a {1} function for Replication Group [{2}] and Image Services system {3}.", "FNRCI0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_NOT_SUPPORTED = new ExceptionCode("IS_ANNOT_NOT_SUPPORTED", "The annotation class is not supported, the number of content elements is not one or Annotated Content Element property is null.", "FNRCI0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_CANT_FETCH_OBJ = new ExceptionCode("IS_REPL_CANT_FETCH_OBJ", "Object {0} cannot be retrieved.", "FNRCI0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_INVALID_ANNOT_EXTID = new ExceptionCode("IS_INVALID_ANNOT_EXTID", "The external object identity {0} in annotation {1} is not valid.", "FNRCI0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_PERM_ERR = new ExceptionCode("IS_ANNOT_PERM_ERR", "There is an exception in the annotation access permission.", "FNRCI0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ISR_NOT_CREATED = new ExceptionCode("IS_ISR_NOT_CREATED", "The Image Services Repository must be created for each IS FCD.", "FNRCI0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_STRING_EXCEED_MAX = new ExceptionCode("IS_STRING_EXCEED_MAX", "The length of the Content Engine String property {0} exceeds the Image Services supported maximum length of 239.", "FNRCI0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_RG_ALREADY_EXIST = new ExceptionCode("IS_RG_ALREADY_EXIST", "Replication group {0} [{1}] already exists for object store {2} and Image Services repository {3}.", "FNRCI0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DATE_ERR = new ExceptionCode("IS_PD_ANNOT_DATE_ERR", "The inbound annotation update was rejected because the modify date is older than the last modified date for the current Content Engine annotation value. This error can result when the Image Services and Content Engine system clocks are not synchronized. The annotation entry will be deleted from the Image Services system.", "FNRCI0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROPERTY_UPDATE_ERR = new ExceptionCode("IS_PD_PROPERTY_UPDATE_ERR", "The Image Services document {0} was rejected because an {1} error occurred when setting the Content Engine property {2} to Image Services index {3} = ''{4}''. {5}", "FNRCI0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CONFIRM_CLASS_MAPPING_ERROR = new ExceptionCode("IS_CONFIRM_CLASS_MAPPING_ERROR", "An error {0} occurred when sending class mapping changes to the Image Services system {1} for object store {2}. Operation is {3}, external class is [{4}].", "FNRCI0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_DICT_TS_ERROR = new ExceptionCode("IS_PD_GET_DICT_TS_ERROR", "The data dictionary time stamp for the Image Services system cannot be retrieved.", "FNRCI0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_DOC_DELETE_NOT_ALLOWED = new ExceptionCode("IS_DOC_DELETE_NOT_ALLOWED", "Deletion of the CE document is not allowed.", "FNRCI0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_INBOUND_DOC_UPDATE_ERROR = new ExceptionCode("IS_INBOUND_DOC_UPDATE_ERROR", "The update from the Image Services document {0} to the Content Engine document {1} cannot be processed because the Content Engine document has a replication error.", "FNRCI0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_REPL_LEAVE_GROUP_ERROR = new ExceptionCode("IS_REPL_LEAVE_GROUP_ERROR", "The replication group [{0}] cannot be deleted. The default mappings for object store {1} need to be removed from the Image Services system {2} using Remote Admin Console (RAC).", "FNRCI0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DOC_ERROR = new ExceptionCode("IS_PD_ANNOT_DOC_ERROR", "The {0} action for the annotation {1} could not be processed because the Content Engine document cannot be found.", "FNRCI0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_REPL_ERROR", "The annotation {0} could not be processed because the replication group {1} did not match the document replication group {2}.", "FNRCI0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_DOC_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_DOC_REPL_ERROR", "The annotation {0} could not be processed because the document is not replicated.", "FNRCI0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_MOVECONTENT_CANT_NULL_RG = new ExceptionCode("IS_MOVECONTENT_CANT_NULL_RG", "The replication group and external object Id for the document {0} and its annotations cannot be removed during MoveContent post processing.", "FNRCI0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_PROPERTY_CONVERT_ERR = new ExceptionCode("IS_PD_PROPERTY_CONVERT_ERR", "The Image Services document {0} was rejected because an {1} error occurred converting the Image Services index {2} = ''{3}'' to the Content Engine type {4}.", "FNRCI0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_NOT_SUPPORTED_INFO = new ExceptionCode("IS_ANNOT_NOT_SUPPORTED_INFO", "Image Services annotations will not be federated for Object Store {0}.  To federate Image Services annotations, install the CFS-IS Extensions AddOn for the Object Store and then restart Content Engine.", "FNRCI0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_REPL_UPDATE_ERROR = new ExceptionCode("IS_PD_ANNOT_REPL_UPDATE_ERROR", "The update or delete action for annotation {0} could not be processed because the replication group {1} did not match the existing Content Engine annotation replication group {2}.", "FNRCI0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_ANNOT_NOT_REPL_ERROR = new ExceptionCode("IS_PD_ANNOT_NOT_REPL_ERROR", "The update or delete action for annotation {0} could not be processed because the existing Content Engine annotation is not replicated.", "FNRCI0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_GET_ANNOTATIONS_ERROR = new ExceptionCode("IS_PD_GET_ANNOTATIONS_ERROR", "An error occurred while getting all the annotations for the Content Engine document {0}.", "FNRCI0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_UPDATE_ANNOT_NOT_FOUND = new ExceptionCode("IS_PD_UPDATE_ANNOT_NOT_FOUND", "The Content Engine annotation cannot be retrieved for update. The annotation may have been deleted or it may not be replicated.", "FNRCI0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_CLASS_DEFAULT_MAPPED = new ExceptionCode("IS_CLASS_DEFAULT_MAPPED", "The class mapping cannot be updated or removed. The default mapping for the external class {0} and the object store {1} must be removed from the Image Services system {2} using Remote Admin Console (RAC).", "FNRCI0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_LOCK_INTERRUPT = new ExceptionCode("IS_LOCK_INTERRUPT", "The IS data dictionary information could not be retrieved because it timed out or was interrupted while waiting for a lock in {0}.", "FNRCI0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_ATTR_INVALID = new ExceptionCode("IS_ANNOT_ATTR_INVALID", "The {0} attribute in the {1} annotation is not valid.", "FNRCI0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_TOO_LARGE = new ExceptionCode("IS_ANNOT_TOO_LARGE", "The {0} annotation is too large to replicate to Image Services.", "FNRCI0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_ANNOT_INVALID = new ExceptionCode("IS_ANNOT_INVALID", "The document annotation {0} originating from the Image Services server is not valid. {1}", "FNRCI0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_PD_MISMATCH_RG = new ExceptionCode("IS_PD_MISMATCH_RG", "The Replication Group in document {0} is {1} instead of {2}. Inbound replication for this object will be ignored.", "FNRCI0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_DEREPL_NOT_ALLOWED_DURING_ASYNC_UPGRADE = new ExceptionCode("IS_DEREPL_NOT_ALLOWED_DURING_ASYNC_UPGRADE", "Stop replication is not allowed during asynchronous replication upgrade for object store {0}.", "FNRCI0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode IS_UPDATE_DUP_ANNOT = new ExceptionCode("IS_UPDATE_DUP_ANNOT", "Annotation {0} is a duplicate and should be deleted. Update is not allowed.", "FNRCI0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_AREA_ACCESS_FAILED = new ExceptionCode("CONTENT_CACHE_AREA_ACCESS_FAILED", "Access to the content cache area directory failed.", "FNRCC0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_FILE_STREAM_ALREADY_CLOSED = new ExceptionCode("CONTENT_CACHE_FILE_STREAM_ALREADY_CLOSED", "The cache file input stream is already closed.", "FNRCC0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_INTERNAL_ERROR = new ExceptionCode("CONTENT_CACHE_INTERNAL_ERROR", "A content cache error occurred internal to the server.", "FNRCC0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_SOURCE_STORAGE_AREA_FAILED = new ExceptionCode("CONTENT_CACHE_SOURCE_STORAGE_AREA_FAILED", "The content cache operation failed because there was a problem accessing the source storage area.", "FNRCC0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_INTERNAL_ERROR = new ExceptionCode("CONTENT_CA_INTERNAL_ERROR", "A content area error occurred internal to the server. See messages in the FileNet P8 server error log for the cause of this exception.", "FNRCC0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CLOSE_FAILED = new ExceptionCode("CONTENT_CA_CLOSE_FAILED", "The close failed on the stream.", "FNRCC0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CONSOLIDATING_CHUNKS_FAILED = new ExceptionCode("CONTENT_CA_CONSOLIDATING_CHUNKS_FAILED", "Consolidating a content element failed for {0}.", "FNRCC0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_CONTINUE_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_CONTINUE_UPLOAD_FAILED", "Continuation upload for large content failed: {0}.", "FNRCC0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_COOKIE_MISSING_PARAM = new ExceptionCode("CONTENT_CA_COOKIE_MISSING_PARAM", "The cookie {0} is missing a required parameter, {1}.", "FNRCC0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_FAILED = new ExceptionCode("CONTENT_CA_DELETE_FAILED", "Unable to delete file: {0}.", "FNRCC0010", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_FAILED_RETENTION_CHECK = new ExceptionCode("CONTENT_CA_DELETE_FAILED_RETENTION_CHECK", "Content Engine could not delete or move content because the retention period for the item has not expired. Current time: {0}; Retention time: {1}.", "FNRCC0011", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_DELETE_SCRUB_FAILED = new ExceptionCode("CONTENT_CA_DELETE_SCRUB_FAILED", "Unable to scrub file for secure delete: {0}.", "FNRCC0012", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FAILED_TEMP_CREATION = new ExceptionCode("CONTENT_CA_FAILED_TEMP_CREATION", "The attempt to create the temporary content file failed.", "FNRCC0013", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FEDERATED_REQUIRES_FIXED_SA = new ExceptionCode("CONTENT_CA_FEDERATED_REQUIRES_FIXED_SA", "Federated content requires a FixedStorageArea; current StorageArea Id: ({0})", "FNRCC0014", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FINISH_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_FINISH_UPLOAD_FAILED", "The upload failed to finish.", "FNRCC0015", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_INVALID_COOKIE = new ExceptionCode("CONTENT_CA_INVALID_COOKIE", "Invalid cookie {0}.", "FNRCC0016", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_MIXED_FEDERATED_CONTENT = new ExceptionCode("CONTENT_CA_MIXED_FEDERATED_CONTENT", "Federated content elements cannot be mixed with non-federated content elements.", "FNRCC0017", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_OUTPUT_STREAM_ALREADY_SET = new ExceptionCode("CONTENT_CA_OUTPUT_STREAM_ALREADY_SET", "The output stream has already been set.", "FNRCC0018", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_READ_FAILED = new ExceptionCode("CONTENT_CA_READ_FAILED", "The read failed for objId={0}.", "FNRCC0019", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_READ_STREAM_ALREADY_SET = new ExceptionCode("CONTENT_CA_READ_STREAM_ALREADY_SET", "The stream has already been set for retrieval.", "FNRCC0020", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_SKIP_BACKWARD_NOT_SUPPORTED = new ExceptionCode("CONTENT_CA_SKIP_BACKWARD_NOT_SUPPORTED", "The underlying stream does not support moving backward.", "FNRCC0021", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_SKIP_FAILED = new ExceptionCode("CONTENT_CA_SKIP_FAILED", "The stream didn''t skip the expected amount, {0}; actual {1}.", "FNRCC0022", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_START_UPLOAD_FAILED = new ExceptionCode("CONTENT_CA_START_UPLOAD_FAILED", "Start upload failed {0}.", "FNRCC0023", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_STORE_CHUNK_FAILED = new ExceptionCode("CONTENT_CA_STORE_CHUNK_FAILED", "The attempt to store a content chunk failed.", "FNRCC0024", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UNABLE_TO_ABANDONED_DELETE_FILE = new ExceptionCode("CONTENT_CA_UNABLE_TO_ABANDONED_DELETE_FILE", "Unable to delete abandoned file ''{0}''.", "FNRCC0025", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UNKNOWN_CONTENT_UPLOAD_COOKIE = new ExceptionCode("CONTENT_CA_UNKNOWN_CONTENT_UPLOAD_COOKIE", "Unknown content upload cookie {0}.", "FNRCC0026", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_UPLOAD_FAILED_WRITE = new ExceptionCode("CONTENT_CA_UPLOAD_FAILED_WRITE", "The upload failed due to a problem writing content.", "FNRCC0027", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_NOT_FOUND = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_NOT_FOUND", "Content validation failed because it does not exist or is inaccessible in the storage area: objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0028", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_PENDING_FINALIZATION = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_PENDING_FINALIZATION", "Content validation failed due to pending finalization.  Please try validation again at a later time for objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0029", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_SIZE = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_SIZE", "Content validation failed due to size mismatch:  expected [{0}]; actual [{1}] for objId={2}; seqNo={3}; retrievalName={4}", "FNRCC0030", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_CREATE_TEMP_FOLDER_FAILED = new ExceptionCode("CONTENT_CONFIG_CREATE_TEMP_FOLDER_FAILED", "Failed to create sub folder {0} under comtent temporary directory root {1}.", "FNRCC0031", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_TEMP_ROOT_DOES_NOT_EXIST = new ExceptionCode("CONTENT_CONFIG_TEMP_ROOT_DOES_NOT_EXIST", "The content temporary directory root {0} does not exist.", "FNRCC0032", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CONFIG_TEMP_ROOT_NOT_FOLDER = new ExceptionCode("CONTENT_CONFIG_TEMP_ROOT_NOT_FOLDER", "The content temporary directory root value does not specify a directory: {0}.", "FNRCC0033", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_APPEND_NOT_SUPPORTED = new ExceptionCode("CONTENT_DCA_APPEND_NOT_SUPPORTED", "The database does not support appending content.", "FNRCC0034", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_CONTENT_ELEMENT_NOT_FOUND = new ExceptionCode("CONTENT_DCA_CONTENT_ELEMENT_NOT_FOUND", "Cannot find the content element {0}.", "FNRCC0035", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_FAILED_INSERT = new ExceptionCode("CONTENT_DCA_FAILED_INSERT", "The content element could not be inserted.", "FNRCC0036", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_DCA_WRONG_LENGTH = new ExceptionCode("CONTENT_DCA_WRONG_LENGTH", "The Content insert has the wrong length: expected {0}; actual {1}.", "FNRCC0037", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_CREATE_FAILED", "Create failed in rootDir {0}, for {1}.", "FNRCC0038", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DELETE_FAILED = new ExceptionCode("CONTENT_FCA_DELETE_FAILED", "Delete failed {0}.", "FNRCC0039", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DIR_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_DIR_ALREADY_EXISTS", "Create failed, the directory already exists: {0}.", "FNRCC0040", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_DIR_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_DIR_CREATE_FAILED", "Create failed, the directory wasn''t created: {0}.", "FNRCC0041", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_RETRIEVING_EXTENSION = new ExceptionCode("CONTENT_FCA_FAILED_RETRIEVING_EXTENSION", "Failed loading content element extension: {0}.", "FNRCC0042", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_RETRIEVING_OBJECT = new ExceptionCode("CONTENT_FCA_FAILED_RETRIEVING_OBJECT", "Failed loading content element document: {0}.", "FNRCC0043", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FAILED_STAKEFILE_LOAD = new ExceptionCode("CONTENT_FCA_FAILED_STAKEFILE_LOAD", "The root directory containing stakefile {0} for the storage area, storage device, or fixed content device cannot be accessed.", "FNRCC0044", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FILE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_FILE_ALREADY_EXISTS", "The file already exists {0}.", "FNRCC0045", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FILE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_FILE_DOES_NOT_EXIST", "The file does not exist {0}.", "FNRCC0046", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_INIT_FAILED = new ExceptionCode("CONTENT_FCA_INIT_FAILED", "The initialization failed.", "FNRCC0047", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_PARENT_OF_FILE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_PARENT_OF_FILE_DOES_NOT_EXIST", "The parent directory of the file {0} does not exist.", "FNRCC0048", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_READ_FAILED = new ExceptionCode("CONTENT_FCA_READ_FAILED", "Read failed {0}; offset={1}.", "FNRCC0049", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_ROOT_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCA_ROOT_DOES_NOT_EXIST", "Create failed, the root folder does not exist: {0}.", "FNRCC0050", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_ROOT_NOT_A_DIRECTORY = new ExceptionCode("CONTENT_FCA_ROOT_NOT_A_DIRECTORY", "Create failed, the root folder value does not specify a directory: {0}.", "FNRCC0051", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_SAVE_FAILED = new ExceptionCode("CONTENT_FCA_SAVE_FAILED", "Save failed {0} at offset {1}.", "FNRCC0052", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCA_STAKEFILE_ALREADY_EXISTS", "A stakefile already exists at this location {0}.", "FNRCC0053", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_CREATE_FAILED = new ExceptionCode("CONTENT_FCA_STAKEFILE_CREATE_FAILED", "Stakefile create failed {0}.", "FNRCC0054", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_STAKEFILE_INVALID_DATE_FORMAT = new ExceptionCode("CONTENT_FCA_STAKEFILE_INVALID_DATE_FORMAT", "Invalid date format found in stakefile {0}.", "FNRCC0055", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_UNABLE_TO_RENAME_FILE = new ExceptionCode("CONTENT_FCA_UNABLE_TO_RENAME_FILE", "\"{0}\" cannot be renamed to \"{1}\".", "FNRCC0056", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ADMIN_INVALID_COMMAND_CODE = new ExceptionCode("CONTENT_FCP_ADMIN_INVALID_COMMAND_CODE", "Expected command code [{0}].  Received invalid command code [{1}].", "FNRCC0057", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ADMIN_INVALID_FUNCTION = new ExceptionCode("CONTENT_FCP_ADMIN_INVALID_FUNCTION", "Invalid admin function type [{0}] specified.", "FNRCC0058", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLIP_CREATION_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLIP_CREATION_FAILED", "Failed to get the Creation Time for Centera Clip [{0}].", "FNRCC0059", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLIP_RETENTION_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLIP_RETENTION_FAILED", "Failed to get the Retention Reriod for Centera Clip [{0}].", "FNRCC0060", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_CLUSTER_TIME_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_CLUSTER_TIME_FAILED", "The Centera cluster current time could not be retrieved.", "FNRCC0061", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_GET_POOL_SETUP_VALUE_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_GET_POOL_SETUP_VALUE_FAILED", "Failed to get the Centera pool [{0}] setup.", "FNRCC0062", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_LOAD_POOL_FILE_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_LOAD_POOL_FILE_FAILED", "Failed to load Pool information file: {0}.", "FNRCC0063", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_OPEN_POOL_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_OPEN_POOL_FAILED", "The Centera connection pool could not be opened.", "FNRCC0064", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_PROCESS_SITEMAP_FAILED = new ExceptionCode("CONTENT_FCP_CENTERA_PROCESS_SITEMAP_FAILED", "The Centera connection string from the site mapping XML data could not be retrieved.", "FNRCC0065", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_REFERRAL_URLS_TAGNUM_MISMATCH = new ExceptionCode("CONTENT_FCP_CENTERA_REFERRAL_URLS_TAGNUM_MISMATCH", "The tag index numbers in the referral URLs are not in the correct order. expected [{0}], actual [{1}].", "FNRCC0066", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_ALREADY_EXISTS = new ExceptionCode("CONTENT_FCP_CE_ALREADY_EXISTS", "Content element create failed, a content element with the name {0} already exists.", "FNRCC0067", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DELETE_FAILED = new ExceptionCode("CONTENT_FCP_CE_DELETE_FAILED", "Content element delete failed for {0}.", "FNRCC0068", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DOES_NOT_EXIST = new ExceptionCode("CONTENT_FCP_CE_DOES_NOT_EXIST", "No content element found for CE Sequence Number: [{0}].", "FNRCC0069", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_DUPLICATE_SEQ_NUM = new ExceptionCode("CONTENT_FCP_CE_DUPLICATE_SEQ_NUM", "Content element duplicate sequence number detected: [{0}].", "FNRCC0070", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_OPEN_FAILED = new ExceptionCode("CONTENT_FCP_CE_OPEN_FAILED", "The operation to open a content element failed for this provider.", "FNRCC0071", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_READ_FAILED = new ExceptionCode("CONTENT_FCP_CE_READ_FAILED", "The content element could not be read.", "FNRCC0072", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_SEEK_FAILED = new ExceptionCode("CONTENT_FCP_CE_SEEK_FAILED", "The content element seek operation failed for this provider.", "FNRCC0073", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CONNECTION_FAILED = new ExceptionCode("CONTENT_FCP_CONNECTION_FAILED", "The fixed content provider could not establish a connection to the fixed content device.", "FNRCC0074", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CONTENT_CACHE_CHECK_FAILED = new ExceptionCode("CONTENT_FCP_CONTENT_CACHE_CHECK_FAILED", "The call to isContentCached failed for this provider.", "FNRCC0075", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CREATE_CE_FAILED = new ExceptionCode("CONTENT_FCP_CREATE_CE_FAILED", "Content element create failed for {0}.", "FNRCC0076", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_CREATE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_CREATE_FAILED", "The document could not be created for this provider.", "FNRCC0077", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_CREATE_FAILED_BAD_INPUT = new ExceptionCode("CONTENT_FCP_DOC_CREATE_FAILED_BAD_INPUT", "The document could not be created because the source file {0} could not be read.", "FNRCC0078", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_DELETE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_DELETE_FAILED", "The document could not be deleted for this provider.", "FNRCC0079", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_DOC_EXISTS_FAILED", "The check to determine whether the document exists failed for this provider.", "FNRCC0080", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_LOCKDOWN_FAILED = new ExceptionCode("CONTENT_FCP_DOC_LOCKDOWN_FAILED", "The document could not be locked down for this provider.", "FNRCC0081", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_DIRECTORY_NOT_FOUND = new ExceptionCode("CONTENT_FCP_FSB_DIRECTORY_NOT_FOUND", "Directory not found: {0}.", "FNRCC0082", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_FSB_EXISTS_FAILED", "Failed to determine whether file exists {0}.", "FNRCC0083", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_INVALID_PROVIDER = new ExceptionCode("CONTENT_FCP_FSB_INVALID_PROVIDER", "The Fixed Content Provider specified is invalid: it is not a snaplock device.", "FNRCC0084", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_MKDIR_FAILED = new ExceptionCode("CONTENT_FCP_FSB_MKDIR_FAILED", "Failed to make directory {0}.", "FNRCC0085", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_OPEN_FAILED = new ExceptionCode("CONTENT_FCP_FSB_OPEN_FAILED", "Failed to open file {0}.", "FNRCC0086", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_REFERRAL_NUM_SEQ_MISMATCH = new ExceptionCode("CONTENT_FCP_FSB_REFERRAL_NUM_SEQ_MISMATCH", "The number of CE sequence numbers [{0}] don''t match the number of federated paths [{1}] in the referral.", "FNRCC0087", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_SET_READ_ONLY_FAILED = new ExceptionCode("CONTENT_FCP_FSB_SET_READ_ONLY_FAILED", "Failed to set read-only file attribute for {0}.", "FNRCC0088", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_TMP_DIRECTORY_CREATE_FAILURE = new ExceptionCode("CONTENT_FCP_FSB_TMP_DIRECTORY_CREATE_FAILURE", "Unable to create tmp Directory: {0}.", "FNRCC0089", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_TMP_DIRECTORY_NOT_ACCESSIBLE = new ExceptionCode("CONTENT_FCP_FSB_TMP_DIRECTORY_NOT_ACCESSIBLE", "Cannot write to tmp Directory: {0}.", "FNRCC0090", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_GET_RETENTION_PERIOD_FAILED = new ExceptionCode("CONTENT_FCP_GET_RETENTION_PERIOD_FAILED", "The retention period for the content element could not be retrieved for this provider.", "FNRCC0091", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_CONFIGURATION = new ExceptionCode("CONTENT_FCP_INVALID_CONFIGURATION", "The configuration is invalid for this provider.", "FNRCC0092", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRAL_URL = new ExceptionCode("CONTENT_FCP_INVALID_REFERRAL_URL", "Invalid Referral URL: [{0}]", "FNRCC0093", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_RESOURCE_STRING = new ExceptionCode("CONTENT_FCP_INVALID_RESOURCE_STRING", "Invalid Resource String: [{0}]", "FNRCC0094", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_SEEK_ORIGIN = new ExceptionCode("CONTENT_FCP_INVALID_SEEK_ORIGIN", "Invalid origin {0} was specified for seek operation.", "FNRCC0095", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_CONFIGURE_DOC_CLASSES = new ExceptionCode("CONTENT_FCP_IS_FAILED_CONFIGURE_DOC_CLASSES", "Failed to configure document classes for: domain [{0}]; domain id [{1}]; object store [{2}]; object store id [{3}].", "FNRCC0096", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_CLASSES = new ExceptionCode("CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_CLASSES", "The attempt to retrieve all document classes from the Image Services server failed.", "FNRCC0097", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_PROPS = new ExceptionCode("CONTENT_FCP_IS_FAILED_RETRIEVE_DOC_PROPS", "Error retrieving document properties for [{0}].", "FNRCC0098", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_INVALID_CSM_CACHE_NAME = new ExceptionCode("CONTENT_FCP_IS_INVALID_CSM_CACHE_NAME", "CSM cache name should be a valid NCH 3-part name (e.g. page_cache2:roadrunner:FileNet).  Actual value: [{0}]", "FNRCC0099", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_INVALID_DOC_CLASS_NAME = new ExceptionCode("CONTENT_FCP_IS_INVALID_DOC_CLASS_NAME", "Invalid Image Services Document Class Name: [{0}].", "FNRCC0100", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_MISMATCHED_PAGE_NUM = new ExceptionCode("CONTENT_FCP_IS_MISMATCHED_PAGE_NUM", "Mismatched Image Services page number.  Expected: [{0}]; Actual: [{1}] for CE seqence number: [{3}].", "FNRCC0101", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_IS_UNABLE_TO_RETRIEVE_IS_CLASS_DESC = new ExceptionCode("CONTENT_FCP_IS_UNABLE_TO_RETRIEVE_IS_CLASS_DESC", "A communication failure with the Image Services server has prevented the retrieval of the ImageServicesClassDescriptions property for this IMFixedContentDevice: {0}", "FNRCC0102", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_LOGOFF_FAILED = new ExceptionCode("CONTENT_FCP_LOGOFF_FAILED", "The logoff operation failed for this provider.", "FNRCC0103", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_CHECKSUM = new ExceptionCode("CONTENT_FCP_MISMATCHED_CHECKSUM", "Checksum failed, expected {0}; actual {1}.", "FNRCC0104", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REFERRALURL_LENGTH = new ExceptionCode("CONTENT_FCP_MISMATCHED_REFERRALURL_LENGTH", "The number of referral URLs [{0}] did not match the number of CE sequence numbers [{1}].", "FNRCC0105", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REFERRALURL_PARAM = new ExceptionCode("CONTENT_FCP_MISMATCHED_REFERRALURL_PARAM", "The referral URLs did not have the same ''{0}''.", "FNRCC0106", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_MISMATCHED_REF_VERSION = new ExceptionCode("CONTENT_FCP_MISMATCHED_REF_VERSION", "Referral version or provider did not match.  Expected (hex): [{0}]; Actual (hex): [{1}].", "FNRCC0107", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_NEGATIVE_RETENTION_PERIOD = new ExceptionCode("CONTENT_FCP_NEGATIVE_RETENTION_PERIOD", "Requested retention period offset is negative {0}.", "FNRCC0108", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_NO_CONTENT_ELEMENTS_EXIST = new ExceptionCode("CONTENT_FCP_NO_CONTENT_ELEMENTS_EXIST", "Content element open failed, no content elements match the sequence {0}.", "FNRCC0109", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED", "The [{1}] operation on the fixed content provider [{0}] failed.", "FNRCC0110", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_ON_OPEN = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_ON_OPEN", "Fixed Content Provider open operation failed.  Provider: [{0}]  SeqNum: [{1}]  Referral: [{2}]", "FNRCC0111", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_CONTENT = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_CONTENT", "The [{1}] operation on the fixed content provider [{0}] failed for the [{2}] content and the sequence numbers [{3}].", "FNRCC0112", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_REFERRAL = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_REFERRAL", "The fixed content provider operation failed.  Provider: [{0}]  Operation: [{1}]  Referral: [{2}]", "FNRCC0113", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_NOT_SUPPORTED = new ExceptionCode("CONTENT_FCP_OPERATION_NOT_SUPPORTED", "Operation not supported for this Fixed Content Provider.  Provider: [{0}]  Operation: [{1}]", "FNRCC0114", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_RETENTION_PARAM_NOT_ALLOWED = new ExceptionCode("CONTENT_FCP_RETENTION_PARAM_NOT_ALLOWED", "The retentionPeriod parameter is set to NOT-ALLOWED: [{0}]", "FNRCC0115", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_SET_RETENTION_PERIOD_FAILED = new ExceptionCode("CONTENT_FCP_SET_RETENTION_PERIOD_FAILED", "Failed to set the retention period to [{0}] for the content element.", "FNRCC0116", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_UNEXPECTED_STATE = new ExceptionCode("CONTENT_FCP_UNEXPECTED_STATE", "The state was unexpected for this fixed content provider.", "FNRCC0117", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_CANNOT_GET_PROVIDER = new ExceptionCode("CONTENT_FXCA_CANNOT_GET_PROVIDER", "Failed loading the provider class {0}.", "FNRCC0118", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_INVALID_CONFIGURATION = new ExceptionCode("CONTENT_FXCA_INVALID_CONFIGURATION", "The content area configuration is invalid.", "FNRCC0119", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_OPERATION_FAILED_CONTENT_IS_MIGRATING = new ExceptionCode("CONTENT_FXCA_OPERATION_FAILED_CONTENT_IS_MIGRATING", "Operation [{0}] cannot be performed while content is being migrated to Fixed Content Device.", "FNRCC0120", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_CANNOT_FIND_INDEX_NUMBER = new ExceptionCode("CONTENT_GC_CANNOT_FIND_INDEX_NUMBER", "Cannot find index number {0}.", "FNRCC0121", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_CANNOT_FIND_SEQUENCE_NUMBER = new ExceptionCode("CONTENT_GC_CANNOT_FIND_SEQUENCE_NUMBER", "Cannot find sequence number {0}.", "FNRCC0122", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GC_INDEX_NOT_CONTENT_TRANSFER = new ExceptionCode("CONTENT_GC_INDEX_NOT_CONTENT_TRANSFER", "Index {0} is not a ContentTransfer.", "FNRCC0123", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_MC_FAILED_MOVING_CONTENT = new ExceptionCode("CONTENT_MC_FAILED_MOVING_CONTENT", "The MoveContent operation failed.", "FNRCC0124", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_MC_UNSUPPORTED_VERSIONABLE_CLASS = new ExceptionCode("CONTENT_MC_UNSUPPORTED_VERSIONABLE_CLASS", "Unsupported Versionable class {0} for MoveContent", "FNRCC0125", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_CLOSE_STREAM_FAILED = new ExceptionCode("CONTENT_PC_CLOSE_STREAM_FAILED", "The PutContent operation failed because InputStream.close failed.", "FNRCC0126", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_FAILED_NO_STORAGE_DEFINED = new ExceptionCode("CONTENT_PC_FAILED_NO_STORAGE_DEFINED", "The PutContent write operation failed because no StorageArea or StoragePolicy has been defined for this content.", "FNRCC0127", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_LAST_CHUNK_NOT_SET = new ExceptionCode("CONTENT_PC_LAST_CHUNK_NOT_SET", "Internal error: The lastChunk property has not been set.", "FNRCC0128", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_STREAM_FAILED = new ExceptionCode("CONTENT_PC_STREAM_FAILED", "The PutContent operation failed because of an InputStream exception", "FNRCC0129", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_UNEXPECTED_CONTENT_TYPE = new ExceptionCode("CONTENT_PC_UNEXPECTED_CONTENT_TYPE", "Unexpected PutContentRequest conte type; classname={0}; content={1}", "FNRCC0130", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_UNKNOWN_STATE = new ExceptionCode("CONTENT_PC_UNKNOWN_STATE", "Unknown PutContent state: {0}, with cookie {1}.", "FNRCC0131", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PC_WRITE_FAILED = new ExceptionCode("CONTENT_PC_WRITE_FAILED", "A document could not be created, checked into a library, or moved from one storage area to another.", "FNRCC0132", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_DELETES_NOT_ALLOWED = new ExceptionCode("CONTENT_SA_DELETES_NOT_ALLOWED", "The Storage Area does not allow delete of content.", "FNRCC0133", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_CLOSURE_DATE = new ExceptionCode("CONTENT_SA_EXCEEDED_CLOSURE_DATE", "Storage Area [{0}] exceeded closure date [{1}].", "FNRCC0134", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_MAX_COUNT = new ExceptionCode("CONTENT_SA_EXCEEDED_MAX_COUNT", "Storage Area [{0}] exceeded maximum number of content elements limit of [{1}].", "FNRCC0135", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_EXCEEDED_MAX_SIZE = new ExceptionCode("CONTENT_SA_EXCEEDED_MAX_SIZE", "Storage Area [{0}] exceeded maximum size limit of [{1}(KB)].", "FNRCC0136", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_DIRECTORY_STRUCTURE = new ExceptionCode("CONTENT_SA_INVALID_DIRECTORY_STRUCTURE", "The directory structure packed value specified for the Storage Area is invalid: [{0}].", "FNRCC0137", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_RETENTION_PERIOD = new ExceptionCode("CONTENT_SA_INVALID_RETENTION_PERIOD", "Invalid Retention Period value: [{0}].", "FNRCC0138", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_INVALID_STATUS_CHANGE = new ExceptionCode("CONTENT_SA_INVALID_STATUS_CHANGE", "Invalid Status value; you cannot change from {0} to {1}.", "FNRCC0139", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_NO_STORAGE_AREA_FOR_RESERVATION = new ExceptionCode("CONTENT_SA_NO_STORAGE_AREA_FOR_RESERVATION", "There are no open Storage Areas available for the reservation.", "FNRCC0140", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_STORAGE_AREA_NOT_OPEN = new ExceptionCode("CONTENT_SA_STORAGE_AREA_NOT_OPEN", "StorageArea [{0}] not open, Status value is [{1}].", "FNRCC0141", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_UNKNOWN_CLASS = new ExceptionCode("CONTENT_SA_UNKNOWN_CLASS", "Unknown StorageArea class {0}.", "FNRCC0142", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_UNKNOWN_STORAGE_AREA = new ExceptionCode("CONTENT_SA_UNKNOWN_STORAGE_AREA", "Unknown StorageArea {0}.", "FNRCC0143", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_STREAM_INIT_FAILED = new ExceptionCode("CONTENT_STREAM_INIT_FAILED", "Stream initialization failed for {0}.", "FNRCC0144", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SQ_SERIALIZED_OBJECT_IS_NULL = new ExceptionCode("CONTENT_SQ_SERIALIZED_OBJECT_IS_NULL", "No content elements have been serialized with this storage queue item.", "FNRCC0145", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SQ_UNKNOWN_COMMAND = new ExceptionCode("CONTENT_SQ_UNKNOWN_COMMAND", "Unknown command: {0}", "FNRCC0146", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_TTL_STREAM_EXPIRED = new ExceptionCode("CONTENT_TTL_STREAM_EXPIRED", "The TTL (Time To Live) value for the stream has expired.", "FNRCC0147", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_FINALIZE_FAILED_SIZE = new ExceptionCode("CONTENT_CA_FINALIZE_FAILED_SIZE", "Failed to finalize content element due to size mismatch:  expected [{0}]; actual [{1}].", "FNRCC0148", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRAL_VERSION = new ExceptionCode("CONTENT_FCP_INVALID_REFERRAL_VERSION", "Invalid Referral Version: [{0}]", "FNRCC0149", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_METADATA_PARSE_ERROR = new ExceptionCode("CONTENT_CFS_METADATA_PARSE_ERROR", "An error occurred while parsing the XML that contains the metadata for a federated document", "FNRCC0150", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_INTERNAL_ERROR = new ExceptionCode("CONTENT_CFS_INTERNAL_ERROR", "A content federation error occurred internal to the server.  Refer to log messages or the cause of this exception for details.", "FNRCC0151", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CFS_DB_ERROR = new ExceptionCode("CONTENT_CFS_DB_ERROR", "An error occurred accessing the federation database.", "FNRCC0152", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CLOSE_FAILED = new ExceptionCode("CONTENT_FCP_CLOSE_FAILED", "The close operation failed for this provider.", "FNRCC0153", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_TESTOPERATIONSUCCESS_FAILED = new ExceptionCode("CONTENT_FCP_CE_TESTOPERATIONSUCCESS_FAILED", "The testOperationSuccess operation failed for this provider.", "FNRCC0154", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_USESVERSIONS_FAILED = new ExceptionCode("CONTENT_FCP_CE_USESVERSIONS_FAILED", "The usesVersions operation failed for this provider.", "FNRCC0155", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CE_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_CE_EXISTS_FAILED", "The exists operation failed for this provider.", "FNRCC0156", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_SA_NO_OPEN_STORAGE_AREA_FOR_CFS = new ExceptionCode("CONTENT_SA_NO_OPEN_STORAGE_AREA_FOR_CFS", "No open storage areas are available for the CFS Importer with object store id=[{0}] and fixed content device id=[{1}]", "FNRCC0157", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_POOL_MAX_REACHED = new ExceptionCode("CONTENT_FCP_POOL_MAX_REACHED", "The maximum number [{0}] of concurrent requests to the fixed content device [{1}] has been reached. Please try your request again later.", "FNRCC0158", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_FREEZE_FAILED = new ExceptionCode("CONTENT_FCP_DOC_FREEZE_FAILED", "The content freeze operation failed for this document.", "FNRCC0159", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_REFERRALURL_COUNT = new ExceptionCode("CONTENT_FCP_INVALID_REFERRALURL_COUNT", "The number of referral URLs [{0}] did not match the expected number for this provider [{1}].", "FNRCC0160", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_INVALID_CONTENT_ELEMENT_SEQUENCE = new ExceptionCode("CONTENT_FCP_INVALID_CONTENT_ELEMENT_SEQUENCE", "The content element sequence number [{0}] is invalid for this provider, expecting [{1}].", "FNRCC0161", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DEVICE_QUERY_FAILED = new ExceptionCode("CONTENT_FCP_DEVICE_QUERY_FAILED", "The device query operation failed for the fixed content device.", "FNRCC0162", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TEMP_FILE_OPERATION_FAILED = new ExceptionCode("CONTENT_FCP_TEMP_FILE_OPERATION_FAILED", "The operation on the temporary file failed for the fixed content provider.", "FNRCC0163", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_OPERATION_NON_RETRIABLE_FAILURE = new ExceptionCode("CONTENT_OPERATION_NON_RETRIABLE_FAILURE", "The content operation [{0}] failed with non-retriable exception.", "FNRCC0164", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_FREEZE_NOT_SUPPORTED = new ExceptionCode("CONTENT_FCP_DOC_FREEZE_NOT_SUPPORTED", "The document does not support freeze content operation.", "FNRCC0165", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_API_FAILURE = new ExceptionCode("CONTENT_FCP_TSM_API_FAILURE", "Failure reported by TSM API, device Id {0}, method: {1}, return code: {2} {3}", "FNRCC0166", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_WRONG_MGMT_CLASS = new ExceptionCode("CONTENT_FCP_TSM_WRONG_MGMT_CLASS", "Unexpected management class result from tsmBindMC, storage area id {0}, found: {1}, expected: {2}", "FNRCC0167", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_NO_OBJECT = new ExceptionCode("CONTENT_FCP_TSM_NO_OBJECT", "The TSM object does not exist, device id {0} object name: {1}", "FNRCC0168", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_RETENTION_EVENT = new ExceptionCode("CONTENT_FCP_TSM_RETENTION_EVENT", "Failed to execute retention event {0}, error code: {1} device id {2} tsm object: {3}", "FNRCC0169", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_OBJECT_CREATE_FAILED = new ExceptionCode("CONTENT_FCP_TSM_OBJECT_CREATE_FAILED", "TSM Object creation failed, content id {0}, migration id {1}, mgmt class name: {2}, object name: {3}", "FNRCC0170", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_INVALID_RETENTION_INITIATED_STATE = new ExceptionCode("CONTENT_FCP_TSM_INVALID_RETENTION_INITIATED_STATE", "The Retention Initiated state is invalid, expected pending or started, state: {0} device id {1} tsm object: {2}", "FNRCC0171", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_INVALID_REFERRAL_BLOB = new ExceptionCode("CONTENT_FCP_TSM_INVALID_REFERRAL_BLOB", "Failed to decode the TSM binary referral blob, the referral is corrupt or invalid, device id {0} referral length: {1}", "FNRCC0172", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_API_INITIALIZATION = new ExceptionCode("CONTENT_FCP_TSM_API_INITIALIZATION", "Unable to initialize TsmJavaApi using API name [{0}] or [{1}].  Please verify that your application server has been configured to point to the proper TSM API native library.", "FNRCC0173", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_CREATE_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_CREATE_OPT_FILE", "Failed to create TSM options file [{0}].", "FNRCC0174", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_LOAD_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_LOAD_OPT_FILE", "Failed to load the TSM options file [{0}].", "FNRCC0175", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_MISSING_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_MISSING_OPT_FILE", "The TSM options file does not exist [{0}].", "FNRCC0176", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_WRITE_OPT_FILE = new ExceptionCode("CONTENT_FCP_TSM_WRITE_OPT_FILE", "Failed to write the TSM options file [{0}].", "FNRCC0177", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_RETRYABLE_READ_FAILURE = new ExceptionCode("CONTENT_RETRYABLE_READ_FAILURE", "The attempt to read document id [{0}], element [{1}] failed.", "FNRCC0178", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_TOO_MANY_CONTENT_ELEMENTS = new ExceptionCode("CONTENT_FCP_TSM_TOO_MANY_CONTENT_ELEMENTS", "TSM Object creation failed, content id {0}, content element count {1}, max objects per transaction: {2}", "FNRCC0179", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DOC_UNLOCK_FAILED = new ExceptionCode("CONTENT_FCP_DOC_UNLOCK_FAILED", "The document could not be unlocked for this provider.", "FNRCC0180", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_RETRYABLE_API_FAILURE = new ExceptionCode("CONTENT_FCP_TSM_RETRYABLE_API_FAILURE", "Failure reported by TSM API, device Id {0}, method: {1}, return code: {2} {3}", "FNRCC0181", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_TSM_OFFLINE_CONTENT = new ExceptionCode("CONTENT_FCP_TSM_OFFLINE_CONTENT", "The TSM content object is offline and the maximum number of concurrent tape readers [{0}] has been exceeded for the TSM Fixed Content Device [{1}].", "FNRCC0182", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_INTERNAL_TIMEOUT = new ExceptionCode("CONTENT_CACHE_INTERNAL_TIMEOUT", "The content cache timed out populating a cache file.  This is an internal error that is handled in the server.", "FNRCC0183", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_OPERATION_FAILED_WITH_CONTEXT = new ExceptionCode("CONTENT_FCP_OPERATION_FAILED_WITH_CONTEXT", "The fixed content provider operation failed.", "FNRCC0184", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_HCP_INVALID_REFERRAL_BLOB = new ExceptionCode("CONTENT_FCP_HCP_INVALID_REFERRAL_BLOB", "Failed to decode the HCP binary referral blob, the referral is corrupt or invalid, device id {0} referral length: {1}", "FNRCC0185", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_CONTENT_EXCEEDS_MAX_SIZE = new ExceptionCode("CONTENT_FXCA_CONTENT_EXCEEDS_MAX_SIZE", "The size of a content element [{0}] exceeds the maximum size supported by the Fixed Content Device [{1}].", "FNRCC0186", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_FCP_REJECTED_RETENTION_CREATE = new ExceptionCode("CONTENT_FXCA_FCP_REJECTED_RETENTION_CREATE", "The fixed content provider rejected the retention date [{0}] during document check-in.", "FNRCC0187", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_FCP_REJECTED_RETENTION_ALTER = new ExceptionCode("CONTENT_FXCA_FCP_REJECTED_RETENTION_ALTER", "The fixed content provider rejected the new value for the retention date [{0}], current value [{1}].", "FNRCC0188", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CRYPTOGRAPHIC_SERVICE_MISSING = new ExceptionCode("CONTENT_CRYPTOGRAPHIC_SERVICE_MISSING", "Content Engine did not enable content encryption for the following reason: The requested encryption algorithm is not available in the server environment or does not support the key size requested.", "FNRCC0189", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_KEY_GENERATION_FAILURE = new ExceptionCode("CONTENT_KEY_GENERATION_FAILURE", "Content Engine failed to generate a new content encryption key.", "FNRCC0190", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CRYPTOGRAPHIC_OP_FAILED = new ExceptionCode("CONTENT_CRYPTOGRAPHIC_OP_FAILED", "Content Engine failed to encrypt or decrypt data by using the encryption key information that is stored in the \"{0}\" object store.", "FNRCC0191", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_KEY_MISSING = new ExceptionCode("CONTENT_KEY_MISSING", "Content Engine did not find the encryption key that is associated with the \"{0}\" index in the \"{1}\" object store.", "FNRCC0192", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CIPHER_FAILURE = new ExceptionCode("CONTENT_CIPHER_FAILURE", "Content Engine failed to encrypt or decrypt content for the following reason: The initialization of a cryptographic cipher instance failed.", "FNRCC0193", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ENCRYPTION_ERROR = new ExceptionCode("CONTENT_ENCRYPTION_ERROR", "Content Engine failed to encrypt content for the \"{0}\" object.", "FNRCC0194", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_COMPRESSION_BLOCK_HEADER_ERROR = new ExceptionCode("CONTENT_COMPRESSION_BLOCK_HEADER_ERROR", "The compressed data stream block signature byte at position {0} did not have the expected value. Expected {1}, actual {2}.", "FNRCC0195", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_COMPRESSION_SHORT_READ = new ExceptionCode("CONTENT_COMPRESSION_SHORT_READ", "A read from the compressed data stream failed to return the expected number of bytes. Expected {0}, actual {1}.", "FNRCC0196", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_COMPRESSION_DECOMPRESSED_SIZE_MISMATCH = new ExceptionCode("CONTENT_COMPRESSION_DECOMPRESSED_SIZE_MISMATCH", "A block from the compressed data stream did not inflate to the expected size. Expected {0}, actual {1}.", "FNRCC0197", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_COMPRESSION_BAD_HEADER = new ExceptionCode("CONTENT_COMPRESSION_BAD_HEADER", "The header read from the data stream did not have the expected form for compressed content. Expected {0}, actual {1}.", "FNRCC0198", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_COMPRESSION_DECOMPRESSION_ERROR = new ExceptionCode("CONTENT_COMPRESSION_DECOMPRESSION_ERROR", "An exception occurred while decompressing the data stream.", "FNRCC0199", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_GET_SERVICE_FAILUER = new ExceptionCode("CONTENT_THUMBNAIL_GET_SERVICE_FAILUER", "Failed to get the Thumbnail Generation Service implementation: [{0}].", "FNRCC0200", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_GENERATION_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_GENERATION_FAILURE", "Failed to generate thumbnail for file: [{0}], generation service return error code: [{1}].", "FNRCC0201", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_READ_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_READ_FAILURE", "Failed to read generated thumbnail into byte array for file: [{0}].", "FNRCC0202", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FAILED_CREATE_CONTROL_FILE = new ExceptionCode("CONTENT_THUMBNAIL_FAILED_CREATE_CONTROL_FILE", "Failed to generate the batch control file for thumbnail generation batch: [{0}].", "FNRCC0203", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FILETYPE_NOT_SUPPORTED = new ExceptionCode("CONTENT_THUMBNAIL_FILETYPE_NOT_SUPPORTED", "The file type is not supported for file:[{0}], mimetype[{1}].", "FNRCC0204", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FAILED_LAUNCH_EXTERNAL_PROCESS = new ExceptionCode("CONTENT_THUMBNAIL_FAILED_LAUNCH_EXTERNAL_PROCESS", "Failed to launch the external thumbnail generation process for batch:[{0}].", "FNRCC0205", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FAILED_READ_RESULT_FILE = new ExceptionCode("CONTENT_THUMBNAIL_FAILED_READ_RESULT_FILE", "Failed to read thumbnail generation process status result file [{0}], process exit value [{1}].", "FNRCC0206", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_NOT_PROCESSED = new ExceptionCode("CONTENT_THUMBNAIL_NOT_PROCESSED", "Thumbnail generation service did not process input file [{0}].", "FNRCC0207", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FAILED_CREATE_OUTPUT_FOLDER = new ExceptionCode("CONTENT_THUMBNAIL_FAILED_CREATE_OUTPUT_FOLDER", "Failed to create folder [{0}] under root folder [{1}] for thumbnail generation of input file [{2}].", "FNRCC0208", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_GENERATION_FAILURE_NONRETRIABLE = new ExceptionCode("CONTENT_THUMBNAIL_GENERATION_FAILURE_NONRETRIABLE", "A non-retriable error occurred when generating thumbnail for file: [{0}], generation service returned error code: [{1}].", "FNRCC0209", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_NOT_PROCESSED_PROCESS_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_NOT_PROCESSED_PROCESS_FAILURE", "Thumbnail generation service did not process input file [{0}], process exit value [{1}].", "FNRCC0210", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_LOAD_BINARY_RECOGNIZER_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_LOAD_BINARY_RECOGNIZER_FAILURE", "Thumbnail generation service failed to load binary recognizer configuration file [{0}].", "FNRCC0211", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_FILETYPE_FILTERED = new ExceptionCode("CONTENT_THUMBNAIL_FILETYPE_FILTERED", "The file type has been configured to be filtered for file:[{0}], mimetype[{1}].", "FNRCC0212", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_LOAD_MIMETYPE_ACTION_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_LOAD_MIMETYPE_ACTION_FAILURE", "Thumbnail generation service failed to load mimetype action configuration file [{0}].", "FNRCC0213", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_WRONG_IWORK_FORMAT_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_WRONG_IWORK_FORMAT_FAILURE", "The input iWork file [{0}], mimetype[{1}] is not in a valid format.", "FNRCC0214", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_IWORK_NO_QUICKLOOK_PREVIEW = new ExceptionCode("CONTENT_THUMBNAIL_IWORK_NO_QUICKLOOK_PREVIEW", "The input iWork file [{0}], mimetype[{1}] does not include a thumbnail in the QuickLook folder.", "FNRCC0215", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_IWORK_THUMB_GENERATION_FAILURE = new ExceptionCode("CONTENT_THUMBNAIL_IWORK_THUMB_GENERATION_FAILURE", "The thumbnail generation for the input iWork file [{0}], mimetype[{1}] failed.", "FNRCC0216", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_IWORK_NO_NATIVE_THUMBNAIL = new ExceptionCode("CONTENT_THUMBNAIL_IWORK_NO_NATIVE_THUMBNAIL", "The input iWork file [{0}], mimetype[{1}] does not include an embedded thumbnail.", "FNRCC0217", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_OUTSIDEIN_SDK_NOT_DEPLOYED = new ExceptionCode("CONTENT_THUMBNAIL_OUTSIDEIN_SDK_NOT_DEPLOYED", "Cannot locate the OutsideIn binary, the SDK is not deployed.", "FNRCC0218", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_THUMBNAIL_OUTPUT_FORMAT_NOT_SUPPORTED = new ExceptionCode("CONTENT_THUMBNAIL_OUTPUT_FORMAT_NOT_SUPPORTED", "The thumbnail image format [{0}] is not supported by the thumbnail generation service provider.", "FNRCC0219", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FXCA_OPERATION_FAILED_PENDING_RETENTION = new ExceptionCode("CONTENT_FXCA_OPERATION_FAILED_PENDING_RETENTION", "Operation [{0}] cannot be performed while there is a pending alter retention request for the fixed content.", "FNRCC0220", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_BMCJ_FAILED_NO_STORAGE_DEFINED = new ExceptionCode("CONTENT_BMCJ_FAILED_NO_STORAGE_DEFINED", "A Bulk Move Content Job cannot continue moving content for objects selected by the job because the specified Storage Policy does not select any open Storage Areas in which to move it.", "FNRCC0221", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_UNKNOWN_SERVER_ERROR = new ExceptionCode("CONTENT_FCP_ATMOS_UNKNOWN_SERVER_ERROR", "The Atmos server encountered an unknown error.", "FNRCC0222", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_SIGNATURE = new ExceptionCode("CONTENT_FCP_ATMOS_SIGNATURE", "Unable to compute Atmos signature for http request with headers: {0}", "FNRCC0223", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_UNEXPECTED_RESPONSE_CODE = new ExceptionCode("CONTENT_FCP_ATMOS_UNEXPECTED_RESPONSE_CODE", "An unexpected status code [{0}] was returned from the Atmos server instead of one of the followng status code(s) [{1}].", "FNRCC0224", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_CREATE_FAILED_NO_OBJECT_ID = new ExceptionCode("CONTENT_FCP_ATMOS_CREATE_FAILED_NO_OBJECT_ID", "Unable to create object on Atmos.  The response did not return an object id: [{0}].", "FNRCC0225", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_CONNECT_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_CONNECT_FAILED", "Unable to connect to Atmos server at {0} using the {1} fixed content device. Caused by [{2}].", "FNRCC0226", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_READ_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_READ_FAILED", "Unable to read Atmos object {0}.  Current position={1}.", "FNRCC0227", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_INVALID_RESPONSE = new ExceptionCode("CONTENT_FCP_ATMOS_INVALID_RESPONSE", "Unable to get response from the Atmos server. HTTP status code={0}.", "FNRCC0228", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_READ_FAILED = new ExceptionCode("CONTENT_FCP_READ_FAILED", "Unable to read document from fixed content device.", "FNRCC0229", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_SIZE_FAILED = new ExceptionCode("CONTENT_FCP_SIZE_FAILED", "Unable to determine the size of the object from fixed content device.", "FNRCC0230", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_DELETE_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_DELETE_FAILED", "Unable to delete Atmos object {0}.", "FNRCC0231", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_SIZE_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_SIZE_FAILED", "Unable to get the size of Atmos object {0}.", "FNRCC0232", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_EXISTS_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_EXISTS_FAILED", "Unable to determine if Atmos object {0} exists.", "FNRCC0233", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_SKIP_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_SKIP_FAILED", "Unable to skip {0} bytes from current offset {1} when retrieving Atmos object {2}.", "FNRCC0234", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_VALIDATE_CONNECT_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_VALIDATE_CONNECT_FAILED", "Unable to validate connectivity to the {0} fixed content device. Verify that the Atmos URL and other connection properties are valid.", "FNRCC0235", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_HTTP_REQUEST_FAILED = new ExceptionCode("CONTENT_FCP_HTTP_REQUEST_FAILED", "The HTTP {0} request to {1} failed for the {2} fixed content device.  Caused by [{3}].", "FNRCC0236", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PIPE_TIMEOUT = new ExceptionCode("CONTENT_PIPE_TIMEOUT", "A read from or write to a pipe timed out after {0}ms.", "FNRCC0237", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_PIPE_CLOSED = new ExceptionCode("CONTENT_PIPE_CLOSED", "An attempt was made to read from or write to a closed pipe.", "FNRCC0238", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_WRITER_SEMAPHORE_FAILED = new ExceptionCode("CONTENT_ASA_WRITER_SEMAPHORE_FAILED", "The replica writer failed to obtain the writer''s semaphore. This is an unexpected state.", "FNRCC0239", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NOT_ENOUGH_REPLICAS = new ExceptionCode("CONTENT_ASA_NOT_ENOUGH_REPLICAS", "There are not enough replicas available to satisfy the synchronous upload requirement, available {0}, required {1}.", "FNRCC0240", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_DOC_CREATE_FAILED_BAD_INPUT = new ExceptionCode("CONTENT_ASA_DOC_CREATE_FAILED_BAD_INPUT", "The document could not be created because the source input stream could not be read.", "FNRCC0241", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REDIRECTOR_SEMAPHORE_FAILED = new ExceptionCode("CONTENT_ASA_REDIRECTOR_SEMAPHORE_FAILED", "The content redirector  was interrupted attempting to acquire the worker semaphores.", "FNRCC0242", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NOT_ENOUGH_REPLICAS_WRITTEN = new ExceptionCode("CONTENT_ASA_NOT_ENOUGH_REPLICAS_WRITTEN", "Not enough replicas were written to satisfy the synchronous upload requirement, written {0}, required {1}.", "FNRCC0243", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_CONTENT_NOT_FOUND = new ExceptionCode("CONTENT_ASA_CONTENT_NOT_FOUND", "The content was not found or not accessible on the storage device.", "FNRCC0244", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_CONTENT_EXISTS = new ExceptionCode("CONTENT_ASA_CONTENT_EXISTS", "The content already exists for storage device {0}, content path {1}.", "FNRCC0245", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_DEVICE_OBJECT_ID = new ExceptionCode("CONTENT_ASA_INVALID_DEVICE_OBJECT_ID", "The device object id is invalid for storage device {0}, expected id {1}, actual id {2}.", "FNRCC0246", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_DEVICE_DIRECTORIES = new ExceptionCode("CONTENT_ASA_INVALID_DEVICE_DIRECTORIES", "The device object directory count is invalid for storage device {0}, expected {1}, actual {2}.", "FNRCC0247", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_DEVICE_VERSION = new ExceptionCode("CONTENT_ASA_INVALID_DEVICE_VERSION", "The device object version is invalid for storage device {0}, expected {1}, actual {2}.", "FNRCC0248", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_OBJECT_EXISTS = new ExceptionCode("CONTENT_ASA_OBJECT_EXISTS", "The target object already exists for storage device {0}, object identifier {1}.", "FNRCC0249", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_FILE_WRITE_FAILED = new ExceptionCode("CONTENT_ASA_FILE_WRITE_FAILED", "The target file cannot be written for storage device {0}, file path {1}.", "FNRCC0250", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_FILE_SYNC_FAILED = new ExceptionCode("CONTENT_ASA_FILE_SYNC_FAILED", "Synchronizing the target file to disk failed for storage device {0}, file path {1}.", "FNRCC0251", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_TEST_DEVICE_FAILED = new ExceptionCode("CONTENT_ASA_TEST_DEVICE_FAILED", "The device cannot be validated; no connectivity to storage device {0}, {1}.", "FNRCC0252", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_MANIFEST_TOO_LARGE = new ExceptionCode("CONTENT_ASA_MANIFEST_TOO_LARGE", "The content manifest data exceeds the maximum size allowed for storage device {0}, maximum allowed {1}, actual size {2}, object {3}.", "FNRCC0253", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_OPENSTACK_AUTHN_FAILED = new ExceptionCode("CONTENT_ASA_OPENSTACK_AUTHN_FAILED", "The OpenStack authentication failed for storage device {0}, address {1}, user {2}, response {3}.", "FNRCC0254", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_MISSING_RESPONSE_HEADER = new ExceptionCode("CONTENT_ASA_MISSING_RESPONSE_HEADER", "Unexpected missing response header {0} for storage device {1}.", "FNRCC0255", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_X_STORAGE_HEADER = new ExceptionCode("CONTENT_ASA_INVALID_X_STORAGE_HEADER", "The X-Storage-Url [{0}] response is invalid and cannot be parsed for storage device {1}.", "FNRCC0256", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_CONVERT_TO_PROPERTIES = new ExceptionCode("CONTENT_ASA_CONVERT_TO_PROPERTIES", "The conversion of the data buffer to a java.util.Properties collection failed for object [{0}], of storage device {1}.", "FNRCC0257", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_FAILURE_RESPONSE = new ExceptionCode("CONTENT_ASA_FAILURE_RESPONSE", "The operation [{0}] on object {1}, of storage device {2}, returned failure response {3}.", "FNRCC0258", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_REST_REQUEST_METHOD = new ExceptionCode("CONTENT_REST_REQUEST_METHOD", "Failed setting the request method [{0}] for object [{1}], {2} [{3}].", "FNRCC0259", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_REST_OBTAIN_STREAM = new ExceptionCode("CONTENT_REST_OBTAIN_STREAM", "Failed to obtain output stream from connection for object [{0}], {1} [{2}].", "FNRCC0260", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_REST_CLOSE_STREAM = new ExceptionCode("CONTENT_REST_CLOSE_STREAM", "Failed to close output stream of connection for object [{0}], {1} [{2}].", "FNRCC0261", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_REST_OPEN_CONNECTION = new ExceptionCode("CONTENT_REST_OPEN_CONNECTION", "Failed to open HTTP connection for object {0}, {1} [{2}].", "FNRCC0262", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_REST_CONSUME_CLOSE_STREAM = new ExceptionCode("CONTENT_REST_CONSUME_CLOSE_STREAM", "Failed to consume and close stream for {0}, {1} [{2}].", "FNRCC0263", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REST_STREAM_NOT_SUPPORTED = new ExceptionCode("CONTENT_ASA_REST_STREAM_NOT_SUPPORTED", "The REST InputStream does not support the mark or reset methods.", "FNRCC0264", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NO_DEVICE_CONNECTIVITY = new ExceptionCode("CONTENT_ASA_NO_DEVICE_CONNECTIVITY", "The storage device threw an exception attempting to test connectivity to the device {0}.", "FNRCC0265", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_ASSERTION_ERROR = new ExceptionCode("CONTENT_ASA_ASSERTION_ERROR", "An internal runtime assertion issue has been detected [{0}].", "FNRCC0266", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_STORAGE_HANDLER_EXCEPTION = new ExceptionCode("CONTENT_ASA_STORAGE_HANDLER_EXCEPTION", "The storage handler method [{0}] threw an exception [{1}], class name [{2}].", "FNRCC0267", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_DEVICE_CONTENT_ID_NOT_SUPPORTED = new ExceptionCode("CONTENT_ASA_DEVICE_CONTENT_ID_NOT_SUPPORTED", "The storage device [{0}] returned an unsupported device generated id [{1}] during synchronous upload.", "FNRCC0268", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NO_REPLICA_FOR_RETRIEVAL = new ExceptionCode("CONTENT_ASA_NO_REPLICA_FOR_RETRIEVAL", "There is no replica available for retrieving content item [{0}] from storage area [{1}].", "FNRCC0269", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REPLICA_RETRIEVAL_ERROR = new ExceptionCode("CONTENT_ASA_REPLICA_RETRIEVAL_ERROR", "All replicas failed while attempting to retrieve content item [{0}] from storage area [{1}].", "FNRCC0270", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_ZERO_REPLICAS = new ExceptionCode("CONTENT_ASA_ZERO_REPLICAS", "There are no storage device replicas associated with the storage area [{0}].", "FNRCC0271", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_SERIALIZATION = new ExceptionCode("CONTENT_ASA_SERIALIZATION", "Advanced storage area serialization error.", "FNRCC0272", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_HANDLER = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_HANDLER", "Content validation failed because an error was returned by the storage handler in the storage area: objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0273", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_ALTER_RETENTION_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_ALTER_RETENTION_FAILED", "Unable to update the retention on Atmos object {0}.", "FNRCC0274", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_UNRECOGNIZED_DATE_FORMAT = new ExceptionCode("CONTENT_FCP_ATMOS_UNRECOGNIZED_DATE_FORMAT", "Atmos returned a retention date value with an unrecognized format: {0}.", "FNRCC0275", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ATMOS_GET_RETENTION_FAILED = new ExceptionCode("CONTENT_FCP_ATMOS_GET_RETENTION_FAILED", "Unable to retrieve the retention for Atmos object {0}.", "FNRCC0276", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_LOOKUP_IDENTITY = new ExceptionCode("CONTENT_ASA_LOOKUP_IDENTITY", "Unable to retrieve the content identity for content object {0}, storage area {1}.", "FNRCC0277", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_UPDATE_AREA_ELEMENT_RETRY = new ExceptionCode("CONTENT_ASA_UPDATE_AREA_ELEMENT_RETRY", "Failed to update the Area Element table {0} after {1} attempts, content object {2}, storage area {3}.", "FNRCC0278", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_UPDATE_AREA_ELEMENT_COUNT = new ExceptionCode("CONTENT_ASA_UPDATE_AREA_ELEMENT_COUNT", "Failed to updated the correct number of rows in the Area Element table {0}, updated {1}, expected {2}, content object {3}.", "FNRCC0279", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_QUERY_AREA_ELEMENT = new ExceptionCode("CONTENT_ASA_QUERY_AREA_ELEMENT", "Failed during query of Area Element table {0}.", "FNRCC0280", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_LOAD_AREA_OBJECT = new ExceptionCode("CONTENT_ASA_LOAD_AREA_OBJECT", "Failed to load the storage area object {0}.", "FNRCC0281", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_STREAM_TO_BUFFER = new ExceptionCode("CONTENT_ASA_STREAM_TO_BUFFER", "Failed to load input stream to memory buffer, buffer size {0}.", "FNRCC0282", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_STORAGE_DEVICE_EXISTENCE = new ExceptionCode("CONTENT_ASA_STORAGE_DEVICE_EXISTENCE", "Failed to determine if the storage device {0} exists in object store {1}, message {2}.", "FNRCC0283", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_DELETE_AREA_ELEMENT = new ExceptionCode("CONTENT_ASA_DELETE_AREA_ELEMENT", "Failed to delete rows from the Area Element table {0} object store {1}.", "FNRCC0284", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_IDCACHE_FILE_VERSION = new ExceptionCode("CONTENT_ASA_INVALID_IDCACHE_FILE_VERSION", "The content identifier cache file version is invalid for Object Store {0}, expected {1}, actual {2}.", "FNRCC0285", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_IDCACHE_FILE_DATA = new ExceptionCode("CONTENT_ASA_INVALID_IDCACHE_FILE_DATA", "The content identifier cache file is invalid for Object Store {0}, expected {1}, actual {2}.", "FNRCC0286", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_IDCACHE_FILE = new ExceptionCode("CONTENT_ASA_INVALID_IDCACHE_FILE", "The content identifier cache file is invalid for Object Store {0}, exception {1}.", "FNRCC0287", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REPLICATION_INVALID_SIZE = new ExceptionCode("CONTENT_ASA_REPLICATION_INVALID_SIZE", "The size of the content is invalid after replication. Expected {0} actual {1}.", "FNRCC0288", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REPLICATION_VALIDATION_FAILED = new ExceptionCode("CONTENT_ASA_REPLICATION_VALIDATION_FAILED", "The content failed validation after replication with validation status [{0}, {1}].", "FNRCC0289", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_COUNTER_FILE_VERSION = new ExceptionCode("CONTENT_ASA_INVALID_COUNTER_FILE_VERSION", "The advanced area counters file version is invalid for Object Store {0}, expected {1}, actual {2}.", "FNRCC0290", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_COUNTER_FILE_DATA = new ExceptionCode("CONTENT_ASA_INVALID_COUNTER_FILE_DATA", "The advanced area counters file is invalid for Object Store {0}, expected {1}, actual {2}.", "FNRCC0291", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_INVALID_COUNTER_FILE = new ExceptionCode("CONTENT_ASA_INVALID_COUNTER_FILE", "The advanced area counters file is invalid for Object Store {0}, exception {1}.", "FNRCC0292", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_UPLOAD_TIMEOUT = new ExceptionCode("CONTENT_ASA_UPLOAD_TIMEOUT", "The long running content upload has been canceled after {0} seconds, content object {1}, storage area {2}.", "FNRCC0293", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NULL_AUTHENTICATION_ADDRESS = new ExceptionCode("CONTENT_ASA_NULL_AUTHENTICATION_ADDRESS", "The OpenStack authentication address [{0}] is invalid for device {1}.", "FNRCC0294", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_NON_HTTPS_AUTHENTICATION_ADDRESS = new ExceptionCode("CONTENT_ASA_NON_HTTPS_AUTHENTICATION_ADDRESS", "The OpenStack authentication address [{0}] does not specify Hypertext Transfer Protocol Secure (HTTPS) for device {1}.", "FNRCC0295", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_SIGNATURE = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_SIGNATURE", "Content validation failed due to an invalid content signature, objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0296", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_SEGMENT_MISSING = new ExceptionCode("CONTENT_ASA_SEGMENT_MISSING", "Content segment {0} is missing for content path {1} on storage device {2}.", "FNRCC0297", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_REPLICATION_FAILED = new ExceptionCode("CONTENT_ASA_REPLICATION_FAILED", "Content replication failed to one or more replicas with the following failure(s): {0}.", "FNRCC0298", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_UNEXPECTED_FILE_OR_DIRECTORY = new ExceptionCode("CONTENT_ASA_UNEXPECTED_FILE_OR_DIRECTORY", "The root directory [{0}] of the file system storage device contains an unexpected pre-existing file or directory [{1}].", "FNRCC0299", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ISILON_ADAPTOR_SESSION_OP_FAILED = new ExceptionCode("CONTENT_FCP_ISILON_ADAPTOR_SESSION_OP_FAILED", "Failed to {0} a session for extended authentication.", "FNRCC0300", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ISILON_ADAPTOR_VALIDATION_FAILED = new ExceptionCode("CONTENT_FCP_ISILON_ADAPTOR_VALIDATION_FAILED", "Failed to validate fixed content device {0}: {1}", "FNRCC0301", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ISILON_ADAPTOR_PRECREATE_DIRECTORIES_FAILED = new ExceptionCode("CONTENT_FCP_ISILON_ADAPTOR_PRECREATE_DIRECTORIES_FAILED", "Failed to pre-create directory structure for fixed content device {0}: {1}", "FNRCC0302", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ISILON_ADAPTOR_DEVICE_FILE_OP_FAILED = new ExceptionCode("CONTENT_FCP_ISILON_ADAPTOR_DEVICE_FILE_OP_FAILED", "Failed to {0} device file for fixed content device {1}: {2}", "FNRCC0303", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ISILON_REST_METHOD_FAILED = new ExceptionCode("CONTENT_FCP_ISILON_REST_METHOD_FAILED", "The Isilon RESTFul [{0}] method has failed.", "FNRCC0304", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_STREAM_POSITION_FAILED = new ExceptionCode("CONTENT_STREAM_POSITION_FAILED", "Unable to set the stream position from offset {0} to offset {1}.", "FNRCC0305", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_VERSION_FILE_CREATION_FAILED = new ExceptionCode("CONTENT_CACHE_VERSION_FILE_CREATION_FAILED", "Failed to create the version file for Content Cache Area {0}, Id={1}.", "FNRCC0306", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_CACHE_STAKE_FILE_INVALID_ID = new ExceptionCode("CONTENT_FCA_CACHE_STAKE_FILE_INVALID_ID", "The cache area Id {0} stored in stake file {1} does not match the actual cache area Id {2}", "FNRCC0308", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CA_VALIDATION_FAILED_UNREACHABLE = new ExceptionCode("CONTENT_CA_VALIDATION_FAILED_UNREACHABLE", "Content validation failed due to an unreachable storage device, objId={0}; seqNo={1}; retrievalName={2}", "FNRCC0309", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_CACHE_MOVE_OLD_FORMAT_REQUIRES_DIRECT_ACCESS = new ExceptionCode("CONTENT_CACHE_MOVE_OLD_FORMAT_REQUIRES_DIRECT_ACCESS", "Unable to check whether stale content cache file exists for objId={0}; seqNo={1} in cache area: {2}; root directory={3}. Moving content with cache areas that check old format cache names requires direct access to the cache files.  The {4} property must not be set if all cache areas are not cross mounted to the object store site.", "FNRCC0310", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_HADOOP_FAILED_TO_REDIRECT = new ExceptionCode("CONTENT_ASA_HADOOP_FAILED_TO_REDIRECT", "The Hadoop service [{0}] for device [{1}] did not redirect the content creation request [{2}], the response [{3}] was unexpected.", "FNRCC0311", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_HADOOP_FAILED_TO_REDIRECT_WRONG_SIZE = new ExceptionCode("CONTENT_ASA_HADOOP_FAILED_TO_REDIRECT_WRONG_SIZE", "The Hadoop service [{0}] for device [{1}] did not redirect the content retrieval request [{2}], the content size is incorrect [{3}].", "FNRCC0312", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_SET_WRITABLE_FAILED = new ExceptionCode("CONTENT_FCP_FSB_SET_WRITABLE_FAILED", "Failed to set writable file attribute for {0}.", "FNRCC0313", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_FSB_JAVA_NIO_FAILED = new ExceptionCode("CONTENT_FCP_FSB_JAVA_NIO_FAILED", "Failed to load and use the Java NIO.2 library (requires JDK1.7+).", "FNRCC0314", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_INVALID_BASE_URL = new ExceptionCode("CONTENT_S3_INVALID_BASE_URL", "The specific connection URL [{0}] for {1} [{2}] is invalid.", "FNRCC0315", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_BUCKET_NOT_EXIST = new ExceptionCode("CONTENT_S3_BUCKET_NOT_EXIST", "The {0} [{1}] with connection URL [{2}] and Region [{3}] does not exist.", "FNRCC0316", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_OPERATION_FAILED = new ExceptionCode("CONTENT_S3_OPERATION_FAILED", "{0} [{1}] call failed for {2}.", "FNRCC0317", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_BUCKET_NOT_ACCESSIBLE = new ExceptionCode("CONTENT_S3_BUCKET_NOT_ACCESSIBLE", "The {0} [{1}] with connection URL [{2}] and Region [{3}] exits but cannot access, wrong connection url, region or credential configuration.", "FNRCC0318", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_S3_STAGING_FILE_EXIST = new ExceptionCode("CONTENT_ASA_S3_STAGING_FILE_EXIST", "The S3 object [{0}] content upload staging file [{1}] already exists.", "FNRCC0319", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_PERMANENT_REDIRECT = new ExceptionCode("CONTENT_S3_PERMANENT_REDIRECT", "Received permanent redirect response, connectionURL for {0} is not correct.", "FNRCC0320", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_REDIRECT_URL_PARSE_FAILED = new ExceptionCode("CONTENT_S3_REDIRECT_URL_PARSE_FAILED", "Failed to parse the redirect URL [{0}]] in the request response.", "FNRCC0321", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_REQUEST_SIGN_FAILED = new ExceptionCode("CONTENT_S3_REQUEST_SIGN_FAILED", "Failed to sign the request.", "FNRCC0322", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_URL_ENCODING_FAILED = new ExceptionCode("CONTENT_URL_ENCODING_FAILED", "Failed to encode the URL [{0}] using UTF-8 encoding scheme.", "FNRCC0323", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_FAILED_CREATE_UPLOADPART_FROM_FILEINPUTSTREAM = new ExceptionCode("CONTENT_S3_FAILED_CREATE_UPLOADPART_FROM_FILEINPUTSTREAM", "Failed to create multipart upload part data from FileInputStream.", "FNRCC0324", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_FAILED_RESET_PART_INPUTSTREAM = new ExceptionCode("CONTENT_S3_FAILED_RESET_PART_INPUTSTREAM", "Failed to reset input stream to position {0} for multipart upload part.", "FNRCC0325", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_XML_PROCESSING_FAILED = new ExceptionCode("CONTENT_XML_PROCESSING_FAILED", "Failed to complete XML processing for request or response.", "FNRCC0326", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_DEVICE_OBJECT_NOT_EXIST = new ExceptionCode("CONTENT_ASA_DEVICE_OBJECT_NOT_EXIST", "A device identity object {0} does not exist for the advanced storage area.", "FNRCC0327", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_GET_VERSIONS_FAILED = new ExceptionCode("CONTENT_S3_GET_VERSIONS_FAILED", "Failed to get the version information for object [{0}]", "FNRCC0328", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_GET_BUCKET_RETENTION_FAILED = new ExceptionCode("CONTENT_S3_GET_BUCKET_RETENTION_FAILED", "Failed to get the retention settings for {0} [{1}].", "FNRCC0329", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ICOS_PARSE_RETENTION_EXPIRATION_DATE_FAILED = new ExceptionCode("CONTENT_FCP_ICOS_PARSE_RETENTION_EXPIRATION_DATE_FAILED", "Failed to parse the retention expiration date value for object [{0}] in IBM ICOS Vault [{1}].", "FNRCC0330", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ICOS_GET_LAST_MODIFIED_DATE_FAILED = new ExceptionCode("CONTENT_FCP_ICOS_GET_LAST_MODIFIED_DATE_FAILED", "Failed to get the last modified date for object [{0}] in IBM ICOS Vault [{1}].", "FNRCC0331", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_GET_BUCKET_VERSION_INFO_FAILED = new ExceptionCode("CONTENT_S3_GET_BUCKET_VERSION_INFO_FAILED", "Failed to get the version information for the {0} [{1}].", "FNRCC0332", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE = new ExceptionCode("CONTENT_FCP_CENTERA_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE", "Invalid (not zero) fixed minimum retention [{0}] setting on Centera device, device cannot be used for a not-aligned fixed content storage area.", "FNRCC0333", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ICOS_VAULT_NOT_PROTECTION_ENABLED = new ExceptionCode("CONTENT_ICOS_VAULT_NOT_PROTECTION_ENABLED", "ICOS vault [{0}] is not protection enabled. It does not support retention settings and legal hold on the storage device side.", "FNRCC0334", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_ICOS_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE = new ExceptionCode("CONTENT_FCP_ICOS_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE", "Invalid (not zero) fixed minimum retention [{0}] setting on protection enabled ICOS vault [{1}], device cannot be used for a not-aligned fixed content storage area.", "FNRCC0335", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_CONNECTOR_NOT_INITIALIZED = new ExceptionCode("CONTENT_ASA_CONNECTOR_NOT_INITIALIZED", "Storage Connector [{0}] was not initialized successfully, method call [{1}] failed. Please check the storage device configuration.", "FNRCC0336", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_DEVICE_HOLDS_NOT_SUPPORTED = new ExceptionCode("CONTENT_FCP_DEVICE_HOLDS_NOT_SUPPORTED", "Device Holds is not supported for the fixed content device with Id [{0}].", "FNRCC0337", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_HCP_FAILED_DEVICE_HOLD_VALIDATION = new ExceptionCode("CONTENT_FCP_HCP_FAILED_DEVICE_HOLD_VALIDATION", "Invalid configuration for Hitachi Fixed Content Storage Area, failed to complete applying device hold validation.", "FNRCC0338", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_LOCK_METHOD_NOT_SUPPORTED = new ExceptionCode("CONTENT_LOCK_METHOD_NOT_SUPPORTED", "The content lock method ''{0}'' is not supported by the device.", "FNRCC0339", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_LOCK_METHOD_INVALID_CHANGE = new ExceptionCode("CONTENT_LOCK_METHOD_INVALID_CHANGE", "The content lock method ''{0}'' cannot be applied when ''{1}'' has been used previously.", "FNRCC0340", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_GET_S3_BUCKET_RETENTION_FAILED = new ExceptionCode("CONTENT_GET_S3_BUCKET_RETENTION_FAILED", "Failed to get the retention settings for {0} [{1}].", "FNRCC0341", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_S3_PARSE_RETENTION_EXPIRATION_DATE_FAILED = new ExceptionCode("CONTENT_FCP_S3_PARSE_RETENTION_EXPIRATION_DATE_FAILED", "Failed to parse the retention expiration date value for object [{0}] versionId [{1}] in {2} [{3}].", "FNRCC0342", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_BUCKET_NOT_OBJECT_LOCK_ENABLED = new ExceptionCode("CONTENT_S3_BUCKET_NOT_OBJECT_LOCK_ENABLED", "S3 bucket [{0}] is not object lock enabled. It does not support retention settings and legal hold on the storage device side.", "FNRCC0343", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_S3_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE = new ExceptionCode("CONTENT_FCP_S3_INVALID_FIXED_MINRET_FOR_NOT_ALIGNED_MODE", "Invalid (not zero) fixed minimum retention [{0}] setting on object lock enabled S3 bucket [{1}] with a default retention set, device cannot be used for a not-aligned fixed content storage area.", "FNRCC0344", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_REQUEST_SIGN_FAILED = new ExceptionCode("CONTENT_AZURE_BLOB_REQUEST_SIGN_FAILED", "Failed to sign the request.", "FNRCC0345", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_URL_DECODING_FAILED = new ExceptionCode("CONTENT_URL_DECODING_FAILED", "Failed to decode the URL [{0}] using UTF-8 encoding scheme.", "FNRCC0346", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_INVALID_BASE_URL = new ExceptionCode("CONTENT_AZURE_BLOB_INVALID_BASE_URL", "The specific connection URL [{0}] for Azure Blob storage service is invalid.", "FNRCC0347", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_CONTAINER_NOT_EXIST = new ExceptionCode("CONTENT_AZURE_BLOB_CONTAINER_NOT_EXIST", "The Azure Blob storage container [{0}] with connection URL [{1}] does not exist.", "FNRCC0348", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_CONTAINER_NOT_ACCESSIBLE = new ExceptionCode("CONTENT_AZURE_BLOB_CONTAINER_NOT_ACCESSIBLE", "The Azure Blob container [{0}] with connection URL [{1}] exits but cannot access, wrong connection url or credential configuration.", "FNRCC0349", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_OPERATION_FAILED = new ExceptionCode("CONTENT_AZURE_BLOB_OPERATION_FAILED", "Azure Blob storage device [{0}] call failed for {1}.", "FNRCC0350", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_FAILED_CREATE_UPLOADBLOCK_FROM_FILEINPUTSTREAM = new ExceptionCode("CONTENT_AZURE_BLOB_FAILED_CREATE_UPLOADBLOCK_FROM_FILEINPUTSTREAM", "Failed to create multiBlock upload block data from FileInputStream.", "FNRCC0351", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_AZURE_BLOB_FAILED_RESET_BLOCK_INPUTSTREAM = new ExceptionCode("CONTENT_AZURE_BLOB_FAILED_RESET_BLOCK_INPUTSTREAM", "Failed to reset input stream to position {0} for Azure Blob multiBlock upload block.", "FNRCC0352", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_ASA_AZURE_BLOB_STAGING_FILE_EXIST = new ExceptionCode("CONTENT_ASA_AZURE_BLOB_STAGING_FILE_EXIST", "The Azure Blob [{0}] content upload staging file [{1}] already exists.", "FNRCC0353", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCP_CENTERA_FAILED_DEVICE_HOLD_VALIDATION = new ExceptionCode("CONTENT_FCP_CENTERA_FAILED_DEVICE_HOLD_VALIDATION", "Invalid configuration for Centera Fixed Content Storage Area, DeviceHold is not supported (FP_RETENTION_HOLD returns unsupported).", "FNRCC0354", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_FCA_FILE_NOT_AVAILABLE_FOR_INDEXING = new ExceptionCode("CONTENT_FCA_FILE_NOT_AVAILABLE_FOR_INDEXING", "During indexing the file {0} was not yet available, indexing will be retried later.", "FNRCC0355", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_EC2ROLE_CREDENTIALS_MANAGER_GET_CREDENTIAL_ERROR = new ExceptionCode("CONTENT_S3_EC2ROLE_CREDENTIALS_MANAGER_GET_CREDENTIAL_ERROR", "The S3 EC2RoleCredentialsManager failed to get S3 temporary credentials.", "FNRCC0356", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_WEBIDENTITY_CREDENTIALS_MANAGER_READ_WEB_TOKEN_ERROR = new ExceptionCode("CONTENT_S3_WEBIDENTITY_CREDENTIALS_MANAGER_READ_WEB_TOKEN_ERROR", "The WebIdentityS3CredentialsManager failed to read the token from file {0}.", "FNRCC0357", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_S3_WEBIDENTITY_CREDENTIALS_MANAGER_GET_CREDENTIAL_ERROR = new ExceptionCode("CONTENT_S3_WEBIDENTITY_CREDENTIALS_MANAGER_GET_CREDENTIAL_ERROR", "The WebIdentityS3CredentialsManager failed to get S3 temporary credentials.", "FNRCC0358", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode CONTENT_UPLOAD_VALIDATION_FAILED = new ExceptionCode("CONTENT_UPLOAD_VALIDATION_FAILED", "The content was rejected by the validation handler configured for the storage area for the following reason: {0}.", "FNRCC0359", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_PROBLEM_SENDING_REQUEST = new ExceptionCode("COMM_PROBLEM_SENDING_REQUEST", "There was a problem sending server communication request {0} to {1}.", "FNRCO0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_NO_RESPONSE_RECEIVED = new ExceptionCode("COMM_NO_RESPONSE_RECEIVED", "No response was received for server communication request {0} to {1}.", "FNRCO0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_NO_RESPONSE_RECEIVED_FOR_DEVICE_CONTENT_CREATE = new ExceptionCode("COMM_NO_RESPONSE_RECEIVED_FOR_DEVICE_CONTENT_CREATE", "No server communication response was received for creating content {0} to storage device {1}.", "FNRCO0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_UNKNOWN_RESPONSE_RECEIVED_FOR_DEVICE_CONTENT_CREATE = new ExceptionCode("COMM_UNKNOWN_RESPONSE_RECEIVED_FOR_DEVICE_CONTENT_CREATE", "An unknown server communication response failure was received for creating content {0} to storage device {1}. Response: {2}.", "FNRCO0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_UNEXPECTED_NUMBER_OF_RESPONSES_RECEIVED = new ExceptionCode("COMM_UNEXPECTED_NUMBER_OF_RESPONSES_RECEIVED", "An unexpected number of responses was received for server communication request {0} to {1}.  Expected {2}, but received {3} responses: {4}", "FNRCO0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_RETRYABLE_AUTH_EXCEPTION = new ExceptionCode("COMM_RETRYABLE_AUTH_EXCEPTION", "A server communication retryable authentication exception was detected.  The request will automatically be retried. {0}", "FNRCO0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_RETRYABLE_CONN_EXCEPTION = new ExceptionCode("COMM_RETRYABLE_CONN_EXCEPTION", "A server communication retryable connection exception was detected for site URL {0}. The following request will automatically be retried if any additional site URLs are available. {1}", "FNRCO0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_CREATE_CONTENT_HUNG_THREAD = new ExceptionCode("COMM_CREATE_CONTENT_HUNG_THREAD", "A hung thread was detected while sending content {0} to site {1}.", "FNRCO0008", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode COMM_SERVER_URL_INVALID = new ExceptionCode("COMM_SERVER_URL_INVALID", "The server communication url {0} for virtual server {1} in site {2} is not valid.  Please verify connectivity to the CPE server at this URL and that the URL has one of the following formats: http://host:port/wsi/FNCEWS40MTOM or https://host:port/wsi/FNCEWS40MTOM.", "FNRCO0009", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_BAD_PUBLISH_REQUEST = new ExceptionCode("PUBLISH_BAD_PUBLISH_REQUEST", "The publish request is invalid.  Check the validity of submitted input such as publish options or publish template.", "FNRCU0001", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_BAD_PUBLISH_TEMPLATE = new ExceptionCode("PUBLISH_BAD_PUBLISH_TEMPLATE", "An exception occurred while handling the provided publish template object.  Check the contents or properties of the object.", "FNRCU0002", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_NO_HANDLER = new ExceptionCode("PUBLISH_NO_HANDLER", "Unable to get a handler for the PublishRequest {0}.", "FNRCU0003", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_HANDLER_THREW = new ExceptionCode("PUBLISH_HANDLER_THREW", "An exception occurred in the Publishing handler. The exception is chained to this one.", "FNRCU0004", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_READING_REC_THREW = new ExceptionCode("PUBLISH_READING_REC_THREW", "An exception occurred during a read of the RenditionEngineConnection.", "FNRCU0005", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_READING_PR_PUBLISHINGSTATUS_THREW = new ExceptionCode("PUBLISH_READING_PR_PUBLISHINGSTATUS_THREW", "An exception occurred during a read of the PublishRequest.PublishingStatus.", "FNRCU0006", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_CONTENT_REFERENCE_NOT_SUPPORTED = new ExceptionCode("PUBLISH_CONTENT_REFERENCE_NOT_SUPPORTED", "Publishing does not support a content reference as the first content element of the source document.", "FNRCU0007", false, ErrorLoggingLevel.Required);
    public static final ExceptionCode PUBLISH_CONTENT_ELEMENT_NOT_FOUND = new ExceptionCode("PUBLISH_CONTENT_ELEMENT_NOT_FOUND", "Publishing requires that the source document must contain a content element, but none was found.", "FNRCU0008", false, ErrorLoggingLevel.Required);
    private static final long serialVersionUID = -4846791583317622768L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private ExceptionCode(String key, String englishString, String eid) {
        this.mKey = key;
        this.mEnglishString = englishString;
        this.id = eid;
        mapNameToExceptionCodeInstance.put(key, this);
    }

    private ExceptionCode(String key, String englishString, String eid, boolean isFatal, ErrorLoggingLevel errLogLevel) {
        this(key, englishString, eid);
        this.isFatal = isFatal;
        this.mErrorLoggingLevel = errLogLevel;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public ErrorLoggingLevel getErrorLoggingLevel() {
        return this.mErrorLoggingLevel;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getId() {
        int idInt = 0;
        try {
            String idTemp = this.id;
            idTemp = idTemp.replaceAll("[a-zA-Z]", "");
            idTemp = idTemp.trim();
            idInt = Integer.parseInt(idTemp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idInt;
    }

    public String getErrorId() {
        return this.id;
    }

    public String getDefaultEnglishString() {
        return this.mEnglishString;
    }

    public String toString(Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, stDefaultLocale, args);
    }

    public String toString(Locale le, Object[] args) {
        return this.toStringHelper(RES_BASE_NAME, le, args);
    }

    public static ExceptionCode getExceptionCode(String key) {
        return (ExceptionCode)mapNameToExceptionCodeInstance.get(key);
    }

    private synchronized String toStringHelper(String BaseName, Locale le, Object[] args) {
        String formattedString;
        String patternString;
        try {
            if (BaseName == null || le == null || this.mKey == null) {
                patternString = this.mEnglishString;
            } else {
                String[] lc = new String[]{le.getLanguage(), le.getCountry()};
                boolean didChange = LocaleUtils.localeSpecialCaseSwitcheroo(lc);
                if (didChange) {
                    lc[1] = lc[1] == null ? null : lc[1].toUpperCase();
                    le = new Locale(lc[0], lc[1]);
                }
                ResourceBundle bundle = ResourceBundle.getBundle(BaseName, le);
                patternString = bundle.getString(this.mKey);
            }
        }
        catch (MissingResourceException ex) {
            patternString = this.mEnglishString;
            le = Locale.US;
        }
        try {
            MessageFormat form = new MessageFormat(patternString, le);
            formattedString = form.format(args);
        }
        catch (Exception ex) {
            formattedString = this.mEnglishString;
            try {
                stLogger.error("Failed formating resource string: " + patternString, ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formattedString;
    }

    private Object readResolve() throws ObjectStreamException {
        return ExceptionCode.getExceptionCode(this.mKey);
    }
}

