/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.api.util;

import com.filenet.api.authentication.Credentials;
import com.filenet.api.authentication.SubjectCredentials;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.UserPasswordToken;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.UnifiedContext;
import com.filenet.apiimpl.util.UserContextImpl;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import javax.security.auth.Subject;

public class UserContext {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(UserContext.class, SubSystem.API);
    private UserContextImpl ucImpl;

    public UserContext() {
        this.ucImpl = new UserContextImpl(this);
    }

    private UserContext(UserContextImpl ucClone) {
        this.ucImpl = ucClone.cloneContext(this);
    }

    public Subject getSubject() {
        Credentials cr = this.ucImpl.getTopCredentials();
        if (cr instanceof SubjectCredentials) {
            return ((SubjectCredentials)cr).getSubject();
        }
        return null;
    }

    public static <T> Object doAs(Subject subject, PrivilegedExceptionAction<T> pea) {
        return new SubjectCredentials(subject).doAs(pea);
    }

    public static Subject getAmbientSubject() {
        J2EEUtil j2ee = J2EEUtil.getInstance();
        return j2ee.getAmbientSubject();
    }

    public void pushSubject(Subject sub) {
        if (UnifiedContext.get() != null) {
            throw new IllegalStateException("A pushSubject is not allowed during a BeginImp");
        }
        this.ucImpl.pushCredentials(new SubjectCredentials(sub));
    }

    public synchronized Subject popSubject() {
        Credentials cr = this.ucImpl.getTopCredentials();
        if (cr instanceof SubjectCredentials) {
            this.ucImpl.popCredentials();
            return ((SubjectCredentials)cr).getSubject();
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.ucImpl.setLocale(locale);
    }

    public Locale getLocale() {
        return this.ucImpl.getLocale();
    }

    public static Subject createSubject(Connection conn, String user, String password, String optionalJAASStanzaName) {
        ConnectionImpl ci = (ConnectionImpl)conn;
        String providerURL = ci.getProviderURL();
        if (logger.isDetailTraceEnabled()) {
            StringBuilder msg = new StringBuilder("UserContext creating Subject for <");
            msg.append(user);
            msg.append("> jaasStanza <");
            msg.append(optionalJAASStanzaName);
            msg.append("> providerURL <");
            msg.append(providerURL);
            msg.append(">");
            logger.traceDetail(msg.toString());
        }
        if (providerURL == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "Connection");
        }
        if (password == null || password.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.PASSWORD_IS_EMPTY_ERROR);
        }
        UserPasswordToken upt = new UserPasswordToken(user, password, optionalJAASStanzaName);
        upt.setProviderURL(ci.getProviderURL());
        return upt.getSubject(ci);
    }

    public static UserContext get() {
        return UserContextImpl.getImpl().getOwner();
    }

    public static void set(UserContext uc) {
        if (uc != null) {
            if (uc.ucImpl.isThreadOwned()) {
                UserContextImpl.set(uc.ucImpl);
            } else {
                UserContext ucClone = new UserContext(uc.ucImpl);
                UserContextImpl.set(ucClone.ucImpl);
            }
        } else {
            UserContextImpl.set(null);
        }
    }
}

