/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.collection;

import com.filenet.api.collection.EngineSet;
import com.filenet.api.collection.PageIterator;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.apiimpl.collection.DefaultPaging;
import com.filenet.apiimpl.collection.EngineSetIterator;
import com.filenet.apiimpl.collection.EngineSetPageIterator;
import com.filenet.apiimpl.collection.Paging;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.Streamable;
import com.filenet.apiimpl.util.Streams;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEngineSet
implements EngineSet,
Streamable {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(AbstractEngineSet.class, SubSystem.API);
    private List list;
    private boolean stale;
    private Paging paging;
    private EngineSetPageIterator iterator;
    private EngineRuntimeException traversalError;
    private static final boolean RELEASE_LIST = false;
    private static final boolean REFRESH_LIST = false;
    private static final long serialVersionUID = -7206490650092280640L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_PAGING = 1;
    private static final int NULL_LIST = 2;
    private static final int EMPTY_LIST = 4;

    protected AbstractEngineSet() {
        this.setList(new ArrayList());
        this.setPaging(new DefaultPaging());
    }

    protected AbstractEngineSet(List list) {
        this.setList(list);
        this.setPaging(new DefaultPaging());
    }

    protected AbstractEngineSet(List list, Paging paging) {
        this.setList(list);
        this.setPaging(paging);
    }

    public EngineRuntimeException getTraversalError() {
        return this.traversalError;
    }

    public void setTraversalError(EngineRuntimeException exp) {
        this.traversalError = exp;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public Paging getPaging() {
        return this.paging;
    }

    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    @Override
    public boolean isEmpty() {
        List list = this.getList();
        return list == null ? this.getIterator().isEmpty() : list.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new EngineSetIterator(this.nextIterator());
    }

    @Override
    public PageIterator pageIterator() {
        return this.nextIterator();
    }

    private EngineSetPageIterator getIterator() {
        if (this.iterator == null || this.iterator.hasFailed()) {
            this.iterator = this.nextIterator();
        }
        return this.iterator;
    }

    private EngineSetPageIterator nextIterator() {
        EngineSetPageIterator iterator = this.iterator;
        this.iterator = null;
        if (iterator == null || iterator.hasFailed()) {
            Paging paging = this.getPaging();
            paging = paging == null ? new DefaultPaging() : paging.copy();
            List list = this.getList();
            this.stale = this.getList() != null;
            iterator = new EngineSetPageIterator(this, paging, list);
        }
        return iterator;
    }

    protected abstract Object[] toArray(List var1);

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" Class=").append(this.getClass().getName());
        sb.append(" List=(").append(this.list).append(')');
        sb.append(" Stale=").append(this.stale);
        sb.append(" Paging=(").append(this.paging).append(')');
        sb.append(" Iterator=(").append(this.iterator).append(')');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(20);
        s.writeObject(this.getCurrentConnection());
        this.putStreamValue(Streams.getInstance().getDelegate(s));
    }

    private Connection getCurrentConnection() {
        Paging paging = this.getPaging();
        Connection connection = paging == null ? null : paging.getConnection();
        return connection == null ? SessionContext.getCurrentConnection() : connection;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Streams streams = Streams.getInstance(s.readShort());
        Connection connection = streams.readConnection(s);
        this.copyValue(this.getStreamValue(streams.getDelegate(s, connection)));
    }

    protected abstract AbstractEngineSet getStreamValue(DelegateInputStream var1) throws IOException, ClassNotFoundException;

    protected abstract void serializeList(DelegateOutputStream var1, List var2, int var3) throws IOException;

    protected abstract void deserializeList(DelegateInputStream var1, Connection var2, List var3, int var4) throws IOException, ClassNotFoundException;

    public void serializeValue(DelegateOutputStream s) throws IOException {
        DefaultPaging paging = (DefaultPaging)this.getPaging();
        List list = this.getList();
        int size = list == null ? -1 : list.size();
        int flags = 0;
        flags |= paging == null ? 1 : 0;
        flags |= list == null ? 2 : 0;
        s.writeShort(flags |= size == 0 ? 4 : 0);
        if (paging != null) {
            s.putPagingContext(paging);
        }
        if (size > 0) {
            s.writeInt(size);
            this.serializeList(s, list, size);
        }
        if (s.getVersion() >= 5) {
            s.putException(this.traversalError);
        } else if (this.traversalError != null) {
            logger.warn("An exception can not be returned to older client [" + s.getVersion() + "] The client program should be updated to use the new API ", this.traversalError);
        }
    }

    public void deserializeValue(DelegateInputStream s, Connection connection) throws IOException, ClassNotFoundException {
        this.setPaging(null);
        this.setList(null);
        short flags = s.readShort();
        if ((flags & 1) == 0) {
            this.setPaging(s.getPagingContext());
        }
        if ((flags & 2) == 0) {
            if ((flags & 4) == 0) {
                int size = s.readInt();
                ArrayList list = new ArrayList(size);
                this.deserializeList(s, connection, list, size);
                this.setList(list);
            } else {
                this.setList(new ArrayList());
            }
        }
        if (s.getVersion() >= 5) {
            this.traversalError = s.getException();
        }
    }

    protected void copyValue(AbstractEngineSet source) {
        this.setList(source.getList());
        this.setPaging(source.getPaging());
    }
}

