/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.jdbc.Debugger;
import java.sql.SQLException;

public class NotSupported
extends SQLException {
    private static final String NOT_SUPPORTED_SQL_STATE = "0A000";
    private SQLException se;

    protected NotSupported(Object instance, String methodName) {
        this.se = NotSupported.constructorCommon(this, instance, methodName);
    }

    protected static SQLException constructorCommon(SQLException thisCaller, Object instance, String methodName) {
        String simpleClassName = NotSupported.computeSimpleClassName(instance);
        Object[] params = new Object[]{simpleClassName, methodName};
        EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_NOT_SUPPORTED_ERROR, params);
        String localizedMessage = eRe.getLocalizedMessage();
        Debugger.write(thisCaller, localizedMessage);
        SQLException newSE = new SQLException(localizedMessage, NOT_SUPPORTED_SQL_STATE);
        newSE.initCause(eRe);
        return newSE;
    }

    protected SQLException getSE() {
        return this.se;
    }

    protected static final String computeSimpleClassName(Object instance) {
        String simpleClassName = null;
        if (instance instanceof String) {
            simpleClassName = (String)instance;
        } else {
            String fullClassName = null;
            fullClassName = instance instanceof Class ? ((Class)instance).getName() : instance.getClass().getName();
            int lastDot = fullClassName.lastIndexOf(46);
            simpleClassName = lastDot > 0 ? fullClassName.substring(lastDot + 1) : fullClassName;
            int lastDollar = simpleClassName.lastIndexOf(36);
            if (lastDollar > 0) {
                simpleClassName = simpleClassName.substring(lastDollar + 1);
            }
        }
        return simpleClassName;
    }
}

