/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.jdbc.Connection;
import com.filenet.apiimpl.jdbc.Field;
import com.filenet.apiimpl.jdbc.NotImplemented;
import com.filenet.apiimpl.jdbc.NotSupported;
import com.filenet.apiimpl.jdbc.ResultSetMetaData;
import com.filenet.apiimpl.jdbc.RowData;
import com.filenet.apiimpl.jdbc.RowDataDynamic;
import com.filenet.apiimpl.jdbc.Statement;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResultSet
implements InvocationHandler {
    private java.sql.ResultSet proxiedInstance = null;
    private Map columnNameToIndex = null;
    private boolean isSQLResultSet = false;
    private Connection connection;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private Field[] fields;
    private Map fullColumnNameToIndex = null;
    private boolean hasBuiltIndexMapping = false;
    private boolean isBinaryEncoded = false;
    private boolean isClosed = false;
    private Statement owningStatement;
    private int resultSetType = 1003;
    protected RowData rowData;
    private Object[] thisRow = null;
    protected long updateCount;
    private long updateId = -1L;
    private SQLWarning warningChain = null;
    private boolean wasNullFlag = false;
    private java.sql.Statement wrapperStatement;

    public static java.sql.ResultSet newInstance(Field[] fields, Connection conn, Statement stmt, Iterator iter) throws SQLException {
        ResultSet instance = new ResultSet(fields, conn, stmt, iter);
        instance.proxiedInstance = (java.sql.ResultSet)Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{java.sql.ResultSet.class}, (InvocationHandler)instance);
        return instance.proxiedInstance;
    }

    public static java.sql.ResultSet newInstance(Field[] fields, RowData tuples, Connection conn, Statement stmt) throws SQLException {
        ResultSet instance = new ResultSet(fields, tuples, conn, stmt);
        instance.proxiedInstance = (java.sql.ResultSet)Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{java.sql.ResultSet.class}, (InvocationHandler)instance);
        return instance.proxiedInstance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException {
        return Connection.invokeProxiedMethod(proxy, method, args);
    }

    java.sql.ResultSet getProxiedInstance() {
        return this.proxiedInstance;
    }

    private ResultSet(Field[] fields, RowData tuples, Connection conn, Statement stmt) throws SQLException {
        this.connection = conn;
        this.owningStatement = stmt;
        this.fields = fields;
        this.rowData = tuples;
        this.updateCount = this.rowData.size();
        this.isSQLResultSet = false;
        this.rowData.setOwner(this);
    }

    private ResultSet(Field[] fields, Connection conn, Statement stmt, Iterator iter) throws SQLException {
        this.connection = conn;
        this.owningStatement = stmt;
        this.fields = fields;
        this.rowData = new RowDataDynamic(this, iter);
        this.updateCount = this.rowData.size();
        this.isSQLResultSet = true;
        this.rowData.setOwner(this);
    }

    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            boolean b = false;
        } else {
            if (row == 0) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_CANNOT_ABSOLUTE_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            if (row == 1) {
                boolean b = this.first();
            } else if (row == -1) {
                boolean b = this.last();
            } else if (row > this.rowData.size()) {
                this.afterLast();
                boolean b = false;
            } else if (row < 0) {
                int newRowPosition = this.rowData.size() + row + 1;
                if (newRowPosition <= 0) {
                    this.beforeFirst();
                    boolean b = false;
                } else {
                    boolean b = this.absolute(newRowPosition);
                }
            } else {
                this.rowData.setCurrentRow(--row);
                this.thisRow = this.rowData.getAt(row);
                boolean b = true;
            }
        }
        return false;
    }

    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        if (this.rowData.size() != 0) {
            this.rowData.afterLast();
            this.thisRow = null;
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return;
        }
        this.rowData.beforeFirst();
        this.thisRow = null;
    }

    private void buildIndexMapping() {
        int numFields = this.fields.length;
        this.columnNameToIndex = new HashMap(numFields);
        this.fullColumnNameToIndex = new HashMap(numFields);
        for (int i = numFields - 1; i >= 0; --i) {
            String columnName = this.fields[i].getName();
            String fullColumnName = this.fields[i].getFullName();
            if (columnName != null) {
                this.columnNameToIndex.put(columnName, i);
                this.columnNameToIndex.put(columnName.toUpperCase(), i);
                this.columnNameToIndex.put(columnName.toLowerCase(), i);
            }
            if (fullColumnName == null) continue;
            this.fullColumnNameToIndex.put(fullColumnName, i);
            this.fullColumnNameToIndex.put(fullColumnName.toUpperCase(), i);
            this.fullColumnNameToIndex.put(fullColumnName.toLowerCase(), i);
        }
        this.hasBuiltIndexMapping = true;
    }

    public void cancelRowUpdates() throws SQLException {
        throw new NotImplemented(this, "cancelRowUpdates").getSE();
    }

    private final synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_RESULTSET_CLOSED_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private final void checkColumnBounds(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            Object[] params = new Object[]{columnIndex, this.fields.length};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_OBJECT_STORE_NOT_FOUND_ERROR, params);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private void checkRowPos() throws SQLException {
        this.checkClosed();
        if (!this.rowData.isDynamic() && this.rowData.size() == 0) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_ILLEGAL_OPERATION_ON_RESULTSET_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        if (this.rowData.isBeforeFirst()) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_BEFORE_START_OF_RESULTSET_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        if (this.rowData.isAfterLast()) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_AFTER_END_OF_RESULTSET_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    public void clearWarnings() {
        this.warningChain = null;
    }

    public synchronized void close() {
        this.realClose(true);
    }

    public void deleteRow() throws SQLException {
        throw new NotImplemented(this, "deleteRow").getSE();
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        Integer index;
        if (!this.hasBuiltIndexMapping) {
            this.buildIndexMapping();
        }
        if ((index = (Integer)this.columnNameToIndex.get(columnName)) == null) {
            index = (Integer)this.fullColumnNameToIndex.get(columnName);
        }
        if (index != null) {
            int ii = index + 1;
            return ii;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getName().equalsIgnoreCase(columnName)) {
                int ii = i + 1;
                return ii;
            }
            if (!this.fields[i].getFullName().equalsIgnoreCase(columnName)) continue;
            int ii = i + 1;
            return ii;
        }
        Object[] params = new Object[]{columnName};
        EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_COLUMN_NOT_FOUND_ERROR, params);
        SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
        sqlEx.initCause(eRe);
        throw sqlEx;
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.rowData.isEmpty()) {
            return false;
        }
        this.rowData.beforeFirst();
        this.thisRow = this.rowData.next();
        return true;
    }

    public Array getArray(int i) throws SQLException {
        throw new NotImplemented(this, "getArray").getSE();
    }

    public Array getArray(String colName) throws SQLException {
        throw new NotImplemented(this, "getArray").getSE();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return null;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) {
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Blob getBlob(int columnIndex) {
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean val = false;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return false;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return false;
            }
            --columnIndex;
            try {
                Boolean boolVal = (Boolean)this.thisRow[columnIndex];
                val = boolVal;
            }
            catch (Exception e) {
                throw new SQLException("Invalid getMethod called on ResultSet. " + e);
            }
        }
        return val;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) {
        return 0;
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) {
        return this.getBytes(columnIndex, false);
    }

    private byte[] getBytes(int columnIndex, boolean noConversion) {
        return (byte[])this.thisRow[columnIndex - 1];
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) {
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Clob getClob(int i) {
        return null;
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public int getConcurrency() {
        return 1007;
    }

    public String getCursorName() throws SQLException {
        throw new NotSupported(this, "getCursorName").getSE();
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date returnVal = null;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return null;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return null;
            }
            java.util.Date returnValDate = (java.util.Date)this.thisRow[--columnIndex];
            long utilLongDate = returnValDate.getTime();
            returnVal = new Date(utilLongDate);
        }
        return returnVal;
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        double returnVal = 0.0;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return 0.0;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return 0.0;
            }
            --columnIndex;
            try {
                Double returnValDub = (Double)this.thisRow[columnIndex];
                returnVal = returnValDub;
            }
            catch (Exception e) {
                throw new SQLException("Invalid getMethod called on ResultSet. ");
            }
        }
        return returnVal;
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public float getFloat(int columnIndex) throws SQLException {
        float returnVal;
        block9: {
            returnVal = 0.0f;
            if (!this.isBinaryEncoded) {
                this.checkRowPos();
                this.checkColumnBounds(columnIndex);
                if (this.fields == null) {
                    EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                    SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                    sqlEx.initCause(eRe);
                    throw sqlEx;
                }
                try {
                    if (this.thisRow[columnIndex - 1] == null) {
                        this.wasNullFlag = true;
                        return 0.0f;
                    }
                    this.wasNullFlag = false;
                }
                catch (NullPointerException E) {
                    this.wasNullFlag = true;
                    return 0.0f;
                }
                --columnIndex;
                try {
                    Object returnValFloat = this.thisRow[columnIndex];
                    if (returnValFloat instanceof Double) {
                        returnVal = ((Double)this.thisRow[columnIndex]).floatValue();
                        break block9;
                    }
                    if (returnValFloat instanceof Float) {
                        returnVal = ((Float)returnValFloat).floatValue();
                        break block9;
                    }
                    throw new SQLException("Invalid getMethod called on ResultSet. ");
                }
                catch (Exception e) {
                    throw new SQLException("Invalid getMethod called on ResultSet. ");
                }
            }
        }
        return returnVal;
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        int returnVal = -1;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return 0;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return 0;
            }
            --columnIndex;
            try {
                Object returnValInteger = this.thisRow[columnIndex];
                if (!(returnValInteger instanceof Integer)) {
                    throw new SQLException("Invalid getMethod called on ResultSet. ");
                }
                returnVal = (Integer)this.thisRow[columnIndex];
            }
            catch (Exception e) {
                throw new SQLException("Invalid getMethod called on ResultSet. ");
            }
        }
        return returnVal;
    }

    public int getInt(String columnName) throws SQLException {
        int i = this.getInt(this.findColumn(columnName));
        return i;
    }

    public long getLong(int columnIndex) throws SQLException {
        long returnVal;
        block9: {
            returnVal = 0L;
            if (!this.isBinaryEncoded) {
                this.checkRowPos();
                this.checkColumnBounds(columnIndex);
                if (this.fields == null) {
                    EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                    SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                    sqlEx.initCause(eRe);
                    throw sqlEx;
                }
                try {
                    if (this.thisRow[columnIndex - 1] == null) {
                        this.wasNullFlag = true;
                        return 0L;
                    }
                    this.wasNullFlag = false;
                }
                catch (NullPointerException E) {
                    this.wasNullFlag = true;
                    return 0L;
                }
                --columnIndex;
                try {
                    Object returnValLong = this.thisRow[columnIndex];
                    if (returnValLong instanceof Long) {
                        returnVal = ((Long)this.thisRow[columnIndex]).intValue();
                        break block9;
                    }
                    if (returnValLong instanceof Integer) {
                        returnVal = ((Integer)this.thisRow[columnIndex]).intValue();
                        break block9;
                    }
                    throw new SQLException("Invalid getMethod called on ResultSet. ");
                }
                catch (Exception e) {
                    throw new SQLException("Invalid getMethod called on ResultSet. ");
                }
            }
        }
        return returnVal;
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return ResultSetMetaData.newInstance(this.fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object returnVal = null;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return null;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return null;
            }
            --columnIndex;
            try {
                returnVal = this.thisRow[columnIndex];
            }
            catch (Exception e) {
                throw new SQLException("Invalid getMethod called on ResultSet. " + e.getMessage());
            }
        }
        return returnVal;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(int i) {
        return null;
    }

    public Ref getRef(String colName) {
        return null;
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        int currentRowNumber = this.rowData.getCurrentRowNumber();
        int row = 0;
        row = currentRowNumber <= 0 || this.rowData.isAfterLast() || this.rowData.isEmpty() ? 0 : currentRowNumber;
        return row;
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkRowPos();
        return 0;
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public java.sql.Statement getStatement() {
        if (this.wrapperStatement != null) {
            return this.wrapperStatement;
        }
        return this.owningStatement.getProxiedInstance();
    }

    public String getString(int columnIndex) throws SQLException {
        String s = this.getStringInternal(columnIndex);
        return s;
    }

    private String getStringInternal(int columnIndex) throws SQLException {
        if (this.isBinaryEncoded) {
            return null;
        }
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.fields == null) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
            this.wasNullFlag = false;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
            return null;
        }
        Object o = this.thisRow[--columnIndex];
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public String getString(String columnName) throws SQLException {
        String s = this.getString(this.findColumn(columnName));
        return s;
    }

    public Time getTime(int columnIndex) {
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) {
        return null;
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(String columnName, Calendar cal) {
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp returnVal = null;
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_QUERY_GENERTED_NO_FIELDS_ERROR);
                SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
                sqlEx.initCause(eRe);
                throw sqlEx;
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return null;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return null;
            }
            java.util.Date returnValStr = (java.util.Date)this.thisRow[--columnIndex];
            long utilLongDate = returnValStr.getTime();
            returnVal = new Timestamp(utilLongDate);
        }
        return returnVal;
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public int getType() {
        return this.resultSetType;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new NotSupported(this, "getUnicodeStream").getSE();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new NotSupported(this, "getUnicodeStream").getSE();
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateId;
    }

    public URL getURL(int colIndex) throws SQLException {
        throw new NotImplemented(this, "getURL").getSE();
    }

    public URL getURL(String colName) throws SQLException {
        throw new NotImplemented(this, "getURL").getSE();
    }

    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    public void insertRow() throws SQLException {
        throw new NotImplemented(this, "insertRow").getSE();
    }

    public boolean isAfterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        return this.rowData.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        return this.rowData.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        return this.rowData.isFirst();
    }

    public boolean isLast() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        return this.rowData.isLast();
    }

    public boolean last() throws SQLException {
        if (this.resultSetType == 1003) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_INVALID_CURSOR_OPERATION);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return false;
        }
        this.rowData.beforeLast();
        this.thisRow = this.rowData.next();
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        throw new NotImplemented(this, "moveToCurrentRow").getSE();
    }

    public void moveToInsertRow() throws SQLException {
        throw new NotImplemented(this, "moveToInsertRow").getSE();
    }

    public boolean next() throws SQLException {
        boolean b = false;
        this.checkClosed();
        if (this.isSQLResultSet) {
            if (!this.rowData.hasNext()) {
                this.rowData.next();
                b = false;
            } else {
                this.clearWarnings();
                this.thisRow = this.rowData.next();
                b = true;
            }
        } else if (this.rowData.size() == 0) {
            b = false;
        } else if (!this.rowData.hasNext()) {
            this.rowData.next();
            b = false;
        } else {
            this.clearWarnings();
            this.thisRow = this.rowData.next();
            b = true;
        }
        return b;
    }

    public boolean prev() throws SQLException {
        this.checkClosed();
        int rowIndex = this.rowData.getCurrentRowNumber();
        if (rowIndex - 1 >= 0) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = this.rowData.getAt(rowIndex);
            return true;
        }
        if (rowIndex - 1 == -1) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = null;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        return this.prev();
    }

    protected void realClose(boolean calledExplicitly) {
        if (this.isClosed) {
            return;
        }
        if (this.rowData != null) {
            try {
                this.rowData.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.rowData = null;
        this.fields = null;
        this.columnNameToIndex = null;
        this.fullColumnNameToIndex = null;
        this.warningChain = null;
        this.owningStatement = null;
        this.thisRow = null;
        this.connection = null;
        this.isClosed = true;
    }

    public void refreshRow() throws SQLException {
        throw new NotImplemented(this, "refreshRow").getSE();
    }

    public boolean relative(int rows) throws SQLException {
        throw new NotImplemented(this, "relative").getSE();
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplemented(this, "setFetchDirection").getSE();
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_VALUE_GENERATED_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.fetchSize = rows;
    }

    public void setWrapperStatement(java.sql.Statement wrapperStatement) {
        this.wrapperStatement = wrapperStatement;
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new NotImplemented(this, "updateArray").getSE();
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new NotImplemented(this, "udpateArray").getSE();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented(this, "updateAsciiStream").getSE();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new NotImplemented(this, "updateAsciiStream").getSE();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotImplemented(this, "updateBigDecimal").getSE();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new NotImplemented(this, "updateBigDecimal").getSE();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented(this, "updateBinaryStream").getSE();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new NotImplemented(this, "updateBinaryStream").getSE();
    }

    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new NotImplemented(this, "updateBlob").getSE();
    }

    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new NotImplemented(this, "updateBlob").getSE();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotImplemented(this, "updateBoolean").getSE();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new NotImplemented(this, "updateBoolean").getSE();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotImplemented(this, "updateByte").getSE();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new NotImplemented(this, "updateByte").getSE();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotImplemented(this, "updateBytes").getSE();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new NotImplemented(this, "updateByte").getSE();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotImplemented(this, "updateCharacterStream").getSE();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new NotImplemented(this, "updateCharacterStream").getSE();
    }

    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new NotImplemented(this, "updateClob").getSE();
    }

    public void updateClob(String columnName, Clob clob) throws SQLException {
        throw new NotImplemented(this, "updateClob").getSE();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotImplemented(this, "updateDate").getSE();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new NotImplemented(this, "updateDate").getSE();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotImplemented(this, "updateDouble").getSE();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new NotImplemented(this, "updateDouble").getSE();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotImplemented(this, "updateFloat").getSE();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new NotImplemented(this, "updateFloat").getSE();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotImplemented(this, "updateInt").getSE();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new NotImplemented(this, "updateInt").getSE();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotImplemented(this, "updateLong").getSE();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new NotImplemented(this, "updateLong").getSE();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new NotImplemented(this, "updateNull").getSE();
    }

    public void updateNull(String columnName) throws SQLException {
        throw new NotImplemented(this, "updateNull").getSE();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotImplemented(this, "updateObject").getSE();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new NotImplemented(this, "updateObject").getSE();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new NotImplemented(this, "updateObject").getSE();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new NotImplemented(this, "updateObject").getSE();
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new NotImplemented(this, "updateRef").getSE();
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new NotImplemented(this, "updateRef").getSE();
    }

    public void updateRow() throws SQLException {
        throw new NotImplemented(this, "updateRow").getSE();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotImplemented(this, "updateShort").getSE();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new NotImplemented(this, "updateShort").getSE();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotImplemented(this, "updateString").getSE();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new NotImplemented(this, "updateString").getSE();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotImplemented(this, "updateTime").getSE();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new NotImplemented(this, "updateTime").getSE();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotImplemented(this, "updateTimestamp").getSE();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new NotImplemented(this, "updateTimestamp").getSE();
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

