/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.jdbc;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.jdbc.Connection;
import com.filenet.apiimpl.jdbc.NotImplemented;
import com.filenet.apiimpl.jdbc.ResultSet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class Statement
implements InvocationHandler {
    private java.sql.Statement proxiedInstance = null;
    private Connection connection = null;
    private boolean isClosed = false;
    private int maxRows = -1;
    private java.sql.ResultSet results = null;
    private final int resultSetConcurrency;
    private final int resultSetType;
    private final int resultSetHoldability;

    public static java.sql.Statement newInstance(Connection connToSet, String catalog, int i1, int i2, int i3) throws SQLException {
        Statement instance = new Statement(connToSet, catalog, i1, i2, i3);
        instance.proxiedInstance = (java.sql.Statement)Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{java.sql.Statement.class}, (InvocationHandler)instance);
        return instance.proxiedInstance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SQLException {
        return Connection.invokeProxiedMethod(proxy, method, args);
    }

    java.sql.Statement getProxiedInstance() {
        return this.proxiedInstance;
    }

    protected Statement(Connection connToSet, String catalog) throws SQLException {
        this(connToSet, catalog, 1003, 1007, 2);
    }

    private Statement(Connection connToSet, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            Object[] codeArgs = new Object[]{"resultSetType", resultSetType};
            Object[] contextArgs = new Object[]{"ResultSet.TYPE_FORWARD_ONLY"};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, codeArgs, ExceptionContext.E_BAD_VALUE_RESTRICTION, contextArgs);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.resultSetType = resultSetType;
        if (resultSetConcurrency != 1007) {
            Object[] codeArgs = new Object[]{"resultSetConcurrency", resultSetConcurrency};
            Object[] contextArgs = new Object[]{"ResultSet.CONCUR_READ_ONLY"};
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, codeArgs, ExceptionContext.E_BAD_VALUE_RESTRICTION, contextArgs);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.connection = connToSet;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        throw new NotImplemented(this, "addBatch").getSE();
    }

    public void cancel() {
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_STATEMENT_CLOSED_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
        if (sql.length() == 0) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_STATEMENT_QUERY_NULL_OR_EMPTY_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    private static String dealWithSchemaSyntax(String sql) {
        String p8schemaStr = "\"P8Schema\".";
        String p8schemaStr2 = "P8Schema.";
        int index = sql.indexOf(p8schemaStr);
        int index2 = sql.indexOf(p8schemaStr2);
        if (index < 0 && index2 < 0) {
            return sql;
        }
        String retSql = null;
        retSql = index >= 0 ? sql.substring(0, index) + sql.substring(index + p8schemaStr.length(), sql.length()) : (index2 >= 0 ? sql.substring(0, index2) + sql.substring(index2 + p8schemaStr2.length(), sql.length()) : sql);
        return Statement.dealWithSchemaSyntax(retSql);
    }

    public synchronized void clearBatch() throws SQLException {
        throw new NotImplemented(this, "clearBatch").getSE();
    }

    public synchronized void clearWarnings() throws SQLException {
        throw new NotImplemented(this, "clearWarnings").getSE();
    }

    public synchronized void close() {
        this.realClose(true);
    }

    public void enableStreamingResults() throws SQLException {
        throw new NotImplemented(this, "enableStreamingResults").getSE();
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.checkNullOrEmptyQuery(sql);
        sql = Statement.dealWithSchemaSyntax(sql);
        this.checkClosed();
        java.sql.ResultSet jrs = this.connection.execSQL(this, sql);
        if (jrs != null) {
            this.results = jrs;
        }
        return jrs != null;
    }

    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        throw new NotImplemented(this, "execute(String,int)").getSE();
    }

    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        throw new NotImplemented(this, "execute(String,int[])").getSE();
    }

    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        throw new NotImplemented(this, "execute(String,String[])").getSE();
    }

    public synchronized int[] executeBatch() throws SQLException {
        throw new NotImplemented(this, "executeBatch").getSE();
    }

    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.results;
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        throw new NotImplemented(this, "executeUpdate").getSE();
    }

    public int executeUpdate(String sql, int returnGeneratedKeys) throws SQLException {
        throw new NotImplemented(this, "executeUpdate").getSE();
    }

    public int executeUpdate(String sql, int[] generatedKeyIndices) throws SQLException {
        throw new NotImplemented(this, "executeUpdate").getSE();
    }

    public int executeUpdate(String sql, String[] generatedKeyNames) throws SQLException {
        throw new NotImplemented(this, "executeUpdate").getSE();
    }

    public synchronized java.sql.Connection getConnection() {
        return this.connection.getProxiedInstance();
    }

    public int getFetchDirection() {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        throw new NotImplemented(this, "getFetchSize").getSE();
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new NotImplemented(this, "getGeneratedKeys").getSE();
    }

    public synchronized int getMaxFieldSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized int getMaxRows() {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    public synchronized boolean getMoreResults(int current) {
        return this.results != null;
    }

    public int getQueryTimeout() throws SQLException {
        throw new NotImplemented(this, "getQueryTimeout").getSE();
    }

    public synchronized java.sql.ResultSet getResultSet() {
        return this.results;
    }

    public synchronized int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        throw new NotImplemented(this, "getResultSetHoldability").getSE();
    }

    public synchronized int getResultSetType() {
        return this.resultSetType;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return 0;
        }
        ResultSet implResults = (ResultSet)Proxy.getInvocationHandler(this.results);
        if (implResults.updateCount > 0L) {
            return -1;
        }
        return implResults.rowData.size();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        throw new NotImplemented(this, "getWarnings").getSE();
    }

    private void realClose(boolean calledExplicitly) {
        if (this.isClosed) {
            return;
        }
        this.results = null;
        this.connection = null;
        this.isClosed = true;
    }

    public void setCursorName(String name) throws SQLException {
        throw new NotImplemented(this, "setCursorName").getSE();
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        throw new NotImplemented(this, "setEscapeProcessing").getSE();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new NotImplemented(this, "setFetchDirection").getSE();
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            EngineRuntimeException eRe = new EngineRuntimeException(ExceptionCode.JDBC_STATEMENT_FETCH_SIZE_ERROR);
            SQLException sqlEx = new SQLException(eRe.getLocalizedMessage());
            sqlEx.initCause(eRe);
            throw sqlEx;
        }
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        throw new NotImplemented(this, "setMaxFieldSize").getSE();
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        throw new NotImplemented(this, "setMaxRows").getSE();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        throw new NotImplemented(this, "setQueryTimeout").getSE();
    }
}

