/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.meta;

import com.filenet.api.constants.MergeMode;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.ObjectRetriever;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Arrays;
import java.util.List;

public class SearchScopeIdentity
extends ObjectReferenceBase
implements ObjectRetriever {
    private Id objectId;
    private GlobalIdentity[] objectStores;
    private MergeMode mergeMode;
    private static final long serialVersionUID = 3155178546929186144L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final int NULL_OBJECT_ID = 2;
    private static final int NULL_MERGE_MODE = 4;
    private static final int NULL_OBJECT_STORES = 8;
    private static final int EMPTY_OBJECT_STORES = 16;

    public SearchScopeIdentity() {
    }

    public SearchScopeIdentity(String className, Id objectIdVal, GlobalIdentity[] objectStoresVal, MergeMode mergeModeVal) {
        super(className);
        this.objectId = objectIdVal;
        this.objectStores = objectStoresVal;
        this.mergeMode = mergeModeVal;
    }

    public GlobalIdentity[] getObjectStores() {
        return this.objectStores;
    }

    public MergeMode getMergeMode() {
        return this.mergeMode;
    }

    @Override
    public Id getObjectId() {
        return this.objectId;
    }

    @Override
    public EngineObject getObject(Connection conn, PropertyFilter propFilter) {
        List list;
        Session session = SessionLocator.getSession(conn);
        AbstractEngineSet cds = (AbstractEngineSet)((Object)session.getSearchMetadata((ConnectionImpl)conn, this.objectStores, this.mergeMode, new String[]{this.objectId.toString()}, propFilter));
        List list2 = list = cds == null ? null : cds.getList();
        if (list == null || list.size() != 1) {
            throw new EngineRuntimeException(ExceptionCode.METADATA_INVALID_SEARCH_MD_RESULT, new Object[]{this.getClassIdentity()});
        }
        return (ClassDescription)list.toArray()[0];
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SearchScopeIdentity)) {
            return false;
        }
        SearchScopeIdentity base = (SearchScopeIdentity)object;
        if (this.objectStores != null && base.objectStores == null || base.objectStores != null && this.objectStores == null) {
            return false;
        }
        if (this.mergeMode != null && base.mergeMode == null || base.mergeMode != null && this.mergeMode == null) {
            return false;
        }
        if (this.objectId != null && base.objectId == null || base.objectId != null && this.objectId == null) {
            return false;
        }
        if (this.objectStores != null && !Arrays.equals(this.objectStores, base.objectStores)) {
            return false;
        }
        if (this.mergeMode != null && !this.mergeMode.equals(base.mergeMode)) {
            return false;
        }
        if (this.objectId != null && !this.objectId.equals(base.objectId)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.mergeMode != null ? this.mergeMode.hashCode() : 0);
        if (this.objectStores != null) {
            for (GlobalIdentity g : this.objectStores) {
                result = 37 * result + g.hashCode();
            }
        }
        result = 37 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 37 * result + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        String oss = "";
        if (this.objectStores != null && this.objectStores.length > 0) {
            StringBuffer buf = new StringBuffer("");
            for (int lp = 0; lp < this.objectStores.length; ++lp) {
                buf.append(this.objectStores[lp].toString());
                if (lp + 1 >= this.objectStores.length) continue;
                buf.append(",");
            }
            oss = buf.toString();
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("classId=");
        sb.append(this.getClassIdentity());
        sb.append("&objectId=");
        sb.append(this.getObjectIdentity());
        sb.append("&objectStore=");
        sb.append(oss);
        if (this.mergeMode != null) {
            sb.append("&mergeMode=");
            sb.append(this.mergeMode);
        }
        return sb.toString();
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public String getObjectIdentity() {
        return this.objectId != null ? this.objectId.toString() : null;
    }

    @Override
    public String getObjectStoreIdentity() {
        GlobalIdentity reference = this.getObjectStoreReference();
        return reference == null ? null : reference.getObjectIdentity();
    }

    @Override
    public GlobalIdentity getObjectStoreReference() {
        if (this.objectStores == null) {
            return null;
        }
        int length = this.objectStores.length;
        if (length == 0) {
            return null;
        }
        GlobalIdentity reference = this.objectStores[0];
        if (reference == null) {
            return null;
        }
        for (int i = 1; i < length; ++i) {
            if (reference.equals(this.objectStores[i])) continue;
            return null;
        }
        return reference;
    }

    private void writeObject(ObjectOutputStream s) {
    }

    private void readObject(ObjectInputStream s) {
    }

    @Override
    public int getClassType() {
        return 6;
    }

    @Override
    protected int getStreamFlags() {
        int size = this.objectStores == null ? -1 : this.objectStores.length;
        int flags = super.getStreamFlags();
        flags |= this.objectId == null ? 2 : 0;
        flags |= this.mergeMode == null ? 4 : 0;
        flags |= this.objectStores == null ? 8 : 0;
        return flags |= size == 0 ? 16 : 0;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        int size;
        super.serializeValue(s);
        if (this.objectId != null) {
            s.putId(this.objectId);
        }
        if (this.mergeMode != null) {
            s.putMergeMode(this.mergeMode);
        }
        int n = size = this.objectStores == null ? -1 : this.objectStores.length;
        if (size > 0) {
            s.writeInt(size);
            for (int i = 0; i < size; ++i) {
                s.putObjectReference(this.objectStores[i]);
            }
        }
    }

    @Override
    protected void deserializeValue(DelegateInputStream s, int flags) throws IOException, ClassNotFoundException {
        super.deserializeValue(s, flags);
        if ((flags & 2) == 0) {
            this.objectId = s.getId();
        }
        if ((flags & 4) == 0) {
            this.mergeMode = s.getMergeMode();
        }
        if ((flags & 8) == 0) {
            if ((flags & 0x10) == 0) {
                int size = s.readInt();
                this.objectStores = new GlobalIdentity[size];
                for (int i = 0; i < size; ++i) {
                    this.objectStores[i] = (GlobalIdentity)s.getObjectReference();
                }
            } else {
                this.objectStores = new GlobalIdentity[0];
            }
        }
    }

    @Override
    protected void copyValue(ObjectReferenceBase src) {
        super.copyValue(src);
        SearchScopeIdentity source = (SearchScopeIdentity)src;
        this.objectId = source.objectId;
        this.mergeMode = source.mergeMode;
        this.objectStores = source.objectStores;
    }
}

