/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.perflog;

import com.filenet.apiimpl.perflog.AuditEntry;
import com.filenet.apiimpl.perflog.PerfAuditEntry;
import com.filenet.apiimpl.perflog.PerfIntervalData;
import com.filenet.apiimpl.perflog.Perflog;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class AuditInterval {
    protected long minutes = -1L;
    protected long lastDumpTime = -1L;
    protected long nextDumpTime = -1L;
    protected volatile AuditInterval nextInterval = null;
    protected long gcCount = 0L;
    protected long gcDuration = 0L;
    protected long gcCountInt = 0L;
    protected long gcDurationInt = 0L;
    protected volatile boolean open = true;
    protected volatile HashMap theTable = new HashMap();
    protected TreeMap theCallbacks = new TreeMap();
    public static String Line_separator = System.getProperty("line.separator");

    public AuditInterval(int interval) {
        if (interval > 0) {
            this.minutes = interval;
            this.lastDumpTime = System.currentTimeMillis();
            this.nextDumpTime = this.getInitialNextDump(interval);
        } else {
            this.lastDumpTime = System.currentTimeMillis();
        }
        try {
            this.countIn("JvmMem", this.getClass().getMethod("getJvmMem", null));
            this.countIn("FreeMem", this.getClass().getMethod("getFreeMem", null));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static long getJvmMem() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public static long getFreeMem() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public void countIn(String name, Method callback) {
        this.theCallbacks.put(name, callback);
    }

    public void countIn(AuditEntry entry1) {
        if (!this.open) {
            return;
        }
        this.checkDump();
        PerfAuditEntry entry = (PerfAuditEntry)entry1;
        String type = entry.getType();
        PerfIntervalData intData = (PerfIntervalData)this.theTable.get(type);
        if (intData != null) {
            intData.countIn(entry);
        } else {
            this.populateEntry(type, entry.unit);
            this.countIn(entry1);
        }
    }

    public void countIn(String type, long time, boolean successful) {
        this.countIn(type, time, successful, 1L);
    }

    public void countIn(String type, long time, boolean successful, long unit) {
        if (!this.open) {
            return;
        }
        this.checkDump();
        if (null == type) {
            return;
        }
        if (Perflog.Instance().getCounterWithStack() != null && type.trim().startsWith(Perflog.Instance().getCounterWithStack())) {
            this.countAndAppendStack(type, time, successful, unit);
        }
        PerfIntervalData intData = null;
        intData = (PerfIntervalData)this.theTable.get(type);
        if (intData != null) {
            intData.countIn(time, successful);
        } else {
            this.populateEntry(type, unit);
            this.countIn(type, time, successful, unit);
        }
    }

    private void countAndAppendStack(String type, long time, boolean successful, long unit) {
        StringBuffer stack = new StringBuffer();
        stack.append(";" + type);
        stack.append("; ");
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] s = e.getStackTrace();
            boolean start = true;
            int count = 0;
            for (StackTraceElement se : s) {
                if (se.getClassName().startsWith("com.filenet.apiimpl.perflog")) continue;
                ++count;
                if (start) {
                    start = false;
                } else {
                    stack.append("; ");
                }
                stack.append(se.getClassName());
                stack.append(".");
                stack.append(se.getMethodName());
                stack.append(":");
                stack.append(se.getLineNumber());
            }
            this.countIn(stack.toString(), time, successful, unit);
            return;
        }
    }

    private synchronized void populateEntry(String type, long unit) {
        if (this.theTable.containsKey(type)) {
            return;
        }
        this.theTable.put(type, new PerfIntervalData(type, unit));
    }

    public String printPerf() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("#Audit#-");
        buf.append(this.minutes);
        buf.append(" minute(s) ");
        Date tmpDate = new Date(this.lastDumpTime);
        SimpleDateFormat formatter = new SimpleDateFormat("MM:dd:HH:mm:ss");
        buf.append(formatter.format(tmpDate));
        tmpDate.setTime(this.nextDumpTime);
        buf.append('-');
        buf.append(formatter.format(tmpDate));
        buf.append(']');
        for (String name : this.theCallbacks.keySet()) {
            Method callback = (Method)this.theCallbacks.get(name);
            try {
                buf.append(" " + name + "=" + callback.invoke(null, null));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.getGcInfo();
        buf.append(" gcCount=" + this.gcCountInt);
        buf.append(" gcDuration=" + this.gcDurationInt);
        buf.append(Line_separator);
        for (PerfIntervalData data : this.theTable.values()) {
            if (!data.hasEntries() || !data.aboveThreshhold()) continue;
            buf.append("#Audit#-" + this.minutes + "\t");
            data.printMyInfo(buf);
            buf.append(Line_separator);
        }
        return buf.toString();
    }

    protected long getInitialNextDump(int interval) {
        int nMinutes;
        Calendar now = Calendar.getInstance();
        Calendar next = (Calendar)now.clone();
        int cMinutes = now.get(12);
        for (nMinutes = 0; nMinutes < cMinutes; nMinutes += interval) {
        }
        next.set(12, nMinutes);
        next.set(13, 0);
        next.set(14, 0);
        return next.getTime().getTime();
    }

    public void setNextInterval(AuditInterval interval) {
        this.nextInterval = interval;
    }

    public boolean isSink() {
        return this.nextInterval == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDump() {
        if (this.isSink()) {
            return;
        }
        if (System.currentTimeMillis() >= this.nextDumpTime) {
            AuditInterval auditInterval = this;
            synchronized (auditInterval) {
                if (System.currentTimeMillis() >= this.nextDumpTime) {
                    this.open = false;
                    long now = System.currentTimeMillis();
                    while (now - this.nextDumpTime > this.minutes * 60L * 1000L) {
                        this.nextDumpTime += this.minutes * 60L * 1000L;
                    }
                    this.printInterval();
                    this.dumpToNextInterval();
                    this.lastDumpTime = this.nextDumpTime;
                    this.nextDumpTime += this.minutes * 60L * 1000L;
                    this.open = true;
                }
            }
        }
    }

    private void printInterval() {
        Perflog.Instance().writeEntry(this.printPerf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToNextInterval() {
        if (this.isSink()) {
            return;
        }
        for (PerfIntervalData data : this.theTable.values()) {
            if (data.hasEntries() && data.execTime > 25L) {
                this.nextInterval.takeDump(data);
                continue;
            }
            data.clear();
        }
        if (this.theTable.size() > 256) {
            HashMap hashMap = this.theTable;
            synchronized (hashMap) {
                this.theTable.clear();
            }
        }
        this.nextInterval.checkDump();
    }

    private void takeDump(PerfIntervalData inData) {
        if (this.isSink()) {
            inData.clear();
            return;
        }
        String type = inData.getType();
        PerfIntervalData ownData = null;
        if (this.theTable.containsKey(type)) {
            ownData = (PerfIntervalData)this.theTable.get(type);
            ownData.addAndClear(inData);
        } else {
            this.populateEntry(type, inData.unit);
            this.takeDump(inData);
        }
    }

    private void getGcInfo() {
        List<GarbageCollectorMXBean> ms = ManagementFactory.getGarbageCollectorMXBeans();
        long count = 0L;
        long duration = 0L;
        for (GarbageCollectorMXBean m : ms) {
            count += m.getCollectionCount();
            duration += m.getCollectionTime();
        }
        this.gcCountInt = count - this.gcCount;
        this.gcDurationInt = duration - this.gcDuration;
        this.gcCount = count;
        this.gcDuration = duration;
    }
}

