/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.perflog;

import com.filenet.apiimpl.perflog.AuditEntry;
import com.filenet.apiimpl.perflog.Perflog;
import java.util.Date;

public class PerfAuditEntry
extends AuditEntry {
    protected String type = null;
    protected long startTime = 0L;
    protected long stopTime = 0L;
    protected boolean successful = true;
    protected long unit = 1L;

    public PerfAuditEntry() {
    }

    public PerfAuditEntry(String type) {
        this.type = type;
    }

    public PerfAuditEntry(String type, long sTime, long unit) {
        this.type = type;
        this.startTime = sTime;
        this.unit = unit;
    }

    public PerfAuditEntry(String type, long sTime, long pTime, boolean success, long unit) {
        this.type = type;
        this.startTime = sTime;
        this.stopTime = pTime;
        this.successful = success;
        this.unit = unit;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void endWithStatus(boolean successful) {
        this.successful = successful;
        this.stopTime = System.currentTimeMillis();
        Perflog.Instance().countIn(this);
    }

    public long getTime() {
        return this.stopTime - this.startTime;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setStartTime(long t) {
        this.startTime = t;
    }

    public void setStartTime(Date d) {
        this.startTime = d.getTime();
    }

    public void setStopTime(long t) {
        this.stopTime = t;
    }

    public void setStopTime(Date d) {
        this.stopTime = d.getTime();
    }

    public void setSuccessful(boolean suc) {
        this.successful = suc;
    }

    public void setType(String type) {
        this.type = type;
    }
}

