/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.perflog;

import com.filenet.apiimpl.perflog.AuditEntry;
import com.filenet.apiimpl.perflog.IntervalData;
import com.filenet.apiimpl.perflog.PerfAuditEntry;
import com.filenet.apiimpl.perflog.Perflog;

public class PerfIntervalData
extends IntervalData {
    protected volatile String type = null;
    protected volatile int successes = 0;
    protected volatile long execTime = 0L;
    protected volatile int failures = 0;
    protected volatile long failureTime = 0L;
    protected long unit = 1L;

    public PerfIntervalData(String type) {
        this.type = type;
    }

    public PerfIntervalData(String type, long unit) {
        this.type = type;
        this.unit = unit;
    }

    @Override
    public void countIn(AuditEntry entry1) {
        PerfAuditEntry entry = (PerfAuditEntry)entry1;
        if (entry.isCounted()) {
            return;
        }
        this.countIn(entry.getTime(), entry.isSuccessful());
        entry.setCounted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAndClear(PerfIntervalData data) {
        PerfIntervalData perfIntervalData = data;
        synchronized (perfIntervalData) {
            this.execTime += data.execTime;
            data.execTime = 0L;
            this.successes += data.successes;
            data.successes = 0;
            this.failureTime += data.failureTime;
            data.failureTime = 0L;
            this.failures += data.failures;
            data.failures = 0;
        }
    }

    public synchronized void clear() {
        this.execTime = 0L;
        this.successes = 0;
        this.failureTime = 0L;
        this.failures = 0;
    }

    public synchronized void countIn(long time, boolean successful) {
        if (successful) {
            ++this.successes;
            if (time >= 0L) {
                this.execTime += time;
            }
        } else {
            ++this.failures;
            if (time >= 0L) {
                this.failureTime += time;
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setUnit(long unit) {
        this.unit = unit;
    }

    public boolean aboveThreshhold() {
        return (long)this.successes > Perflog.timesThreshHold || this.execTime / this.unit > Perflog.durationThreshHold;
    }

    @Override
    public void printMyInfo(StringBuffer buf) {
        if (!this.hasEntries()) {
            return;
        }
        if (!this.aboveThreshhold()) {
            return;
        }
        buf.append(this.successes);
        buf.append("  ");
        buf.append(this.successes == 0 ? 0L : this.execTime / (long)this.successes / this.unit);
        buf.append("     \t");
        buf.append(this.execTime / this.unit);
        buf.append("     \t");
        buf.append(this.failures);
        buf.append("  ");
        buf.append(this.failures == 0 ? 0L : this.failureTime / (long)this.failures / this.unit);
        buf.append("     \t");
        buf.append(this.type);
    }

    public boolean hasEntries() {
        return this.successes > 0 || this.failures > 0;
    }
}

