/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.property;

import com.filenet.api.collection.DependentObjectList;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyDependentObjectList;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.constants.ListMode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.SubListImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.PropertyUpdateList;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Iterator;

public class PropertyEngineObjectListImpl
extends PropertyImpl
implements PropertyDependentObjectList {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(PropertyEngineObjectListImpl.class, SubSystem.API);
    private static final long serialVersionUID = -3592494494688626283L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public PropertyEngineObjectListImpl(String name, DependentObjectList val, byte accessMask) {
        super(name, null, accessMask);
        this.setValueInternal(val, null);
    }

    public PropertyEngineObjectListImpl(UnevaluatedPropertyValue obj, Connection conn, byte accessMask) {
        super(obj.getPropertyName(), obj, accessMask);
        this.connection = conn;
    }

    public PropertyEngineObjectListImpl(PropertyEngineObjectListImpl source) {
        super(source);
    }

    @Override
    public DependentObjectList fetchDependentObjectListValue(PropertyFilter pf) {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof ListImpl && ((ListImpl)this.value).isEmpty()) {
            return (DependentObjectList)this.value;
        }
        if (!(this.value instanceof UnevaluatedPropertyValue)) {
            throw new EngineRuntimeException(ExceptionCode.API_EXPECTED_UNEVALUATED_STATE, this.getPropertyName());
        }
        PropertyImpl tProp = this.getSession().getProperty((ConnectionImpl)this.connection, (UnevaluatedPropertyValue)this.value, null, pf, null);
        this.value = tProp != null ? tProp.value : null;
        return (DependentObjectList)this.value;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    @Override
    PropertyImpl getModifiedData(EngineObject parent) {
        if (!this.isDirty()) {
            return null;
        }
        if (this.value instanceof ListImpl) {
            EngineObjectImpl eoi = (EngineObjectImpl)parent;
            ListImpl li = (ListImpl)this.value;
            PropertyUpdateList ret = new PropertyUpdateList(this.getPropertyName(), li.getModifiedData(eoi));
            ret.isDirty = true;
            return ret;
        }
        return null;
    }

    @Override
    public void propagatePropertyAccess() {
        ListImpl v;
        if (this.value instanceof ListImpl && !(v = (ListImpl)this.value).isEmpty()) {
            this.propagatePropertyAccess(this.access, v);
        }
    }

    private void propagatePropertyAccess(byte newAccess, ListImpl li) {
        for (Object v : li) {
            if (!(v instanceof EngineObjectImpl)) continue;
            Iterator propIter = ((EngineObjectImpl)v).getProperties().iterator();
            while (propIter.hasNext()) {
                PropertyImpl pi = (PropertyImpl)propIter.next();
                pi.setPropertyAccess(newAccess);
                if (!(pi instanceof PropertyEngineObjectListImpl) || !(pi.getInstanceValue() instanceof ListImpl)) continue;
                this.propagatePropertyAccess(newAccess, (ListImpl)pi.getInstanceValue());
            }
        }
    }

    @Override
    public void setValue(DependentObjectList val) {
        this.checkSettable();
        this.setValueInternal(val, ListMode.REPLACE);
    }

    public void setValueInternal(DependentObjectList val, ListMode lm) {
        if (val instanceof ListImpl) {
            ListImpl nv = (ListImpl)((Object)val);
            if (nv.hasBeenAttached()) {
                if (logger.isWarnEnabled() && !SessionLocator.isExecutingInServer()) {
                    logger.warn("Dependent object reuse is detected. Reuse of dependent objects is not recommended");
                }
                if (!SessionLocator.isExecutingInServer()) {
                    nv = (ListImpl)nv.clone();
                }
                nv.setDirty(true);
                this.value = nv;
            } else {
                this.value = nv;
                nv.setHasBeenAttached(true);
            }
            if (lm != null && lm != nv.getListMode()) {
                nv.setListMode(lm);
            }
        } else if (val == null) {
            this.value = new SubListImpl(EngineObjectImpl.class);
            if (lm != null) {
                ((SubListImpl)this.value).setListMode(lm);
            }
        } else {
            this.value = val;
        }
        this.isDirty = true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    }

    @Override
    public int getSerializeMask() {
        return super.getSerializeMask() | 0xC00000 | 7;
    }

    @Override
    public void serializeValue(DelegateOutputStream s) throws IOException {
        s.putObject(this.value);
    }

    @Override
    public void deserializeValue(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        this.value = s.getObject();
        this.connection = conn;
    }
}

