/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.query.parser;

import com.filenet.apiimpl.query.parser.QueryParser;
import com.filenet.apiimpl.query.parser.QueryParserHelper;
import com.filenet.apiimpl.query.parser.SimpleNode;
import java.util.Date;

public class Literal
extends SimpleNode {
    private int literalType;
    public static final int UNDEFINED_TYPE = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_ISO_DATE = 4;
    public static final int TYPE_W3C_DATE = 5;
    public static final int TYPE_BOOLEAN = 6;
    public static final int TYPE_GUID = 7;

    public Literal(int id) {
        super(id);
    }

    public Literal(QueryParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return this.literalType;
    }

    public void setType(int i) {
        this.literalType = i;
    }

    @Override
    public String toString() {
        if (this.m_text != null) {
            String showText = this.m_text;
            if (this.literalType == 4) {
                Date isoParse = QueryParserHelper.parseIsoDate(this.m_text);
                String isoFormat = QueryParserHelper.toISOformat(isoParse);
                showText = this.m_text + " >ISO> " + isoFormat;
            } else if (this.literalType == 5) {
                Date w3cParse = QueryParserHelper.parseW3cDate(this.m_text);
                String w3cFormat = QueryParserHelper.toW3Cformat(w3cParse);
                showText = this.m_text + " >W3C> " + w3cFormat;
            }
            return this.getNodeName() + "[" + showText + "]";
        }
        return this.getNodeName();
    }
}

