/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.smm;

import com.filenet.apiimpl.smm.PCH;
import com.filenet.pch.Event;
import com.filenet.pch.Meter;

public class PCHContext {
    private final String rpc_cpu_time = "RPC CPU time(ms)";
    private final String background_cpu_time = "Background task CPU time(ms)";
    private final String rpc_elapse_time = "RPC elapsed time(ms)";
    private final String background_elapse_time = "Background task elapsed time(ms)";
    private final String execute_changes_event = "ExecuteChanges";
    private final String execute_search_event = "ExecuteSearch";
    private final String get_objects_event = "GetObjects";
    private final String get_search_metadata_event = "GetSearchMetaData";
    private final String download_content_size = "DownloadContentSize(KB)";
    private final String upload_content_size = "UploadContentSize(KB)";
    private final String database_meter = "Database Time(ms)";
    private final String emails_sent_event = "Emails Sent";
    protected String tenantName;
    Meter RPCDuration;
    Meter backgroundDuration;
    Meter serverRPCCPU;
    Meter backgroundCPU;
    Event executeChangesEvent;
    Event executeSearchEvent;
    Event getObjectsEvent;
    Event getSearchMetaDataEvent;
    Meter downloadContentSizeMeter;
    Meter uploadContentSizeMeter;
    Meter databaseMeter;
    Event emailsSentEvent;

    public PCHContext(String tenantName) {
        this.tenantName = tenantName;
    }

    public Meter getRPCDurationMeter() {
        if (this.RPCDuration != null) {
            return this.RPCDuration;
        }
        this.RPCDuration = PCH.lookupMeterByTenant(this.tenantName, "RPC elapsed time(ms)");
        return this.RPCDuration;
    }

    public Meter getBackgroundTaskDurationDuration() {
        if (this.backgroundDuration != null) {
            return this.backgroundDuration;
        }
        this.backgroundDuration = PCH.lookupMeterByTenant(this.tenantName, "Background task elapsed time(ms)");
        return this.backgroundDuration;
    }

    public Meter getRPCCPUMeter() {
        if (this.serverRPCCPU != null) {
            return this.serverRPCCPU;
        }
        this.serverRPCCPU = PCH.lookupMeterByTenant(this.tenantName, "RPC CPU time(ms)");
        return this.serverRPCCPU;
    }

    public Meter getBackgroudCPUMeter() {
        if (this.backgroundCPU != null) {
            return this.backgroundCPU;
        }
        this.backgroundCPU = PCH.lookupMeterByTenant(this.tenantName, "Background task CPU time(ms)");
        return this.backgroundCPU;
    }

    public Event getExecuteChangesEvent() {
        if (this.executeChangesEvent != null) {
            return this.executeChangesEvent;
        }
        this.executeChangesEvent = PCH.lookupEventByTenant(this.tenantName, "ExecuteChanges");
        return this.executeChangesEvent;
    }

    public Event getExecuteSearchEvent() {
        if (this.executeSearchEvent != null) {
            return this.executeSearchEvent;
        }
        this.executeSearchEvent = PCH.lookupEventByTenant(this.tenantName, "ExecuteSearch");
        return this.executeSearchEvent;
    }

    public Event getObjectsEvent() {
        if (this.getObjectsEvent != null) {
            return this.getObjectsEvent;
        }
        this.getObjectsEvent = PCH.lookupEventByTenant(this.tenantName, "GetObjects");
        return this.getObjectsEvent;
    }

    public Event getSearchMetaDataEvent() {
        if (this.getSearchMetaDataEvent != null) {
            return this.getSearchMetaDataEvent;
        }
        this.getSearchMetaDataEvent = PCH.lookupEventByTenant(this.tenantName, "GetSearchMetaData");
        return this.getSearchMetaDataEvent;
    }

    public Meter getDownloadContentSizeMeter() {
        if (this.downloadContentSizeMeter != null) {
            return this.downloadContentSizeMeter;
        }
        this.downloadContentSizeMeter = PCH.lookupMeterByTenant(this.tenantName, "DownloadContentSize(KB)");
        return this.downloadContentSizeMeter;
    }

    public Meter getUploadContentSizeMeter() {
        if (this.uploadContentSizeMeter != null) {
            return this.uploadContentSizeMeter;
        }
        this.uploadContentSizeMeter = PCH.lookupMeterByTenant(this.tenantName, "UploadContentSize(KB)");
        return this.uploadContentSizeMeter;
    }

    public Meter getDatabaseMeter() {
        if (this.databaseMeter != null) {
            return this.databaseMeter;
        }
        this.databaseMeter = PCH.lookupMeterByTenant(this.tenantName, "Database Time(ms)");
        return this.databaseMeter;
    }

    public Event getEmailsSentEvent() {
        if (this.emailsSentEvent != null) {
            return this.emailsSentEvent;
        }
        this.emailsSentEvent = PCH.lookupEventByTenant(this.tenantName, "Emails Sent");
        return this.emailsSentEvent;
    }
}

