/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.constants.PropertyState;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Property;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.transport.PutContentRequest;
import java.io.InputStream;

public class ContentHandle {
    ObjectReferenceBase objRef;
    PropertiesImpl objProps;
    PropertiesImpl contentProps;
    Id actualStorageAreaId = null;
    boolean isNew = false;

    public ContentHandle(ObjectReferenceBase or, PropertiesImpl objPropsVal, PropertiesImpl contentPropsVal, boolean isNew) {
        if (objPropsVal.isPropertyPresent("Id")) {
            Id overrideId = objPropsVal.getIdValue("Id");
            if (or instanceof RepositoryIdentity) {
                ((RepositoryIdentity)or).setObjectId(overrideId);
            }
        }
        this.objRef = or;
        this.objProps = objPropsVal;
        this.contentProps = contentPropsVal;
        this.isNew = isNew;
    }

    public ObjectReferenceBase getObjectReference() {
        return this.objRef;
    }

    public PropertiesImpl getObjectProperties() {
        return this.objProps;
    }

    public PropertiesImpl getContentProperties() {
        return this.contentProps;
    }

    public PutContentRequest getPutContentRequest() {
        String retrievalName = null;
        if (this.getContentProperties().isPropertyPresent("RetrievalName")) {
            retrievalName = this.getContentProperties().getStringValue("RetrievalName");
        }
        String contentType = null;
        if (this.getContentProperties().isPropertyPresent("ContentType")) {
            contentType = this.getContentProperties().getStringValue("ContentType");
        }
        Id storageAreaId = null;
        if (this.getObjectProperties().isPropertyPresent("StorageArea")) {
            Property prop = this.getObjectProperties().get("StorageArea");
            if (prop.getState() == PropertyState.NO_VALUE) {
                storageAreaId = Id.ZERO_ID;
            } else {
                PropertyImpl propImpl = (PropertyImpl)this.getObjectProperties().get("StorageArea");
                if (propImpl != null) {
                    ObjectReference or = propImpl.getObjectReference();
                    storageAreaId = ((RepositoryIdentity)or).getObjectId();
                }
            }
        }
        Id storagePolicyId = null;
        if (this.getObjectProperties().isPropertyPresent("StoragePolicy")) {
            Property prop = this.getObjectProperties().get("StoragePolicy");
            if (prop.getState() == PropertyState.NO_VALUE) {
                storagePolicyId = Id.ZERO_ID;
            } else {
                PropertyImpl propImpl = (PropertyImpl)this.getObjectProperties().get("StoragePolicy");
                if (propImpl != null) {
                    ObjectReference or = propImpl.getObjectReference();
                    storagePolicyId = ((RepositoryIdentity)or).getObjectId();
                }
            }
        }
        InputStream input = null;
        Object content = this.getContentProperties().getObjectValue("Content");
        if (!(content instanceof InputStream)) {
            if (content instanceof String) {
                return null;
            }
            String classname = null;
            if (content != null) {
                classname = content.getClass().getName();
            }
            throw new EngineRuntimeException(ExceptionCode.CONTENT_PC_UNEXPECTED_CONTENT_TYPE, new Object[]{classname, content});
        }
        input = (InputStream)content;
        PutContentRequest request = new PutContentRequest(this.getObjectReference(), "1", storageAreaId, storagePolicyId, retrievalName, contentType, input, true, this.isNew, null);
        return request;
    }

    public void setActualStorageAreaId(Id saId) {
        this.actualStorageAreaId = saId;
    }

    public Id getActualStorageAreaId() {
        return this.actualStorageAreaId;
    }

    public boolean isNew() {
        return this.isNew;
    }
}

