/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.transport;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.transport.ChangeResponse;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.io.IOException;
import java.io.ObjectStreamField;

public class ExecuteChangesResponse
extends Message
implements Response,
XMLTraceable {
    transient ChangeResponse[] batch;
    private static final long serialVersionUID = -2081521552163169039L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ExecuteChangesResponse(ChangeResponse[] batchVal) {
        this.batch = batchVal;
    }

    public ChangeResponse[] getBatch() {
        return this.batch;
    }

    @Override
    public int getBatchSize() {
        return this.batch == null ? 0 : this.batch.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBatch(DelegateOutputStream s) throws IOException {
        int size = this.batch != null ? this.batch.length : 0;
        s.writeInt(size);
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ChangeResponse cr = this.batch[lp];
                s.putObject(cr.getValue());
                s.writeObject(cr.getCorrelationId());
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBatch(DelegateInputStream s, Connection conn) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        this.batch = new ChangeResponse[size];
        DuplicateObjectCache objCache = s.getObjectCache();
        try {
            for (int lp = 0; lp < size; ++lp) {
                s.setObjectCache(new DuplicateObjectCache());
                ChangeResponse cr = new ChangeResponse();
                cr.putValue(s.getObject());
                cr.setCorrelationId((String)s.readObject());
                this.batch[lp] = cr;
            }
        }
        finally {
            s.setObjectCache(objCache);
        }
    }

    @Override
    public void trace(XMLTraceReader reader, String element) throws Exception {
        this.trace(reader, element, this.batch);
    }
}

