/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.DomainType;
import com.filenet.api.security.Realm;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.smm.PCHContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.UniBinary;
import com.filenet.apiimpl.util.UniBinaryKeyGen;
import com.filenet.apiimpl.util.UniToken;
import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;

public class ApiToEngineBridge {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ApiToEngineBridge.class, SubSystem.API);
    private static EngineRunnable engineRunnable = null;

    private ApiToEngineBridge() {
    }

    public static void setEngineRunnable(EngineRunnable engineRunnable) {
        logger.info("EngineRunnable injection received: " + engineRunnable);
        ApiToEngineBridge.engineRunnable = engineRunnable;
    }

    public static boolean setSecurityCheckingDisabled(boolean setting) {
        if (engineRunnable != null) {
            return engineRunnable.setSecurityCheckingDisabled(setting);
        }
        return false;
    }

    public static boolean isDomainAvailable(Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.isDomainAvailable(tenantId);
        }
        return false;
    }

    public static boolean isGCDDatabaseAvailable(Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.isGCDDatabaseAvailable(tenantId);
        }
        return false;
    }

    public static byte[] mDec(byte[] data, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.mDec(data, tenantId);
        }
        return null;
    }

    public static byte[] mEnc(byte[] data, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.mEnc(data, tenantId);
        }
        return null;
    }

    public static ClassLoader getEngineClassLoader() {
        if (engineRunnable != null) {
            return engineRunnable.getClass().getClassLoader();
        }
        return null;
    }

    public static boolean isInCEServer() {
        return engineRunnable != null;
    }

    public static int getGCDValue(String gcdClass, String name, int defaultValue, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getGCDValue(gcdClass, name, defaultValue, tenantId);
        }
        return defaultValue;
    }

    public static String getGCDValue(String gcdClass, String name, String defaultValue, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getGCDValue(gcdClass, name, defaultValue, tenantId);
        }
        return defaultValue;
    }

    public static byte[] getGCDValue(String gcdClass, String name, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getGCDValue(gcdClass, name, tenantId);
        }
        return null;
    }

    public static HashSet<String> getSecurityTokenShortNames(String userName, Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getSecurityTokenShortNames(userName, tenantId);
        }
        return null;
    }

    public static boolean pushAppContext() {
        if (engineRunnable != null) {
            return engineRunnable.pushAppContext();
        }
        return false;
    }

    public static void popAppContext() {
        if (engineRunnable != null) {
            engineRunnable.popAppContext();
        }
    }

    public static void beginImp(String username) {
        if (engineRunnable != null) {
            engineRunnable.beginImp(username);
        }
    }

    public static void endImp() {
        if (engineRunnable != null) {
            engineRunnable.endImp();
        }
    }

    public static String getPeServerUsername() {
        if (engineRunnable != null) {
            return engineRunnable.getPeServerUsername();
        }
        return null;
    }

    public static UniToken renewImp(UniToken oldToken) {
        if (engineRunnable != null) {
            return engineRunnable.renewImp(oldToken);
        }
        return null;
    }

    public static Subject getPeServiceSubject() {
        if (engineRunnable != null) {
            return engineRunnable.getPeServiceSubject();
        }
        return null;
    }

    public static String getPEOperationsUserName() {
        if (engineRunnable != null) {
            return engineRunnable.getPEOperationsUsername();
        }
        return null;
    }

    public static Subject getKrb5Subject(String principalName, String ccacheFile) {
        if (engineRunnable != null) {
            return engineRunnable.getKrb5Subject(principalName, ccacheFile);
        }
        return null;
    }

    public static String getCeConnectionUrl(Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getCeConnectionUrl(tenantId);
        }
        return null;
    }

    public static byte[] getBits() {
        if (engineRunnable != null) {
            return engineRunnable.getBits();
        }
        return null;
    }

    public static boolean isUnifUsername(String username) {
        if (engineRunnable != null) {
            return engineRunnable.isUnifUsername(username);
        }
        return false;
    }

    public static UniToken newUniToken(String username) {
        if (engineRunnable != null) {
            return engineRunnable.newUniToken(username);
        }
        return null;
    }

    public static UniToken newUniToken(char[] rawToken) {
        if (engineRunnable != null) {
            return engineRunnable.newUniToken(rawToken);
        }
        return null;
    }

    public static UniBinary newUniBinary(String username) {
        if (engineRunnable != null) {
            return engineRunnable.newUniBinary(username);
        }
        return null;
    }

    public static UniBinary newUniBinary(char[] b64Token, byte[] key) {
        if (engineRunnable != null) {
            return engineRunnable.newUniBinary(b64Token, key);
        }
        return null;
    }

    public static UniBinary newUniBinary(char[] b64Token, UniBinaryKeyGen keygen, long clockSkew) {
        if (engineRunnable != null) {
            return engineRunnable.newUniBinary(b64Token, keygen, clockSkew);
        }
        return null;
    }

    public static List<Id> getTenantIds() {
        if (engineRunnable != null) {
            return engineRunnable.getTenantIds();
        }
        return null;
    }

    public static Id getTenantId(URI connectionUri) {
        if (engineRunnable != null) {
            return engineRunnable.getTenantId(connectionUri);
        }
        return null;
    }

    public static String getCurrentTenantName() {
        if (engineRunnable != null) {
            return engineRunnable.getCurrentTenantName();
        }
        return null;
    }

    public static DomainType getDomainType() {
        if (engineRunnable != null) {
            return engineRunnable.getDomainType();
        }
        return null;
    }

    public static boolean isTenant() {
        return ApiToEngineBridge.getDomainType() == DomainType.TENANT;
    }

    public static PCHContext getPCHContext(String tenantName) {
        if (engineRunnable != null) {
            return engineRunnable.getPCHContext(tenantName);
        }
        return null;
    }

    public static Id getTenantId(String tenantName) {
        if (engineRunnable != null) {
            return engineRunnable.getTenantId(tenantName);
        }
        return null;
    }

    public static String getMasterAdminGroupName(Id tenantId) {
        if (engineRunnable != null) {
            return engineRunnable.getMasterAdminGroupName(tenantId);
        }
        return null;
    }

    public static Subject getCurrentSubject() {
        if (engineRunnable != null) {
            return engineRunnable.getCurrentSubject();
        }
        return null;
    }

    public static Principal getCurrentPrincipal() {
        if (engineRunnable != null) {
            return engineRunnable.getCurrentPrincipal();
        }
        return null;
    }

    public static Object doAsServer(Id tenantId, PrivilegedExceptionAction pea) {
        return engineRunnable.doAsServer(tenantId, pea);
    }

    public static void engineStart(HashMap startupContext) {
        if (engineRunnable != null) {
            engineRunnable.engineStart(startupContext);
        }
    }

    public static void engineDestroy() {
        if (engineRunnable != null) {
            engineRunnable.engineDestroy();
        }
    }

    public static Realm getRegistrationRealm(Id tenantId, String email) {
        if (engineRunnable != null) {
            return engineRunnable.getRegistrationRealm(tenantId, email);
        }
        return null;
    }

    public static Realm getSelfRegistrationRealm(Id tenantId, String email) {
        if (engineRunnable != null) {
            return engineRunnable.getSelfRegistrationRealm(tenantId, email);
        }
        return null;
    }

    public static void registerShutdownHook(ShutdownHook hook) {
        if (engineRunnable != null) {
            engineRunnable.registerShutdownHook(hook);
        }
    }

    public static void orderlyShutdown(int timeLimitSeconds) {
        if (engineRunnable != null) {
            engineRunnable.orderlyShutdown(timeLimitSeconds);
        }
    }

    public static interface ShutdownHook {
        public void beginOrderlyShutdown(long var1);

        public boolean isShutdownComplete();
    }

    public static interface EngineRunnable {
        public boolean setSecurityCheckingDisabled(boolean var1);

        public boolean isDomainAvailable(Id var1);

        public boolean isGCDDatabaseAvailable(Id var1);

        public byte[] mDec(byte[] var1, Id var2);

        public byte[] mEnc(byte[] var1, Id var2);

        public int getGCDValue(String var1, String var2, int var3, Id var4);

        public String getGCDValue(String var1, String var2, String var3, Id var4);

        public byte[] getGCDValue(String var1, String var2, Id var3);

        public HashSet<String> getSecurityTokenShortNames(String var1, Id var2);

        public boolean pushAppContext();

        public void popAppContext();

        public void beginImp(String var1);

        public void endImp();

        public String getPeServerUsername();

        public UniToken renewImp(UniToken var1);

        public Subject getPeServiceSubject();

        public String getPEOperationsUsername();

        public Subject getKrb5Subject(String var1, String var2);

        public String getCeConnectionUrl(Id var1);

        public byte[] getBits();

        public boolean isUnifUsername(String var1);

        public UniToken newUniToken(String var1);

        public UniToken newUniToken(char[] var1);

        public UniBinary newUniBinary(String var1);

        public UniBinary newUniBinary(char[] var1, byte[] var2);

        public UniBinary newUniBinary(char[] var1, UniBinaryKeyGen var2, long var3);

        public List<Id> getTenantIds();

        public Id getTenantId(URI var1);

        public Id getTenantId(String var1);

        public String getCurrentTenantName();

        public DomainType getDomainType();

        public PCHContext getPCHContext(String var1);

        public String getMasterAdminGroupName(Id var1);

        public Subject getCurrentSubject();

        public Principal getCurrentPrincipal();

        public Object doAsServer(Id var1, PrivilegedExceptionAction var2);

        public void engineStart(HashMap var1);

        public void engineDestroy();

        public Realm getRegistrationRealm(Id var1, String var2);

        public Realm getSelfRegistrationRealm(Id var1, String var2);

        public void registerShutdownHook(ShutdownHook var1);

        public void orderlyShutdown(int var1);
    }
}

