/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BlockBasedInputStream;
import com.filenet.apiimpl.util.BufferedBlock;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingPipe
extends BlockBasedInputStream {
    private int capacity;
    private long readTimeoutMs;
    private long writeTimeoutMs;
    private volatile ArrayBlockingQueue<BufferedBlock> buffers;
    private volatile boolean isClosed = false;
    private volatile long bytesWritten = 0L;
    private volatile long bytesRead = 0L;
    private static BufferedBlock CLOSED_INDICATOR = new BufferedBlock(null, 42, true);

    public BlockingPipe(int capacity, long readTimeoutMs, long writeTimeoutMs) {
        this.capacity = capacity;
        this.readTimeoutMs = readTimeoutMs;
        this.writeTimeoutMs = writeTimeoutMs;
        this.buffers = new ArrayBlockingQueue(capacity);
    }

    public void send(byte[] data, int size, boolean last) {
        if (size == 0 && !last) {
            return;
        }
        this.send(new BufferedBlock(data, size, last));
    }

    public void send(BufferedBlock bb) {
        if (this.isClosed) {
            throw new EngineRuntimeException(ExceptionCode.CONTENT_PIPE_CLOSED);
        }
        try {
            if (!this.buffers.offer(bb, this.writeTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new EngineRuntimeException(ExceptionCode.CONTENT_PIPE_TIMEOUT, this.writeTimeoutMs);
            }
            this.bytesWritten += (long)bb.getSize();
            if (this.isClosed) {
                while (this.buffers.poll() != null) {
                }
            }
        }
        catch (InterruptedException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public void write(byte[] data, int offset, int size, boolean last) {
        if (size == 0) {
            this.send(null, 0, last);
            return;
        }
        byte[] copy = new byte[size];
        System.arraycopy(data, offset, copy, 0, size);
        this.send(copy, size, last);
    }

    public BufferedBlock receive() {
        if (this.isClosed) {
            throw new EngineRuntimeException(ExceptionCode.CONTENT_PIPE_CLOSED);
        }
        try {
            BufferedBlock be = this.buffers.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
            if (be != null) {
                this.bytesRead += (long)be.getSize();
                if (this.isClosed || be == CLOSED_INDICATOR) {
                    throw new EngineRuntimeException(ExceptionCode.CONTENT_PIPE_CLOSED);
                }
                return be;
            }
            throw new EngineRuntimeException(ExceptionCode.CONTENT_PIPE_TIMEOUT, this.readTimeoutMs);
        }
        catch (InterruptedException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        while (this.buffers.poll() != null) {
        }
    }

    public void abort() {
        if (!this.isClosed) {
            this.isClosed = true;
            while (this.buffers.poll() != null) {
            }
            this.buffers.offer(CLOSED_INDICATOR);
        }
    }

    public long getReadTimeout() {
        return this.readTimeoutMs;
    }

    public long getWriteTimeout() {
        return this.writeTimeoutMs;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getRemainingCacpacity() {
        return this.buffers.remainingCapacity();
    }

    @Override
    protected BufferedBlock fetchNextBlock() throws IOException {
        return this.receive();
    }

    public int size() {
        return this.buffers.size();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

