/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

public abstract class CacheEntry {
    private long ttAdded = 0L;
    long timeLastUsed;
    long lruScore;

    public abstract Object getId();

    public abstract Object getValue();

    public long getAge() {
        return System.currentTimeMillis() - this.ttAdded;
    }

    protected void added() {
        this.ttAdded = System.currentTimeMillis();
    }

    public void forceExpiry() {
        this.ttAdded = 0L;
    }

    protected final boolean hasExpired(int ttlSeconds) {
        if (ttlSeconds == 0) {
            return false;
        }
        long ttExpiry = this.ttAdded + (long)(ttlSeconds * 1000);
        return ttExpiry < System.currentTimeMillis();
    }

    protected void removed() {
    }
}

