/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class ClassKey
implements Serializable {
    private Object context;
    private Class target;
    private transient int hash;
    private static final long serialVersionUID = 355853603020216966L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    public ClassKey(Object context, Class target) {
        if (target == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.target = target;
        this.hash = context.hashCode();
    }

    public ClassKey(Class target) {
        this.context = target;
        this.target = target;
        this.hash = this.context.hashCode();
    }

    public Object getContext() {
        return this.context;
    }

    public Class getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassKey)) {
            return false;
        }
        ClassKey other = (ClassKey)o;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.context != other.context && !this.context.equals(other.context)) {
            return false;
        }
        return this.target == other.target || this.target.isAssignableFrom(other.target) || other.target.isAssignableFrom(this.target);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "{" + this.context + ", " + this.target.getName() + "}";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.context);
        s.writeObject(this.target);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.context = s.readObject();
        this.target = (Class)s.readObject();
        this.hash = this.context.hashCode();
    }
}

