/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.smm.PCH;
import com.filenet.apiimpl.util.Cache;
import com.filenet.apiimpl.util.CacheEntry;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.pch.Container;
import com.filenet.pch.Event;
import com.filenet.pch.Meter;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConcurrentCache
extends Cache {
    private Map<Object, CacheEntry> idMap = new ConcurrentHashMap<Object, CacheEntry>();
    private Map<Object, CacheEntry> valueMap = null;
    private Container pchBaseContainer;
    private Event pchCacheAttempts;
    private Event pchCacheHits;
    private Event pchCacheExpiries;
    private Event pchCacheEvictions;
    private Meter pchCacheEntries;
    private boolean pchMonitoring;
    private static List<WeakReference<ConcurrentCache>> scavengeList = Collections.synchronizedList(new LinkedList());
    private static int scavengeDelay = ConfigValueLookup.getValueAsInt("com.filenet.cache.ScavengeInterval", 30);
    private static Thread scavengeThread = new Thread(){

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(scavengeDelay * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int iS = 0;
                while (true) {
                    if (iS >= scavengeList.size()) continue block2;
                    WeakReference ref = (WeakReference)scavengeList.get(iS);
                    ConcurrentCache scavenge = (ConcurrentCache)ref.get();
                    if (scavenge == null) {
                        scavengeList.remove(iS);
                        continue;
                    }
                    scavenge.scavenge();
                    ++iS;
                }
                break;
            }
        }
    };
    private static int scavengeThreshold;
    private volatile long usageTime = 0L;
    private AtomicBoolean scavengeInProgress = new AtomicBoolean(false);
    private long lastExpiryCheckTime = 0L;
    private int scavengeCount = 0;
    private static boolean SORT_WITH_TREESET;
    private static CacheEntryLRUComparator comparator;

    private ConcurrentCache() {
    }

    private boolean isPCHRunning() {
        if (!this.pchMonitoring) {
            return false;
        }
        return PCH.isRunning;
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal, Container pchContainer) {
        this.init(needsByValue, ttlVal, maxEntriesVal, pchContainer);
    }

    private void init(boolean needsByValue, int ttlVal, int maxEntriesVal, Container pchContainer) {
        this.pchBaseContainer = pchContainer;
        if (needsByValue) {
            this.valueMap = new ConcurrentHashMap<Object, CacheEntry>();
        }
        this.ttl = ttlVal;
        this.maxEntries = maxEntriesVal;
        boolean bl = this.pchMonitoring = pchContainer != null;
        if (this.isPCHRunning()) {
            this.pchCacheAttempts = PCH.lookupUserEventByContainer(pchContainer, "Cache Attempt Count");
            this.pchCacheHits = PCH.lookupUserEventByContainer(pchContainer, "Cache Hit Count");
            this.pchCacheExpiries = PCH.lookupUserEventByContainer(pchContainer, "Cache Expiry Count");
            this.pchCacheEvictions = PCH.lookupUserEventByContainer(pchContainer, "Cache Eviction Count");
            this.pchCacheEntries = pchContainer.lookupMeter("Cache Entries");
        }
        if (this.ttl != 0 || this.maxEntries != 0) {
            scavengeList.add(new WeakReference<ConcurrentCache>(this));
        }
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal, String objectStoreName, String cacheName, String category, boolean pchMonitoringVal) {
        this.pchMonitoring = pchMonitoringVal;
        Container pchContainer = null;
        if (this.isPCHRunning()) {
            pchContainer = objectStoreName == null && category == null ? PCH.lookupContainerByDomain(cacheName) : (objectStoreName == null ? PCH.lookupChildContainerByDomain(category, cacheName) : PCH.lookupContainerByObjectStore(objectStoreName, cacheName));
        }
        this.init(needsByValue, ttlVal, maxEntriesVal, pchContainer);
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal, String objectStoreName, String cacheName, boolean pchMonitoringVal) {
        this(needsByValue, ttlVal, maxEntriesVal, objectStoreName, cacheName, null, pchMonitoringVal);
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal) {
        this(needsByValue, ttlVal, maxEntriesVal, null);
    }

    public final int size() {
        return this.idMap.size();
    }

    public final String dumpInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append(" \t(Cache " + this.maxEntries + "/" + this.ttl + ") " + this.idMap.size() + "/" + (this.valueMap == null ? 0 : this.valueMap.size()));
        if (this.isPCHRunning()) {
            buf.append(" " + this.pchCacheAttempts.getCount() + "/" + this.pchCacheHits.getCount() + "/" + this.pchCacheExpiries.getCount() + "/" + this.pchCacheEvictions.getCount());
        }
        return buf.toString();
    }

    public final void dump() {
        System.out.println("*** Dumping " + this.size() + " idMap entries");
        for (Map.Entry<Object, CacheEntry> entry : this.idMap.entrySet()) {
            System.out.println("    " + entry.toString());
        }
        if (this.valueMap != null) {
            System.out.println("*** Dumping " + this.valueMap.size() + " valueMap entries");
            Iterator<Map.Entry<Object, CacheEntry>> it = this.valueMap.entrySet().iterator();
            while (it.hasNext()) {
                System.out.println("    " + it.next().toString());
            }
        }
    }

    @Override
    public final void add(CacheEntry ce) {
        ce.added();
        CacheEntry repValue = null;
        if (this.valueMap != null && ce.getValue() != null) {
            repValue = this.valueMap.put(ce.getValue(), ce);
        }
        this.promote(ce);
        this.idMap.put(ce.getId(), ce);
        this.checkEvict();
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    private void remove(CacheEntry ce) {
        CacheEntry removed = this.idMap.remove(ce.getId());
        if (removed == ce) {
            ce.removed();
        } else if (removed != null) {
            this.idMap.put(removed.getId(), removed);
        }
        if (this.valueMap != null && ce.getValue() != null && (removed = this.valueMap.remove(ce.getValue())) != ce && removed != null) {
            this.valueMap.put(removed.getValue(), removed);
        }
    }

    @Override
    public final void removeCacheEntry(CacheEntry ce) {
        this.remove(ce);
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    @Override
    public final CacheEntry find(Object id) {
        if (this.isPCHRunning()) {
            this.pchCacheAttempts.recordEvent();
        }
        if (id == null) {
            return null;
        }
        CacheEntry ce = this.idMap.get(id);
        if (ce != null) {
            if (!ce.hasExpired(this.ttl)) {
                this.promote(ce);
                if (this.isPCHRunning()) {
                    this.pchCacheHits.recordEvent();
                }
                return ce;
            }
            this.remove(ce);
            if (this.isPCHRunning()) {
                this.pchCacheExpiries.recordEvent();
            }
            if (this.isPCHRunning()) {
                this.pchCacheEntries.setValue((long)this.idMap.size());
            }
        }
        return null;
    }

    @Override
    public final CacheEntry findByValue(Object value) {
        if (this.isPCHRunning()) {
            this.pchCacheAttempts.recordEvent();
        }
        if (this.valueMap == null) {
            return null;
        }
        CacheEntry ce = this.valueMap.get(value);
        if (ce != null) {
            if (!ce.hasExpired(this.ttl)) {
                this.promote(ce);
                if (this.isPCHRunning()) {
                    this.pchCacheHits.recordEvent();
                }
                return ce;
            }
            this.remove(ce);
            if (this.isPCHRunning()) {
                this.pchCacheExpiries.recordEvent();
            }
            if (this.isPCHRunning()) {
                this.pchCacheEntries.setValue((long)this.idMap.size());
            }
        }
        return null;
    }

    protected CacheEntry peek(Object id) {
        CacheEntry ce = this.idMap.get(id);
        if (ce != null) {
            if (!ce.hasExpired(this.ttl)) {
                return ce;
            }
            this.remove(ce);
            if (this.isPCHRunning()) {
                this.pchCacheExpiries.recordEvent();
            }
        }
        return null;
    }

    @Override
    public final void purge(Object id) {
        CacheEntry removed;
        CacheEntry ce = this.idMap.remove(id);
        if (ce != null && ce.getValue() != null && this.valueMap != null && (removed = this.valueMap.remove(ce.getValue())) != null && !id.equals(removed.getId())) {
            this.valueMap.put(removed.getValue(), removed);
        }
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    @Override
    public final void setMaxEntries(int maxEntriesVal) {
        super.setMaxEntries(maxEntriesVal);
        this.checkEvict();
    }

    protected final Event lookupPCHEvent(String eventName) {
        return PCH.lookupUserEventByContainer(this.pchBaseContainer, eventName);
    }

    private void promote(CacheEntry ce) {
        if (this.maxEntries == 0) {
            return;
        }
        ce.timeLastUsed = ++this.usageTime;
    }

    private void checkEvict() {
        int emergencyScavengeMax = this.maxEntries * (4 * scavengeThreshold + 100) / 100;
        if (emergencyScavengeMax != 0 && this.idMap.size() > emergencyScavengeMax) {
            this.scavenge();
        }
    }

    private boolean scavenge() {
        if (this.scavengeInProgress.compareAndSet(false, true)) {
            try {
                boolean bl = this._scavenge();
                return bl;
            }
            finally {
                this.scavengeInProgress.set(false);
            }
        }
        return false;
    }

    private boolean _scavenge() {
        boolean checkExpiry;
        int scavengeMax = this.maxEntries * (100 + scavengeThreshold) / 100;
        boolean doEvictions = scavengeMax != 0 && this.idMap.size() > scavengeMax;
        boolean bl = checkExpiry = this.ttl != 0 && (long)(500 * this.ttl) + this.lastExpiryCheckTime < System.currentTimeMillis();
        if (doEvictions || checkExpiry) {
            int expired = 0;
            AbstractCollection evictionCandidates = SORT_WITH_TREESET ? new TreeSet<CacheEntry>(comparator) : new ArrayList();
            long evictionCeiling = this.usageTime;
            this.lastExpiryCheckTime = System.currentTimeMillis();
            for (CacheEntry ce : this.idMap.values()) {
                if (ce.hasExpired(this.ttl)) {
                    this.remove(ce);
                    ++expired;
                    continue;
                }
                if (!doEvictions) continue;
                ce.lruScore = ce.timeLastUsed;
                if (ce.timeLastUsed >= evictionCeiling) continue;
                evictionCandidates.add(ce);
            }
            int removed = 0;
            if (doEvictions) {
                int scavengeTarget = this.maxEntries * (100 - scavengeThreshold) / 100;
                if (!SORT_WITH_TREESET) {
                    Collections.sort((List)((Object)evictionCandidates), comparator);
                }
                Iterator iter = evictionCandidates.iterator();
                while (this.idMap.size() > scavengeTarget && iter.hasNext()) {
                    CacheEntry ce = (CacheEntry)iter.next();
                    if (ce.timeLastUsed >= evictionCeiling) continue;
                    this.remove(ce);
                    ++removed;
                }
            }
            if (expired != 0 || removed != 0) {
                if (this.isPCHRunning()) {
                    if (expired != 0) {
                        this.pchCacheExpiries.recordEvent(expired);
                    }
                    if (removed != 0) {
                        this.pchCacheEvictions.recordEvent(removed);
                    }
                    this.pchCacheEntries.setValue((long)this.idMap.size());
                }
                return true;
            }
        }
        return false;
    }

    static {
        scavengeThread.setDaemon(true);
        scavengeThread.start();
        scavengeThreshold = ConfigValueLookup.getValueAsInt("com.filenet.cache.ScavengeThreshold", 10);
        SORT_WITH_TREESET = false;
        comparator = new CacheEntryLRUComparator();
    }

    private static class CacheEntryLRUComparator
    implements Comparator<CacheEntry> {
        private CacheEntryLRUComparator() {
        }

        @Override
        public int compare(CacheEntry ce1, CacheEntry ce2) {
            int timeDiff = Long.signum(ce1.lruScore - ce2.lruScore);
            if (timeDiff == 0) {
                timeDiff = ce1.getId().hashCode() - ce2.getId().hashCode();
            }
            return timeDiff;
        }
    }
}

