/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.AliasMap;
import com.filenet.apiimpl.util.CacheMap;
import com.filenet.apiimpl.util.ContextEntries;
import com.filenet.apiimpl.util.ContextKey;

public class ContextCache
implements ContextEntries.Values {
    private ContextEntries contexts;
    private AliasMap aliases;
    private final CacheMap values = new CacheMap();
    private final CacheMap.Removed removed = new CacheMap.Removed();
    private CacheMap.Removed saved = CacheMap.Removed.NULL;

    public ContextCache() {
        this.values.setRemoved(this.removed);
    }

    public boolean isEnabled() {
        return this.values.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.values.setEnabled(enabled);
        if (!enabled) {
            this.clear();
        }
    }

    public void setMaxAliases(int count) {
        this.aliases().setMaxAliases(count);
    }

    public int getMaxAliases() {
        return this.aliases().getMaxAliases();
    }

    public long getTTL() {
        return this.values.getTTL();
    }

    public void setTTL(long duration) {
        this.values.setTTL(duration);
    }

    public int getLRUMaxSize() {
        return this.values.getLRUMaxSize();
    }

    public void setLRUMaxSize(int count) {
        this.values.setLRUMaxSize(count);
    }

    public boolean isLRUSoft() {
        return this.values.isLRUSoft();
    }

    public void setLRUSoft(boolean enabled) {
        this.values.setLRUSoft(enabled);
    }

    public boolean isFixedOnPut() {
        return this.values.isFixedOnPut();
    }

    public void setFixedOnPut(boolean enabled) {
        this.values.setFixedOnPut(enabled);
    }

    public CacheMap.Removed getRemoved() {
        this.poll();
        return this.saved;
    }

    public void setRemoved(CacheMap.Removed queue) {
        this.saved = queue != null ? queue : CacheMap.Removed.NULL;
    }

    public CacheMap.Entry get(Object key) {
        return this.values.get(this.getCandidateKey(key));
    }

    public Object getAliasedKey(Object alias) {
        if (this.aliases == null) {
            return null;
        }
        Object key = this.aliases.get(alias);
        if (key == null || this.values.get(key) == null) {
            return null;
        }
        return key;
    }

    public Object getCanonicalKey(Object key) {
        CacheMap.Entry entry = this.values.get(this.getCandidateKey(key));
        return entry == null ? null : entry.getKey();
    }

    private Object getCandidateKey(Object key) {
        if (this.aliases == null) {
            return key;
        }
        Object norm = this.aliases.get(key);
        return norm == null ? key : norm;
    }

    public boolean put(CacheMap.Entry entry) {
        Object key = entry.getKey();
        this.remove(key);
        if (!this.values.put(entry)) {
            return false;
        }
        if (key instanceof ContextKey) {
            this.contexts().put((ContextKey)key);
        }
        return true;
    }

    public boolean alias(Object key, Object alias) {
        return this.alias(key, alias, false);
    }

    boolean alias(Object key, Object alias, boolean create) {
        Object keyNorm = this.getCanonicalKey(key);
        if (keyNorm != null) {
            key = keyNorm;
            create = false;
        } else if (!create) {
            return false;
        }
        Object aliasNorm = this.getCanonicalKey(alias);
        if (aliasNorm != null && !aliasNorm.equals(key)) {
            return false;
        }
        if (create && !this.put(new CacheMap.Entry(key, new Object()))) {
            return false;
        }
        if (!this.aliases().add(key, alias)) {
            if (create) {
                this.remove(key);
            }
            return false;
        }
        if (alias instanceof ContextKey) {
            this.contexts().put((ContextKey)alias);
        }
        return true;
    }

    Object removeAlias(Object alias) {
        AliasMap aliases = this.aliases();
        Object value = aliases.remove(alias);
        if (value == null) {
            return null;
        }
        if (!aliases.containsValue(value)) {
            this.remove(value);
        }
        if (alias instanceof ContextKey) {
            this.contexts().remove((ContextKey)alias);
        }
        return value;
    }

    boolean containsAliasValue(Object value) {
        return this.aliases().containsValue(value);
    }

    Object[] getAliases(Object value) {
        return this.aliases().getAliases(value);
    }

    private AliasMap aliases() {
        if (this.aliases == null) {
            this.aliases = new AliasMap();
        }
        return this.aliases;
    }

    public CacheMap.Entry remove(Object key) {
        CacheMap.Entry entry = this.values.remove(this.getCandidateKey(key));
        this.scrub();
        return entry;
    }

    private void clean(Object key) {
        Object[] keys = null;
        if (this.aliases != null) {
            if (this.contexts != null) {
                keys = this.aliases.getAliases(key);
            }
            this.aliases.removeValue(key);
        }
        if (this.contexts != null) {
            if (key instanceof ContextKey) {
                this.contexts.remove((ContextKey)key);
            }
            if (keys != null) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object next = keys[i];
                    if (!(next instanceof ContextKey)) continue;
                    this.contexts.remove((ContextKey)next);
                }
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCanonicalKey(key) != null;
    }

    public Object getValue(Object key) {
        CacheMap.Entry entry = this.get(key);
        return entry == null ? null : entry.getValue();
    }

    public boolean putValue(Object key, Object value) {
        return this.put(new CacheMap.Entry(key, value));
    }

    public Object removeValue(Object key) {
        CacheMap.Entry removed = this.remove(key);
        return removed == null ? null : removed.getValue();
    }

    public Object[] getKeys() {
        return this.values.getKeys();
    }

    public CacheMap.Entry[] getEntries() {
        return this.values.getEntries();
    }

    public Object[] getValues() {
        return this.values.getValues();
    }

    public ContextKey find(Object context, Object object) {
        return this.contexts().find(context, object);
    }

    public ContextKey make(Object context, Object object) {
        return this.contexts().make(context, object);
    }

    private ContextEntries contexts() {
        if (this.contexts == null) {
            this.contexts = new ContextEntries(this);
        }
        return this.contexts;
    }

    public int size() {
        return this.values.getSize();
    }

    public void clear() {
        if (this.contexts != null) {
            this.contexts.clear();
        }
        if (this.aliases != null) {
            this.aliases.clear();
        }
        this.values.clear();
        this.saved.clear();
    }

    public void scrub() {
        this.values.scrub();
        this.poll();
    }

    private void poll() {
        CacheMap.Entry entry = this.removed.poll();
        while (entry != null) {
            this.clean(entry.getKey());
            this.saved.add(entry);
            entry = this.removed.poll();
        }
    }

    public String toString() {
        return "{values=" + this.values + ", contexts=" + this.contexts + ", aliases=" + this.aliases + ", removed=" + this.removed + ", saved=" + this.saved + "}";
    }
}

