/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

public class DnHelper {
    public static String normalizeDN(String origDN) {
        if (null == origDN || 0 == origDN.length()) {
            return null;
        }
        int length = origDN.length();
        StringBuffer dn = new StringBuffer(length);
        int start = 0;
        while (start < length) {
            int end = origDN.indexOf(61, start);
            if (-1 == end) {
                return null;
            }
            String attrName = origDN.substring(start, end).trim().toLowerCase();
            dn.append(attrName);
            dn.append('=');
            for (start = end + 1; start < length && Character.isWhitespace(origDN.charAt(start)); ++start) {
            }
            if (start >= length) {
                return null;
            }
            int countSpace = 0;
            int pos = start;
            while (pos < length) {
                char ch = origDN.charAt(pos);
                if (Character.isWhitespace(ch)) {
                    ++countSpace;
                    ++pos;
                    continue;
                }
                if ('\\' == ch) {
                    countSpace = 0;
                    if (++pos >= length) {
                        return null;
                    }
                    ch = origDN.charAt(pos);
                    if (',' == ch || ';' == ch || '+' == ch || '\"' == ch || '\\' == ch || '<' == ch || '>' == ch || ' ' == ch || '#' == ch || '/' == ch || '=' == ch) {
                        ++pos;
                        continue;
                    }
                    if (Character.digit(ch, 16) > -1) {
                        if (++pos >= length || -1 == Character.digit(origDN.charAt(pos), 16)) {
                            return null;
                        }
                        ++pos;
                        continue;
                    }
                    return null;
                }
                if (',' == ch || ';' == ch || '+' == ch) break;
                countSpace = 0;
                ++pos;
            }
            if ((end = pos - countSpace) < start) {
                return null;
            }
            String value = origDN.substring(start, end).trim().toLowerCase();
            dn.append(value);
            if (pos < length) {
                char ch = origDN.charAt(pos);
                if (',' == ch || ';' == ch) {
                    dn.append(',');
                } else {
                    dn.append('+');
                }
            }
            start = pos + 1;
        }
        return dn.toString();
    }
}

