/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.admin.Choice;
import com.filenet.api.admin.ChoiceList;
import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.CmChangePreprocessorDefinition;
import com.filenet.api.admin.LocalizedString;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.admin.PropertyTemplate;
import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.EngineCollection;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.PropertyPersistence;
import com.filenet.api.constants.PropertySettability;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.constants.SecurityPrincipalType;
import com.filenet.api.constants.SpecialPrincipal;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.Annotation;
import com.filenet.api.core.ContentElement;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.Versionable;
import com.filenet.api.events.CmChangePreprocessorAction;
import com.filenet.api.events.DocumentState;
import com.filenet.api.events.Event;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.meta.PropertyDescriptionBinary;
import com.filenet.api.meta.PropertyDescriptionBoolean;
import com.filenet.api.meta.PropertyDescriptionDateTime;
import com.filenet.api.meta.PropertyDescriptionFloat64;
import com.filenet.api.meta.PropertyDescriptionId;
import com.filenet.api.meta.PropertyDescriptionInteger32;
import com.filenet.api.meta.PropertyDescriptionString;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyEngineObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.MarkingSet;
import com.filenet.api.security.SecurityTemplate;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.SubListImpl;
import com.filenet.apiimpl.util.Base64;
import com.filenet.apiimpl.util.CachePropIE;
import com.filenet.apiimpl.util.CachePropertiesIE;
import com.filenet.apiimpl.util.ImportExportUtil;
import com.filenet.apiimpl.util.MetadataCacheIE;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExportXML {
    static Object[][] exportTypes = new Object[][]{{"CmChangePreprocessorActions", 3000}, {"DocumentLifecycleActions", 1154}, {"DocumentLifecyclePolicies", 1148}, {"ChoiceLists", 1026}, {"PropertyTemplates", 1055}, {"ClassDefinitions", 1027}, {"CustomObjects", 15}, {"Folders", 2}, {"Documents", 1}, {"Annotations", 3}, {"EventActions", 1143}, {"Subscriptions", 1144}, {"Others", 0}, {"ReferentialContainmentRelationships", 1124}, {"DynamicReferentialContainmentRelationships", 1050}};
    static Element globalExportFilter = null;
    static Element globalClassFilter = null;
    static Element globalDefaultFilter = null;
    static boolean globalRecursiveExport = false;
    static int fileSeqNo = 0;
    static HashSet<Id> exportedPropertyTemplates = null;
    static HashSet<Id> exportedChangePreprocessorActions = null;

    public static void exportObject(Domain domain, EngineObject engineObject, Object exportTarget, Object optFlags, Object exportFilter) {
        ExportXML.exportObject(domain, engineObject, exportTarget, optFlags, null, exportFilter);
    }

    public static void exportObject(Domain domain, EngineObject engineObject, Object exportTarget, Object optFlags, Object externalContentRef, Object exportFilter) {
        int flags = 0;
        if (ImportExportUtil.isOptionalParamPresent(optFlags)) {
            flags = (Integer)optFlags;
        }
        MetadataCacheIE.setLocalDomain(domain);
        if (exportTarget instanceof String) {
            Document exportDOMDoc = null;
            Element exportXMLNode = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                exportDOMDoc = factory.newDocumentBuilder().newDocument();
                exportXMLNode = exportDOMDoc.createElement("ExportObjects");
                exportDOMDoc.appendChild(exportXMLNode);
                ExportXML.exportObject(engineObject, flags, externalContentRef, exportXMLNode, exportFilter);
                Transformer tf = TransformerFactory.newInstance().newTransformer();
                tf.setOutputProperty("method", "xml");
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("encoding", "UTF-8");
                tf.transform(new DOMSource(exportDOMDoc), new StreamResult((String)exportTarget));
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        } else if (exportTarget instanceof Element) {
            ExportXML.exportObject(engineObject, flags, externalContentRef, (Element)exportTarget, exportFilter);
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
    }

    public static void export(Domain domain, ObjectStore objectStore, Object exportTarget, Object exportFilter, Object optFlags, Object externalContentRef) {
        int flags = 0;
        if (ImportExportUtil.isOptionalParamPresent(optFlags)) {
            flags = (Integer)optFlags;
        }
        MetadataCacheIE.setLocalDomain(domain);
        if (exportFilter == null || !(exportFilter instanceof Element)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "exportFilter");
        }
        if (exportTarget instanceof String) {
            Document exportDOMDoc = null;
            Element exportXMLNode = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                exportDOMDoc = factory.newDocumentBuilder().newDocument();
                exportXMLNode = exportDOMDoc.createElement("ExportObjects");
                exportDOMDoc.appendChild(exportXMLNode);
                ExportXML.export(objectStore, exportXMLNode, (Element)exportFilter, flags, externalContentRef);
                Transformer tf = TransformerFactory.newInstance().newTransformer();
                tf.setOutputProperty("method", "xml");
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("encoding", "UTF-8");
                tf.transform(new DOMSource(exportDOMDoc), new StreamResult((String)exportTarget));
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        } else if (exportTarget instanceof Element) {
            ExportXML.export(objectStore, (Element)exportTarget, (Element)exportFilter, flags, externalContentRef);
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "exportTarget");
        }
    }

    private static void exportObject(EngineObject eo, int flags, Object externalContentRef, Element exportXMLNode, Object exportFilter) {
        globalExportFilter = null;
        Element manifestNode = null;
        int recursionDepth = 0;
        boolean duplicate = false;
        if (exportFilter != null && exportFilter instanceof Element) {
            globalExportFilter = (Element)exportFilter;
        } else if (exportFilter != null) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_VALUE, null);
        }
        if (exportXMLNode != null) {
            Document xmlDoc = exportXMLNode.getOwnerDocument();
            IndependentlyPersistableObject ipo = (IndependentlyPersistableObject)eo;
            if (eo.getProperties().size() == 0) {
                ipo.refresh(ImportExportUtil.propFilter());
            }
            if (ImportExportUtil.isDeleted(ipo)) {
                throw new EngineRuntimeException(ExceptionCode.E_OBJECT_DELETED, null);
            }
            if (globalExportFilter != null) {
                String id;
                ExportXML.createExportManifestTemplate(xmlDoc, exportXMLNode);
                Integer objType = MetadataCacheIE.getObjectType(eo);
                if (objType != null) {
                    manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
                }
                if (!(duplicate = ExportXML.prepareToExportNewObject(manifestNode, id = ipo.getProperties().getIdValue("Id").toString()))) {
                    String recursion;
                    ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
                    ClassDescription classDesc = MetadataCacheIE.getClassDescription(eo, objStore);
                    ExportXML.getApplicableFilters(classDesc);
                    Element classFilter = globalClassFilter;
                    Element defaultFilter = globalDefaultFilter;
                    boolean recursionSet = false;
                    if (classFilter != null && (recursion = classFilter.getAttribute("OVPRecursion")) != null && recursion.length() > 0) {
                        recursionDepth = Integer.parseInt(recursion);
                        recursionSet = true;
                    }
                    if (!recursionSet && defaultFilter != null && (recursion = defaultFilter.getAttribute("OVPRecursion")) != null && recursion.length() > 0) {
                        recursionDepth = Integer.parseInt(recursion);
                        recursionSet = true;
                    }
                    boolean exportSubscriptions = ExportXML.getFilterOptions("ExportSubscriptionsOnObject");
                    boolean exportMetadata = ExportXML.getFilterOptions("ExportObjectMetadata");
                    if (exportSubscriptions) {
                        ExportXML.exportSubscriptions(exportXMLNode, objStore, classDesc, flags, xmlDoc);
                    }
                    if (exportMetadata) {
                        ExportXML.exportMetadata(exportXMLNode, objStore, classDesc, flags, xmlDoc);
                    }
                }
            }
            if (!duplicate) {
                String className = eo.getClassName();
                Element classNode = xmlDoc.createElement(className);
                Element classPropertiesNode = xmlDoc.createElement(className + "Properties");
                classNode.appendChild(classPropertiesNode);
                if (manifestNode != null) {
                    manifestNode.appendChild(classNode);
                } else {
                    exportXMLNode.appendChild(classNode);
                }
                if (classPropertiesNode != null) {
                    int contentFlags = flags & 0x30;
                    boolean exportFailed = false;
                    if (contentFlags == 0 || (contentFlags & 0x10) != 0) {
                        try {
                            ExportXML.independentlyPersistableExport(eo, classPropertiesNode, flags, null, xmlDoc, recursionDepth);
                        }
                        catch (Exception e) {
                            exportFailed = true;
                        }
                    } else if ((contentFlags & 0x20) != 0 && ImportExportUtil.isOptionalParamPresent(externalContentRef)) {
                        if (ImportExportUtil.isOptionalParamPresent(externalContentRef) && !(externalContentRef instanceof String)) {
                            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
                        }
                        String externalContentURL = (String)externalContentRef;
                        if (externalContentURL == null || externalContentURL.length() == 0) {
                            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
                        }
                        try {
                            ExportXML.independentlyPersistableExport(eo, classPropertiesNode, flags, externalContentURL, xmlDoc, recursionDepth);
                        }
                        catch (Exception e) {
                            exportFailed = true;
                        }
                    } else {
                        throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
                    }
                    if (exportFailed) {
                        if (manifestNode != null) {
                            manifestNode.removeChild(classNode);
                        } else {
                            exportXMLNode.removeChild(classNode);
                        }
                    }
                }
            }
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
    }

    private static void export(ObjectStore objectStore, Element exportTarget, Element exportFilter, int flags, Object externalContentRef) {
        globalExportFilter = exportFilter;
        String userName = ExportXML.getFilterCriteria("ExportObjectsCreatedBy");
        String date = ExportXML.getFilterCriteria("ExportObjectsModifiedSince");
        boolean searchAll = false;
        for (int i = 0; i < exportTypes.length; ++i) {
            String exportType = (String)exportTypes[i][0];
            exportType = exportType.endsWith("ies") ? exportType.substring(0, exportType.length() - 3) + "y" : exportType.substring(0, exportType.length() - 1);
            if (!searchAll) {
                ClassDescription cd = null;
                try {
                    cd = MetadataCacheIE.getClassDescription(exportType, objectStore);
                }
                catch (EngineRuntimeException e) {
                    if (e.getExceptionCode() == ExceptionCode.E_BAD_CLASSID) continue;
                    throw e;
                }
                if (cd != null) {
                    boolean hasFilter = ExportXML.getApplicableFilters(cd);
                    Element classFilter = globalClassFilter;
                    Element defaultFilter = globalDefaultFilter;
                    if (i == 0) {
                        searchAll = !hasFilter ? true : defaultFilter != null;
                    }
                    if (globalExportFilter == null || classFilter == null && !searchAll) continue;
                }
            }
            SearchSQL sql = new SearchSQL();
            sql.setFromClauseInitialValue(exportType, null, true);
            if (userName != null && userName.length() > 0 || date != null && date.length() > 0) {
                String whereClause = "";
                if (userName != null && userName.length() > 0) {
                    whereClause = whereClause + "Creator = '" + userName + "'";
                    if (date != null && date.length() > 0) {
                        whereClause = whereClause + " AND ";
                    }
                }
                if (date != null && date.length() > 0) {
                    whereClause = whereClause + "DateLastModified > " + date;
                }
                sql.setWhereClause(whereClause);
            }
            SearchScope ss = new SearchScope(objectStore);
            IndependentObjectSet objs = null;
            try {
                objs = ss.fetchObjects(sql, null, new PropertyFilter(), null);
                Iterator iter = objs.iterator();
                while (iter.hasNext()) {
                    EngineObject eo = (EngineObject)iter.next();
                    ExportXML.exportObject(eo, flags, externalContentRef, exportTarget, (Object)exportFilter);
                }
                ss = null;
                continue;
            }
            catch (EngineRuntimeException e) {
                if (e.getExceptionCode() == ExceptionCode.E_BAD_CLASSID) continue;
                throw e;
            }
        }
    }

    private static void independentlyPersistableExport(EngineObject eo, Element classPropertiesNode, int flags, String externalContentURL, Document xmlDoc, int recursionDepth) {
        boolean exported = ExportXML.persistableExport(eo, classPropertiesNode, flags, externalContentURL, xmlDoc, recursionDepth);
        if (exported && (flags & 2) != 0) {
            Element securityNode;
            String className = eo.getClassName();
            Node classNode = classPropertiesNode.getParentNode();
            if (classNode != null && ExportXML.securityExport(eo, securityNode = xmlDoc.createElement(className + "Security"), flags, xmlDoc)) {
                classNode.appendChild(securityNode);
            }
        }
    }

    private static boolean persistableExport(EngineObject eo, Element parentNode, int flags, String externalContentURL, Document xmlDoc, int recursionDepth) {
        if (eo instanceof SecurityTemplate && eo.getProperties().isPropertyPresent("TemplatePermissions")) {
            Element permsNode = ExportXML.createElement("TemplatePermissions", null, xmlDoc);
            AccessPermissionList perms = (AccessPermissionList)eo.getProperties().get("TemplatePermissions").getObjectValue();
            if (ExportXML.permissionsExport(perms, permsNode, xmlDoc)) {
                parentNode.appendChild(permsNode);
            }
        }
        return ExportXML.genericPersistableExport(eo, parentNode, flags, externalContentURL, xmlDoc, recursionDepth);
    }

    private static boolean genericPersistableExport(EngineObject eo, Element parentNode, int flags, String externalContentURL, Document xmlDoc, int recursionDepth) {
        CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
        Properties props = eo.getProperties();
        Iterator<Property> it = ExportXML.getOrderedIterator(props);
        ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
        Integer oType = MetadataCacheIE.getObjectType(eo);
        if (ImportExportUtil.isAddOnExport(flags)) {
            if (oType != null && oType.equals(1027)) {
                if (exportedPropertyTemplates == null) {
                    exportedPropertyTemplates = ExportXML.getExportedPropertyTemplates(xmlDoc);
                }
                if (exportedChangePreprocessorActions == null) {
                    exportedChangePreprocessorActions = ExportXML.getExportedChangePreprocessorActions(xmlDoc);
                }
            }
        } else if (oType != null) {
            parentNode.appendChild(ExportXML.createElement("ObjectType", oType, xmlDoc));
        }
        while (it.hasNext()) {
            globalRecursiveExport = false;
            Property prop = it.next();
            String name = prop.getPropertyName();
            CachePropIE cacheProp = cacheProps.Item(name);
            boolean shouldExportProp = ExportXML.shouldExportProperty(cacheProp, prop, objStore, eo, flags);
            boolean exportFull = (flags & 0x80) != 0;
            boolean shouldExportPropDef = ExportXML.shouldExportPropDefProperty(cacheProp, eo, flags);
            if (!shouldExportProp || !exportFull && !shouldExportPropDef) continue;
            Cardinality Card = cacheProp.getPropertyDescription().get_Cardinality();
            TypeID Type2 = cacheProp.getPropertyDescription().get_DataType();
            if (Card == Cardinality.SINGLE) {
                if (Type2 == TypeID.OBJECT) {
                    String id;
                    Integer objType;
                    Element manifestNode;
                    boolean duplicate;
                    if (cacheProp.getName().equals("InstalledByAddOn")) continue;
                    ExportXML.objectPropertyExport(cacheProp, prop, parentNode, eo, xmlDoc);
                    if (!globalRecursiveExport || cacheProp.getName().equals("VersionSeries") || recursionDepth <= 0) continue;
                    EngineObject eoSub = null;
                    PropertyState state = prop.getState();
                    if (state == PropertyState.REFERENCE || state == PropertyState.UNEVALUATED) {
                        eoSub = ((PropertyEngineObject)prop).fetchIndependentObject(ImportExportUtil.propFilter());
                    } else if (state == PropertyState.VALUE) {
                        eoSub = (EngineObject)prop.getObjectValue();
                    }
                    if (eoSub == null || (duplicate = ExportXML.prepareToExportNewObject(manifestNode = ExportXML.locateInManifest(parentNode, objType = MetadataCacheIE.getObjectType(eoSub)), id = eoSub.getProperties().getIdValue("Id").toString()))) continue;
                    String className = eoSub.getClassName();
                    Element classNode = xmlDoc.createElement(className);
                    Element classPropertiesNode = xmlDoc.createElement(className + "Properties");
                    classNode.appendChild(classPropertiesNode);
                    Element objectType = ExportXML.createElement("ObjectType", objType, xmlDoc);
                    classPropertiesNode.appendChild(objectType);
                    manifestNode.appendChild(classNode);
                    ExportXML.persistableExport(eoSub, classPropertiesNode, flags, externalContentURL, xmlDoc, recursionDepth - 1);
                    continue;
                }
                if (cacheProp.isValueSet()) {
                    ExportXML.propertySingleExport(cacheProp, prop, parentNode, xmlDoc);
                    continue;
                }
                ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), parentNode, xmlDoc);
                continue;
            }
            if (Card == Cardinality.LIST) {
                ExportXML.propertyListExport(eo, cacheProp, prop, flags, parentNode, externalContentURL, xmlDoc);
                continue;
            }
            if (Card == Cardinality.ENUM && recursionDepth > 0) {
                EngineCollection eoc = (EngineCollection)prop.getObjectValue();
                ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), parentNode, xmlDoc);
                ExportXML.enumPropertyExport(eoc, parentNode, flags, externalContentURL, recursionDepth - 1, xmlDoc);
                continue;
            }
            ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), parentNode, xmlDoc);
        }
        if (eo instanceof ContentTransfer) {
            if ((flags & 0x20) != 0) {
                ExportXML.contentRefExport(eo, parentNode, externalContentURL, xmlDoc);
            } else {
                ExportXML.encodedExport(eo, parentNode, xmlDoc);
            }
        }
        return true;
    }

    private static Iterator<Property> getOrderedIterator(Properties props) {
        ArrayList orderedProps = new ArrayList(props.size());
        Iterator it = props.iterator();
        while (it.hasNext()) {
            orderedProps.add(it.next());
        }
        Collections.sort(orderedProps, new PropertyExportComparator());
        return orderedProps.iterator();
    }

    private static void encodedExport(EngineObject eo, Element parentNode, Document xmlDoc) {
        Element contElem = ExportXML.createElement("EncodedContent", null, xmlDoc);
        ContentTransfer contTrans = (ContentTransfer)eo;
        try {
            byte[] buffer = new byte[6144];
            StringBuffer base64 = new StringBuffer();
            InputStream inputStream = contTrans.accessContentStream();
            int bytesRead = 0;
            do {
                if ((bytesRead = inputStream.read(buffer, 0, 6144)) <= 0) continue;
                base64.append(Base64.encode(buffer, 0, bytesRead));
            } while (bytesRead > 0);
            Text textNode = xmlDoc.createTextNode(base64.toString());
            contElem.appendChild(textNode);
            inputStream.close();
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_VALUE_NOT_SET, null);
        }
        parentNode.appendChild(contElem);
    }

    private static void contentRefExport(EngineObject eo, Element parentNode, String externalContentURL, Document xmlDoc) {
        String OutputPath = ExportXML.getOutputFile(externalContentURL, eo);
        Element ContElem = ExportXML.createElement("ExternalRef", OutputPath, xmlDoc);
        parentNode.appendChild(ContElem);
    }

    private static String getOutputFile(String externalContentURL, EngineObject eo) {
        String outputFile = "";
        if (eo.getProperties().isPropertyPresent("RetrievalName")) {
            outputFile = eo.getProperties().getStringValue("RetrievalName");
        }
        if (outputFile.length() == 0) {
            Integer temp = new Integer(++fileSeqNo);
            outputFile = "ContentFile" + temp.toString();
        }
        return outputFile;
    }

    private static void objectPropertyExport(CachePropIE cacheProp, Property prop, Element classPropertiesNode, EngineObject eo, Document xmlDoc) {
        Element propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), null, xmlDoc);
        String classId = "";
        String objectId = "";
        String objectStoreId = "";
        PropertyState state = prop.getState();
        ObjectReference objRef = null;
        if (state == PropertyState.REFERENCE || state == PropertyState.VALUE) {
            objRef = ((PropertyEngineObject)prop).getObjectReference();
        } else if (state == PropertyState.UNEVALUATED) {
            try {
                objRef = ((PropertyEngineObject)prop).fetchIndependentObject(ImportExportUtil.propFilter()).getObjectReference();
            }
            catch (Exception e) {
                objRef = null;
            }
        }
        if (objRef != null) {
            classId = objRef.getClassIdentity();
            objectId = objRef.getObjectIdentity();
            if (cacheProp.getName().equals("MarkingSet")) {
                classId = "{4b424567-4739-4995-80c7-ad7fd0ef3773}";
                MarkingSet obj = Factory.MarkingSet.fetchInstance(MetadataCacheIE.getLocalDomain(), new Id(objectId), ImportExportUtil.propFilter());
                MarkingSet ms = obj;
                if (ms.get_DisplayName().length() > 0) {
                    objectId = ms.get_DisplayName();
                }
            }
            ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
            if (!Id.isId(classId)) {
                ClassDescription classDesc = MetadataCacheIE.getClassDescription(classId, objStore);
                classId = classDesc.get_Id().toString();
            }
            try {
                String ovpOSId = objRef.getObjectStoreIdentity();
                if (ovpOSId != null && ovpOSId.length() > 0) {
                    if (!objStore.getProperties().isPropertyPresent("Id")) {
                        objStore.refresh();
                    }
                    if (Id.isId(ovpOSId)) {
                        if (ovpOSId.compareToIgnoreCase(objStore.get_Id().toString()) != 0) {
                            objectStoreId = ovpOSId;
                        }
                    } else if (ovpOSId.compareToIgnoreCase(objStore.get_Name()) != 0) {
                        objectStoreId = ovpOSId;
                    }
                }
            }
            catch (Exception e) {
                objectStoreId = "";
            }
            ExportXML.objectRefExport(classId, objectId, objectStoreId, propElem, xmlDoc);
        }
        classPropertiesNode.appendChild(propElem);
    }

    private static void propertySingleExport(CachePropIE cacheProp, Property prop, Element classPropertiesNode, Document xmlDoc) {
        Element propElem = null;
        switch (cacheProp.getTypeID().getValue()) {
            case 8: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getStringValue(), xmlDoc);
                break;
            }
            case 6: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getInteger32Value(), xmlDoc);
                break;
            }
            case 3: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getDateTimeValue(), xmlDoc);
                break;
            }
            case 4: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getFloat64Value(), xmlDoc);
                break;
            }
            case 1: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getBinaryValue(), xmlDoc);
                break;
            }
            case 2: {
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), prop.getBooleanValue() != false ? "1" : "0", xmlDoc);
                break;
            }
            case 5: {
                String id = ImportExportUtil.unFormatId(prop.getIdValue().toString());
                propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), id, xmlDoc);
                break;
            }
            default: {
                throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
            }
        }
        classPropertiesNode.appendChild(propElem);
    }

    private static void propertyListExport(EngineObject engObj, CachePropIE cacheProp, Property prop, int flags, Element classPropertiesNode, String externalContentURL, Document xmlDoc) {
        boolean isFullExport;
        boolean bl = isFullExport = (flags & 0x80) != 0;
        if (ImportExportUtil.isAddOnExport(flags) && !isFullExport && engObj instanceof ClassDefinition) {
            Iterator it;
            EngineCollection eoc;
            Object obj;
            if (prop.getPropertyName().equals("PropertyDefinitions")) {
                boolean hasExportedPropertyTemplates = false;
                if (exportedPropertyTemplates != null && exportedPropertyTemplates.size() > 0 && (obj = prop.getObjectValue()) instanceof EngineCollection) {
                    eoc = (EngineCollection)obj;
                    it = eoc.iterator();
                    while (it.hasNext() && !hasExportedPropertyTemplates) {
                        PropertyDefinition pd = (PropertyDefinition)it.next();
                        Id ptId = pd.getProperties().getIdValue("PrimaryId");
                        hasExportedPropertyTemplates = exportedPropertyTemplates.contains(ptId);
                        if (hasExportedPropertyTemplates || (ptId = pd.getProperties().getIdValue("AuditAs")) == null) continue;
                        hasExportedPropertyTemplates = exportedPropertyTemplates.contains(ptId);
                    }
                }
                if (!hasExportedPropertyTemplates) {
                    return;
                }
            } else if (prop.getPropertyName().equals("ChangePreprocessorDefinitions")) {
                boolean hasExportedChangePreprocessorActions = false;
                if (exportedChangePreprocessorActions != null && exportedChangePreprocessorActions.size() > 0 && (obj = prop.getObjectValue()) instanceof EngineCollection) {
                    eoc = (EngineCollection)obj;
                    it = eoc.iterator();
                    while (it.hasNext() && !hasExportedChangePreprocessorActions) {
                        CmChangePreprocessorDefinition cppd = (CmChangePreprocessorDefinition)it.next();
                        Id cpaId = cppd.getProperties().getIdValue("ChangePreprocessorAction");
                        hasExportedChangePreprocessorActions = exportedChangePreprocessorActions.contains(cpaId);
                    }
                }
                if (!hasExportedChangePreprocessorActions) {
                    return;
                }
            }
        }
        Element propElem = ExportXML.createElement(cacheProp.getPropertyDescription().get_SymbolicName(), null, xmlDoc);
        if (cacheProp.isValueSet()) {
            Iterator it;
            TypeID type = cacheProp.getPropertyDescription().get_DataType();
            if (type == TypeID.OBJECT) {
                Object obj = prop.getObjectValue();
                if (obj instanceof EngineCollection) {
                    EngineCollection eoc = (EngineCollection)obj;
                    it = eoc.iterator();
                    while (it.hasNext()) {
                        EngineObject eo = (EngineObject)it.next();
                        if ((flags & 0x80) == 0 && !ExportXML.shouldExportObject(eo)) continue;
                        Element classElem = ExportXML.createElement(eo.getClassName(), propElem, xmlDoc);
                        ExportXML.persistableExport(eo, classElem, flags, externalContentURL, xmlDoc, 0);
                    }
                }
            } else {
                String Name2 = "";
                List list = null;
                if (type == TypeID.STRING) {
                    Name2 = "String";
                    list = prop.getStringListValue();
                } else if (type == TypeID.LONG) {
                    Name2 = "Integer32";
                    list = prop.getInteger32ListValue();
                } else if (type == TypeID.DATE) {
                    Name2 = "DateTime";
                    list = prop.getDateTimeListValue();
                } else if (type == TypeID.BINARY) {
                    Name2 = "Binary";
                    list = prop.getBinaryListValue();
                } else if (type == TypeID.DOUBLE) {
                    Name2 = "Float64";
                    list = prop.getFloat64ListValue();
                } else if (type == TypeID.BOOLEAN) {
                    Name2 = "Boolean";
                    list = prop.getBooleanListValue();
                } else if (type == TypeID.GUID) {
                    Name2 = "Id";
                    list = prop.getIdListValue();
                }
                if (list != null) {
                    it = list.iterator();
                    while (it.hasNext()) {
                        Element ItemElem = ExportXML.createElement(Name2, it.next(), xmlDoc);
                        propElem.appendChild(ItemElem);
                    }
                }
            }
        }
        classPropertiesNode.appendChild(propElem);
    }

    private static boolean securityExport(EngineObject eo, Element securityNode, int flags, Document xmlDoc) {
        AccessPermissionList perms;
        Element permsNode;
        Property owner;
        if (eo.getProperties().isPropertyPresent("Owner") && (owner = eo.getProperties().get("Owner")).getState() == PropertyState.VALUE) {
            Element ownerNode = ExportXML.createElement("Owner", null, xmlDoc);
            ExportXML.sidExport(owner.getStringValue(), ownerNode, xmlDoc);
            securityNode.appendChild(ownerNode);
        }
        if (eo.getProperties().isPropertyPresent("Permissions")) {
            permsNode = ExportXML.createElement("Permissions", null, xmlDoc);
            perms = (AccessPermissionList)eo.getProperties().get("Permissions").getObjectValue();
            if (ExportXML.permissionsExport(perms, permsNode, xmlDoc)) {
                securityNode.appendChild(permsNode);
            }
        }
        if (eo instanceof ClassDefinition) {
            if (eo.getProperties().isPropertyPresent("DefaultInstancePermissions")) {
                permsNode = ExportXML.createElement("DefaultInstancePermissions", null, xmlDoc);
                perms = (AccessPermissionList)eo.getProperties().get("DefaultInstancePermissions").getObjectValue();
                if (ExportXML.permissionsExport(perms, permsNode, xmlDoc)) {
                    securityNode.appendChild(permsNode);
                }
            }
            if (eo.getProperties().isPropertyPresent("DefaultInstanceOwner")) {
                Element ownerNode = ExportXML.createElement("DefaultInstanceOwner", null, xmlDoc);
                Property owner2 = eo.getProperties().get("DefaultInstanceOwner");
                if (owner2.getStringValue().equals(SpecialPrincipal.CREATOR_OWNER.toString()) || owner2.getStringValue().equals(SpecialPrincipal.AUTHENTICATED_USERS.toString())) {
                    ExportXML.exportWellKnownName(owner2.getStringValue(), ownerNode, xmlDoc);
                } else {
                    ExportXML.sidExport(owner2.getStringValue(), ownerNode, xmlDoc);
                }
                securityNode.appendChild(ownerNode);
            }
        }
        return true;
    }

    private static void sidExport(String name, Element parentNode, Document xmlDoc) {
        ImportExportUtil.Principal principal = new ImportExportUtil.Principal();
        principal.name = name;
        principal.principalType = SecurityPrincipalType.USER;
        ImportExportUtil.lookupPrincipal(principal);
        if (principal.sid.length() > 0) {
            Element elem = ExportXML.createElement("SID", principal.sid, xmlDoc);
            parentNode.appendChild(elem);
            elem = ExportXML.createElement("Name", principal.name, xmlDoc);
            parentNode.appendChild(elem);
            elem = ExportXML.createElement("ShortName", principal.shortName, xmlDoc);
            parentNode.appendChild(elem);
            elem = ExportXML.createElement("DisplayName", principal.displayName, xmlDoc);
            parentNode.appendChild(elem);
            elem = principal.principalType == SecurityPrincipalType.USER ? ExportXML.createElement("PrincipalType", "0", xmlDoc) : ExportXML.createElement("PrincipalType", "1", xmlDoc);
            parentNode.appendChild(elem);
        } else {
            Element elem = ExportXML.createElement("Name", principal.name, xmlDoc);
            parentNode.appendChild(elem);
        }
    }

    private static boolean permissionsExport(AccessPermissionList perms, Element permsNode, Document xmlDoc) {
        Element elem = null;
        for (AccessPermission perm : perms) {
            Integer permSource;
            Integer accessMask;
            Element accessPermsNode = ExportXML.createElement("AccessPermission", permsNode, xmlDoc);
            Element GranteeNode = ExportXML.createElement("Grantee", accessPermsNode, xmlDoc);
            if (perm.get_GranteeName().equals(SpecialPrincipal.CREATOR_OWNER.toString()) || perm.get_GranteeName().equals(SpecialPrincipal.AUTHENTICATED_USERS.toString())) {
                ExportXML.exportWellKnownName(perm.get_GranteeName(), GranteeNode, xmlDoc);
            } else {
                ExportXML.sidExport(perm.get_GranteeName(), GranteeNode, xmlDoc);
            }
            Integer typeasint = new Integer(perm.get_AccessType().getValue());
            elem = ExportXML.createElement("AccessType", typeasint, xmlDoc);
            accessPermsNode.appendChild(elem);
            Integer inheritDepth = perm.get_InheritableDepth();
            if (inheritDepth != null) {
                elem = ExportXML.createElement("InheritableDepth", inheritDepth, xmlDoc);
                accessPermsNode.appendChild(elem);
            }
            if ((accessMask = perm.get_AccessMask()) != null) {
                elem = ExportXML.createElement("AccessMask", accessMask.toString(), xmlDoc);
                accessPermsNode.appendChild(elem);
            }
            if ((permSource = new Integer(perm.get_PermissionSource().getValue())) != null) {
                elem = ExportXML.createElement("PermissionSource", permSource.toString(), xmlDoc);
                accessPermsNode.appendChild(elem);
            }
            permsNode.appendChild(accessPermsNode);
        }
        return true;
    }

    private static void exportWellKnownName(String name, Element parentNode, Document xmlDoc) {
        Element elem = null;
        String SID = "";
        if (name.equals(SpecialPrincipal.CREATOR_OWNER.toString())) {
            SID = "S-1-3-0";
        } else if (name.equals(SpecialPrincipal.AUTHENTICATED_USERS.toString())) {
            SID = "S-1-5-11";
        }
        if (SID.length() > 0) {
            elem = ExportXML.createElement("SID", SID, xmlDoc);
            parentNode.appendChild(elem);
        }
        elem = ExportXML.createElement("Name", name, xmlDoc);
        parentNode.appendChild(elem);
    }

    private static Element createElement(String name, Element parentNode, Document xmlDoc) {
        Element elem = xmlDoc.createElement(name);
        if (parentNode != null) {
            parentNode.appendChild(elem);
        }
        return elem;
    }

    private static Element createElement(String name, Object value, Document xmlDoc) {
        Element elem = xmlDoc.createElement(name);
        Text textNode = null;
        if (value != null) {
            if (value instanceof String) {
                textNode = xmlDoc.createTextNode(ExportXML.formatXMLString((String)value));
            } else if (value instanceof Integer) {
                textNode = xmlDoc.createTextNode(((Integer)value).toString());
            } else if (value instanceof Boolean) {
                boolean val = (Boolean)value;
                textNode = xmlDoc.createTextNode(val ? "1" : "0");
            } else if (value instanceof Double) {
                textNode = xmlDoc.createTextNode(((Double)value).toString());
            } else if (value instanceof byte[]) {
                textNode = xmlDoc.createTextNode(Base64.encode((byte[])value));
            } else if (value instanceof Date) {
                textNode = xmlDoc.createTextNode(ImportExportUtil.toXmlDateTime((Date)value));
            } else if (value instanceof Id) {
                textNode = xmlDoc.createTextNode(ImportExportUtil.unFormatId(((Id)value).toString()));
            } else {
                throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
            }
            if (textNode != null) {
                elem.appendChild(textNode);
            }
        }
        return elem;
    }

    private static void objectRefExport(String classId, String objectId, String objectStoreId, Element propElem, Document xmlDoc) {
        Element objRefElem = ExportXML.createElement("ObjectRef", propElem, xmlDoc);
        Element objectIdElem = null;
        Text textNode = null;
        if (Id.isId(objectId)) {
            objectIdElem = ExportXML.createElement("ObjectId", objRefElem, xmlDoc);
            textNode = xmlDoc.createTextNode(ImportExportUtil.unFormatId(objectId));
        } else {
            objectIdElem = ExportXML.createElement("Name", objRefElem, xmlDoc);
            textNode = xmlDoc.createTextNode(ExportXML.formatXMLString(objectId));
        }
        objectIdElem.appendChild(textNode);
        Element classIdElem = ExportXML.createElement("ClassId", objRefElem, xmlDoc);
        textNode = xmlDoc.createTextNode(ImportExportUtil.unFormatId(classId));
        classIdElem.appendChild(textNode);
        if (objectStoreId.length() > 0) {
            Element objStoreIdElem = ExportXML.createElement("StoreId", objRefElem, xmlDoc);
            textNode = xmlDoc.createTextNode(ImportExportUtil.unFormatId(objectStoreId));
            objStoreIdElem.appendChild(textNode);
        }
    }

    private static boolean shouldExportProperty(CachePropIE cacheProp, Property prop, ObjectStore objStore, EngineObject eo, int flags) {
        String propName = cacheProp.getName();
        if (eo instanceof Versionable) {
            if (propName.equals("CurrentVersion")) {
                return false;
            }
            if (propName.equals("StoragePolicy")) {
                return false;
            }
            if (propName.equals("StorageArea")) {
                return false;
            }
            if (propName.equals("StorageLocation")) {
                return false;
            }
            if (propName.equals("VersionSeries")) {
                return true;
            }
            if (propName.equals("VersionStatus")) {
                return true;
            }
            if (propName.equals("MajorVersionNumber")) {
                return true;
            }
            if (propName.equals("MinorVersionNumber")) {
                return true;
            }
            if (propName.equals("IsFrozenVersion")) {
                return true;
            }
        } else if (eo instanceof Annotation) {
            if (propName.equals("StoragePolicy")) {
                return false;
            }
            if (propName.equals("StorageLocation")) {
                return false;
            }
        } else if (eo instanceof ClassDefinition) {
            if (propName.equals("TableDefinition")) {
                return false;
            }
            if (propName.equals("DefaultInstancePermissions")) {
                return false;
            }
            if (propName.equals("DefaultInstanceOwner")) {
                return false;
            }
            if (propName.equals("SuperclassDefinition")) {
                return true;
            }
            if (propName.equals("Creator") || propName.equals("DateCreated") || propName.equals("LastModifier") || propName.equals("DateLastModified")) {
                return !ImportExportUtil.isAddOnExport(flags);
            }
        } else if (eo instanceof PropertyDefinition) {
            if (propName.equals("SymbolicName")) {
                return (flags & 0x80) != 0;
            }
            if (propName.equals("PrimaryId")) {
                return true;
            }
            if (propName.equals("Id")) {
                return false;
            }
            if (propName.equals("DisplayName")) {
                return (flags & 0x80) != 0;
            }
            if (propName.equals("DescriptiveText")) {
                return (flags & 0x80) != 0;
            }
            if (propName.equals("TableDefinition")) {
                return false;
            }
            if (propName.equals("ColumnId")) {
                return false;
            }
        } else {
            if (eo instanceof Event) {
                return !propName.equals("ClassDescription") && !propName.equals("This") && !propName.equals("Owner") && !propName.equals("Permissions");
            }
            if (eo instanceof PropertyTemplate && (propName.equals("Creator") || propName.equals("DateCreated") || propName.equals("LastModifier") || propName.equals("DateLastModified"))) {
                return !ImportExportUtil.isAddOnExport(flags);
            }
        }
        PropertySettability Settable = cacheProp.getPropertyDescription().get_Settability();
        boolean isReadOnly = false;
        if (Settable == PropertySettability.READ_ONLY) {
            isReadOnly = true;
        }
        Cardinality card = cacheProp.getPropertyDescription().get_Cardinality();
        boolean isPersistent = ImportExportUtil.isPersistentProperty(cacheProp.getPropertyDescription());
        if (propName.equals("Id")) {
            if (eo instanceof LocalizedString || eo instanceof Choice || eo instanceof DocumentState || eo instanceof ContentElement) {
                return false;
            }
            return (flags & 1) != 0 || globalExportFilter != null;
        }
        if (propName.equals("SecurityParent")) {
            return true;
        }
        if (propName.equals("Name")) {
            return true;
        }
        if (propName.equals("This") || propName.equals("Owner") || propName.equals("Permissions") || propName.equals("TemplatePermissions") || card == Cardinality.ENUM && globalExportFilter == null) {
            return false;
        }
        if (globalExportFilter != null && cacheProp.getTypeID() == TypeID.OBJECT && (card == Cardinality.SINGLE || card == Cardinality.ENUM) && isPersistent) {
            ClassDescription classDesc = MetadataCacheIE.getClassDescription(eo, objStore);
            boolean include = ExportXML.filterProperty(classDesc, cacheProp.getPropertyDescription(), objStore);
            if (card == Cardinality.SINGLE) {
                globalRecursiveExport = include;
                if (ImportExportUtil.isAddOnExport(flags)) {
                    if (prop.getState().equals(PropertyState.NO_VALUE)) {
                        return false;
                    }
                    if (prop.getState().equals(PropertyState.UNEVALUATED)) {
                        Object propValue = prop.getObjectValue();
                        if (propValue instanceof SubListImpl) {
                            return ((SubListImpl)propValue).size() > 0;
                        }
                        return propValue != null;
                    }
                }
                return true;
            }
            globalRecursiveExport = false;
            return include;
        }
        if (isReadOnly && (flags & 0x80) == 0) {
            return false;
        }
        if (isPersistent) {
            boolean shouldExport = true;
            if (ImportExportUtil.isAddOnExport(flags)) {
                if (prop.getState().equals(PropertyState.VALUE)) {
                    Object propValue = prop.getObjectValue();
                    Object defaultValue = ExportXML.getDefaultValue(cacheProp);
                    if (defaultValue != null) {
                        shouldExport = !defaultValue.equals(propValue);
                    } else if (propValue instanceof Boolean) {
                        shouldExport = (Boolean)propValue;
                    }
                } else if (prop.getState().equals(PropertyState.NO_VALUE)) {
                    shouldExport = false;
                } else if (prop.getState().equals(PropertyState.UNEVALUATED)) {
                    Object propValue = prop.getObjectValue();
                    shouldExport = propValue instanceof SubListImpl ? ((SubListImpl)propValue).size() > 0 : propValue != null;
                }
            }
            return shouldExport;
        }
        return false;
    }

    private static Object getDefaultValue(CachePropIE cacheProp) {
        TypeID typeID = cacheProp.getTypeID();
        switch (typeID.getValue()) {
            case 1: {
                return ((PropertyDescriptionBinary)cacheProp.getPropertyDescription()).get_PropertyDefaultBinary();
            }
            case 2: {
                return ((PropertyDescriptionBoolean)cacheProp.getPropertyDescription()).get_PropertyDefaultBoolean();
            }
            case 3: {
                return ((PropertyDescriptionDateTime)cacheProp.getPropertyDescription()).get_PropertyDefaultDateTime();
            }
            case 4: {
                return ((PropertyDescriptionFloat64)cacheProp.getPropertyDescription()).get_PropertyDefaultFloat64();
            }
            case 5: {
                return ((PropertyDescriptionId)cacheProp.getPropertyDescription()).get_PropertyDefaultId();
            }
            case 6: {
                return ((PropertyDescriptionInteger32)cacheProp.getPropertyDescription()).get_PropertyDefaultInteger32();
            }
            case 8: {
                return ((PropertyDescriptionString)cacheProp.getPropertyDescription()).get_PropertyDefaultString();
            }
        }
        return null;
    }

    private static boolean shouldExportPropDefProperty(CachePropIE cacheProp, EngineObject eo, int flags) {
        boolean shouldExport = true;
        String propName = cacheProp.getName();
        if (eo instanceof PropertyDefinition) {
            shouldExport = false;
            if (propName.equals("PrimaryId")) {
                shouldExport = true;
            } else if (propName.equals("Name")) {
                shouldExport = true;
            } else if (ImportExportUtil.isAddOnExport(flags) && propName.equals("PropertyTemplate")) {
                shouldExport = false;
            } else {
                boolean isSettable;
                boolean systemProp = ((PropertyDefinition)eo).get_IsSystemOwned();
                Cardinality card = ((PropertyDefinition)eo).get_Cardinality();
                boolean persistent = true;
                PropertyPersistence persistenceType = ((PropertyDefinition)eo).get_PersistenceType();
                if (persistenceType == PropertyPersistence.NOT_PERSISTENT) {
                    persistent = false;
                }
                if (ExportXML.isPropertyWriteable(cacheProp, systemProp, card, persistent, isSettable = eo.getProperties().get(cacheProp.getName()).isSettable())) {
                    shouldExport = true;
                }
            }
        }
        return shouldExport;
    }

    private static boolean isPropertyWriteable(CachePropIE cacheProp, boolean systemProp, Cardinality card, boolean persistent, boolean isSettable) {
        boolean writeable = true;
        String propName = cacheProp.getName();
        if (systemProp) {
            if (propName.equals("RequiredClassId") || propName.equals("ReflectivePropertyId") || propName.equals("DeletionAction")) {
                if (!persistent || propName.equals("This")) {
                    writeable = false;
                }
            } else if (!ExportXML.isDefaultValueProp(propName) || !isSettable) {
                writeable = false;
            }
        } else if (ExportXML.isDefaultValueProp(propName) && card != Cardinality.SINGLE) {
            writeable = false;
        } else if (propName.equals("ChoiceList") && card == Cardinality.ENUM) {
            writeable = false;
        } else if (propName.equals("Name") && card == Cardinality.ENUM) {
            writeable = false;
        } else if (propName.equals("Name") && card != Cardinality.SINGLE) {
            writeable = false;
        }
        return writeable;
    }

    private static boolean isDefaultValueProp(String propName) {
        boolean DefaultValue = false;
        if (propName.equals("PropertyDefaultBinary") || propName.equals("PropertyDefaultBoolean") || propName.equals("PropertyDefaultDateTime") || propName.equals("PropertyDefaultFloat64") || propName.equals("PropertyDefaultId") || propName.equals("PropertyDefaultInteger32") || propName.equals("PropertyDefaultObject") || propName.equals("PropertyDefaultString")) {
            DefaultValue = true;
        }
        return DefaultValue;
    }

    private static boolean shouldExportObject(EngineObject eo) {
        boolean exportObject = true;
        if (eo instanceof PropertyDefinition) {
            exportObject = false;
            PropertyDefinition propDef = (PropertyDefinition)eo;
            Id ptId = propDef.get_PrimaryId();
            Id ptAuditAsId = propDef.getProperties().getIdValue("AuditAs");
            if (!(exportedPropertyTemplates == null || exportedPropertyTemplates.contains(ptId) || ptAuditAsId != null && exportedPropertyTemplates.contains(ptAuditAsId))) {
                return false;
            }
            String symbolicName = propDef.get_SymbolicName();
            Cardinality card = propDef.get_Cardinality();
            boolean persistent = true;
            PropertyPersistence persistenceType = propDef.get_PersistenceType();
            if (persistenceType == PropertyPersistence.NOT_PERSISTENT) {
                persistent = false;
            }
            boolean systemOwned = propDef.get_IsSystemOwned();
            boolean isSettable = true;
            TypeID type = propDef.get_DataType();
            if (type == TypeID.OBJECT) {
                isSettable = eo.getProperties().get("PropertyDefaultObject").isSettable();
            } else if (type == TypeID.STRING) {
                isSettable = eo.getProperties().get("PropertyDefaultString").isSettable();
            } else if (type == TypeID.BOOLEAN) {
                isSettable = eo.getProperties().get("PropertyDefaultBoolean").isSettable();
            } else if (type == TypeID.DATE) {
                isSettable = eo.getProperties().get("PropertyDefaultDateTime").isSettable();
            } else if (type == TypeID.GUID) {
                isSettable = eo.getProperties().get("PropertyDefaultId").isSettable();
            } else if (type == TypeID.DOUBLE) {
                isSettable = eo.getProperties().get("PropertyDefaultFloat64").isSettable();
            } else if (type == TypeID.LONG) {
                isSettable = eo.getProperties().get("PropertyDefaultInteger32").isSettable();
            } else if (type == TypeID.BINARY) {
                isSettable = eo.getProperties().get("PropertyDefaultBinary").isSettable();
            }
            if (!systemOwned || isSettable || type == TypeID.OBJECT && card != Cardinality.LIST && persistent && !symbolicName.equals("This")) {
                exportObject = true;
            }
        } else if (eo instanceof CmChangePreprocessorDefinition) {
            Id cpaId;
            CmChangePreprocessorDefinition cppDef = (CmChangePreprocessorDefinition)eo;
            CmChangePreprocessorAction cpa = cppDef.get_ChangePreprocessorAction();
            if (exportedChangePreprocessorActions != null && cpa != null && !exportedChangePreprocessorActions.contains(cpaId = cpa.get_Id())) {
                exportObject = false;
            }
        }
        return exportObject;
    }

    private static void enumPropertyExport(EngineCollection eoc, Element exportXMLNode, int flags, String externalContentURL, int recursionDepth, Document xmlDoc) {
        Iterator iter = eoc.iterator();
        while (iter.hasNext()) {
            EngineObject eo = (EngineObject)iter.next();
            Integer objType = MetadataCacheIE.getObjectType(eo);
            Element manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
            String subId = eo.getProperties().getIdValue("Id").toString();
            boolean duplicate = ExportXML.prepareToExportNewObject(manifestNode, subId);
            String symbolicName = "";
            if (duplicate || manifestNode == null) continue;
            if (symbolicName.length() == 0) {
                ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
                ClassDescription cd = MetadataCacheIE.getClassDescription(eo, objStore);
                symbolicName = cd.get_SymbolicName();
            }
            Element classNode = xmlDoc.createElement(symbolicName);
            Element classPropertiesNode = xmlDoc.createElement(symbolicName + "Properties");
            classNode.appendChild(classPropertiesNode);
            manifestNode.appendChild(classNode);
            try {
                ExportXML.independentlyPersistableExport(eo, classPropertiesNode, flags, externalContentURL, xmlDoc, recursionDepth);
            }
            catch (Exception e) {
                manifestNode.removeChild(classNode);
            }
        }
    }

    private static void exportSubscriptions(Element exportXMLNode, ObjectStore objStore, ClassDescription classDesc, int flags, Document xmlDoc) {
        SearchSQL sql = new SearchSQL();
        sql.setFromClauseInitialValue("Subscription", null, true);
        String whereClause = "SubscriptionTarget = Object('" + classDesc.get_Id().toString() + "')";
        sql.setWhereClause(whereClause);
        SearchScope ss = new SearchScope(objStore);
        IndependentObjectSet objs = ss.fetchObjects(sql, null, new PropertyFilter(), null);
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            String subId;
            EngineObject eo = (EngineObject)iter.next();
            Integer objType = MetadataCacheIE.getObjectType(eo);
            Element manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
            boolean duplicate = ExportXML.prepareToExportNewObject(manifestNode, subId = eo.getProperties().getIdValue("Id").toString());
            if (duplicate || manifestNode == null) continue;
            ClassDescription cd = MetadataCacheIE.getClassDescription(eo, objStore);
            Element classNode = xmlDoc.createElement(cd.get_SymbolicName());
            Element classPropertiesNode = xmlDoc.createElement(cd.get_SymbolicName() + "Properties");
            classNode.appendChild(classPropertiesNode);
            ExportXML.independentlyPersistableExport(eo, classPropertiesNode, flags, null, xmlDoc, 0);
            manifestNode.appendChild(classNode);
        }
        ss = null;
    }

    private static void exportMetadata(Element exportXMLNode, ObjectStore objStore, ClassDescription classDesc, int flags, Document xmlDoc) {
        Id classId = classDesc.get_Id();
        ClassDefinition classDef = Factory.ClassDefinition.fetchInstance(objStore, classId, ImportExportUtil.propFilter());
        if (classDef != null) {
            Integer objType = MetadataCacheIE.getObjectType(classDef);
            Element manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
            boolean duplicate = ExportXML.prepareToExportNewObject(manifestNode, classId.toString());
            if (!duplicate && manifestNode != null) {
                ClassDescription cdCDef = null;
                cdCDef = classDef.getProperties().isPropertyPresent("ClassDescription") ? classDef.get_ClassDescription() : MetadataCacheIE.getClassDescription(classDef, objStore);
                Element classNode = xmlDoc.createElement(cdCDef.get_SymbolicName());
                Element classPropertiesNode = xmlDoc.createElement(cdCDef.get_SymbolicName() + "Properties");
                classNode.appendChild(classPropertiesNode);
                ExportXML.independentlyPersistableExport(classDef, classPropertiesNode, flags, null, xmlDoc, 0);
                manifestNode.appendChild(classNode);
            }
            PropertyDefinitionList pdl = classDef.get_PropertyDefinitions();
            for (PropertyDefinition pd : pdl) {
                ClassDescription cd;
                Property prop = pd.getProperties().get("PropertyTemplate");
                if (prop.getState() == PropertyState.VALUE || prop.getState() == PropertyState.REFERENCE) {
                    PropertyTemplate pt = (PropertyTemplate)prop.getObjectValue();
                    objType = MetadataCacheIE.getObjectType(pt);
                    manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
                    cd = null;
                    cd = pt.getProperties().isPropertyPresent("ClassDescription") ? pt.get_ClassDescription() : MetadataCacheIE.getClassDescription(pt, objStore);
                    String ptClassId = cd.get_Id().toString();
                    duplicate = ExportXML.prepareToExportNewObject(manifestNode, ptClassId);
                    Element classNode = xmlDoc.createElement(cd.get_SymbolicName());
                    Element classPropertiesNode = xmlDoc.createElement(cd.get_SymbolicName() + "Properties");
                    classNode.appendChild(classPropertiesNode);
                    ExportXML.independentlyPersistableExport(pt, classPropertiesNode, flags, null, xmlDoc, 0);
                    manifestNode.appendChild(classNode);
                }
                if ((prop = pd.getProperties().get("ChoiceList")).getState() != PropertyState.VALUE && prop.getState() != PropertyState.REFERENCE) continue;
                ChoiceList cl = (ChoiceList)prop.getObjectValue();
                objType = MetadataCacheIE.getObjectType(cl);
                manifestNode = ExportXML.locateInManifest(exportXMLNode, objType);
                cd = MetadataCacheIE.getClassDescription(cl, objStore);
                duplicate = ExportXML.prepareToExportNewObject(manifestNode, classId.toString());
                Element classNode = xmlDoc.createElement(cd.get_SymbolicName());
                Element classPropertiesNode = xmlDoc.createElement(cd.get_SymbolicName() + "Properties");
                classNode.appendChild(classPropertiesNode);
                ExportXML.independentlyPersistableExport(cl, classPropertiesNode, flags, null, xmlDoc, 0);
                manifestNode.appendChild(classNode);
            }
        }
    }

    private static void createExportManifestTemplate(Document xmlDoc, Element exportXMLNode) {
        for (int i = 0; i < exportTypes.length; ++i) {
            String nodeName = (String)exportTypes[i][0];
            Node node = ImportExportUtil.selectSingleNode(exportXMLNode, nodeName);
            if (node != null) continue;
            node = xmlDoc.createElement(nodeName);
            exportXMLNode.appendChild(node);
        }
    }

    private static boolean prepareToExportNewObject(Element manifestNode, String objectId) {
        boolean duplicate = false;
        if (manifestNode != null) {
            NodeList nodes = manifestNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                String nodeObjectId;
                if (nodes.item(i).getNodeType() == 3 || (nodeObjectId = ImportExportUtil.formatId(ExportXML.getObjectId(nodes.item(i)))) == null || !nodeObjectId.equalsIgnoreCase(objectId)) continue;
                duplicate = true;
                break;
            }
        }
        return duplicate;
    }

    private static String getObjectId(Node classNode) {
        String nodeId = "";
        String name = classNode.getNodeName() + "Properties";
        Node node = ImportExportUtil.selectSingleNode(classNode, name);
        if (node != null) {
            Node idNode = ImportExportUtil.selectSingleNode(node, "Id");
            if (idNode == null) {
                idNode = ImportExportUtil.selectSingleNode(node, "PrimaryId");
            }
            nodeId = ImportExportUtil.getNodeValue(idNode);
        }
        return nodeId;
    }

    private static boolean getApplicableFilters(ClassDescription classDesc) {
        boolean hasFilter = false;
        globalClassFilter = null;
        globalDefaultFilter = null;
        if (globalExportFilter == null) {
            return hasFilter;
        }
        do {
            if (!globalExportFilter.getNodeName().equalsIgnoreCase("ExportFilter")) {
                return hasFilter;
            }
            NodeList filters = globalExportFilter.getChildNodes();
            int filterCount = filters.getLength();
            for (int i = 0; i < filterCount; ++i) {
                String symName;
                Node filter = filters.item(i);
                if (filter.getNodeType() == 3 || !filter.getNodeName().equalsIgnoreCase("ObjectFilter")) continue;
                hasFilter = true;
                String id = ((Element)filter).getAttribute("Id");
                boolean filterFound = false;
                if (id != null && id.length() > 0) {
                    String classId = classDesc.get_Id().toString();
                    if (id != null && id.length() > 0 && classId.equalsIgnoreCase(id = ImportExportUtil.formatId(id))) {
                        globalClassFilter = (Element)filter;
                        filterFound = true;
                    }
                }
                if (filterFound || (symName = ((Element)filter).getAttribute("SymbolicName")) == null || symName.length() <= 0) continue;
                if (symName.equalsIgnoreCase(classDesc.get_SymbolicName())) {
                    globalClassFilter = (Element)filter;
                    continue;
                }
                if (!symName.equalsIgnoreCase("*")) continue;
                globalDefaultFilter = (Element)filter;
            }
            ClassDescription superClass = null;
            if (classDesc.getProperties().isPropertyPresent("SuperclassDescription")) {
                superClass = classDesc.get_SuperclassDescription();
            }
            classDesc = null;
            if (superClass == null) continue;
            classDesc = superClass;
        } while (globalClassFilter == null && classDesc != null);
        return hasFilter;
    }

    private static Element locateInManifest(Element baseNode, int objectType) {
        Node node = null;
        switch (objectType) {
            case 1160: 
            case 1162: {
                objectType = 1;
                break;
            }
            case 1165: 
            case 1166: {
                objectType = 1144;
            }
        }
        String nodeName = "Others";
        for (int i = 0; i < exportTypes.length; ++i) {
            int exportObjType = (Integer)exportTypes[i][1];
            if (objectType != exportObjType) continue;
            nodeName = (String)exportTypes[i][0];
            break;
        }
        if ((node = ImportExportUtil.selectSingleNode(baseNode, nodeName)) == null) {
            Document xmlDoc = baseNode.getOwnerDocument();
            Element rootElement = xmlDoc.getDocumentElement();
            node = ImportExportUtil.selectSingleNode(rootElement, nodeName);
        }
        return (Element)node;
    }

    private static boolean filterProperty(ClassDescription classDesc, PropertyDescription pd, ObjectStore objStore) {
        ExportXML.getApplicableFilters(classDesc);
        Element classFilter = globalClassFilter;
        Element defaultFilter = globalDefaultFilter;
        if (classFilter != null || defaultFilter != null) {
            if (classFilter != null) {
                if (ExportXML.traverseList(classFilter, pd, false)) {
                    return false;
                }
                if (ExportXML.traverseList(classFilter, pd, true)) {
                    return true;
                }
            }
            if (defaultFilter != null) {
                if (ExportXML.traverseList(defaultFilter, pd, false)) {
                    return false;
                }
                if (ExportXML.traverseList(defaultFilter, pd, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean traverseList(Element filter, PropertyDescription pd, boolean include) {
        boolean propertyFound = false;
        Node exInNode = null;
        String id = pd.get_Id().toString();
        String symName = pd.get_SymbolicName();
        exInNode = include ? ImportExportUtil.selectSingleNode(filter, "IncludeProperties") : ImportExportUtil.selectSingleNode(filter, "ExcludeProperties");
        if (exInNode != null) {
            NodeList propNodes = exInNode.getChildNodes();
            int cNodes = propNodes.getLength();
            for (int i = 0; i < cNodes; ++i) {
                String filterSymName;
                if (propNodes.item(i).getNodeType() == 3) continue;
                Element elem = (Element)propNodes.item(i);
                String filterId = elem.getAttribute("Id");
                if (filterId != null && filterId.length() > 0 && id != null && filterId.equalsIgnoreCase(id)) {
                    propertyFound = true;
                    break;
                }
                if (propertyFound || (filterSymName = elem.getAttribute("SymbolicName")) == null || filterSymName.length() <= 0) continue;
                if (symName.equalsIgnoreCase("*") && !include) {
                    propertyFound = true;
                    break;
                }
                if (!filterSymName.equalsIgnoreCase(symName)) continue;
                propertyFound = true;
                break;
            }
        }
        return propertyFound;
    }

    private static String getFilterCriteria(String optionName) {
        String criteria = null;
        Node expOptsNode = ImportExportUtil.selectSingleNode(globalExportFilter, "ExportOptions");
        if (expOptsNode != null && expOptsNode.hasAttributes()) {
            criteria = ((Element)expOptsNode).getAttribute(optionName);
        }
        return criteria;
    }

    private static boolean getFilterOptions(String optionName) {
        String value;
        boolean option = false;
        Node expOptsNode = ImportExportUtil.selectSingleNode(globalExportFilter, "ExportOptions");
        if (expOptsNode != null && expOptsNode.hasAttributes() && (value = ((Element)expOptsNode).getAttribute(optionName)).equalsIgnoreCase("true")) {
            option = true;
        }
        return option;
    }

    private static String formatXMLString(String inString) {
        if (inString == null) {
            return inString;
        }
        StringBuffer xml = new StringBuffer();
        int len = inString.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = inString.charAt(i);
            switch (c) {
                case '&': {
                    xml.append("&amp;");
                    continue block6;
                }
                case '<': {
                    xml.append("&lt;");
                    continue block6;
                }
                case '>': {
                    xml.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    xml.append("&quot;");
                    continue block6;
                }
                default: {
                    xml.append(c);
                }
            }
        }
        return xml.toString();
    }

    private static HashSet<Id> getExportedPropertyTemplates(Document xmlDoc) {
        return ExportXML.getExportedIdsOfTemplate(xmlDoc, "PropertyTemplates");
    }

    private static HashSet<Id> getExportedChangePreprocessorActions(Document xmlDoc) {
        return ExportXML.getExportedIdsOfTemplate(xmlDoc, "CmChangePreprocessorActions");
    }

    private static HashSet<Id> getExportedIdsOfTemplate(Document xmlDoc, String templateName) {
        Node pts;
        HashSet<Id> exportedObjs = new HashSet<Id>();
        Node objManifest = ImportExportUtil.selectSingleNode(xmlDoc, "ObjectManifest");
        if (objManifest != null && (pts = ImportExportUtil.selectSingleNode(objManifest, templateName)) != null) {
            NodeList ptsNodes = pts.getChildNodes();
            block0: for (int i = 0; ptsNodes != null && i < ptsNodes.getLength(); ++i) {
                Node ptProps = ptsNodes.item(i);
                if (ptProps == null) continue;
                NodeList propNodes = ptProps.getChildNodes();
                for (int j = 0; propNodes != null && j < propNodes.getLength(); ++j) {
                    Node valNode;
                    Node propNode = propNodes.item(j);
                    if (propNode == null) continue;
                    Node idNode = ImportExportUtil.selectSingleNode(propNode, "Id");
                    if (idNode == null || (valNode = idNode.getFirstChild()) == null) continue block0;
                    exportedObjs.add(new Id(valNode.getNodeValue()));
                    continue block0;
                }
            }
        }
        return exportedObjs;
    }

    private static class PropertyExportComparator
    implements Comparator {
        private PropertyExportComparator() {
        }

        public int compare(Object prop1, Object prop2) {
            String name2;
            String name1 = ((Property)prop1).getPropertyName();
            if (name1.equals(name2 = ((Property)prop2).getPropertyName())) {
                return 0;
            }
            if (name1.equals("SymbolicName")) {
                return -1;
            }
            if (name2.equals("SymbolicName")) {
                return 1;
            }
            if (name1.equals("DisplayName")) {
                return -1;
            }
            if (name2.equals("DisplayName")) {
                return 1;
            }
            if (name1.equals("Name")) {
                return -1;
            }
            if (name2.equals("Name")) {
                return 1;
            }
            if (name1.equals("ContainmentName")) {
                return -1;
            }
            if (name2.equals("ContainmentName")) {
                return 1;
            }
            if (name1.equals("Id")) {
                return -1;
            }
            if (name2.equals("Id")) {
                return 1;
            }
            if (name1.equals("PrimaryId")) {
                return -1;
            }
            if (name2.equals("PrimaryId")) {
                return 1;
            }
            if (name1.equals("DescriptiveTexts")) {
                return 1;
            }
            if (name2.equals("DescriptiveTexts")) {
                return -1;
            }
            if (name1.equals("DisplayNames")) {
                return 1;
            }
            if (name2.equals("DisplayNames")) {
                return -1;
            }
            return name1.compareTo(name2);
        }
    }
}

