/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.authentication.util.B64;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

public class J2EEUtilWSBase
extends J2EEUtil {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtilWSBase.class, SubSystem.API);
    private static boolean enableLegacyLTPA = ConfigValueLookup.getValueAsBoolean("com.filenet.authentication.enableLegacyLtpa", false);
    private static boolean allowAuthTokenFromAmbientSubject = ConfigValueLookup.getValueAsBoolean("com.filenet.authentication.allowAuthTokenFromAmbientSubject", false);
    protected static Class<?> doAsClass;
    protected static Method doAsMethod;
    protected static Method getSubjectMethod;
    protected static Method getRunAsSubjectMethod;
    protected static Method getAccessTokenMethod;
    protected static Method getSSOCookieMethod;
    protected static Method getIdTokenMethod;
    protected static String MAPPING_ALIAS_KEY;
    protected static Method j2caFactoryGetInstanceMethod;
    protected static Method j2caGetCallbackHandlerMethod;

    protected static void handleException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)cause;
        }
        if (e instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)e;
        }
        if (e instanceof InvocationTargetException && cause instanceof RuntimeException && cause.getCause() instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)cause.getCause();
        }
        throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
    }

    @Override
    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return doAsMethod.invoke(null, sub, pa);
        }
        catch (Exception e) {
            J2EEUtilWSBase.handleException(e);
            return null;
        }
    }

    @Override
    protected Subject getCurrentAmbientSubject() {
        Subject sub = super.getCurrentAmbientSubject();
        if (sub == null) {
            try {
                sub = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
                if (sub != null && logger.isDetailTraceEnabled()) {
                    if (sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
                        this.trace("getCurrentAmbientSubject", "got subject from runAs subject: {0}", sub);
                    } else {
                        Object[] principals = sub.getPrincipals().toArray();
                        this.trace("getCurrentAmbientSubject", "got subject from runAs subject: {0}", (Principal)principals[0]);
                    }
                } else if (sub == null && (sub = (Subject)getSubjectMethod.invoke(null, (Object[])null)) != null && logger.isDetailTraceEnabled()) {
                    if (sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
                        this.trace("getCurrentAmbientSubject", "got subject from caller subject: {0}", sub);
                    } else {
                        Object[] principals = sub.getPrincipals().toArray();
                        this.trace("getCurrentAmbientSubject", "got subject from caller subject: {0}", (Principal)principals[0]);
                    }
                }
                if (sub == null) {
                    this.trace("getCurrentAmbientSubject", "Unable to get subject", new Object[0]);
                }
            }
            catch (Exception e) {
                J2EEUtilWSBase.handleException(e);
            }
        }
        return sub;
    }

    @Override
    protected Subject getLegacyAmbientSubject() {
        Subject sub = super.getLegacyAmbientSubject();
        if (sub == null) {
            try {
                sub = (Subject)getSubjectMethod.invoke(null, (Object[])null);
                if (sub != null && logger.isDetailTraceEnabled()) {
                    this.trace("getLegacyAmbientSubject", "got subject from caller subject: {0}", sub);
                } else if (sub == null && (sub = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null)) != null && logger.isDetailTraceEnabled()) {
                    this.trace("getLegacyAmbientSubject", "got subject from runAs subject: {0}", sub);
                }
                if (sub == null && logger.isDetailTraceEnabled()) {
                    this.trace("getLegacyAmbientSubject", "Unable to get subject", new Object[0]);
                }
            }
            catch (Exception e) {
                J2EEUtilWSBase.handleException(e);
            }
        }
        return sub;
    }

    @Override
    protected String getCurrentLTPATokenFromSubject(Subject sub) {
        String ltpaToken = null;
        try {
            ltpaToken = (String)this.doAs(sub, new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return J2EEUtilWSBase.this.getSecurityTokenFromCookie();
                }
            });
        }
        catch (Exception e) {
            this.trace("getCurrentLTPATokenFromSubject", "Got exception trying to get LTPA token from Cookie using passed-in Subject.  {0}", e);
            ltpaToken = null;
        }
        if (ltpaToken != null) {
            this.trace("getCurrentLTPATokenFromSubject", "Got LTPA token from Cookie using passed-in Subject.", new Object[0]);
            if (logger.isDetailTraceEnabled()) {
                String ambientLtpaToken = this.getSecurityTokenFromCookie();
                if (ltpaToken.contentEquals(ambientLtpaToken)) {
                    this.trace("getCurrentLTPATokenFromSubject", "LTPA from passed-in Subject cookie same as from ambient subject", new Object[0]);
                } else {
                    this.trace("getCurrentLTPATokenFromSubject", "LTPA from passed-in Subject cookie is different than from ambient subject: {0}", ambientLtpaToken);
                }
            }
        } else {
            ltpaToken = this.getSecurityTokenFromSubject(sub);
            if (ltpaToken != null) {
                this.trace("getCurrentLTPATokenFromSubject", "Got LTPA token from passed-in Subject.", new Object[0]);
            } else if (allowAuthTokenFromAmbientSubject && (ltpaToken = this.getSecurityTokenFromCookie()) != null) {
                this.trace("getCurrentLTPATokenFromSubject", "Got LTPA token from Cookie using Subject on current thread.", new Object[0]);
            } else {
                ltpaToken = this.getSSOLTPATokenFromSubject(sub);
                if (ltpaToken != null) {
                    this.trace("getCurrentLTPATokenFromSubject", "Got LTPA token w/in doAs using the passed in subject.", new Object[0]);
                } else if (allowAuthTokenFromAmbientSubject && (ltpaToken = this.getSSOLTPAToken()) != null) {
                    this.trace("getCurrentLTPATokenFromSubject", "Got LTPA token w/in doAs using the current runAs subject.", new Object[0]);
                } else {
                    this.trace("getCurrentLTPATokenFromSubject", "Unable to get LTPA token from subject", new Object[0]);
                }
            }
        }
        return ltpaToken;
    }

    @Override
    protected String getLegacyLTPATokenFromSubject() {
        String ltpaToken = this.getSecurityToken();
        this.trace("getLegacyLTPATokenFromSubject", "From getSecurityToken, got ltpaToken={0}", ltpaToken);
        if (ltpaToken == null) {
            ltpaToken = this.getSSOLTPAToken();
            this.trace("getLegacyLTPATokenFromSubject", "From getSSOLTPAToken, got ltpaToken={0}", ltpaToken);
        }
        return ltpaToken;
    }

    private String getSSOLTPATokenFromSubject(Subject sub) {
        String ltpaToken = null;
        SingleSignonToken ssoToken = this.getSSOTokenFromSubject(sub);
        this.trace("getSSOLTPATokenFromSubject", "Got ssoToken: {0}", ssoToken);
        if (ssoToken != null) {
            byte[] ssoTokenBytes = ssoToken.getBytes();
            ltpaToken = B64.encodeToString(ssoTokenBytes);
        }
        return ltpaToken;
    }

    private SingleSignonToken getSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            this.trace("getSSOTokenFromSubject", "No subject provided.", new Object[0]);
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<SingleSignonToken>(){

            @Override
            public SingleSignonToken run() {
                Set<SingleSignonToken> ssoTokens = subject.getPrivateCredentials(SingleSignonToken.class);
                for (SingleSignonToken ssoToken : ssoTokens) {
                    J2EEUtilWSBase.this.trace("getSSOTokenFromSubject", "sso Token Name is={0}", new Object[]{ssoToken.getName()});
                    if (!ssoToken.getName().equals("LtpaToken")) continue;
                    J2EEUtilWSBase.this.trace("getSSOTokenFromSubject", "sso Token is={0}", new Object[]{ssoToken});
                    return ssoToken;
                }
                return null;
            }
        });
    }

    private String getSecurityToken() {
        if (getSSOCookieMethod != null && !enableLegacyLTPA) {
            try {
                Cookie cookie = (Cookie)getSSOCookieMethod.invoke(null, (Object[])null);
                if (cookie != null) {
                    String ltpaToken = cookie.getValue();
                    this.trace("getSecurityToken", "Got LTPA token from SSOCookie: {0}", ltpaToken);
                    return ltpaToken;
                }
            }
            catch (Exception e) {
                this.trace("getSecurityToken", "Unable to get LTPA token from SSOCookie: {0}", e);
            }
        }
        this.trace("getSecurityToken", "Using legacy method of obtaining LTPA token.", new Object[0]);
        byte[] token = null;
        try {
            Subject security_subject = null;
            try {
                security_subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                J2EEUtilWSBase.handleException(e);
            }
            if (security_subject != null) {
                Set<WSCredential> security_credentials = security_subject.getPublicCredentials(WSCredential.class);
                WSCredential security_credential = security_credentials.iterator().next();
                String user = security_credential.getSecurityName();
                if (user.equalsIgnoreCase("UNAUTHENTICATED")) {
                    this.trace("getSecurityToken", "Unable to get LTPA token from unauthenticated user {0}", user);
                    return null;
                }
                token = security_credential.getCredentialToken();
                this.trace("getSecurityToken", "Credential Token is={0}", new Object[]{token});
                if (token == null) {
                    return null;
                }
                String ltpaToken = B64.encodeToString(token);
                this.trace("getSecurityToken", "Got LTPA token using legacy method: {0}", ltpaToken);
                return ltpaToken;
            }
        }
        catch (Exception e) {
            J2EEUtilWSBase.handleException(e);
        }
        return null;
    }

    private String getSecurityTokenFromSubject(Subject sub) {
        if (sub == null) {
            this.trace("getSecurityTokenFromSubject", "No subject provided.", new Object[0]);
            return null;
        }
        byte[] token = null;
        try {
            Set<WSCredential> securityCredentials = sub.getPublicCredentials(WSCredential.class);
            Iterator<WSCredential> securityCredentialIter = securityCredentials.iterator();
            if (securityCredentialIter.hasNext()) {
                while (securityCredentialIter.hasNext()) {
                    WSCredential wsCred = securityCredentialIter.next();
                    String user = wsCred.getSecurityName();
                    if (user.equalsIgnoreCase("UNAUTHENTICATED")) {
                        this.trace("getSecurityTokenFromSubject", "unauthenticated user is {0}", user);
                        continue;
                    }
                    token = wsCred.getCredentialToken();
                    if (token == null) {
                        this.trace("getSecurityTokenFromSubject", "null credential token for {0}", user);
                        continue;
                    }
                    this.trace("getSecurityTokenFromSubject", "Got credential token for {0}", user);
                    break;
                }
            } else {
                this.trace("getSecurityTokenFromSubject", "No WSCredentails in subject.", new Object[0]);
            }
            if (token == null) {
                this.trace("getSecurityTokenFromSubject", "No credential token found.", new Object[0]);
                return null;
            }
            String ltpaToken = B64.encodeToString(token);
            this.trace("getSecurityTokenFromSubject", "Got LTPAToken: {0}", ltpaToken);
            return ltpaToken;
        }
        catch (Exception e) {
            logger.warn("getSecurityTokenFromSubject: Unable to get security token from subject: " + e);
            return null;
        }
    }

    private String getSecurityTokenFromCookie() {
        try {
            Cookie cookie = (Cookie)getSSOCookieMethod.invoke(null, (Object[])null);
            if (cookie != null) {
                String ltpaToken = cookie.getValue();
                this.trace("getSecurityTokenFromCookie", "Got LTPAToken: {0}", ltpaToken);
                return ltpaToken;
            }
        }
        catch (Exception e) {
            this.trace("getSecurityTokenFromCookie", "Unable to get SSO cookie from WebSecurityHelper: {0}", e);
        }
        return null;
    }

    private String getSSOLTPAToken() {
        Subject subject = null;
        try {
            subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            J2EEUtilWSBase.handleException(e);
        }
        SingleSignonToken ssoToken = this.getSSOTokenFromSubject(subject);
        this.trace("getSSOLTPAToken", "Got SingleSignonToken.", new Object[0]);
        String ssoTokenStr = null;
        if (ssoToken != null) {
            byte[] ssoTokenBytes = ssoToken.getBytes();
            ssoTokenStr = B64.encodeToString(ssoTokenBytes);
        }
        this.trace("getSSOLTPAToken", "Got LTPAToken: {0}", ssoTokenStr);
        return ssoTokenStr;
    }

    @Override
    public String getSSOCookieName() {
        String cookieName = "ltpaToken2";
        boolean cookieNameFromSecurityHelper = false;
        if (getSSOCookieMethod != null) {
            try {
                Cookie cookie = (Cookie)getSSOCookieMethod.invoke(null, (Object[])null);
                if (cookie != null) {
                    cookieName = cookie.getName();
                    cookieNameFromSecurityHelper = true;
                }
            }
            catch (Exception e) {
                this.trace("getSSOCookieName", "Unable to get SSO cookie name from WebSecurityHelper: {0}", e);
            }
        }
        if (logger.isDetailTraceEnabled()) {
            if (cookieNameFromSecurityHelper) {
                this.trace("getSSOCookieName", "Using cookie name from WebSecurityHelper: {0}", cookieName);
            } else {
                this.trace("getSSOCookieName", "Using default cookie name: {0}", cookieName);
            }
        }
        return cookieName;
    }

    @Override
    protected String getCurrentOIDCTokenFromSubject(Subject sub) {
        String ssoToken = null;
        if (getIdTokenMethod != null) {
            try {
                ssoToken = (String)this.doAs(sub, new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return J2EEUtilWSBase.this.getOIDCTokenFromWebSphereHelper();
                    }
                });
            }
            catch (Exception e) {
                this.trace("getCurrentOIDCTokenFromSubject", "Got exception trying to get OIDC token from WebSphereHelper using passed-in Subject.  {0}", e);
                ssoToken = null;
            }
        }
        if (ssoToken != null) {
            this.trace("getCurrentOIDCTokenFromSubject", "Got OIDC token from WebSphereHelper using passed-in Subject.", new Object[0]);
        } else {
            ssoToken = this.getJWTTokenFromSubject(sub, "id_token");
            if (ssoToken != null) {
                this.trace("getCurrentOIDCTokenFromSubject", "Got OIDC token from passed-in Subject.", new Object[0]);
            } else if (allowAuthTokenFromAmbientSubject && (ssoToken = this.getJWTTokenFromSubject("id_token")) != null) {
                this.trace("getCurrentOIDCTokenFromSubject", "Got OIDC token from ambient Subject.", new Object[0]);
            } else {
                this.trace("getCurrentOIDCTokenFromSubject", "No OIDC token found", new Object[0]);
            }
        }
        return ssoToken;
    }

    @Override
    protected String getLegacyOIDCTokenFromSubject() {
        String ssoToken = null;
        ssoToken = this.getOIDCTokenFromWebSphereHelper();
        if (ssoToken == null) {
            Subject subject = null;
            try {
                subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
                if (subject == null) {
                    subject = this.getLegacyAmbientSubject();
                }
                if (subject == null) {
                    this.trace("getLegacyOIDCTokenFromSubject", "Unable to get subject", new Object[0]);
                    return null;
                }
            }
            catch (Exception e) {
                this.trace("getLegacyOIDCTokenFromSubject", "Unable to get subject: {0}", e);
                return null;
            }
            ssoToken = this.getJWTTokenFromSubject(subject, "id_token");
            this.trace("getLegacyOIDCTokenFromSubject", "Got ssoToken: {0}", ssoToken);
        }
        return ssoToken;
    }

    private String getOIDCTokenFromWebSphereHelper() {
        if (getIdTokenMethod != null) {
            try {
                String idToken = (String)getIdTokenMethod.invoke(null, (Object[])null);
                if (idToken != null) {
                    this.trace("getOIDCTokenFromWebSphereHelper", "got OIDC token using {0}.", getIdTokenMethod.getDeclaringClass().getSimpleName());
                    return idToken;
                }
            }
            catch (Exception e) {
                this.trace("getOIDCTokenFromWebSphereHelper", "Unable to use {0} to get OIDC token: {1}", getAccessTokenMethod.getDeclaringClass().getSimpleName(), e);
            }
        }
        return null;
    }

    @Override
    protected String getCurrentOAuthTokenFromSubject(Subject sub) {
        String ssoToken = null;
        try {
            ssoToken = (String)this.doAs(sub, new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return J2EEUtilWSBase.this.getOAuthTokenFromWebSphereHelper();
                }
            });
        }
        catch (Exception e) {
            this.trace("getCurrentOAuthTokenFromSubject", "Got exception trying to get OAuth token from WebSphereHelper using passed-in Subject.  {0}", e);
            ssoToken = null;
        }
        if (ssoToken != null) {
            this.trace("getCurrentOAuthTokenFromSubject", "Got OAuth token from WebSphereHelper using passed-in Subject.", new Object[0]);
        } else {
            ssoToken = this.getJWTTokenFromSubject(sub, "access_token");
            if (ssoToken != null) {
                this.trace("getCurrentOAuthTokenFromSubject", "Got OAuth token from passed-in Subject.", new Object[0]);
            } else if (allowAuthTokenFromAmbientSubject && (ssoToken = this.getJWTTokenFromSubject("access_token")) != null) {
                this.trace("getCurrentOAuthTokenFromSubject", "Got OAuth token from ambient subject.", new Object[0]);
            } else {
                this.trace("getCurrentOAuthTokenFromSubject", "No OAuth token found", new Object[0]);
            }
        }
        return ssoToken;
    }

    @Override
    protected String getLegacyOAuthTokenFromSubject() {
        String ssoToken = this.getOAuthTokenFromWebSphereHelper();
        if (ssoToken == null) {
            Subject subject = null;
            try {
                subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
                if (subject == null) {
                    subject = this.getLegacyAmbientSubject();
                }
                if (subject == null) {
                    this.trace("getLegacyOAuthTokenFromSubject", "Unable to get subject", new Object[0]);
                    return null;
                }
            }
            catch (Exception e) {
                this.trace("getLegacyOAuthTokenFromSubject", "Unable to get subject: {0}", e);
                return null;
            }
            ssoToken = this.getJWTTokenFromSubject(subject, "access_token");
        }
        this.trace("getLegacyOAuthTokenFromSubject", "Got ssoToken: {0}", ssoToken);
        return ssoToken;
    }

    private String getOAuthTokenFromWebSphereHelper() {
        if (getAccessTokenMethod != null) {
            try {
                String accessToken = (String)getAccessTokenMethod.invoke(null, (Object[])null);
                if (accessToken != null) {
                    this.trace("getOAuthTokenFromWebSphereHelper", "got OAuth token using {0}. ssoToken={1}", getAccessTokenMethod.getDeclaringClass().getSimpleName(), accessToken);
                    return accessToken;
                }
            }
            catch (Exception e) {
                this.trace("getOAuthTokenFromWebSphereHelper", "Unable to use {0} to get accessToken: {1}", getAccessTokenMethod.getDeclaringClass().getSimpleName(), e);
            }
        }
        return null;
    }

    private String getJWTTokenFromSubject(String tokenName) {
        Subject subject = null;
        try {
            subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
            if (subject == null) {
                subject = this.getCurrentAmbientSubject();
            }
            if (subject == null) {
                this.trace("getJWTTokenFromSubject", "Unable to get subject", new Object[0]);
                return null;
            }
        }
        catch (Exception e) {
            this.trace("getJWTTokenFromSubject", "Unable to get subject: {0}", e);
            return null;
        }
        String ssoToken = this.getJWTTokenFromSubject(subject, tokenName);
        this.trace("getJWTTokenFromSubject", "Got ssoToken: {0}", ssoToken);
        return ssoToken;
    }

    private String getJWTTokenFromSubject(final Subject subject, final String tokenName) {
        if (subject == null) {
            this.trace("getJWTTokenFromSubject", "No subject provided.", new Object[0]);
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String ssoToken = null;
                Set<Object> creds = subject.getPrivateCredentials();
                if (creds != null && creds.size() > 0) {
                    J2EEUtilWSBase.this.trace("getJWTTokenFromSubject", "Looking for jwt token: {0} in {1} private credential(s).", new Object[]{tokenName, creds.size()});
                    for (Object cred : creds) {
                        if (cred instanceof Hashtable) {
                            J2EEUtilWSBase.this.trace("getJWTTokenFromSubject", "Looking for jwt token in Hashtable credential", new Object[0]);
                            ssoToken = (String)((Hashtable)cred).get(tokenName);
                        } else if (cred instanceof Map) {
                            J2EEUtilWSBase.this.trace("getJWTTokenFromSubject", "Looking for jwt token in Map credential", new Object[0]);
                            ssoToken = (String)((Map)cred).get(tokenName);
                        } else {
                            J2EEUtilWSBase.this.trace("getJWTTokenFromSubject", "Unable to look for jwt token in {0} credential", new Object[]{cred.getClass().getSimpleName()});
                        }
                        if (ssoToken == null) continue;
                        break;
                    }
                }
                return ssoToken;
            }
        });
    }

    @Override
    protected String getCurrentRealmFromSubject(Subject sub) {
        String realm = null;
        realm = this.getSecurityRealmFromSubject(sub);
        if (realm != null) {
            this.trace("getCurrentRealmFromSubject", "Got realm [{0}] from passed-in subject.", realm);
        } else {
            realm = this.getLegacyRealmFromSubject();
            if (realm != null) {
                this.trace("getCurrentRealmFromSubject", "Got realm [{0}] from legacy subject.", realm);
            } else {
                this.trace("getCurrentRealmFromSubject", "No realm found in subject", new Object[0]);
            }
        }
        return realm;
    }

    @Override
    protected String getLegacyRealmFromSubject() {
        try {
            Subject security_subject = null;
            try {
                security_subject = (Subject)getRunAsSubjectMethod.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                J2EEUtilWSBase.handleException(e);
            }
            if (security_subject == null) {
                security_subject = this.getLegacyAmbientSubject();
            }
            return this.getSecurityRealmFromSubject(security_subject);
        }
        catch (Exception e) {
            logger.warn("J2EEUtilWSL.getLegacyRealmFromSubject: Unable to get Realm from subject: " + e);
            return null;
        }
    }

    private String getSecurityRealmFromSubject(Subject sub) {
        if (sub == null) {
            this.trace("getSecurityRealmFromSubject", "No subject provided.", new Object[0]);
            return null;
        }
        String realm = null;
        try {
            Set<WSCredential> securityCredentials = sub.getPublicCredentials(WSCredential.class);
            Iterator<WSCredential> securityCredentialIter = securityCredentials.iterator();
            if (securityCredentialIter.hasNext()) {
                while (securityCredentialIter.hasNext()) {
                    WSCredential wsCred = securityCredentialIter.next();
                    String user = wsCred.getSecurityName();
                    if (user.equalsIgnoreCase("UNAUTHENTICATED")) {
                        realm = wsCred.getRealmName();
                        this.trace("getSecurityRealmFromSubject", "Got realm [{0}] for unauthenticated user [{1}]", realm, user);
                        continue;
                    }
                    realm = wsCred.getRealmName();
                    this.trace("getSecurityRealmFromSubject", "Got realm [{0}] for authenticated user [{1}]", realm, user);
                    break;
                }
            }
            if (realm == null) {
                this.trace("getSecurityRealmFromSubject", "No realm found in subject.", new Object[0]);
                return null;
            }
            return realm;
        }
        catch (Exception e) {
            logger.warn("getSecurityRealmFromSubject: Unable to get realm from subject: " + e);
            return null;
        }
    }

    private void trace(String method, String message, Object ... params) {
        this.trace(J2EEUtilWSBase.class, method, message, params);
    }
}

