/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.LogFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingConfiguration {
    private static LogFormatter formatter;
    private static String configFile;
    private static ArrayList<Handler> globalHandlers;
    private ConcurrentHashMap<String, ArrayList<Handler>> subSystemHandlers = new ConcurrentHashMap();
    private static Properties configProperties;
    private static volatile long nextRefreshTime;
    private static long configFileLastModified;
    private static String logFileName;
    private static String logPath;
    private static FileHandler fileHandler;
    private static ArrayList<LoggingConfiguration> configInstances;
    private String settingsPrefix;
    private ArrayList<String> subSystemNames;
    private HashMap<String, String> subSystemLevelSettings = new HashMap();
    private volatile boolean subSystemReload = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingConfiguration(String prefix, ArrayList<String> subSystemNames) {
        this.settingsPrefix = prefix;
        this.subSystemNames = subSystemNames;
        ArrayList<LoggingConfiguration> arrayList = configInstances;
        synchronized (arrayList) {
            configInstances.add(this);
        }
        if (configFile != null) {
            LoggingConfiguration.reloadConfigFile();
        }
        LoggingConfiguration.getLogFile();
        this.readSubSystemSettings();
    }

    public static boolean hasLog() {
        return fileHandler != null;
    }

    public static FileHandler getLogHandler() {
        return fileHandler;
    }

    public static String getLogPath() {
        return logPath;
    }

    public static Formatter getFormatter() {
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        FileHandler fh = fileHandler;
        if (fh != null) {
            fileHandler = null;
            ((Handler)fh).close();
        }
        ArrayList<Object> arrayList = globalHandlers;
        synchronized (arrayList) {
            for (Handler h : globalHandlers) {
                try {
                    h.close();
                }
                catch (Throwable throwable) {}
            }
        }
        arrayList = configInstances;
        synchronized (arrayList) {
            for (int i = 0; i < configInstances.size(); ++i) {
                configInstances.get(i).closeHandlers();
            }
        }
    }

    public HashMap<String, String> getSubSystemLevels() {
        return this.subSystemLevelSettings;
    }

    public boolean refreshSettings() {
        if (configFile == null) {
            return false;
        }
        LoggingConfiguration.refreshCheck();
        if (this.subSystemReload) {
            this.readSubSystemSettings();
            return true;
        }
        return false;
    }

    public static String createFilePattern(String path, String file) {
        path = path.replace('\\', '/');
        if (file != null) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + file;
        }
        return path;
    }

    private static boolean reloadSettings() {
        nextRefreshTime = System.currentTimeMillis() + 300000L;
        try {
            if (LoggingConfiguration.reloadConfigFile()) {
                LoggingConfiguration.getLogFile();
                return true;
            }
        }
        catch (Throwable t) {
            System.err.println("com.filenet.logging Exception loading settings: " + t);
            nextRefreshTime = System.currentTimeMillis() + 10000L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void refreshCheck() {
        if (configFile == null) {
            return;
        }
        long currTime = System.currentTimeMillis();
        if (currTime <= nextRefreshTime) return;
        Class<LoggingConfiguration> clazz = LoggingConfiguration.class;
        synchronized (LoggingConfiguration.class) {
            if (currTime <= nextRefreshTime || !LoggingConfiguration.reloadSettings()) return;
            ArrayList<LoggingConfiguration> arrayList = configInstances;
            synchronized (arrayList) {
                for (int i = 0; i < configInstances.size(); ++i) {
                    LoggingConfiguration.configInstances.get((int)i).subSystemReload = true;
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private static synchronized boolean reloadConfigFile() {
        try {
            File cff = new File(configFile);
            if (!cff.exists() || cff.lastModified() <= configFileLastModified) {
                return false;
            }
            FileInputStream fis = new FileInputStream(cff);
            Properties props = new Properties();
            try {
                props.load(fis);
            }
            finally {
                fis.close();
            }
            configProperties = props;
            configFileLastModified = cff.lastModified();
            System.out.println("com.filenet.logging Successfully (re)loaded settings file " + configFile);
            return true;
        }
        catch (Throwable t) {
            System.err.println("com.filenet.logging Exception loading config file " + configFile + ": " + t);
            configFile = null;
            return false;
        }
    }

    private static synchronized boolean getLogFile() {
        String multiLine = LoggingConfiguration.getTraceSetting("MultiLine");
        if (multiLine != null && multiLine.equalsIgnoreCase("true")) {
            formatter.setMultiLine(true);
        } else {
            formatter.setMultiLine(false);
        }
        String logFile = LoggingConfiguration.getTraceSetting("LogFile");
        if (logFile != null && logFile.length() > 0) {
            try {
                File flf = new File(logFile);
                if (flf.isDirectory()) {
                    System.err.println("com.filenet.api Logging cannot be enabled because the specified log location '" + logFile + "' specifies a directory, not a file");
                    return false;
                }
                logFile = flf.getCanonicalPath();
                File flp = flf.getParentFile();
                if (!flp.isDirectory()) {
                    System.err.println("com.filenet.api Logging cannot be enabled because the specified log location '" + flp.getPath() + "' does not exist or is not a directory");
                    return false;
                }
                if (logFileName != null && logFile.equals(logFileName)) {
                    return false;
                }
                String filePattern = LoggingConfiguration.createFilePattern(logFile, null);
                FileHandler handler = new FileHandler(filePattern, true);
                handler.setFormatter(formatter);
                handler.setLevel(Level.ALL);
                handler.setEncoding("UTF-8");
                FileHandler prevHandler = fileHandler;
                fileHandler = handler;
                logFileName = logFile;
                logPath = flp.getCanonicalPath();
                if (prevHandler != null) {
                    prevHandler.close();
                }
                return true;
            }
            catch (Throwable t) {
                System.err.println("com.filenet.logging Exception during log file initialisation: " + t);
                return false;
            }
        }
        if (logFileName != null) {
            if (fileHandler != null) {
                fileHandler.close();
                fileHandler = null;
            }
            logFileName = null;
            return true;
        }
        return false;
    }

    private boolean readSubSystemSettings() {
        boolean updated = false;
        HashMap<String, String> newLevels = new HashMap<String, String>();
        String defaultLevel = LoggingConfiguration.getTraceSetting(this.settingsPrefix + "LogLevel");
        for (int i = 0; i < this.subSystemNames.size(); ++i) {
            String name = this.subSystemNames.get(i);
            String prevValue = this.subSystemLevelSettings.get(name);
            String lstr = LoggingConfiguration.getTraceSetting(this.settingsPrefix + "SubSystem." + name);
            if (lstr == null || lstr.length() == 0) {
                lstr = defaultLevel;
            }
            if (lstr != null && lstr.length() > 0) {
                lstr = lstr.toLowerCase();
                newLevels.put(name, lstr);
                if (prevValue != null && lstr.equals(prevValue)) continue;
                updated = true;
                continue;
            }
            if (prevValue == null) continue;
            updated = true;
        }
        if (updated) {
            this.subSystemLevelSettings = newLevels;
        }
        this.subSystemReload = false;
        return updated;
    }

    private static String getTraceSetting(String param) {
        String result = null;
        if (configProperties != null) {
            result = (String)configProperties.get(param);
        }
        if (result == null) {
            result = System.getProperty("com.filenet.logging." + param);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalHandler(Handler handler, boolean useDefaultFormatter) {
        if (useDefaultFormatter) {
            handler.setFormatter(LoggingConfiguration.getFormatter());
        }
        ArrayList<Handler> arrayList = globalHandlers;
        synchronized (arrayList) {
            globalHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGlobalHandler(Handler handler) {
        ArrayList<Handler> arrayList = globalHandlers;
        synchronized (arrayList) {
            globalHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String subSystemName, Handler handler, boolean useDefaultFormatter) {
        ArrayList<Handler> subHandlers;
        if (useDefaultFormatter) {
            handler.setFormatter(LoggingConfiguration.getFormatter());
        }
        if ((subHandlers = this.subSystemHandlers.get(subSystemName)) == null) {
            subHandlers = new ArrayList();
            this.subSystemHandlers.putIfAbsent(subSystemName, subHandlers);
        }
        ArrayList<Handler> arrayList = subHandlers = this.subSystemHandlers.get(subSystemName);
        synchronized (arrayList) {
            subHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(String subSystemName, Handler handler) {
        ArrayList<Handler> subHandlers = this.subSystemHandlers.get(subSystemName);
        if (subHandlers != null) {
            ArrayList<Handler> arrayList = subHandlers;
            synchronized (arrayList) {
                subHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHandlers() {
        Iterator<ArrayList<Handler>> iterator = this.subSystemHandlers.values().iterator();
        while (iterator.hasNext()) {
            ArrayList<Handler> subHandlers;
            ArrayList<Handler> arrayList = subHandlers = iterator.next();
            synchronized (arrayList) {
                for (Handler h : subHandlers) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {}
                }
                subHandlers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String subSystemName, LogRecord record) {
        FileHandler ph = LoggingConfiguration.getLogHandler();
        if (ph != null) {
            try {
                ((Handler)ph).publish(record);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ArrayList<Handler> arrayList = globalHandlers;
        synchronized (arrayList) {
            for (Handler h : globalHandlers) {
                try {
                    h.publish(record);
                }
                catch (Throwable throwable) {}
            }
        }
        ArrayList<Handler> subHandlers = this.subSystemHandlers.get(subSystemName);
        if (subHandlers != null) {
            ArrayList<Handler> arrayList2 = subHandlers;
            synchronized (arrayList2) {
                for (Handler h : subHandlers) {
                    try {
                        h.publish(record);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    static {
        File cff;
        formatter = new LogFormatter();
        configFile = System.getProperty("com.filenet.logging.ConfigFile");
        if (configFile != null && !(cff = new File(configFile)).exists()) {
            System.out.println("com.filenet.logging Specified configuration file " + configFile + " does not currently exist. It can be added later.");
        }
        globalHandlers = new ArrayList();
        configProperties = null;
        nextRefreshTime = 0L;
        configFileLastModified = 0L;
        logFileName = null;
        logPath = null;
        fileHandler = null;
        configInstances = new ArrayList();
    }
}

