/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.exception.ExceptionContext;
import java.io.UnsupportedEncodingException;

public class SIDConversion {
    public static final String SID_PREFIX = "S-";

    public static String ldapIdToSid(String ldapId) {
        byte[] sidBinary = SIDConversion.ldapIdStringToSidBinary(ldapId);
        return SIDConversion.sidBinaryToSidString(sidBinary);
    }

    public static String sidToLdapId(String sid) {
        byte[] sidBinary = SIDConversion.sidStringToSidBinary(sid);
        return SIDConversion.sidBinaryToLdapIdString(sidBinary);
    }

    public static boolean isSid(String value) {
        if (null == value || !value.startsWith(SID_PREFIX) || value.length() < SID_PREFIX.length() + 1) {
            return false;
        }
        char c = value.charAt(SID_PREFIX.length());
        return c == '1' || c == '{';
    }

    public static byte[] ldapIdStringToSidBinary(String ldapIdString) {
        if (ldapIdString == null || ldapIdString.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_MISSING_REQUIRED_LDAP_ATTRIBUTE_VALUE, null, ExceptionContext.SECURITY_MISSING_REQUIRED_SID_VALUE, null);
        }
        byte[] subauths = null;
        try {
            subauths = ldapIdString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] sid = SIDConversion.ldapIdBinaryToSid(subauths);
        sid[7] = 98;
        return sid;
    }

    public static String sidBinaryToLdapIdString(byte[] sid) {
        byte subAuthCount = sid[1];
        byte bytesPadded = sid[sid.length - 1];
        int length = subAuthCount * 4 - bytesPadded;
        String strSid = null;
        try {
            strSid = new String(sid, 8, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String escapedStrSid = SIDConversion.escapeForSearch(strSid, 0);
        return escapedStrSid;
    }

    public static byte[] asSidBytesOrNull(String sidStr) {
        if (!SIDConversion.isSid(sidStr)) {
            return null;
        }
        Id id = Id.asIdOrNull(sidStr = sidStr.substring(SID_PREFIX.length()));
        if (id != null) {
            return id.getBytes();
        }
        String[] tokens = sidStr.split("-");
        int numTokens = tokens.length;
        if (numTokens < 3) {
            return null;
        }
        if (sidStr.charAt(sidStr.length() - 1) == '-') {
            return null;
        }
        int numSubAuthorities = numTokens - 2;
        if (numSubAuthorities > 127) {
            return null;
        }
        int byteLen = 8 + numSubAuthorities * 4;
        byte[] bytes = new byte[byteLen];
        long version = SIDConversion.parseLong(tokens[0]);
        if (version != 1L) {
            return null;
        }
        bytes[0] = (byte)version;
        bytes[1] = (byte)numSubAuthorities;
        long authority = SIDConversion.parseLong(tokens[1]);
        for (int i = 7; i >= 2; --i) {
            bytes[i] = (byte)(authority & 0xFFL);
            authority >>= 8;
        }
        if (authority != 0L) {
            return null;
        }
        int offset = 8;
        for (int j = 2; j < numTokens; ++j) {
            long subAuthority = SIDConversion.parseLong(tokens[j]);
            for (int i = 0; i < 4; ++i) {
                bytes[offset++] = (byte)(subAuthority & 0xFFL);
                subAuthority >>= 8;
            }
            if (subAuthority == 0L) continue;
            return null;
        }
        return bytes;
    }

    private static long parseLong(String s) {
        if (s == null || s.length() == 0) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException fne) {
            return -1L;
        }
    }

    public static byte[] sidStringToSidBinary(String sidString) {
        byte[] result = SIDConversion.asSidBytesOrNull(sidString);
        if (result == null) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_SID_STRING, sidString);
        }
        return result;
    }

    public static String sidBinaryToSidString(byte[] sidBytes) {
        if (16 == sidBytes.length) {
            // empty if block
        }
        StringBuffer buf = new StringBuffer(sidBytes.length * 3);
        buf.append(SID_PREFIX);
        buf.append(Integer.toString(sidBytes[0] & 0xFF));
        buf.append('-');
        int subAuthCount = sidBytes[1] & 0xFF;
        long bitsToShift = 0L;
        long identAuth = 0L;
        for (int idx = 7; idx >= 2; --idx) {
            identAuth |= (long)(sidBytes[idx] & 0xFF) << (int)bitsToShift;
            bitsToShift += 8L;
        }
        buf.append(Long.toString(identAuth));
        for (int subAuth = 0; subAuth < subAuthCount; ++subAuth) {
            buf.append('-');
            bitsToShift = 0L;
            int startIndex = subAuth * 4 + 8;
            long value = 0L;
            for (int idx = 0; idx < 4; ++idx) {
                value |= (long)(sidBytes[startIndex + idx] & 0xFF) << (int)bitsToShift;
                bitsToShift += 8L;
            }
            buf.append(Long.toString(value));
        }
        String sidString = buf.toString();
        return sidString;
    }

    public static byte[] ldapIdBinaryToSid(byte[] ldapIdBinary) {
        int subAuthCount = ldapIdBinary.length / 4 + 1;
        if (subAuthCount > 127) {
            String svalue = null;
            try {
                svalue = new String(ldapIdBinary, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            throw new EngineRuntimeException(ExceptionCode.SECURITY_SID_ATTRIBUTE_VALUE_SIZELIMIT_EXCEEDED, new Object[]{svalue, "508"});
        }
        int bytesPadded = 4 - ldapIdBinary.length % 4;
        byte[] sid = new byte[8 + ldapIdBinary.length + bytesPadded];
        sid[0] = 1;
        sid[1] = 0;
        sid[2] = 0;
        sid[3] = 0;
        sid[4] = 0;
        sid[5] = 0;
        sid[6] = 0;
        sid[7] = 0;
        System.arraycopy(ldapIdBinary, 0, sid, 8, ldapIdBinary.length);
        int offset = 8 + ldapIdBinary.length;
        for (int i = 0; i < bytesPadded; ++i) {
            sid[offset++] = 0;
        }
        sid[1] = (byte)subAuthCount;
        sid[sid.length - 1] = (byte)bytesPadded;
        return sid;
    }

    public static String escapeForSearch(String search, int bsCount) {
        boolean needsEscaping = false;
        int len = search.length();
        block10: for (int idx = 0; idx < len && !needsEscaping; ++idx) {
            switch (search.charAt(idx)) {
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    needsEscaping = true;
                    continue block10;
                }
            }
        }
        if (needsEscaping) {
            StringBuffer sb = new StringBuffer(search.length() * 3);
            block11: for (int idx = 0; idx < len; ++idx) {
                char ch = search.charAt(idx);
                switch (ch) {
                    case '(': {
                        sb.append("\\28");
                        continue block11;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block11;
                    }
                    case '*': {
                        sb.append("\\2A");
                        continue block11;
                    }
                    case '#': {
                        sb.append("\\23");
                        continue block11;
                    }
                    case '\\': {
                        for (int i = 0; i < bsCount; ++i) {
                            sb.append("\\5C");
                        }
                        continue block11;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            search = sb.toString();
        }
        return search;
    }

    public static boolean isSidFromConfigurableString(byte[] sid) {
        if (sid == null || sid.length < 8) {
            return false;
        }
        return sid[0] == 1 && sid[2] == 0 && sid[3] == 0 && sid[4] == 0 && sid[5] == 0 && sid[6] == 0 && sid[7] == 98;
    }

    public static boolean isSidFromConfigurableString(String sid) {
        if (sid == null || sid.length() < 8) {
            return false;
        }
        sid = sid.toUpperCase();
        return sid.startsWith("S-1-98-");
    }

    public static boolean isSidFromConfigurableBinary(byte[] sid) {
        if (sid == null || sid.length < 8) {
            return false;
        }
        return sid[0] == 1 && sid[2] == 0 && sid[3] == 0 && sid[4] == 0 && sid[5] == 0 && sid[6] == 0 && sid[7] == 99;
    }

    public static boolean isSidFromConfigurableBinary(String sid) {
        if (sid == null || sid.length() < 8) {
            return false;
        }
        sid = sid.toUpperCase();
        return sid.startsWith("S-1-99-");
    }
}

