/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ClassDescriptionSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.ObjectStoreSet;
import com.filenet.api.constants.PermissionSource;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.UpdatingBatch;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.CmAbstractPermission;
import com.filenet.api.security.CmDelegatedAccessPermission;
import com.filenet.api.security.CmExtendedPermission;
import com.filenet.api.security.CmRole;
import com.filenet.api.security.CmRolePermission;
import com.filenet.api.util.Id;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SecurityBlitzer {
    public static final String ROLE_GRANTEE_PREFIX = "#ROLE:";
    private static int DEFAULT_BATCH_SIZE = 50;
    private static int NO_UPDATE = 0;
    private static int UPDATE = 1;
    private static int UPDATE_BREAK_BATCH = 2;
    private Domain domain;
    private ObjectStore singleTargetOS;
    private ProgressReporter reporter;
    private ArrayList<OperationDetail> operations = new ArrayList();
    private HashSet<String> excludedClasses = new HashSet();
    private boolean hasOwnerOp = false;
    private boolean hasDefaultOwnerOp = false;
    private int batchSize = DEFAULT_BATCH_SIZE;

    public SecurityBlitzer(Domain domain, ProgressReporter reporter) {
        this.domain = domain;
        this.reporter = reporter;
    }

    public SecurityBlitzer(ObjectStore objStore, ProgressReporter reporter) {
        this.singleTargetOS = objStore;
        this.domain = Factory.Domain.fetchInstance(objStore.getConnection(), null, null);
        this.reporter = reporter;
    }

    public void addOperation(Operation operation, String matchGrantee, String newGrantee) {
        OperationDetail detail = new OperationDetail();
        detail.operation = operation;
        detail.matchGrantee = matchGrantee;
        detail.newGrantee = newGrantee;
        this.operations.add(detail);
        if (operation == Operation.REPLACE_OWNER || operation == Operation.REPLACE_STALE_OWNER) {
            this.hasOwnerOp = true;
        }
        if (operation == Operation.REPLACE_DEFAULT_OWNER) {
            this.hasDefaultOwnerOp = true;
        }
    }

    public void excludeClass(String excludeClass) {
        this.excludedClasses.add(excludeClass);
    }

    public void setBatchSize(int newSize) {
        this.batchSize = newSize;
    }

    public void blitz() {
        for (OperationDetail detail : this.operations) {
            switch (detail.operation) {
                case CLONE: {
                    this.reportProgress("*** Blitzing copy " + detail.matchGrantee + " to " + detail.newGrantee);
                    break;
                }
                case REPLACE: {
                    this.reportProgress("*** Blitzing replace " + detail.matchGrantee + " by " + detail.newGrantee);
                    break;
                }
                case REMOVE: {
                    this.reportProgress("*** Blitzing remove " + detail.matchGrantee);
                    break;
                }
                case REMOVE_STALE: {
                    this.reportProgress("*** Blitzing remove stale");
                    break;
                }
                case REPLACE_OWNER: {
                    this.reportProgress("*** Blitzing replace owner" + detail.matchGrantee + " by " + detail.newGrantee);
                    break;
                }
                case REPLACE_STALE_OWNER: {
                    this.reportProgress("*** Blitzing replace stale owner by " + detail.newGrantee);
                }
            }
        }
        if (this.singleTargetOS == null) {
            this.processDomain();
        } else {
            this.processInObjectStore(this.singleTargetOS);
        }
        this.operations.clear();
        this.excludedClasses.clear();
    }

    private void processDomain() {
        this.domain.refresh();
        if (this.processObject(null, this.domain) != NO_UPDATE) {
            this.domain.save(RefreshMode.REFRESH);
        }
        ObjectStoreSet objStores = this.domain.get_ObjectStores();
        Iterator iter = objStores.iterator();
        while (iter.hasNext()) {
            ObjectStore objStore = (ObjectStore)iter.next();
            this.processObjectStore(objStore);
        }
    }

    private void processObjectStore(ObjectStore objStore) {
        objStore.refresh();
        this.reportProgress("Processing object store " + objStore.get_Name());
        if (this.processObject(null, objStore) != NO_UPDATE) {
            objStore.save(RefreshMode.REFRESH);
        }
        this.processInObjectStore(objStore);
    }

    private void processInObjectStore(ObjectStore objStore) {
        SearchScope scope = new SearchScope(objStore);
        Iterator<String> iter = this.getRootSearchableClasses(scope);
        while (iter.hasNext()) {
            String className = iter.next();
            if (this.excludedClasses.contains(className)) {
                this.reportProgress("    Skipping class " + className);
                continue;
            }
            this.processClass(objStore, scope, className);
        }
    }

    private void processClass(ObjectStore objStore, SearchScope scope, String className) {
        this.reportProgress("    Processing objects of class " + className);
        SearchSQL sql = new SearchSQL("SELECT * FROM " + className);
        IndependentObjectSet objs = scope.fetchObjects(sql, null, null, true);
        Iterator iter = objs.iterator();
        UpdatingBatch ub = null;
        int batchCount = 0;
        while (iter.hasNext()) {
            IndependentlyPersistableObject ipo = (IndependentlyPersistableObject)iter.next();
            int status = this.processObject(objStore, ipo);
            if (status == NO_UPDATE) continue;
            if (ub == null) {
                ub = UpdatingBatch.createUpdatingBatchInstance(this.domain, RefreshMode.NO_REFRESH);
            }
            ub.add(ipo, null);
            if (++batchCount < this.batchSize && status != UPDATE_BREAK_BATCH) continue;
            this.reportProgress("      Committing batch of " + batchCount);
            ub.updateBatch();
            ub = null;
            batchCount = 0;
        }
        if (ub != null) {
            this.reportProgress("      Committing batch of " + batchCount);
            ub.updateBatch();
        }
    }

    private int processObject(ObjectStore objStore, IndependentlyPersistableObject ipo) {
        boolean ownerChanged;
        boolean canUpdateOwner;
        int defStatus;
        Properties props;
        Property prop;
        int status = NO_UPDATE;
        boolean canUpdate = true;
        if ((ipo.getAccessAllowed() & 0x40000) == 0) {
            canUpdate = false;
        }
        if ((prop = (props = ipo.getProperties()).find("Permissions")) != null) {
            status = this.applyOperations(objStore, (AccessPermissionList)prop.getDependentObjectListValue(), !canUpdate);
        }
        if ((prop = props.find("DefaultInstancePermissions")) != null && (defStatus = this.applyOperations(objStore, (AccessPermissionList)prop.getDependentObjectListValue(), !canUpdate)) != NO_UPDATE && status == NO_UPDATE) {
            status = UPDATE;
        }
        if ((prop = props.find("Owner")) != null && this.hasOwnerOp) {
            canUpdateOwner = (ipo.getAccessAllowed() & 0x80000) != 0 & prop.isSettable();
            ownerChanged = this.applyOwnerOperations(props, prop.getStringValue(), !canUpdateOwner);
            if (ownerChanged) {
                if (status == NO_UPDATE) {
                    status = UPDATE;
                }
                if (!canUpdateOwner) {
                    canUpdate = false;
                }
            }
        }
        if ((prop = props.find("DefaultInstanceOwner")) != null && this.hasDefaultOwnerOp) {
            canUpdateOwner = (ipo.getAccessAllowed() & 2) != 0;
            ownerChanged = this.applyDefaultOwnerOperations(props, prop.getStringValue(), !canUpdateOwner);
            if (ownerChanged) {
                if (status == NO_UPDATE) {
                    status = UPDATE;
                }
                if (!canUpdateOwner) {
                    canUpdate = false;
                }
            }
        }
        if (status != NO_UPDATE) {
            if (canUpdate) {
                this.reportProgress("      Updating object " + ipo.getObjectReference());
            } else {
                this.reportProblem("      Required update cannot be performed due to insufficient permission or full proxy: " + ipo.getObjectReference());
                status = NO_UPDATE;
            }
        }
        return status;
    }

    private int applyOperations(ObjectStore objStore, AccessPermissionList perms, boolean checkOnly) {
        int status = NO_UPDATE;
        for (OperationDetail detail : this.operations) {
            if (detail.operation == Operation.REPLACE_OWNER || detail.operation == Operation.REPLACE_STALE_OWNER) continue;
            block11: for (int i = perms.size() - 1; i >= 0; --i) {
                CmDelegatedAccessPermission dap;
                AccessPermission ap = (AccessPermission)perms.get(i);
                PermissionSource src = PermissionSource.SOURCE_DIRECT;
                if (ap.getProperties().isPropertyPresent("PermissionSource")) {
                    src = ap.get_PermissionSource();
                }
                if (!src.equals(PermissionSource.SOURCE_DIRECT) && !src.equals(PermissionSource.SOURCE_DEFAULT)) continue;
                if (detail.operation == Operation.REMOVE_STALE) {
                    if (ap instanceof CmRolePermission) {
                        CmRole role = ((CmRolePermission)((Object)ap)).get_Role();
                        if (role != null) continue;
                        status = SecurityBlitzer.getChangeStatus(status, ap);
                        if (checkOnly) continue;
                        perms.remove(i);
                        continue;
                    }
                    if (ap instanceof CmDelegatedAccessPermission) {
                        dap = (CmDelegatedAccessPermission)((Object)ap);
                        if (!this.isStalePrincipal(dap.get_DelegateName()) && !this.isStalePrincipal(dap.get_DelegatingUserName())) continue;
                        status = SecurityBlitzer.getChangeStatus(status, ap);
                        if (checkOnly) continue;
                        perms.remove(i);
                        continue;
                    }
                    if (!this.isStalePrincipal(ap.get_GranteeName())) continue;
                    status = SecurityBlitzer.getChangeStatus(status, ap);
                    if (checkOnly) continue;
                    perms.remove(i);
                    continue;
                }
                if (ap instanceof CmDelegatedAccessPermission) {
                    dap = (CmDelegatedAccessPermission)((Object)ap);
                    boolean matchDelegator = detail.matchGrantee.equalsIgnoreCase(dap.get_DelegatingUserName());
                    boolean matchDelegate = detail.matchGrantee.equalsIgnoreCase(dap.get_DelegateName());
                    if (!matchDelegator && !matchDelegate) continue;
                    status = SecurityBlitzer.getChangeStatus(status, ap);
                    if (checkOnly) continue;
                    switch (detail.operation) {
                        case REMOVE: {
                            perms.remove(i);
                            break;
                        }
                        case REPLACE: {
                            perms.remove(i);
                        }
                        case CLONE: {
                            perms.add(this.createDelegatedPermission(objStore, dap, detail.newGrantee, matchDelegate, matchDelegator));
                        }
                    }
                    continue;
                }
                if (ap instanceof CmExtendedPermission || !ap.get_GranteeName().equalsIgnoreCase(detail.matchGrantee)) continue;
                status = SecurityBlitzer.getChangeStatus(status, ap);
                if (checkOnly) continue;
                switch (detail.operation) {
                    case REMOVE: {
                        perms.remove(i);
                        continue block11;
                    }
                    case REPLACE: {
                        perms.remove(i);
                    }
                    case CLONE: {
                        perms.add(this.createPermission(objStore, ap, detail.newGrantee));
                    }
                }
            }
        }
        return status;
    }

    private static int getChangeStatus(int currentStatus, AccessPermission ap) {
        if (ap.get_InheritableDepth() == 0) {
            if (currentStatus == NO_UPDATE) {
                return UPDATE;
            }
            return currentStatus;
        }
        return UPDATE_BREAK_BATCH;
    }

    private boolean applyOwnerOperations(Properties props, String ownerName, boolean checkOnly) {
        boolean changed = false;
        if (ownerName != null) {
            for (OperationDetail detail : this.operations) {
                if (detail.operation == Operation.REPLACE_OWNER) {
                    if (!ownerName.equalsIgnoreCase(detail.matchGrantee)) continue;
                    changed = true;
                    if (checkOnly) continue;
                    props.putValue("Owner", detail.newGrantee);
                    continue;
                }
                if (detail.operation != Operation.REPLACE_STALE_OWNER || !this.isStalePrincipal(ownerName)) continue;
                changed = true;
                if (checkOnly) continue;
                props.putValue("Owner", detail.newGrantee);
            }
        }
        return changed;
    }

    private boolean applyDefaultOwnerOperations(Properties props, String ownerName, boolean checkOnly) {
        boolean changed = false;
        if (ownerName != null) {
            for (OperationDetail detail : this.operations) {
                if (detail.operation != Operation.REPLACE_DEFAULT_OWNER || !ownerName.equalsIgnoreCase(detail.matchGrantee)) continue;
                changed = true;
                if (checkOnly) continue;
                props.putValue("DefaultInstanceOwner", detail.newGrantee);
            }
        }
        return changed;
    }

    private Iterator<String> getRootSearchableClasses(SearchScope scope) {
        HashMap<String, ClassDescription> classes = new HashMap<String, ClassDescription>();
        ClassDescriptionSet cds = scope.fetchSearchableClassDescriptions(null, null);
        Iterator iter = cds.iterator();
        while (iter.hasNext()) {
            ClassDescription cd = (ClassDescription)iter.next();
            String className = cd.get_SymbolicName();
            if (className.equals("ContentSearch") || className.equals("Versionable")) continue;
            classes.put(className, cd);
        }
        ArrayList<String> rootClasses = new ArrayList<String>();
        Iterator itMap = classes.entrySet().iterator();
        while (itMap.hasNext()) {
            ClassDescription cd = (ClassDescription)itMap.next().getValue();
            ClassDescription cdSuper = cd.get_SuperclassDescription();
            if (cdSuper != null && classes.containsKey(cdSuper.get_SymbolicName())) continue;
            rootClasses.add(cd.get_SymbolicName());
        }
        return rootClasses.iterator();
    }

    private CmAbstractPermission createPermission(ObjectStore objStore, CmAbstractPermission srcPerm, String newGrantee) {
        CmAbstractPermission destPerm;
        if (newGrantee != null && newGrantee.startsWith(ROLE_GRANTEE_PREFIX)) {
            String roleSpec = newGrantee.substring(ROLE_GRANTEE_PREFIX.length());
            String[] parts = roleSpec.split(":");
            Id roleId = null;
            ObjectStore roleObjStore = objStore;
            if (parts.length == 1) {
                roleId = new Id(parts[0]);
            } else {
                roleId = new Id(parts[1]);
                Id objStoreId = new Id(parts[0]);
                roleObjStore = Factory.ObjectStore.getInstance(this.domain, objStoreId);
            }
            CmRole role = Factory.CmRole.getInstance(roleObjStore, roleId);
            CmRolePermission rp = Factory.CmRolePermission.createInstance();
            rp.set_Role(role);
            destPerm = rp;
        } else {
            AccessPermission ap = (AccessPermission)srcPerm;
            AccessPermission apNew = Factory.AccessPermission.createInstance();
            apNew.set_AccessType(ap.get_AccessType());
            apNew.set_GranteeName(newGrantee);
            apNew.set_AccessMask(ap.get_AccessMask());
            destPerm = apNew;
        }
        destPerm.set_InheritableDepth(srcPerm.get_InheritableDepth());
        return destPerm;
    }

    private CmDelegatedAccessPermission createDelegatedPermission(ObjectStore objStore, CmDelegatedAccessPermission dap, String newGrantee, boolean replaceDelegate, boolean replaceDelegator) {
        CmDelegatedAccessPermission dapNew = Factory.CmDelegatedAccessPermission.createInstance();
        if (replaceDelegate) {
            dapNew.set_DelegateName(newGrantee);
        } else {
            dapNew.set_DelegateName(dap.get_DelegateName());
        }
        if (replaceDelegator) {
            dapNew.set_DelegatingUserName(newGrantee);
        } else {
            dapNew.set_DelegatingUserName(dap.get_DelegatingUserName());
        }
        dapNew.set_AccessMask(dap.get_AccessMask());
        dapNew.set_InheritableDepth(dap.get_InheritableDepth());
        return dap;
    }

    private boolean isStalePrincipal(String name) {
        if (name.startsWith("S-1-")) {
            try {
                Factory.SecurityPrincipal.fetchInstance(this.domain.getConnection(), name, null);
                return false;
            }
            catch (EngineRuntimeException ere) {
                if (ere.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                    return true;
                }
                throw ere;
            }
        }
        return false;
    }

    private void reportProgress(String info) {
        if (this.reporter != null) {
            this.reporter.reportProgress(info);
        }
    }

    private void reportProblem(String info) {
        if (this.reporter != null) {
            this.reporter.reportProblem(info);
        }
    }

    private static class OperationDetail {
        Operation operation;
        String matchGrantee;
        String newGrantee;

        private OperationDetail() {
        }
    }

    public static interface ProgressReporter {
        public void reportProgress(String var1);

        public void reportProblem(String var1);
    }

    public static enum Operation {
        CLONE,
        REPLACE,
        REMOVE,
        REPLACE_OWNER,
        REPLACE_DEFAULT_OWNER,
        REMOVE_STALE,
        REPLACE_STALE_OWNER;

    }
}

