/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.transport.ejb.ContentEJBHome;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWL;
import com.filenet.apiimpl.util.J2EEUtilWSL;
import com.filenet.apiimpl.util.SessionHandle;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.ServiceSessionNst;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.LinkException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class SessionLocator {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(SessionLocator.class, SubSystem.API);
    private static boolean useSessionCache = true;
    private static ThreadLocal cache = new ThreadLocal();
    private static String splat = " {|} ";
    private static ThreadLocal ejbHomeCache = new ThreadLocal();
    private static ThreadLocal commEjbHomeCache = new ThreadLocal();
    private static HashMap<String, SoftReference<ContentEJBHome>> cacheEntriesContentEjb = new HashMap();
    private static HashMap ejbHomeCacheMap = new HashMap();
    private static Constructor serverSessionConstructor;
    private static Constructor EJBSessionConstructor;
    private static Throwable EJBSessionConstructorError;
    private static ThreadLocal enableServerSession;
    private static ClassLoader cl;
    private static final String SERVER_SESSION_CLASS_NAME = "com.filenet.engine.context.ServerSession";
    private static final String EJB_SESSION_CLASS_NAME = "com.filenet.apiimpl.transport.ejb.EJBSession";
    private static ThreadLocal serverSessionOverRide;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(Connection conn) {
        HashMap<String, SoftReference<ContentEJBHome>> hashMap = cacheEntriesContentEjb;
        synchronized (hashMap) {
            cacheEntriesContentEjb.clear();
        }
        if (!useSessionCache) {
            return;
        }
        ConnectionImpl connToUse = SessionLocator.getConnectionToUse((ConnectionImpl)conn);
        if (connToUse == null) {
            return;
        }
        HashMap cacheEntryes = (HashMap)cache.get();
        if (cacheEntryes == null) {
            return;
        }
        SoftReference sr = (SoftReference)cacheEntryes.remove(SessionLocator.getConnectionKey(connToUse));
        if (sr != null) {
            Session session = (Session)sr.get();
            session.remove();
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Clearing Session cache for:" + connToUse.toString());
        }
    }

    private static String getConnectionKey(Connection conn) {
        if (conn == null) {
            return "";
        }
        String connURI = conn.getURI();
        if (connURI == null) {
            return "";
        }
        String key = connURI.toLowerCase();
        if (SessionLocator.usesWsiTransport(connURI) || SessionLocator.isExecutingInServer()) {
            return key;
        }
        Properties props = J2EEUtil.getEJBJndiEnvironment((ConnectionImpl)conn);
        if (props == null || props.size() < 2) {
            return key + splat;
        }
        key = key + splat + props.toString();
        return key;
    }

    private static String getContentConnectionKey(String baseKey, boolean useAffinity) {
        if (useAffinity) {
            return baseKey + "-stateful";
        }
        return baseKey + "-stateless";
    }

    public static Session getSession(Connection conn) {
        SoftReference sr;
        HashMap<String, SoftReference<Session>> cacheEntryes = (HashMap<String, SoftReference<Session>>)cache.get();
        if (cacheEntryes == null) {
            cacheEntryes = new HashMap<String, SoftReference<Session>>();
            cache.set(cacheEntryes);
        }
        ConnectionImpl connToUse = SessionLocator.getConnectionToUse((ConnectionImpl)conn);
        if (!(SessionLocator.isExecutingInServer() || connToUse != null && connToUse.getURI() != null && connToUse.getURI().length() >= 3)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "Connection");
        }
        Session session = null;
        ContextInfo cinfo = SessionLocator.initContextInfo(connToUse);
        if (SessionLocator.shouldCacheSession(connToUse) && (sr = (SoftReference)cacheEntryes.get(cinfo.conKey)) != null && sr.get() != null) {
            session = (Session)sr.get();
            if (logger.isDetailTraceEnabled() && session != null) {
                logger.traceDetail("A session instance for " + cinfo.conKey + " was found in the cache : " + sr.get());
                logger.traceDetail("Session connection: " + connToUse);
            }
        }
        if (session == null) {
            block19: {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("No session entry found in the cache for " + cinfo.conKey);
                }
                session = SessionLocator.createNewSession(connToUse, cinfo);
                J2EEUtil j2eeUtil = J2EEUtil.getInstance();
                if (session == null && j2eeUtil.canInstantiateInitialContext()) {
                    try {
                        if (connToUse == null) {
                            connToUse = new ConnectionImpl();
                        }
                        ContextInfo ic = SessionLocator.resolveContextInfo(cinfo);
                        if (session == null) {
                            String remoteEnginePath = j2eeUtil.getRemoteEnginePath();
                            session = SessionLocator.findEJBSessionByPath(connToUse, ic, remoteEnginePath);
                            if (logger.isDetailTraceEnabled()) {
                                if (session == null) {
                                    logger.traceDetail("Remote EJB Interface " + remoteEnginePath + " NOT found " + SessionLocator.getJNDIDebugText(ic));
                                } else {
                                    logger.traceDetail("Remote EJB Interface " + remoteEnginePath + " found " + session + ' ' + SessionLocator.getJNDIDebugText(ic));
                                }
                            }
                        }
                    }
                    catch (NamingException ne) {
                        if (!logger.isDetailTraceEnabled()) break block19;
                        logger.traceDetail(" Naming exception occurred that is being ignored " + ne.toString());
                    }
                }
            }
            if (session != null && connToUse != null && SessionLocator.shouldCacheSession(connToUse)) {
                cacheEntryes.put(cinfo.conKey, new SoftReference<Session>(session));
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Session was cached for " + cinfo.conKey);
                    logger.traceDetail("Session connection: " + connToUse);
                }
            }
        }
        if (session != null) {
            if (SessionLocator.isExecutingInServer()) {
                return session;
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Remote session is returned and will be wrapped in a session handle for retry conditions");
                logger.traceDetail("Session connection: " + connToUse);
            }
            return new SessionHandle(session, connToUse);
        }
        throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, connToUse != null ? connToUse.toString() : "null");
    }

    private static boolean shouldCacheSession(ConnectionImpl conn) {
        return conn != null && useSessionCache && !SessionLocator.usesWsiTransport(conn.getURI()) && !SessionLocator.isExecutingInServer();
    }

    private static ConnectionImpl getConnectionToUse(ConnectionImpl conn) {
        if (!SessionLocator.isExecutingInServer() && conn != null && conn.getURI() == null) {
            return SessionLocator.getDefaultConnectionFromExisting(conn);
        }
        if (conn == null) {
            return new ConnectionImpl();
        }
        return conn;
    }

    public static Object getEJB(Context ctx) {
        ContextInfo cinfo = new ContextInfo();
        cinfo.ctx = ctx;
        Object ejb = SessionLocator.getEJB(cinfo);
        SessionLocator.logLocalOrRemoteEJB(ejb);
        return ejb;
    }

    private static Object getEJB(ContextInfo cinfo) {
        String conKey;
        J2EEUtil j2eeUtil;
        SoftReference sr;
        if (cinfo == null) {
            return null;
        }
        HashMap<String, SoftReference<Object>> cacheEntryes = (HashMap<String, SoftReference<Object>>)ejbHomeCache.get();
        if (cacheEntryes == null) {
            cacheEntryes = new HashMap<String, SoftReference<Object>>();
            ejbHomeCache.set(cacheEntryes);
        }
        if ((sr = (SoftReference)cacheEntryes.get((j2eeUtil = J2EEUtil.getInstance()).getLocalEnginePath())) != null && sr.get() != null) {
            Object srEJB = sr.get();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Local EJB Interface " + j2eeUtil.getLocalEnginePath() + " found in cache : " + srEJB);
            }
            SessionLocator.logLocalOrRemoteEJB(srEJB);
            return srEJB;
        }
        Object h = SessionLocator.locateEJBByPath(cinfo, j2eeUtil.getLocalEnginePath());
        if (h != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Local EJB Interface " + j2eeUtil.getLocalEnginePath() + " found : " + h + ' ' + SessionLocator.getJNDIDebugText(cinfo));
            }
            cacheEntryes.put(j2eeUtil.getLocalEnginePath(), new SoftReference<Object>(h));
            SessionLocator.logLocalOrRemoteEJB(h);
            return h;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Local EJB Interface " + j2eeUtil.getLocalEnginePath() + " NOT found " + SessionLocator.getJNDIDebugText(cinfo));
        }
        if ((sr = (SoftReference)cacheEntryes.get(conKey = j2eeUtil.getRemoteEnginePath())) != null && sr.get() != null) {
            Object srEJB = sr.get();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Remote EJB Interface " + conKey + " found in cache : " + srEJB);
            }
            SessionLocator.logLocalOrRemoteEJB(srEJB);
            return srEJB;
        }
        Object ret = SessionLocator.locateEJBByPath(cinfo, j2eeUtil.getRemoteEnginePath());
        if (ret != null) {
            cacheEntryes.put(conKey, new SoftReference<Object>(ret));
        }
        if (logger.isDetailTraceEnabled()) {
            if (ret != null) {
                logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " found : " + ret + ' ' + SessionLocator.getJNDIDebugText(cinfo));
            } else {
                logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " NOT found " + SessionLocator.getJNDIDebugText(cinfo));
            }
        }
        if (ret != null) {
            SessionLocator.logLocalOrRemoteEJB(ret);
        }
        return ret;
    }

    public static Object getCommEJB(Context ctx) {
        ContextInfo cinfo = new ContextInfo();
        cinfo.ctx = ctx;
        Object commEJB = SessionLocator.getCommEJB(cinfo);
        SessionLocator.logLocalOrRemoteEJB(commEJB);
        return commEJB;
    }

    private static Object getCommEJB(ContextInfo cntx) {
        J2EEUtil j2eeUtil;
        SoftReference sr;
        if (cntx == null) {
            return null;
        }
        HashMap<String, SoftReference<Object>> cacheEntries = (HashMap<String, SoftReference<Object>>)commEjbHomeCache.get();
        if (cacheEntries == null) {
            cacheEntries = new HashMap<String, SoftReference<Object>>();
            commEjbHomeCache.set(cacheEntries);
        }
        if ((sr = (SoftReference)cacheEntries.get((j2eeUtil = J2EEUtil.getInstance()).getLocalEngineCommPath())) != null && sr.get() != null) {
            return sr.get();
        }
        Object h = SessionLocator.locateEJBByPath(cntx, j2eeUtil.getLocalEngineCommPath());
        if (h != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Local Comm EJB Interface " + j2eeUtil.getLocalEngineCommPath() + " found " + SessionLocator.getJNDIDebugText(cntx));
            }
            cacheEntries.put(j2eeUtil.getLocalEngineCommPath(), new SoftReference<Object>(h));
            return h;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Local Comm EJB Interface " + j2eeUtil.getLocalEngineCommPath() + " NOT found " + SessionLocator.getJNDIDebugText(cntx));
        }
        if ((sr = (SoftReference)cacheEntries.get(j2eeUtil.getRemoteEngineCommPath())) != null && sr.get() != null) {
            return sr.get();
        }
        Object ret = SessionLocator.locateEJBByPath(cntx, j2eeUtil.getRemoteEngineCommPath());
        if (ret != null) {
            cacheEntries.put(j2eeUtil.getRemoteEngineCommPath(), new SoftReference<Object>(ret));
        }
        if (logger.isDetailTraceEnabled()) {
            if (ret == null) {
                logger.traceDetail("Remote Comm EJB Interface " + j2eeUtil.getRemoteEngineCommPath() + " found " + SessionLocator.getJNDIDebugText(cntx));
            } else {
                logger.traceDetail("Remote Comm EJB Interface " + j2eeUtil.getRemoteEngineCommPath() + " NOT found " + SessionLocator.getJNDIDebugText(cntx));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentEJBHome getContentEJB(ConnectionImpl conn, boolean useAffinityEjb) {
        Object ejbHome = null;
        ContentEJBHome contentEjbHome = null;
        boolean isStateful = useAffinityEjb;
        boolean isLocal = false;
        HashMap<String, SoftReference<ContentEJBHome>> hashMap = cacheEntriesContentEjb;
        synchronized (hashMap) {
            ContextInfo cinfo = SessionLocator.initContextInfo(conn);
            String conKey = SessionLocator.getContentConnectionKey(cinfo.conKey, useAffinityEjb);
            SoftReference<ContentEJBHome> sr = cacheEntriesContentEjb.get(conKey);
            ContentEJBHome contentEJBHome = contentEjbHome = sr != null ? sr.get() : null;
            if (contentEjbHome != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.getContentEJB called and a cached value is being returned for " + conKey);
                }
                SessionLocator.logLocalOrRemoteEJB(contentEjbHome);
                return contentEjbHome;
            }
            cinfo = SessionLocator.resolveContextInfoRuntime(cinfo);
            J2EEUtil j2eeUtil = J2EEUtil.getInstance();
            String localEngineContentPath = j2eeUtil.getLocalEngineContentPath();
            String remoteEngineContentPath = useAffinityEjb ? j2eeUtil.getRemoteEngineContentAffinityPath() : j2eeUtil.getRemoteEngineContentPath();
            if (J2EEUtil.getInstance() instanceof J2EEUtilWSL) {
                try {
                    if (null != conKey && conKey.toLowerCase().contains("remote")) {
                        ejbHome = SessionLocator.locateEJBByPath(cinfo, remoteEngineContentPath);
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("Setting the EJB home to the type state less isStateful= " + isStateful);
                        }
                        isStateful = false;
                        isLocal = false;
                    } else {
                        ejbHome = SessionLocator.locateEJBByPath(cinfo, localEngineContentPath);
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("Setting the EJB home to the type state less isStateful= " + isStateful);
                        }
                        isStateful = false;
                        isLocal = true;
                    }
                }
                catch (Throwable t) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("SessionLocator.getContentEJB: Exception trying to find Local content EJB path: " + localEngineContentPath + "; Exception=" + t.getLocalizedMessage());
                    }
                    ejbHome = null;
                }
                if (ejbHome != null && logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.getContentEJB: Local content EJB path '" + localEngineContentPath + "' lookup found " + ejbHome);
                }
            }
            if (ejbHome == null && (ejbHome = SessionLocator.locateEJBByPath(cinfo, remoteEngineContentPath)) != null && logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.getContentEJB: Remote content EJB path '" + remoteEngineContentPath + "' lookup found " + ejbHome);
            }
            if (ejbHome == null) {
                String remoteEnginePath = j2eeUtil.getRemoteEnginePath();
                String connPath = conn.getPath();
                if (connPath != null && connPath.endsWith(remoteEnginePath)) {
                    if ((connPath = connPath.substring(0, connPath.length() - remoteEnginePath.length()) + remoteEngineContentPath).startsWith("/")) {
                        connPath = connPath.substring(1);
                    }
                    if ((ejbHome = SessionLocator.locateEJBByPath(cinfo, connPath)) != null && logger.isDetailTraceEnabled()) {
                        logger.traceDetail("SessionLocator.getContentEJB: Connection content EJB path '" + connPath + "' lookup found " + ejbHome);
                    }
                }
            }
            if (ejbHome != null) {
                contentEjbHome = new ContentEJBHome(ejbHome, isLocal, isStateful, conKey);
                cacheEntriesContentEjb.put(conKey, new SoftReference<ContentEJBHome>(contentEjbHome));
            }
        }
        if (contentEjbHome != null) {
            SessionLocator.logLocalOrRemoteEJB(contentEjbHome);
        }
        return contentEjbHome;
    }

    public static ContentEJBHome getContentEJB(Context ctx) {
        J2EEUtil j2eeUtil;
        Object h;
        ContextInfo cinfo = new ContextInfo();
        cinfo.ctx = ctx;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.getContentEJB: Getting ContentEJB from Context: " + SessionLocator.getJNDIDebugText(cinfo));
        }
        if ((h = SessionLocator.locateEJBByPath(cinfo, (j2eeUtil = J2EEUtil.getInstance()).getLocalEngineContentPath())) != null) {
            ContentEJBHome contentEjbHome = new ContentEJBHome(h, true, false, null);
            SessionLocator.logLocalOrRemoteEJB(h);
            return contentEjbHome;
        }
        h = SessionLocator.locateEJBByPath(cinfo, j2eeUtil.getRemoteEngineContentPath());
        if (h != null) {
            ContentEJBHome contentEjbHome = new ContentEJBHome(h, false, false, null);
            SessionLocator.logLocalOrRemoteEJB(contentEjbHome);
            return contentEjbHome;
        }
        return null;
    }

    public static void setUseSessionCache(boolean val) {
        useSessionCache = val;
    }

    private static Session createNewSession(ConnectionImpl conn, ContextInfo cinfo) {
        if (SessionLocator.isExecutingInServer() && !conn.allowRemoteConnectionInServer()) {
            try {
                return (Session)SessionLocator.getServerSessionConstructor().newInstance(null);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.createNewSession called and it attempted to create a server session " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.createNewSession called and it attempted to create a server session " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{SERVER_SESSION_CLASS_NAME});
            }
        }
        if (conn != null && conn.getAsURI() != null) {
            Session session = null;
            String providerURL = conn.getProviderURL();
            String path = conn.getPath();
            URI uri = conn.getAsURI();
            boolean isAbsolute = uri.isAbsolute();
            if (path != null && !isAbsolute) {
                cinfo = SessionLocator.resolveContextInfoRuntime(cinfo);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String path2 = path;
                if (path != null && J2EEUtil.getInstance() instanceof J2EEUtilWSL) {
                    path2 = path.toLowerCase().contains("remote") ? J2EEUtil.getInstance().getRemoteEnginePath() : J2EEUtil.getInstance().getLocalEnginePath();
                }
                session = SessionLocator.findEJBSessionByPath(conn, cinfo, path2);
            } else if (SessionLocator.usesWsiTransport(providerURL)) {
                session = SessionLocator.createNewSoapSession(conn, providerURL, path);
            } else if (path == null || path.length() < 1 || path.equals("/")) {
                cinfo = SessionLocator.resolveContextInfoRuntime(cinfo);
                session = SessionLocator.findEJBSession(conn, cinfo);
            } else {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String path2 = path;
                if (path != null && J2EEUtil.getInstance() instanceof J2EEUtilWSL) {
                    if (path.equals("FileNet/Engine")) {
                        path2 = J2EEUtil.getInstance().getRemoteEnginePath();
                    } else if (path.indexOf("FileNet/Local/Engine") > -1) {
                        path2 = J2EEUtil.getInstance().getLocalEnginePath();
                    }
                }
                if (J2EEUtil.getInstance() instanceof J2EEUtilWL) {
                    session = SessionLocator.findEJBSessionByPath(conn, path2);
                } else {
                    cinfo = SessionLocator.resolveContextInfoRuntime(cinfo);
                    session = SessionLocator.findEJBSessionByPath(conn, cinfo, path2);
                }
            }
            if (session != null) {
                return session;
            }
        }
        return null;
    }

    public static ContextInfo initContextInfo(ConnectionImpl conn) {
        ContextInfo cinfo = new ContextInfo();
        cinfo.conn = conn;
        cinfo.conKey = SessionLocator.getConnectionKey(conn);
        return cinfo;
    }

    private static ContextInfo resolveContextInfo(ConnectionImpl conn) throws NamingException {
        return SessionLocator.resolveContextInfo(SessionLocator.initContextInfo(conn));
    }

    public static ContextInfo resolveContextInfoRuntime(ContextInfo cinfo) {
        try {
            return SessionLocator.resolveContextInfo(cinfo);
        }
        catch (NamingException ne) {
            throw new EngineRuntimeException(ne, ExceptionCode.API_UNEXPECTED_JNDI_ERROR, null);
        }
    }

    private static ContextInfo resolveContextInfo(ContextInfo cinfo) throws NamingException {
        if (cinfo.ctx != null) {
            return cinfo;
        }
        cinfo.ctx = J2EEUtil.getInitialContextWithParameters((ConnectionImpl)cinfo.conn, null);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.resolveContextInfo created new InitialContext : " + SessionLocator.getJNDIDebugText(cinfo));
        }
        return cinfo;
    }

    private static boolean usesWsiTransport(String providerURL) {
        if (providerURL == null) {
            return false;
        }
        return providerURL.substring(0, 4).equalsIgnoreCase("http");
    }

    public static boolean isExecutingInServer() {
        boolean ret = SessionLocator.getServerSessionConstructor() != null && SessionLocator.isServerSessionEnabled();
        return ret;
    }

    private static StringBuilder getJNDIDebugText(ContextInfo cinfo) {
        try {
            return SessionLocator.getJNDIDebugText(cinfo.ctx, cinfo.ctx.getEnvironment());
        }
        catch (NamingException e) {
            logger.error("exception in getJNDIDebugText", e);
            return new StringBuilder("<null>");
        }
    }

    private static StringBuilder getJNDIDebugText(Context ctx, Hashtable env) {
        StringBuilder txt = new StringBuilder();
        Set entries = env.entrySet();
        Iterator iter = entries.iterator();
        txt.append(' ');
        txt.append(ctx);
        txt.append(' ');
        txt.append("JNDI InitialContext environment");
        while (iter.hasNext()) {
            Map.Entry ent = iter.next();
            String key = ent.getKey().toString();
            Object value = ent.getValue();
            if ("java.naming.security.credentials".equals(key) || key.endsWith("password")) {
                value = "*****";
            }
            txt.append("\n key=");
            txt.append(key);
            txt.append(" Value=");
            txt.append(value);
        }
        return txt;
    }

    private static Session createNewSoapSession(ConnectionImpl conn, String providerURL, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.createNewSoapSession called with providerURL " + (providerURL != null ? providerURL : "null") + " path " + (path != null ? path : "null"));
        }
        if (path == null || path.length() < 1 || path.equals("/")) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        String query = "";
        URI uri = conn.getAsURI();
        if (uri != null && uri.getQuery() != null) {
            query = "?" + uri.getQuery();
        }
        String soapURI = providerURL + path + query;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Instantiating a SoapSession instance using uri " + soapURI);
        }
        return new ServiceSessionNst(soapURI);
    }

    private static ConnectionImpl getDefaultConnectionFromExisting(ConnectionImpl conn) {
        String uri = ConfigValueLookup.getValue("Engine", null);
        if (uri != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.getDefaultConnectionFromExisting called a URI was found " + uri);
            }
            return new ConnectionImpl(uri);
        }
        return conn;
    }

    private static Session findEJBSession(Connection conn, ContextInfo cinfo) {
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSession is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        Object ejb = SessionLocator.getEJB(cinfo);
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cinfo);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSession called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSession called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Session findEJBSessionByPath(ConnectionImpl conn, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.findEJBSessionByPath called path=" + path);
        }
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSessionByPath is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        Object ejb = null;
        ContextInfo cinfo = SessionLocator.initContextInfo(conn);
        HashMap hashMap = ejbHomeCacheMap;
        synchronized (hashMap) {
            ejb = ejbHomeCacheMap.get(cinfo.conKey);
            if (ejb == null && (ejb = SessionLocator.locateEJBByPath(cinfo = SessionLocator.resolveContextInfoRuntime(cinfo), path)) != null) {
                ejbHomeCacheMap.put(cinfo.conKey, ejb);
            }
        }
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cinfo.ctx);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    private static Session findEJBSessionByPath(Connection conn, ContextInfo cinfo, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.findEJBSessionByPath called path=" + path);
        }
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSessionByPath is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        Object ejb = SessionLocator.locateEJBByPath(cinfo, path);
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cinfo.ctx);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    public static Object locateEJBByPath(ContextInfo cinfo, String path) {
        if (cinfo == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBByPath called with a null context and path of " + path);
            }
            return null;
        }
        try {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBBypath called with path: " + path + ", using context: " + cinfo.ctx);
            }
            Object o = cinfo.ctx.lookup(path);
            if (logger.isDetailTraceEnabled()) {
                if (o == null) {
                    logger.traceDetail("SessionLocator.locateEJBBypath found null object using context: " + cinfo.ctx);
                } else {
                    logger.traceDetail("SessionLocator.locateEJBBypath found object : " + o.getClass().getName() + '@' + Integer.toHexString(o.hashCode()) + ' ' + o + ", using context: " + cinfo.ctx);
                    SessionLocator.logLocalOrRemoteEJB(o);
                }
            }
            return o;
        }
        catch (NamingException ne) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBByPath was called with a path of " + path + " and resulted in an exception " + ne.toString());
            }
            if (!SessionLocator.isNamingExceptionTolerated(ne)) {
                throw new EngineRuntimeException(ne, ExceptionCode.API_UNEXPECTED_JNDI_ERROR, null);
            }
            return null;
        }
    }

    private static void logLocalOrRemoteEJB(Object o) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Located EJB Home " + o);
            logger.traceDetail("instanceof " + EJBLocalHome.class.getSimpleName() + "? " + (o instanceof EJBLocalHome));
            logger.traceDetail("instanceof " + EJBHome.class.getSimpleName() + "? " + (o instanceof EJBHome));
        }
    }

    private static boolean isNamingExceptionTolerated(NamingException ne) {
        return ne instanceof NameNotFoundException || ne.getRootCause() instanceof NameNotFoundException || ne instanceof LinkException || ne instanceof ConfigurationException;
    }

    public static void setEnableServerSession(boolean enable) {
        if (enable) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.setEnableServerSession(true) called");
            }
            enableServerSession.set(Boolean.TRUE);
        } else {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.setEnableServerSession(false) called");
            }
            enableServerSession.set(null);
        }
    }

    public static boolean isServerSessionEnabled() {
        if (enableServerSession.get() == null) {
            return false;
        }
        return (Boolean)enableServerSession.get();
    }

    public static void setClassLoader(ClassLoader ncl) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.setClassLoader called " + ncl.toString());
        }
        cl = ncl;
        SessionLocator.loadSessionConstructors();
    }

    public static void setServerSessionConstructor(Constructor ssc) {
        if (logger.isDetailTraceEnabled() && ssc != null) {
            logger.traceDetail("SessionLocator.setServerSessionConstructor called " + ssc.getName());
        }
        serverSessionOverRide.set(ssc);
    }

    public static Constructor getServerSessionConstructor() {
        if (serverSessionOverRide.get() != null) {
            return (Constructor)serverSessionOverRide.get();
        }
        return serverSessionConstructor;
    }

    private static Constructor findServerSessionConstructor() {
        Constructor<?> ret = null;
        try {
            Class<?> serverSessionClass = cl.loadClass(SERVER_SESSION_CLASS_NAME);
            ret = serverSessionClass.getConstructor(null);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor com.filenet.engine.context.ServerSession found");
            }
        }
        catch (NoClassDefFoundError ncd) {
            ret = null;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + ncd.toString());
            }
        }
        catch (ClassNotFoundException cnf) {
            ret = null;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + cnf.toString());
            }
        }
        catch (EngineRuntimeException ert) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + ert.toString());
            }
            throw ert;
        }
        catch (Throwable t) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + t.toString());
            }
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{SERVER_SESSION_CLASS_NAME});
        }
        return ret;
    }

    private static void loadSessionConstructors() {
        serverSessionConstructor = SessionLocator.findServerSessionConstructor();
        try {
            Class<?> EJBSessionClass = cl.loadClass(EJB_SESSION_CLASS_NAME);
            EJBSessionConstructor = EJBSessionClass.getConstructor(Object.class, Context.class);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor com.filenet.apiimpl.transport.ejb.EJBSession found");
            }
        }
        catch (NoClassDefFoundError ncd) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = ncd;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + ncd.toString());
            }
        }
        catch (ClassNotFoundException cnf) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = cnf;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + cnf.toString());
            }
        }
        catch (EngineRuntimeException ert) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = ert;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + ert.toString());
            }
            throw ert;
        }
        catch (Throwable t) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = t;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + t.toString());
            }
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
        }
    }

    static {
        enableServerSession = new ThreadLocal();
        serverSessionOverRide = new ThreadLocal();
        cl = SessionLocator.class.getClassLoader();
        SessionLocator.loadSessionConstructors();
    }

    public static class ContextInfo {
        Connection conn;
        Context ctx;
        String conKey;

        public String toString() {
            return this.conKey;
        }
    }
}

