/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.Cache;
import com.filenet.apiimpl.util.CacheEntry;
import java.util.HashMap;
import java.util.Iterator;

public final class TransientCache
extends Cache {
    private HashMap idMap = new HashMap();
    private HashMap valueMap = null;

    public TransientCache(boolean needByValue) {
        this.maxEntries = 0;
        if (needByValue) {
            this.valueMap = new HashMap();
        }
    }

    @Override
    public void add(CacheEntry ce) {
        this.idMap.put(ce.getId(), ce);
        if (this.valueMap != null && ce.getValue() != null) {
            this.valueMap.put(ce.getValue(), ce);
        }
    }

    @Override
    public void removeCacheEntry(CacheEntry ce) {
        this.idMap.remove(ce.getId());
        if (this.valueMap != null && ce.getValue() != null) {
            this.valueMap.remove(ce.getValue());
        }
    }

    @Override
    public CacheEntry find(Object id) {
        return (CacheEntry)this.idMap.get(id);
    }

    @Override
    public CacheEntry findByValue(Object value) {
        if (this.valueMap == null) {
            return null;
        }
        return (CacheEntry)this.valueMap.get(value);
    }

    @Override
    public void purge(Object id) {
        CacheEntry ce = (CacheEntry)this.idMap.remove(id);
        if (ce != null && ce.getValue() != null && this.valueMap != null) {
            this.valueMap.remove(ce.getValue());
        }
    }

    public Iterator<CacheEntry> iterator() {
        return this.idMap.values().iterator();
    }
}

