/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.XMLObjectReader;
import com.filenet.apiimpl.util.XMLObjectSource;
import com.filenet.apiimpl.util.XMLTraceReader;
import com.filenet.apiimpl.util.XMLTraceReaderBasic;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.XMLReader;

public class XMLHelper {
    private static final char[] digits = "0123456789ABCDEF".toCharArray();

    public static String transform(String name, Object object) {
        StreamResult result = new StreamResult(new StringWriter(1024));
        XMLHelper.transform(name, object, result);
        return result.getWriter().toString();
    }

    public static void transform(String name, Object object, Result result) {
        try {
            SAXSource source = new SAXSource(new XMLObjectReader(), new XMLObjectSource(name, object));
            TransformerFactory factory = SAXTransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            throw Exceptions.evaluate(e);
        }
    }

    public static String trace(String name, Object object) {
        return XMLHelper.trace(name, object, true);
    }

    public static String trace(String name, Object object, boolean isDetail) {
        StreamResult result = new StreamResult(new StringWriter(1024));
        XMLHelper.trace(name, object, result, isDetail);
        return result.getWriter().toString().trim();
    }

    public static void trace(String name, Object object, Result result, boolean isDetail) {
        try {
            SAXSource source = new SAXSource(XMLHelper.getTraceReader(isDetail), new XMLObjectSource(name, object));
            TransformerFactory factory = SAXTransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            XMLHelper.configureTraceOutputProperties(transformer);
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            throw Exceptions.evaluate(e);
        }
    }

    private static XMLReader getTraceReader(boolean isDetail) throws Exception {
        final String name = ConfigValueLookup.getValue("TraceReaderClass", "").trim();
        if (name.length() == 0) {
            if (isDetail) {
                return new XMLTraceReader();
            }
            return new XMLTraceReaderBasic();
        }
        return (XMLReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = XMLHelper.class.getClassLoader();
                }
                return loader.loadClass(name).newInstance();
            }
        });
    }

    private static void configureTraceOutputProperties(Transformer transformer) {
        int index;
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        String properties = ConfigValueLookup.getValue("TraceOutputProperties", "");
        int from = 0;
        while (from < properties.length() && (index = properties.indexOf(61, from)) != -1) {
            String key = properties.substring(from, index).trim();
            from = index + 1;
            if ((index = properties.indexOf(44, from)) == -1) {
                index = properties.length();
            }
            String value = properties.substring(from, index).trim();
            from = index + 1;
            transformer.setOutputProperty(key, value);
        }
    }

    public static boolean isUnicodeIdentifier(String name) {
        int length;
        int n = length = name == null ? 0 : name.length();
        if (length == 0) {
            return false;
        }
        if (!Character.isUnicodeIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (Character.isUnicodeIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidChar(char c) {
        if (c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028') {
            return false;
        }
        if (c == '\t') {
            return true;
        }
        if (c >= ' ' && c <= '\ud7ff') {
            return true;
        }
        return c >= '\ue000' && c <= '\ufffd';
    }

    public static boolean isValidText(String text) {
        if (text == null) {
            return true;
        }
        for (int i = text.length() - 1; i >= 0; --i) {
            if (XMLHelper.isValidChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String encodeText(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        int size = (int)Math.max((long)length, (long)length + (long)(length / 4));
        StringBuffer buffer = new StringBuffer(size);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c != '^' && XMLHelper.isValidChar(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append('^');
            if (c > '\u00ff') {
                buffer.append('^');
                buffer.append(digits[c >> 12 & 0xF]);
                buffer.append(digits[c >> 8 & 0xF]);
            }
            buffer.append(digits[c >> 4 & 0xF]);
            buffer.append(digits[c & 0xF]);
        }
        return buffer.toString();
    }

    public static String decodeText(String text) {
        if (text == null) {
            return null;
        }
        int position = 0;
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        while (position < length) {
            int end;
            char c;
            if ((c = text.charAt(position++)) != '^') {
                buffer.append(c);
                continue;
            }
            int start = position;
            if (start < length && text.charAt(start) == '^') {
                ++start;
            }
            if ((end = start + 2 * (start - position + 1)) > length) {
                buffer.append(c);
                continue;
            }
            int value = 0;
            while (start < end) {
                char next;
                if ((next = text.charAt(start++)) >= '0' && next <= '9') {
                    value = value << 4 | next - 48 & 0xF;
                    continue;
                }
                if (next >= 'A' && next <= 'F') {
                    value = value << 4 | 10 + (next - 65) & 0xF;
                    continue;
                }
                if (next >= 'a' && next <= 'f') {
                    value = value << 4 | 10 + (next - 97) & 0xF;
                    continue;
                }
                value = -1;
                break;
            }
            if (value == -1) {
                buffer.append(c);
                continue;
            }
            buffer.append((char)value);
            position = end;
        }
        return buffer.toString();
    }

    public static boolean isValidText(String[] text) {
        if (text == null) {
            return true;
        }
        for (int i = text.length - 1; i >= 0; --i) {
            if (XMLHelper.isValidText(text[i])) continue;
            return false;
        }
        return true;
    }

    public static void encodeText(String[] text) {
        if (text == null) {
            return;
        }
        for (int i = text.length - 1; i >= 0; --i) {
            text[i] = XMLHelper.encodeText(text[i]);
        }
    }

    public static void decodeText(String[] text) {
        if (text == null) {
            return;
        }
        for (int i = text.length - 1; i >= 0; --i) {
            text[i] = XMLHelper.decodeText(text[i]);
        }
    }

    public static String popularEntityEncode(String in) {
        boolean needsEncoding;
        int inLen;
        if (in == null || (inLen = in.length()) == 0) {
            return in;
        }
        boolean bl = needsEncoding = in.indexOf("&") >= 0 || in.indexOf(">") >= 0 || in.indexOf("<") >= 0;
        if (!needsEncoding) {
            return in;
        }
        StringBuffer sb = new StringBuffer(inLen + 10);
        block5: for (int ii = 0; ii < inLen; ++ii) {
            char c = in.charAt(ii);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

