/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.CacheEntry;
import com.filenet.apiimpl.util.Digest;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CodeModuleClassLoader;
import java.net.URL;
import java.util.Collection;

final class CMCLCacheEntry
extends CacheEntry {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(CMCLCacheEntry.class, SubSystem.CodeModule);
    private final String key;
    private final CodeModuleClassLoader cmcl;

    CMCLCacheEntry(CodeModuleClassLoader cmcl, String key) {
        this.key = key;
        this.cmcl = cmcl;
    }

    @Override
    public Object getId() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.cmcl;
    }

    static String makeKey(Id osId, Id cmId, String className, Collection<URL> jboj, Collection<String> augmentedWhiteList, boolean doParentFirstForClasses, boolean doParentFirstForResources, ClassLoader parentClassLoader) {
        String key = (cmId != null ? cmId.toString() : "cm") + "-" + (className != null ? className : "cn") + "-" + (jboj != null ? "^0x" + Integer.toHexString(System.identityHashCode(jboj)) + ":0x" + Long.toHexString(Digest.checksum(jboj)) : "jboj") + "-" + (augmentedWhiteList != null ? "^0x" + Integer.toHexString(System.identityHashCode(augmentedWhiteList)) + ":0x" + Long.toHexString(Digest.checksum(augmentedWhiteList)) : "awl") + "-" + (osId != null ? osId.toString() : "os") + "-" + (doParentFirstForClasses ? "PFc" : "PLc") + "-" + (doParentFirstForResources ? "PFr" : "PLr") + (parentClassLoader == null ? "^^" : "^0x" + Integer.toHexString(System.identityHashCode(parentClassLoader)) + "^");
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCLCacheEntry.makeKey() => " + key);
        }
        return key;
    }

    @Override
    protected void removed() {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("CMCL removed from cache " + this.cmcl);
        }
        this.cmcl.removedFromCacheCallback();
        super.removed();
    }
}

