/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.classloader;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.classloader.CodeModuleClassLoader;
import com.filenet.apiimpl.util.classloader.ScriptEngine;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ScriptHandler {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ScriptHandler.class, SubSystem.Events);
    public static final String SCRIPT_JAVASCRIPT = "JavaScript";
    private static boolean cacheEngines = ConfigValueLookup.getValueAsBoolean("com.filenet.apiimpl.util.classloader.CacheEngines", true);
    private static boolean useCMCL = ConfigValueLookup.getValueAsBoolean("com.filenet.apiimpl.util.classloader.UseCMCL", true);
    private static Map<String, ScriptEngineConfig> scriptIdToConfig = new HashMap<String, ScriptEngineConfig>();
    private static ConcurrentHashMap<String, ScriptEngine> cachedEngines;

    public static Object execute(String scriptOrClassName, String scriptText, String scriptMethod, Object[] parameters) {
        ScriptEngine engine = ScriptHandler.getEngine(scriptOrClassName, scriptText);
        return engine.execute(scriptMethod, parameters);
    }

    public static ScriptEngine getEngine(String scriptOrClassName, String scriptText) {
        String simpleClassName = scriptOrClassName;
        int lastDotAt = simpleClassName.lastIndexOf(46);
        if (lastDotAt > 0) {
            simpleClassName = simpleClassName.substring(0, lastDotAt);
        }
        ScriptEngine engine = null;
        if (cacheEngines) {
            engine = cachedEngines.get(scriptText);
        }
        if (logger.isDetailTraceEnabled()) {
            if (engine == null) {
                logger.traceDetail("SCRIPT: " + simpleClassName + " script engine cache miss, script hash=" + scriptText.hashCode());
            } else {
                logger.traceDetail("SCRIPT: " + simpleClassName + " script engine cache hit, script hash=" + scriptText.hashCode() + " " + engine);
            }
        }
        if (engine == null) {
            ScriptEngineConfig config = scriptIdToConfig.get(scriptOrClassName.toLowerCase());
            if (config != null) {
                engine = config.getInstance();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SCRIPT: " + simpleClassName + " script engine instantiated, script text hash=" + scriptText.hashCode() + " " + engine);
                }
                engine.initialize(scriptText);
                if (cacheEngines) {
                    cachedEngines.put(scriptText, engine);
                }
            } else {
                throw new EngineRuntimeException(ExceptionCode.SCRIPT_ERROR, null, ExceptionContext.E_REF_CLASS_NOT_FOUND, new Object[]{scriptOrClassName});
            }
        }
        return engine;
    }

    private ScriptHandler() {
    }

    static {
        ArrayList<String> augmentedWhiteListForCMCL_JS = new ArrayList<String>(2);
        augmentedWhiteListForCMCL_JS.add("com.filenet.apiimpl.util.classloader.JavaScriptEngine");
        augmentedWhiteListForCMCL_JS.add("com.filenet.apiimpl.util.classloader.JavaScriptEngine$CompiledScope");
        scriptIdToConfig.put(SCRIPT_JAVASCRIPT.toLowerCase(), new ScriptEngineConfig("com.filenet.apiimpl.util.classloader.JavaScriptEngine", "JavaScriptEngine", new String[]{"js.jar"}, augmentedWhiteListForCMCL_JS));
        cachedEngines = new ConcurrentHashMap();
    }

    private static class ScriptEngineConfig {
        private static final String STALKING_HORSE_JAR_NAME = "Jace.jar";
        private final String className;
        private String classSimpleName;
        private final String[] specialJars;
        private Class<?> clazz;
        private final Collection<String> augmentedWhiteList;
        static String urlBase;

        private static boolean isViableBaseUrl() {
            try {
                String stalkingHorseUrl = urlBase + STALKING_HORSE_JAR_NAME;
                if (logger.isDebugEnabled()) {
                    logger.traceDetail("SCRIPT: Opening resource as stream " + stalkingHorseUrl);
                }
                URL theJar = new URL(stalkingHorseUrl);
                InputStream is = theJar.openStream();
                is.close();
                if (logger.isDebugEnabled()) {
                    logger.traceDetail("SCRIPT: success " + stalkingHorseUrl);
                }
                return true;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.traceDetail("SCRIPT: Exception caught: " + e);
                }
                return false;
            }
        }

        private static String findUrlBaseFromProtectionDomain() {
            String resultBaseUrl = null;
            URL urlPD = ScriptHandler.class.getProtectionDomain().getCodeSource().getLocation();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SCRIPT: PD.CS.Loc for " + ScriptHandler.class.getSimpleName() + " is " + urlPD);
            }
            if (urlPD != null) {
                resultBaseUrl = urlPD.toExternalForm();
                int jarNameAt = resultBaseUrl.indexOf(STALKING_HORSE_JAR_NAME);
                if (jarNameAt != -1) {
                    resultBaseUrl = resultBaseUrl.substring(0, jarNameAt);
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("SCRIPT: PD.CS.Loc trimmed to " + resultBaseUrl);
                    }
                } else {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("SCRIPT: PD.CS.Loc could not be trimmed");
                    }
                    resultBaseUrl = null;
                }
            }
            return resultBaseUrl;
        }

        private static String findUrlBaseFromGetResource() {
            String resultBaseUrl;
            int jarNameAt;
            String withDots = ScriptHandler.class.getName();
            String withSlashes = withDots.replace('.', '/') + ".class";
            URL urlGR = ScriptHandler.class.getClassLoader().getResource(withSlashes);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SCRIPT: CL.gR loc for " + ScriptHandler.class.getSimpleName() + " is " + urlGR);
            }
            if ((jarNameAt = (resultBaseUrl = urlGR.toExternalForm()).indexOf(STALKING_HORSE_JAR_NAME)) != -1) {
                resultBaseUrl = resultBaseUrl.substring(0, jarNameAt);
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SCRIPT: CL.gR loc trimmed to " + resultBaseUrl);
                }
            } else {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SCRIPT: CL.gR loc could not be trimmed");
                }
                resultBaseUrl = null;
            }
            return resultBaseUrl;
        }

        ScriptEngineConfig(String className, String classSimpleName, String[] specialJars, Collection<String> augmentedWhiteList) {
            this.className = className;
            this.classSimpleName = classSimpleName;
            this.specialJars = specialJars;
            this.augmentedWhiteList = augmentedWhiteList;
        }

        private static final URL jarNameToUrl(String jarName) {
            try {
                return new URL(urlBase + jarName);
            }
            catch (MalformedURLException e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }

        ScriptEngine getInstance() {
            try {
                if (this.clazz == null) {
                    if (useCMCL) {
                        ArrayList<URL> specialJarUrls = null;
                        if (this.specialJars != null && this.specialJars.length > 0) {
                            specialJarUrls = new ArrayList<URL>();
                            for (String specialJar : this.specialJars) {
                                URL url = ScriptEngineConfig.jarNameToUrl(specialJar);
                                if (url == null) continue;
                                specialJarUrls.add(url);
                            }
                        }
                        if (logger.isDetailTraceEnabled()) {
                            logger.traceDetail("SCRIPT: " + this.classSimpleName + " engine config: " + specialJarUrls);
                        }
                        ClassLoader cmcl = CodeModuleClassLoader.getInstance(specialJarUrls, this.augmentedWhiteList, false, false, null);
                        this.clazz = cmcl.loadClass(this.className);
                    } else {
                        this.clazz = Class.forName(this.className);
                    }
                }
                return (ScriptEngine)this.clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new EngineRuntimeException(e, ExceptionCode.SCRIPT_ERROR, null, ExceptionContext.E_REF_CLASS_NOT_FOUND, new Object[]{this.className});
            }
            catch (Throwable t) {
                throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }

        static {
            if (useCMCL) {
                try {
                    urlBase = ScriptEngineConfig.findUrlBaseFromProtectionDomain();
                    if (logger.isDebugEnabled()) {
                        logger.traceDetail("SCRIPT: PD.CS.Loc base = " + urlBase);
                    }
                    if (urlBase == null) {
                        urlBase = ScriptEngineConfig.findUrlBaseFromGetResource();
                        if (logger.isDebugEnabled()) {
                            logger.traceDetail("SCRIPT: CL.gR loc base = " + urlBase);
                        }
                    }
                    if (urlBase != null && !ScriptEngineConfig.isViableBaseUrl()) {
                        urlBase = null;
                    }
                }
                catch (Throwable t) {
                    logger.traceDetail("SCRIPT: ScriptHandler error when attempting to determine base URL: " + t);
                    urlBase = null;
                }
                if (urlBase == null) {
                    useCMCL = false;
                    logger.traceDetail("SCRIPT: Disabling CMCL usage due to null baseURL");
                } else {
                    useCMCL = true;
                    logger.traceDetail("SCRIPT: Enabling CMCL usage for baseURL " + urlBase);
                }
            }
        }
    }
}

