/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util.json;

import com.filenet.apiimpl.util.json.JSON;
import com.filenet.apiimpl.util.json.JSONArtifact;
import com.filenet.apiimpl.util.json.Tokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    public JSONArray() {
    }

    protected JSONArray(Tokenizer tkr) throws IOException {
        Tokenizer.Token tok;
        Tokenizer.TokenType tt;
        do {
            if ((tt = (tok = tkr.nextToken()).getTokenType()) == Tokenizer.TokenType.CLOSE_SQUARE) {
                return;
            }
            Object elemVal = JSON.decodeToken(tok, tkr);
            this.add(elemVal);
            tok = tkr.nextToken();
            tt = tok.getTokenType();
            if (tt != Tokenizer.TokenType.CLOSE_SQUARE) continue;
            return;
        } while (tt == Tokenizer.TokenType.COMMA);
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON; expecting COMMA or CLOSE_SQUARE");
    }

    public static JSONArray parse(String json) throws IOException {
        Tokenizer tkr = new Tokenizer(new StringReader(json));
        Tokenizer.Token tok = tkr.nextToken();
        if (tok.getTokenType().equals((Object)Tokenizer.TokenType.OPEN_SQUARE)) {
            return new JSONArray(tkr);
        }
        throw new RuntimeException("Unexpected token " + tok + " while parsing JSON array; expecting OPEN_SQUARE");
    }

    @Override
    public String serialize() throws IOException {
        return this.toString();
    }

    public void serialize(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    @Override
    public void serialize(OutputStream os) throws IOException {
        this.serialize(new OutputStreamWriter(os));
    }

    public String getString(int index) {
        Object val = this.get(index);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        this.toJsonString(sb);
        return sb.toString();
    }

    void toJsonString(StringBuilder sb) {
        sb.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            JSON.toJsonString(sb, this.get(i));
        }
        sb.append("]");
    }
}

