/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.util.SessionContext;
import java.util.HashMap;
import javax.security.auth.Subject;

public class ClientInfo {
    public static final int VERSION_FNCEWS10 = 300;
    public static final int VERSION_FNCEWS35 = 350;
    public static final int VERSION_FNCEWS40 = 400;
    private static final int VERSION_DEFAULT = ClientCallContext.VERSION_DEFAULT;
    public static final int BINDING_SOAP = 3;
    public static final int BINDING_MTOM = 4;
    private static final int BINDING_DEFAULT = 4;
    public static final String WSDL_VERSION = "WSDL_VERSION";
    public static final String BINDING = "FNCEWS_BINDING";
    public static final String LOCATION = "FNCEWS_LOCATION";
    public static final int LOCATION_CLIENT = 1;
    public static final int LOCATION_SERVER = 2;
    private static final String FNCEWS10 = "/FNCEWS10";
    private static final String FNCEWS35 = "/FNCEWS35";
    private static final String FNCEWS40 = "/FNCEWS40";
    private static final String SOAP = "SOAP";
    private static final String MTOM = "MTOM";
    private static final String SECURITY_TOKEN = "SECURITY_TOKEN";
    private static final String TRANSPORT_REQUEST = "TRANSPORT_REQUEST";

    public static int getVersion() {
        return ClientInfo.getIntValue(WSDL_VERSION, VERSION_DEFAULT);
    }

    public static void setVersion(int versionVal) {
        ClientInfo.setValue(WSDL_VERSION, versionVal);
    }

    public static int getBinding() {
        return ClientInfo.getIntValue(BINDING, 4);
    }

    public static void setBinding(int bindingVal) {
        ClientInfo.setValue(BINDING, bindingVal);
    }

    public static int getLocation() {
        return ClientInfo.getIntValue(LOCATION, 1);
    }

    public static void setLocation(int locationVal) {
        ClientInfo.setValue(LOCATION, locationVal);
    }

    public static Request getRequest() {
        return (Request)ClientInfo.getValue(TRANSPORT_REQUEST);
    }

    public static void setRequest(Request request) {
        ClientInfo.setValue(TRANSPORT_REQUEST, request);
    }

    private static int getIntValue(Object key, int defaultValue) {
        Object value = ClientInfo.getValue(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    private static Object getValue(Object key) {
        HashMap values = SessionContext.getRuntimeValues();
        return values == null ? null : values.get(key);
    }

    private static void setValue(Object key, Object value) {
        HashMap values = SessionContext.getRuntimeValues();
        if (values != null) {
            values.put(key, value);
        }
    }

    public static Integer determineWsdlVersion(String address) {
        String path = address.toUpperCase();
        if (path.indexOf(FNCEWS40) != -1) {
            return 400;
        }
        if (path.indexOf(FNCEWS35) != -1) {
            return 350;
        }
        if (path.indexOf(FNCEWS10) != -1) {
            return 300;
        }
        return null;
    }

    public static Integer determineBinding(String address) {
        String path = address.toUpperCase();
        if (path.indexOf(MTOM) != -1) {
            return 4;
        }
        if (path.indexOf(SOAP) != -1) {
            return 3;
        }
        return null;
    }

    public static void setSubject(Subject sub) {
        HashMap values = SessionContext.getRuntimeValues();
        if (values != null) {
            values.put(SECURITY_TOKEN, sub);
        }
    }

    public static Subject getSubject() {
        HashMap values = SessionContext.getRuntimeValues();
        return values == null ? null : values.get(SECURITY_TOKEN);
    }
}

