/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.constants.Charsets;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.MultipartInputStreamManager;
import com.filenet.apiimpl.util.SpillStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;

public final class MtomInputStreamManager
extends MultipartInputStreamManager {
    private byte[] masterBuffer;
    private PushbackInputStream masterInputStream;
    private static final byte[] CRLF_DASHES = Charsets.getBytes("\r\n--");
    private int firstAvailableCallerBytePosition = 0;
    private int firstMasterBufUnfilledBytePosition = 0;
    private static final int NO_BOUNDARY_IN_BUFFER = Integer.MAX_VALUE;
    private int possibleCrlfBoundaryAt = Integer.MAX_VALUE;
    private boolean completeCrlfBoundary = false;
    private boolean masterEOF = false;
    private byte[] crlfDashesMimeBoundary;

    private void ctorInit(String mimeBoundary, InputStream masterIS, int masterBufferSize) {
        if (mimeBoundary == null) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_NO_MIME_BOUNDARY, null);
        }
        this.crlfDashesMimeBoundary = new byte[CRLF_DASHES.length + mimeBoundary.length()];
        System.arraycopy(CRLF_DASHES, 0, this.crlfDashesMimeBoundary, 0, CRLF_DASHES.length);
        byte[] mbBytes = Charsets.getBytes(mimeBoundary, Charsets.CHARSET_ISO_8859_1);
        System.arraycopy(mbBytes, 0, this.crlfDashesMimeBoundary, CRLF_DASHES.length, mbBytes.length);
        this.masterInputStream = new PushbackInputStream(masterIS);
        int minimumBufferSize = Math.max(masterBufferSize, 50 + this.crlfDashesMimeBoundary.length);
        this.masterBuffer = new byte[minimumBufferSize];
        this.masterBuffer[0] = 13;
        this.masterBuffer[1] = 10;
        this.firstAvailableCallerBytePosition = 0;
        this.possibleCrlfBoundaryAt = 0;
        this.firstMasterBufUnfilledBytePosition = 2;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("MIME boundary: " + mimeBoundary);
            logger.traceDetail("Master buffer size: " + masterBufferSize);
        }
    }

    public MtomInputStreamManager(String mimeBoundary, String rootContentId, InputStream masterIS, int masterBufferSize, SpillStreamFactory ssF) {
        super(rootContentId, ssF);
        this.ctorInit(mimeBoundary, masterIS, masterBufferSize);
    }

    public MtomInputStreamManager(String messageContentType, InputStream masterIS, int masterBufferSize, SpillStreamFactory ssF) {
        super(null, ssF);
        String[] returnVals = this.parseOutStartAndBoundary(messageContentType);
        super.setRootContentId(returnVals[0]);
        this.ctorInit(returnVals[1], masterIS, masterBufferSize);
    }

    private String[] parseOutStartAndBoundary(String messageContentType) {
        String[] tokens = messageContentType.split("\\s?;\\s?");
        if (tokens.length == 0 || !"multipart/related".equalsIgnoreCase(tokens[0])) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_BAD_HTTP_CONTENT_TYPE, (Object[])new String[]{messageContentType});
        }
        String rootId = "";
        String mimeBoundary = null;
        for (int ii = 1; ii < tokens.length; ++ii) {
            String item = tokens[ii];
            int equalAt = item.indexOf(61);
            if (equalAt <= 0) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_BAD_HTTP_CONTENT_TYPE, (Object[])new String[]{messageContentType});
            }
            String key = item.substring(0, equalAt).trim();
            String value = item.substring(equalAt + 1).trim();
            if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if ("boundary".equalsIgnoreCase(key)) {
                mimeBoundary = value;
                continue;
            }
            if (!"start".equalsIgnoreCase(key)) continue;
            rootId = value;
        }
        String[] returnVals = new String[]{rootId, mimeBoundary};
        return returnVals;
    }

    private boolean lookForMimeBoundaryInBuffer() {
        int startAt = this.possibleCrlfBoundaryAt == Integer.MAX_VALUE ? this.firstAvailableCallerBytePosition : Math.max(this.possibleCrlfBoundaryAt, this.firstAvailableCallerBytePosition);
        for (int candidate = startAt; candidate < this.firstMasterBufUnfilledBytePosition; ++candidate) {
            if (this.masterBuffer[candidate] != this.crlfDashesMimeBoundary[0]) continue;
            boolean brokeInnerLoop = false;
            for (int mimedex = 1; mimedex < this.crlfDashesMimeBoundary.length; ++mimedex) {
                int bufferByteAt = candidate + mimedex;
                if (bufferByteAt >= this.firstMasterBufUnfilledBytePosition) {
                    this.completeCrlfBoundary = false;
                    this.possibleCrlfBoundaryAt = candidate;
                    return this.completeCrlfBoundary;
                }
                byte boundaryByte = this.crlfDashesMimeBoundary[mimedex];
                byte bufferByte = this.masterBuffer[bufferByteAt];
                if (boundaryByte == bufferByte) continue;
                brokeInnerLoop = true;
                break;
            }
            if (brokeInnerLoop) continue;
            this.completeCrlfBoundary = true;
            this.possibleCrlfBoundaryAt = candidate;
            return this.completeCrlfBoundary;
        }
        this.possibleCrlfBoundaryAt = Integer.MAX_VALUE;
        this.completeCrlfBoundary = false;
        return this.completeCrlfBoundary;
    }

    private void slideLeft() {
        if (this.firstAvailableCallerBytePosition == 0) {
            return;
        }
        int shiftThisManyBytes = this.firstMasterBufUnfilledBytePosition - this.firstAvailableCallerBytePosition;
        if (shiftThisManyBytes > 0) {
            System.arraycopy(this.masterBuffer, this.firstAvailableCallerBytePosition, this.masterBuffer, 0, shiftThisManyBytes);
        }
        if (this.possibleCrlfBoundaryAt != Integer.MAX_VALUE) {
            this.possibleCrlfBoundaryAt -= this.firstAvailableCallerBytePosition;
        }
        this.firstMasterBufUnfilledBytePosition -= this.firstAvailableCallerBytePosition;
        this.firstAvailableCallerBytePosition = 0;
    }

    @Override
    protected int availableRightNow() {
        int justPast = this.possibleCrlfBoundaryAt == Integer.MAX_VALUE ? this.firstMasterBufUnfilledBytePosition : this.possibleCrlfBoundaryAt;
        int availableRightNow = justPast - this.firstAvailableCallerBytePosition;
        return availableRightNow;
    }

    @Override
    protected int eatBytesFromBuffer(byte[] bucket, int destOffset, int howManyToEat) throws IOException {
        System.arraycopy(this.masterBuffer, this.firstAvailableCallerBytePosition, bucket, destOffset, howManyToEat);
        this.firstAvailableCallerBytePosition += howManyToEat;
        if (this.firstAvailableCallerBytePosition >= this.firstMasterBufUnfilledBytePosition) {
            this.makeSomethingAvailable();
        }
        return howManyToEat;
    }

    @Override
    protected MultipartInputStreamManager.ManagedInputStream getNextContentInputStream() throws IOException {
        this.makeSomethingAvailable();
        if (!this.completeCrlfBoundary) {
            return null;
        }
        this.firstAvailableCallerBytePosition = this.possibleCrlfBoundaryAt + this.crlfDashesMimeBoundary.length;
        this.possibleCrlfBoundaryAt = Integer.MAX_VALUE;
        this.completeCrlfBoundary = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int lastByte = -1;
        int crlfdex = 0;
        for (int giveUpDex = 0; giveUpDex < 10000; ++giveUpDex) {
            int thisByte;
            if (this.firstAvailableCallerBytePosition < this.firstMasterBufUnfilledBytePosition) {
                thisByte = this.masterBuffer[this.firstAvailableCallerBytePosition++];
            } else {
                thisByte = -1;
                if (!this.masterEOF) {
                    thisByte = this.masterInputStream.read();
                }
                if (thisByte < 0) {
                    this.closeMIS();
                    if (giveUpDex > 0 && logger.isDetailTraceEnabled()) {
                        byte[] leftOvers = baos.toByteArray();
                        if (leftOvers.length >= 2 && leftOvers[0] == 45 && leftOvers[1] == 45) {
                            logger.traceDetail("Ignoring " + (giveUpDex - 1) + " bytes at the end of the MTOM stream (normal)");
                        } else {
                            String startsWith = Charsets.getString(leftOvers, Charsets.CHARSET_UTF_8);
                            startsWith = startsWith.replace("\n", "<LF>");
                            if ((startsWith = startsWith.replace("\r", "<CR>")).length() > 100) {
                                startsWith = startsWith.substring(0, 99) + "....";
                            }
                            logger.traceDetail("Ignoring " + (giveUpDex - 1) + " bytes at the end of the MTOM stream: " + startsWith);
                        }
                    }
                    return null;
                }
            }
            baos.write(thisByte);
            if (thisByte == 13 || thisByte == 10) {
                if ((crlfdex += thisByte == lastByte ? 2 : 1) >= 4) {
                    break;
                }
            } else {
                crlfdex = 0;
            }
            lastByte = thisByte;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        baos = null;
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)bais, Charsets.CHARSET_ISO_8859_1));
        bais = null;
        String theLine = null;
        String contentId = null;
        String encoding = "binary";
        int headersRead = 0;
        while ((theLine = lnr.readLine()) != null) {
            String[] hv = theLine.split("\\s?:\\s", 2);
            if (hv.length < 2) continue;
            ++headersRead;
            String header = hv[0].trim();
            if ("Content-ID".equalsIgnoreCase(header)) {
                contentId = hv[1].trim();
                continue;
            }
            if (!"Content-Transfer-Encoding".equalsIgnoreCase(header)) continue;
            encoding = hv[1].trim();
        }
        if (headersRead == 0) {
            return null;
        }
        if (contentId == null || contentId.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_NO_CONTENT_ID, null);
        }
        if (!"binary".equalsIgnoreCase(encoding) && !"8bit".equalsIgnoreCase(encoding)) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_UNSUPPORTED_ENCODING, (Object[])new String[]{encoding});
        }
        MultipartInputStreamManager.ManagedInputStream contentInputStream = (MultipartInputStreamManager.ManagedInputStream)this.instantiateContentInputStream(contentId);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("iPART MTOMpart   CID=" + contentId + "; CIS=" + System.identityHashCode(contentInputStream) + " " + contentInputStream.getClass().getSimpleName());
        }
        this.makeSomethingAvailable();
        return contentInputStream;
    }

    private void closeMIS() {
        this.masterEOF = true;
        try {
            this.masterInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean peekForDashes() throws IOException {
        if (!this.completeCrlfBoundary) {
            return false;
        }
        int justAfterBoundary = this.possibleCrlfBoundaryAt + this.crlfDashesMimeBoundary.length;
        if (justAfterBoundary < this.firstMasterBufUnfilledBytePosition) {
            boolean isDash = this.masterBuffer[justAfterBoundary] == 45;
            return isDash;
        }
        if (this.masterEOF) {
            return false;
        }
        int first = this.masterInputStream.read();
        if (first < 0) {
            this.closeMIS();
            return false;
        }
        this.masterInputStream.unread(first);
        boolean isDash = (byte)first == 45;
        return isDash;
    }

    @Override
    protected boolean isManagedInputStreamAtLogicalEOF() throws IOException {
        if (this.completeCrlfBoundary) {
            return this.firstAvailableCallerBytePosition == this.possibleCrlfBoundaryAt;
        }
        if (this.possibleCrlfBoundaryAt == Integer.MAX_VALUE) {
            if (this.firstAvailableCallerBytePosition < this.firstMasterBufUnfilledBytePosition - 1) {
                return false;
            }
            if (this.masterEOF) {
                return true;
            }
            this.makeSomethingAvailable();
            return this.isManagedInputStreamAtLogicalEOF();
        }
        if (this.firstAvailableCallerBytePosition < this.possibleCrlfBoundaryAt) {
            return false;
        }
        if (this.masterEOF) {
            return true;
        }
        this.makeSomethingAvailable();
        return this.isManagedInputStreamAtLogicalEOF();
    }

    @Override
    protected void makeSomethingAvailable() throws IOException {
        this.slideLeft();
        while (this.masterBuffer.length - this.firstMasterBufUnfilledBytePosition > 0 && !this.masterEOF) {
            int howManyRead = this.masterInputStream.read(this.masterBuffer, this.firstMasterBufUnfilledBytePosition, this.masterBuffer.length - this.firstMasterBufUnfilledBytePosition);
            if (howManyRead < 0) {
                this.closeMIS();
                break;
            }
            if (howManyRead == 0) {
                int oneByte = this.masterInputStream.read();
                if (oneByte < 0) {
                    this.closeMIS();
                    break;
                }
                this.masterBuffer[this.firstMasterBufUnfilledBytePosition++] = (byte)oneByte;
                continue;
            }
            this.firstMasterBufUnfilledBytePosition += howManyRead;
        }
        this.lookForMimeBoundaryInBuffer();
        if (this.peekForDashes()) {
            this.closeMIS();
        }
    }
}

