/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.util.AuthToken;
import com.filenet.apiimpl.util.UniToken;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.UsernameToken;

public class WSICredential {
    private Security securityData = new Security();
    private int hash = 0;

    public WSICredential(String userName, String password) {
        this.securityData.UsernameToken = new UsernameToken();
        this.securityData.UsernameToken.Username = userName;
        this.securityData.UsernameToken.Password = password;
    }

    public WSICredential(UniToken token) {
        this.securityData.ImpersonationToken = token;
    }

    public Security getSecurityToken() {
        return this.securityData;
    }

    public String getUserName() {
        return this.securityData.UsernameToken.Username;
    }

    public String getPassword() {
        return this.securityData.UsernameToken.Password;
    }

    public void setAuthToken(AuthToken authToken) {
        this.securityData.OpenAuthenticationToken = authToken;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WSICredential)) {
            return false;
        }
        WSICredential base = (WSICredential)object;
        if (base.securityData == null || this.securityData == null) {
            return false;
        }
        if (this.securityData.ImpersonationToken != null) {
            return this.securityData.ImpersonationToken.equals(base.securityData.ImpersonationToken);
        }
        if (base.securityData.UsernameToken == null || this.securityData.UsernameToken == null) {
            return false;
        }
        if (this.securityData.UsernameToken.Username != null && base.securityData.UsernameToken.Username == null || base.securityData.UsernameToken.Username != null && this.securityData.UsernameToken.Username == null) {
            return false;
        }
        if (this.securityData.UsernameToken.Password != null && base.securityData.UsernameToken.Password == null || base.securityData.UsernameToken.Password != null && this.securityData.UsernameToken.Password == null) {
            return false;
        }
        if (this.securityData.UsernameToken.Username != null && !this.securityData.UsernameToken.Username.equalsIgnoreCase(base.securityData.UsernameToken.Username)) {
            return false;
        }
        return this.securityData.UsernameToken.Password == null || this.securityData.UsernameToken.Password.equals(base.securityData.UsernameToken.Password);
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.securityData.ImpersonationToken != null) {
                this.hash = this.securityData.ImpersonationToken.hashCode();
            } else {
                this.hash = 17;
                this.hash = 37 * this.hash + (this.securityData.UsernameToken.Username != null ? this.securityData.UsernameToken.Username.toLowerCase().hashCode() : 0);
                this.hash = 37 * this.hash + (this.securityData.UsernameToken.Password != null ? this.securityData.UsernameToken.Password.hashCode() : 0);
            }
        }
        return this.hash;
    }

    public String toString() {
        if (this.securityData.UsernameToken != null) {
            return "WSICredential for user: " + String.valueOf(this.securityData.UsernameToken.Username);
        }
        return "WSICredential for token.";
    }
}

