/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.wsi.serialization.TokenWriter;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.InputStream;
import java.io.Writer;
import java.util.Stack;

public class TokenWriterJson
implements TokenWriter {
    private final Writer writer;
    private final String operationName;
    private Stack stk;

    public TokenWriterJson(Writer writer, String opName) {
        this.operationName = opName;
        this.stk = new Stack();
        this.writer = writer;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
        }
    }

    @Override
    public String getPrefixForNamespace(String namespace) {
        return "";
    }

    @Override
    public void setPrefixForNamespace(String prefix, String namespace) {
    }

    @Override
    public void enter(String namespace, String eltName) {
        block29: {
            try {
                if (eltName == null) {
                    return;
                }
                if ("Object".equals(eltName)) {
                    Object parent;
                    if (!this.stk.empty() && (parent = this.stk.peek()) instanceof ArrayObject && !((ArrayObject)parent).skipComma()) {
                        this.writer.write(",");
                    }
                    this.stk.push(new SingletonObject());
                    this.writer.write("{");
                    break block29;
                }
                if ("Property".equals(eltName)) {
                    if (!this.stk.empty()) {
                        Object obj = this.stk.peek();
                        if (obj instanceof SingletonObject) {
                            SingletonObject pobj = (SingletonObject)obj;
                            if (pobj.getCount() == 0) {
                                this.writer.write(",\"properties\":{");
                            } else {
                                this.writer.write(",");
                            }
                        } else if (obj instanceof ValueObject) {
                            ValueObject pobj = (ValueObject)obj;
                            if (pobj.getCount() == 0) {
                                this.writer.write(",\"properties\":{");
                            } else {
                                this.writer.write(",");
                            }
                        }
                    }
                    PropObject pobj = new PropObject();
                    this.stk.push(pobj);
                    break block29;
                }
                if ("Value".equals(eltName)) {
                    this.writer.write(",");
                    ValueObject vobj = new ValueObject();
                    Object obj = this.stk.peek();
                    if (obj instanceof PropObject) {
                        PropObject pobj = (PropObject)obj;
                        if (!pobj.isProcessingValueTag()) {
                            this.writer.write("\"value\":");
                            if (pobj.isEnumOfObject() || pobj.isListOfString() || pobj.isListOfObject()) {
                                this.writer.write("[");
                            }
                            pobj.setProcessingValueTag(true);
                        }
                        if (pobj.isSingletonObject() || pobj.isEnumOfObject() || pobj.isListOfObject()) {
                            this.writer.write("{");
                            vobj.setCloseTag("}");
                        }
                    }
                    this.stk.push(vobj);
                    break block29;
                }
                if ("ObjectSet".equals(eltName)) {
                    this.stk.push(new ArrayObject());
                    this.writer.write("[");
                    break block29;
                }
                if ("CollectionTerminator".equals(eltName)) {
                    Object obj = this.stk.peek();
                    if (obj instanceof ArrayObject && !((ArrayObject)obj).skipComma()) {
                        this.writer.write(",");
                    } else if (obj instanceof PropObject) {
                        this.writer.write(",");
                        PropObject pobj = (PropObject)obj;
                        if (!pobj.isProcessingValueTag()) {
                            this.writer.write("\"value\":");
                            if (pobj.isEnumOfObject() || pobj.isListOfString()) {
                                this.writer.write("[");
                            }
                            pobj.setProcessingValueTag(true);
                        }
                    }
                    this.stk.push(new CollectionTerminatorElement());
                    this.writer.write("{");
                    this.writer.write("\"localName\":\"CollectionTerminator\",");
                    break block29;
                }
                if ("ParentReference".equals(eltName)) {
                    this.writer.write(",");
                    ValueObject vobj = new ValueObject();
                    Object obj = this.stk.peek();
                    if (obj instanceof PropObject) {
                        PropObject pobj = (PropObject)obj;
                        if (!pobj.isProcessingValueTag()) {
                            this.writer.write("\"parentRef\":");
                            pobj.setProcessingValueTag(true);
                        }
                        this.writer.write("{");
                        vobj.setCloseTag("}");
                    }
                    this.stk.push(vobj);
                    break block29;
                }
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"Not implemented for elementType: " + eltName});
            }
            catch (Throwable t) {
                throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
            }
        }
    }

    @Override
    public String registerAttachment(int attachmentMode, InputStream stream) {
        throw new UnsupportedOperationException(this.getClass().getName() + ": registerAttachement is not supported.");
    }

    @Override
    public void writeAttribute(String namespace, String attrName, String attrValue) {
        block11: {
            try {
                if (this.stk.empty()) {
                    return;
                }
                Object obj = this.stk.peek();
                if (obj instanceof PropObject) {
                    PropObject pobj = (PropObject)obj;
                    if (attrName.equals("type")) {
                        pobj.setType(attrValue);
                    } else if ("propertyId".equals(attrName)) {
                        pobj.setPropId(attrValue);
                        this.writer.write("\"" + attrValue + "\":{");
                        this.writer.write("\"type\":\"" + pobj.getType() + "\"");
                    } else {
                        this.writer.write(",");
                        this.writer.write("\"" + attrName + "\":\"" + TokenWriterJson.escapeChars(attrValue) + "\"");
                    }
                    break block11;
                }
                if (obj instanceof ArrayObject) break block11;
                if (obj instanceof CommaSeperatedObject) {
                    CommaSeperatedObject sobj = (CommaSeperatedObject)obj;
                    if (sobj.skipComma()) {
                        this.writer.write("\"" + attrName + "\":\"" + TokenWriterJson.escapeChars(attrValue) + "\"");
                        sobj.setSkipComma(false);
                    } else {
                        this.writer.write(",");
                        this.writer.write("\"" + attrName + "\":\"" + TokenWriterJson.escapeChars(attrValue) + "\"");
                    }
                    break block11;
                }
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"unexpected. should never get here."});
            }
            catch (Throwable t) {
                throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
            }
        }
    }

    @Override
    public void writeContent(String contentValue) {
        try {
            this.writer.write("\"" + TokenWriterJson.escapeChars(contentValue) + "\"");
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
        }
    }

    @Override
    public void leave() {
        block20: {
            try {
                if (this.stk.empty()) {
                    return;
                }
                Object obj = this.stk.pop();
                if (obj instanceof SingletonObject) {
                    Object parent;
                    SingletonObject so = (SingletonObject)obj;
                    if (so.getCount() > 0) {
                        this.writer.write("}");
                    }
                    if (!this.stk.empty() && (parent = this.stk.peek()) instanceof ArrayObject) {
                        ((ArrayObject)parent).setSkipComma(false);
                    }
                    this.writer.write("}");
                    break block20;
                }
                if (obj instanceof ArrayObject) {
                    Object o1;
                    this.writer.write("]");
                    if (!this.stk.empty() && (o1 = this.stk.peek()) instanceof PropObject && ((PropObject)o1).isProcessingValueTag && ((PropObject)o1).isListOfString()) {
                        ((PropObject)o1).setProcessingValueTag(false);
                    }
                    break block20;
                }
                if (obj instanceof PropObject) {
                    PropObject pObj = (PropObject)obj;
                    if (pObj.isProcessingValueTag()) {
                        pObj.setProcessingValueTag(false);
                        if (pObj.isListOfString() || pObj.isEnumOfObject() || pObj.isListOfObject()) {
                            this.writer.write("]");
                        }
                    }
                    this.writer.write("}");
                    if (!this.stk.empty()) {
                        Object sobj = this.stk.peek();
                        if (sobj instanceof SingletonObject) {
                            SingletonObject so = (SingletonObject)sobj;
                            so.counting();
                        } else if (sobj instanceof ValueObject) {
                            ValueObject so = (ValueObject)sobj;
                            so.counting();
                        }
                    }
                    break block20;
                }
                if (obj instanceof ValueObject) {
                    String ctag;
                    ArrayObject aobj;
                    Object o;
                    ValueObject vobj = (ValueObject)obj;
                    if (vobj.getCount() > 0) {
                        this.writer.write("}");
                    }
                    if ((o = this.stk.peek()) instanceof ArrayObject && !(aobj = (ArrayObject)o).skipComma()) {
                        this.writer.write(",");
                    }
                    if ((ctag = vobj.getCloseTag()) != null && !"".equals(ctag)) {
                        this.writer.write(ctag);
                    }
                    break block20;
                }
                if (obj instanceof CollectionTerminatorElement) {
                    this.writer.write("}");
                    break block20;
                }
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"unexpected. should never get here."});
            }
            catch (Throwable t) {
                throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
            }
        }
    }

    public void startDocument() {
        try {
            this.writer.write("{\"data\":");
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
        }
    }

    public void endDocument() {
        try {
            this.writer.write("}");
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_PARSING_JSON, null, null, null);
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    private static String escapeChars(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"' || c == '/') {
                sb.append("\\").append(c);
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static class CollectionTerminatorElement
    extends CommaSeperatedObject {
        private CollectionTerminatorElement() {
        }
    }

    private static class SingletonObject
    extends PropertyCountingObject {
        private SingletonObject() {
        }
    }

    private static class ArrayObject
    extends CommaSeperatedObject {
        private ArrayObject() {
        }
    }

    private static class ValueObject
    extends PropertyCountingObject {
        private String closeTag = "";

        public void setCloseTag(String tag) {
            this.closeTag = tag;
        }

        public String getCloseTag() {
            return this.closeTag;
        }
    }

    private static class PropObject {
        private String type;
        private String propId;
        private boolean isProcessingValueTag = false;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPropId() {
            return this.propId;
        }

        public void setPropId(String propId) {
            this.propId = propId;
        }

        public void setProcessingValueTag(boolean b) {
            this.isProcessingValueTag = b;
        }

        public boolean isProcessingValueTag() {
            return this.isProcessingValueTag;
        }

        public boolean isSingletonObject() {
            return this.type.equals("SingletonObject");
        }

        public boolean isEnumOfObject() {
            return this.type.equals("EnumOfObject");
        }

        public boolean isListOfObject() {
            return this.type.equals("ListOfObject");
        }

        public boolean isListOfString() {
            return this.type.equals("ListOfString") || this.type.equals("ListOfBoolean") || this.type.equals("ListOfBinary") || this.type.equals("ListOfDateTime") || this.type.equals("ListOfFloat64") || this.type.equals("ListOfId") || this.type.equals("ListOfInteger32") || this.type.equals("Enum");
        }
    }

    private static class PropertyCountingObject
    extends CommaSeperatedObject {
        private int propertyCount = 0;

        public void counting() {
            ++this.propertyCount;
        }

        public int getCount() {
            return this.propertyCount;
        }
    }

    private static class CommaSeperatedObject {
        private boolean needSkipComma = true;

        private CommaSeperatedObject() {
        }

        public boolean skipComma() {
            return this.needSkipComma;
        }

        public void setSkipComma(boolean b) {
            this.needSkipComma = b;
        }
    }
}

