/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.transport.comm.StorageDeviceContentOpRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.StorageDeviceRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.property.ContentSerialization;

public class StorageDeviceContentOpRequestSerialization
extends StorageDeviceRequestSerialization {
    public static final StorageDeviceContentOpRequestSerialization INSTANCE = new StorageDeviceContentOpRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        StorageDeviceContentOpRequest request = (StorageDeviceContentOpRequest)object;
        context.writeAttribute("operation", request.getOperation().name());
        context.writeAttribute("deleteMethod", Util.toIntString(request.getDeleteMethod()));
        context.writeAttribute("validateSignature", Util.toBooleanString(request.getValidateSignature()));
        context.writeAttribute("logWarningForMissingContent", Util.toBooleanString(request.getLogWarningForMissingContent()));
        context.writeAttribute("autoRepairWithinReplica", Util.toBooleanString(request.getAutoRepairWithinReplica()));
        context.writeAttribute("validateContent", Util.toBooleanString(request.getValidateContent()));
        context.writeAttribute("size", Util.toUnsignedLongString(request.getContentSize()));
        context.writeAttribute("compressedSize", Util.toUnsignedLongString(request.getCompressedSize()));
        context.writeAttribute("keyIndex", Util.toIntString(request.getKeyIndex()));
        context.writeAttribute("nonce", Util.toBase64BinaryString(request.getNonce()));
        context.writeAttribute("signature", Util.toBase64BinaryString(request.getContentSignature()));
        context.writeAttribute("isTrueSHA", Util.toBooleanString(request.getIsTrueSHA()));
        context.writeAttribute("asyncReplication", Util.toBooleanString(request.getAsyncReplication()));
        super.serialize(object, context);
        if (StorageDeviceContentOpRequest.Operation.CREATE_CONTENT == request.getOperation()) {
            context.enterElement("Content", null);
            ContentSerialization.INSTANCE.serializeStream(context, request.getContent());
            context.leaveElement();
        }
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        StorageDeviceContentOpRequest request = (StorageDeviceContentOpRequest)object;
        String operation = context.getAttribute("operation");
        if (StorageDeviceContentOpRequest.Operation.CREATE_CONTENT.name().equals(operation)) {
            request.setOperation(StorageDeviceContentOpRequest.Operation.CREATE_CONTENT);
        } else if (StorageDeviceContentOpRequest.Operation.RETRIEVE_CONTENT.name().equals(operation)) {
            request.setOperation(StorageDeviceContentOpRequest.Operation.RETRIEVE_CONTENT);
        } else if (StorageDeviceContentOpRequest.Operation.BACKOUT_CONTENT.name().equals(operation)) {
            request.setOperation(StorageDeviceContentOpRequest.Operation.BACKOUT_CONTENT);
        } else if (StorageDeviceContentOpRequest.Operation.DELETE_CONTENT.name().equals(operation)) {
            request.setOperation(StorageDeviceContentOpRequest.Operation.DELETE_CONTENT);
        } else if (StorageDeviceContentOpRequest.Operation.VALIDATE_CONTENT.name().equals(operation)) {
            request.setOperation(StorageDeviceContentOpRequest.Operation.VALIDATE_CONTENT);
        } else {
            context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, (Object)new Object[]{operation});
        }
        Integer deleteMethod = Util.parseInteger(context.getAttribute("deleteMethod"));
        request.setDeleteMethod(deleteMethod);
        Boolean validateSignature = Util.parseBoolean(context.getAttribute("validateSignature"));
        request.setValidateSignature(validateSignature);
        Boolean logWarningForMissingContent = Util.parseBoolean(context.getAttribute("logWarningForMissingContent"));
        request.setLogWarningForMissingContent(logWarningForMissingContent);
        Boolean validateContent = Util.parseBoolean(context.getAttribute("validateContent"));
        request.setValidateContent(validateContent);
        Boolean autoRepairWithinReplica = Util.parseBoolean(context.getAttribute("autoRepairWithinReplica"));
        request.setAutoRepairWithinReplica(autoRepairWithinReplica);
        Long contentSize = Util.parseLong(context.getAttribute("size"));
        request.setContentSize(contentSize);
        Long compressedSize = Util.parseLong(context.getAttribute("compressedSize"));
        request.setCompressedSize(compressedSize);
        Integer keyIndex = Util.parseInteger(context.getAttribute("keyIndex"));
        request.setKeyIndex(keyIndex);
        byte[] nonce = Util.parseBase64Binary(context.getAttribute("nonce"));
        request.setNonce(nonce);
        byte[] contentSignature = Util.parseBase64Binary(context.getAttribute("signature"));
        Boolean isTrueSHA = Util.parseBoolean(context.getAttribute("isTrueSHA"));
        request.setContentSignature(contentSignature, isTrueSHA);
        Boolean asyncReplication = Util.parseBoolean(context.getAttribute("asyncReplication"));
        request.setAsyncReplication(asyncReplication);
        super.deserialize(object, context);
        if (context.isStartToken("Content")) {
            ClientInputStream content = ContentSerialization.INSTANCE.deserializeStream(context, null, null, null, null, null, null);
            request.setContent(content);
            context.checkEndToken();
            context.nextElementToken();
        }
        return null;
    }
}

