/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.comm.StorageDeviceContentOpResponse;
import com.filenet.apiimpl.transport.comm.StorageDeviceOpFailure;
import com.filenet.apiimpl.transport.comm.StorageDeviceOpResponse;
import com.filenet.apiimpl.transport.comm.StorageDeviceOpSuccess;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.CommResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import com.filenet.apiimpl.wsi.serialization.property.ContentSerialization;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class StorageDeviceContentOpResponseSerialization
extends CommResponseSerialization {
    private static final TransportLogger logger = TransportLogger.getLogger(StorageDeviceContentOpResponseSerialization.class, SubSystem.ServerCommunication);
    public static final StorageDeviceContentOpResponseSerialization INSTANCE = new StorageDeviceContentOpResponseSerialization();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        StorageDeviceContentOpResponse response = (StorageDeviceContentOpResponse)object;
        context.writeAttribute("id", response.getCorrelationId());
        if (response.getValue() instanceof EngineRuntimeException) {
            context.writeSchemaType("CommErrorResponseType");
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, response.getValue());
            return;
        } else {
            context.writeSchemaType("StorageDeviceResponseType");
            context.writeAttribute("storageAreaId", Util.toIdString(response.getStorageAreaId()));
            context.writeAttribute("contentId", Util.toIdString(response.getContentId()));
            context.writeAttribute("size", Util.toUnsignedLongString(response.getContentSize()));
            List<StorageDeviceOpResponse> storageDeviceOpResponse = response.getResponses();
            for (StorageDeviceOpResponse opResponse : storageDeviceOpResponse) {
                String opResponseType = "StorageDeviceOpSuccessType";
                if (opResponse instanceof StorageDeviceOpSuccess) {
                    opResponseType = "StorageDeviceOpSuccessType";
                } else {
                    if (!(opResponse instanceof StorageDeviceOpFailure)) throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{"StorageDeviceResponseType: " + opResponse.getClass().getName() + "; value=" + String.valueOf(opResponse)});
                    StorageDeviceOpFailure opFailure = (StorageDeviceOpFailure)opResponse;
                    opResponseType = opFailure.getEx() != null ? "CommErrorResponseType" : "ContentOpFailureType";
                }
                context.enterElement("StorageDeviceOpResponse", opResponseType);
                context.writeAttribute("storageDeviceId", Util.toIdString(opResponse.getStorageDeviceId()));
                context.writeAttribute("externalIdentity", opResponse.getExternalIdentity());
                if (opResponseType == "StorageDeviceOpSuccessType") {
                    StorageDeviceOpSuccess successResponse = (StorageDeviceOpSuccess)opResponse;
                    Object returnVal = successResponse.getReturnVal();
                    if (returnVal != null) {
                        if (returnVal instanceof Boolean) {
                            context.writeElement("ReturnValue", "boolean", Util.toBooleanString((Boolean)returnVal));
                        } else if (returnVal instanceof Long) {
                            context.writeElement("ReturnValue", "long", Util.toUnsignedLongString((Long)returnVal));
                        } else if (returnVal instanceof Integer) {
                            context.writeElement("ReturnValue", "int", Util.toIntString((Integer)returnVal));
                        } else if (returnVal instanceof String) {
                            context.writeElement("ReturnValue", "string", (String)returnVal);
                        } else {
                            if (!(returnVal instanceof InputStream)) throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{"returnVal: " + returnVal.getClass().getName()});
                            context.enterElement("ReturnValue", "InputStreamType");
                            context.enterElement("Content");
                            ContentSerialization.INSTANCE.serializeStream(context, (InputStream)returnVal);
                            context.leaveElement();
                            context.leaveElement();
                        }
                    }
                } else if (opResponseType == "CommErrorResponseType") {
                    context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, (Object)((StorageDeviceOpFailure)opResponse).getEx());
                } else if (opResponseType == "ContentOpFailureType") {
                    Object[] failureDetails;
                    for (Object failureDetail : failureDetails = ((StorageDeviceOpFailure)opResponse).getFailureDetails()) {
                        if (failureDetail == null) continue;
                        if (failureDetail instanceof Long) {
                            context.writeElement("FailureDetail", "long", Util.toUnsignedLongString((Long)failureDetail));
                            continue;
                        }
                        if (failureDetail instanceof Integer) {
                            context.writeElement("FailureDetail", "int", Util.toIntString((Integer)failureDetail));
                            continue;
                        }
                        context.writeElement("FailureDetail", "string", String.valueOf(failureDetail));
                    }
                }
                context.leaveElement();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        StorageDeviceContentOpResponse response = (StorageDeviceContentOpResponse)object;
        String correlationId = context.getAttribute("id");
        response.setCorrelationId(correlationId);
        String type = context.getXsiType();
        Object value = null;
        if (type.equals("ContentErrorResponse")) {
            context.nextElementToken();
            value = context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
            response.putValue(value);
        } else if (type.equals("StorageDeviceResponseType")) {
            Id storageAreaId = Util.parseId(context.getAttribute("storageAreaId"));
            response.setStorageAreaId(storageAreaId);
            Id contentId = Util.parseId(context.getAttribute("contentId"));
            response.setContentId(contentId);
            Long contentSize = Util.parseLong(context.getAttribute("size"));
            response.setContentSize(contentSize);
            while (Util.isStartToken(context.nextElementToken())) {
                String externalIdentity;
                Id storageDeviceId;
                StorageDeviceOpResponse opResponse = null;
                type = context.getXsiType();
                if (type.equals("StorageDeviceOpSuccessType")) {
                    opResponse = new StorageDeviceOpSuccess();
                    storageDeviceId = Util.parseId(context.getAttribute("storageDeviceId"));
                    opResponse.setStorageDeviceId(storageDeviceId);
                    externalIdentity = context.getAttribute("externalIdentity");
                    if (externalIdentity != null) {
                        opResponse.setExternalIdentity(externalIdentity);
                    }
                    context.nextElementToken();
                    if (context.isStartToken("ReturnValue")) {
                        String retvalType = context.getXsiType();
                        if (retvalType.equals("InputStreamType")) {
                            context.nextElementToken();
                            value = ContentSerialization.INSTANCE.deserializeStream(context, (ConnectionImpl)context.getConnection(), null, -1, null, contentSize, null);
                            ((StorageDeviceOpSuccess)opResponse).setReturnVal(value);
                            context.checkEndToken();
                            context.nextElementToken();
                            context.nextElementToken();
                        } else {
                            Comparable<Boolean> val;
                            String retval = context.readElement();
                            if (retvalType.equals("boolean")) {
                                val = Util.parseBoolean(retval);
                                ((StorageDeviceOpSuccess)opResponse).setReturnVal(val);
                            } else if (retvalType.equals("long")) {
                                val = Util.parseLong(retval);
                                ((StorageDeviceOpSuccess)opResponse).setReturnVal(val);
                            } else if (retvalType.equals("int")) {
                                val = Util.parseInteger(retval);
                                ((StorageDeviceOpSuccess)opResponse).setReturnVal(val);
                            } else {
                                if (!retvalType.equals("string")) throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{"return type: " + retvalType + "; value: " + String.valueOf(retval)});
                                ((StorageDeviceOpSuccess)opResponse).setReturnVal(retval);
                            }
                        }
                    }
                } else {
                    opResponse = new StorageDeviceOpFailure();
                    storageDeviceId = Util.parseId(context.getAttribute("storageDeviceId"));
                    opResponse.setStorageDeviceId(storageDeviceId);
                    externalIdentity = context.getAttribute("externalIdentity");
                    if (externalIdentity != null) {
                        opResponse.setExternalIdentity(externalIdentity);
                    }
                    if (type.equals("CommErrorResponseType")) {
                        context.nextElementToken();
                        Object ex = context.deserializeObject("ErrorStack", ExceptionSerialization.INSTANCE, null);
                        EngineRuntimeException ert = null;
                        if (ex instanceof EngineRuntimeException) {
                            ert = (EngineRuntimeException)ex;
                        } else if (ex instanceof Exception) {
                            ert = new EngineRuntimeException((Exception)ex, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                        } else {
                            String className = ex.getClass().getName();
                            String err = "Unknown error response.  Class: " + className + "; Error: " + String.valueOf(ex);
                            ert = new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{err});
                        }
                        ((StorageDeviceOpFailure)opResponse).setEx(ert);
                    } else if (type.equals("ContentOpFailureType")) {
                        context.nextElementToken();
                        LinkedList<Boolean> failureDetail = new LinkedList<Boolean>();
                        while (context.isStartToken("FailureDetail")) {
                            String failureType = context.getXsiType();
                            String failureVal = context.readElement();
                            Object val = null;
                            if (failureType.equals("boolean")) {
                                val = Util.parseBoolean(failureVal);
                            } else if (failureType.equals("long")) {
                                val = Util.parseLong(failureVal);
                            } else if (failureType.equals("int")) {
                                val = Util.parseInteger(failureVal);
                            } else {
                                if (!failureType.equals("string")) throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{"return type: " + failureType + "; value: " + String.valueOf(failureVal)});
                                val = failureVal;
                            }
                            failureDetail.add((Boolean)val);
                        }
                        Object[] failureDetails = failureDetail.toArray();
                        ((StorageDeviceOpFailure)opResponse).setFailureDetails(failureDetails);
                    } else {
                        EngineRuntimeException ert = new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_BAD_DATA_TYPE, new Object[]{type});
                        ((StorageDeviceOpFailure)opResponse).setEx(ert);
                        context.nextElementToken();
                    }
                }
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("StorageDeviceContentOpResponse: adding operation response: " + opResponse);
                }
                response.addResponse(opResponse);
                context.checkEndToken();
            }
        }
        if (!logger.isDetailTraceEnabled()) return response;
        logger.traceDetail("Server Communication response: " + response);
        return response;
    }
}

