/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.comm;

import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.comm.StorageDeviceOpRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.CommSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;

public class StorageDeviceOpRequestSerialization
extends CommSerialization {
    public static final StorageDeviceOpRequestSerialization INSTANCE = new StorageDeviceOpRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        super.serialize(object, context);
        StorageDeviceOpRequest request = (StorageDeviceOpRequest)object;
        context.writeAttribute("operation", request.getOperation().name());
        if (request.getStorageDeviceId() != null) {
            context.writeElement("StorageDeviceId", "GuidType", Util.toIdString(request.getStorageDeviceId()));
        }
        if (request.getEngineObject() != null) {
            context.enterElement("Object");
            EngineObjectSerialization.INSTANCE.serialize(request.getEngineObject(), true, context);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        super.deserialize(object, context);
        StorageDeviceOpRequest request = (StorageDeviceOpRequest)object;
        String operation = context.getAttribute("operation");
        if (StorageDeviceOpRequest.Operation.CREATE_PHASE1.name().equals(operation)) {
            request.setOperation(StorageDeviceOpRequest.Operation.CREATE_PHASE1);
        } else if (StorageDeviceOpRequest.Operation.CREATE_PHASE2.name().equals(operation)) {
            request.setOperation(StorageDeviceOpRequest.Operation.CREATE_PHASE2);
        } else if (StorageDeviceOpRequest.Operation.VALIDATE_ACCESS.name().equals(operation)) {
            request.setOperation(StorageDeviceOpRequest.Operation.VALIDATE_ACCESS);
        } else {
            context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, (Object)new Object[]{operation});
        }
        context.nextElementToken();
        String xsiType = context.getXsiType();
        if (xsiType.equals("GuidType")) {
            Id storageDeviceId = Util.parseId(context.readElement("StorageDeviceId"));
            request.setStorageDeviceId(storageDeviceId);
        }
        if (context.isStartToken()) {
            xsiType = context.getXsiType();
            if (xsiType.equals("ObjectValue")) {
                PropertyDeserializerCall call = new PropertyDeserializerCall((ObjectReferenceBase)null);
                EngineObjectImpl engObj = (EngineObjectImpl)EngineObjectSerialization.INSTANCE.deserialize(call, context);
                request.setEngineObject(engObj);
                context.checkEndToken();
                context.nextElementToken();
            } else {
                context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, (Object)new Object[]{xsiType});
            }
        }
        context.checkEndToken();
        return null;
    }
}

