/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;

public class CollectionTerminatorSerialization
extends Serialization {
    public static final CollectionTerminatorSerialization INSTANCE = new CollectionTerminatorSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        if (object instanceof EngineRuntimeException) {
            context.writeSchemaType("TraversalError");
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, object);
        } else if (Util.emptyAsNull((String)object) == null) {
            context.writeSchemaType("EndOfCollection");
        } else {
            context.writeSchemaType("EndOfPage");
            context.writeAttribute("continueFrom", (String)object);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        String continuation = Util.emptyAsNull(context.getAttribute("continueFrom"));
        if (Util.isEndToken(context.nextElementToken())) {
            return continuation;
        }
        return (EngineRuntimeException)context.deserializeObject(ExceptionSerialization.INSTANCE, null);
    }
}

