/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.comm.CommBatchRequest;
import com.filenet.apiimpl.transport.comm.CommRequest;
import com.filenet.apiimpl.transport.comm.StorageDeviceContentOpRequest;
import com.filenet.apiimpl.transport.comm.StorageDeviceOpRequest;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.comm.CommSerialization;
import com.filenet.apiimpl.wsi.serialization.comm.StorageDeviceContentOpRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.comm.StorageDeviceOpRequestSerialization;
import java.util.ArrayList;

public class CommBatchRequestSerialization
extends Serialization {
    private static final TransportLogger logger = TransportLogger.getLogger(CommBatchRequestSerialization.class, SubSystem.WSI);
    public static final CommBatchRequestSerialization INSTANCE = new CommBatchRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        CommBatchRequest gcr = (CommBatchRequest)object;
        CommRequest[] batch = gcr.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            CommRequest request = batch[i];
            if (request instanceof StorageDeviceContentOpRequest) {
                context.serializeObject("StorageDeviceContentOpType", request.getClass(), (Object)request);
                continue;
            }
            if (request instanceof StorageDeviceOpRequest) {
                context.serializeObject("StorageDeviceOpType", request.getClass(), (Object)request);
                continue;
            }
            if (request instanceof CommRequest) {
                context.serializeObject("CommRequestType", request.getClass(), (Object)request);
                context.leaveElement();
                continue;
            }
            logger.error("CommBatchRequestSerialization: Unknown request type: " + request);
            throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ArrayList<StorageDeviceContentOpRequest> requests = new ArrayList<StorageDeviceContentOpRequest>();
        String curToken = "";
        curToken = context.getLocalName();
        context.nextElementToken();
        curToken = context.getLocalName();
        while (true) {
            if (!Util.isStartToken(context.getTokenType())) break;
            CommRequest request = null;
            if (context.isStartToken("StorageDeviceContentOpType")) {
                request = new StorageDeviceContentOpRequest();
                context.deserializeObject("StorageDeviceContentOpType", StorageDeviceContentOpRequestSerialization.INSTANCE, request);
            } else if (context.isStartToken("StorageDeviceOpType")) {
                request = new StorageDeviceOpRequest();
                context.deserializeObject("StorageDeviceOpType", StorageDeviceOpRequestSerialization.INSTANCE, request);
            } else if (context.isStartToken("CommRequestType")) {
                request = new CommRequest();
                context.deserializeObject("CommRequestType", CommSerialization.INSTANCE, request);
                context.nextElementToken();
            } else {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "CommRequestType");
            }
            requests.add((StorageDeviceContentOpRequest)request);
            curToken = context.getLocalName();
        }
        context.getLocalName();
        context.checkEndToken();
        CommRequest[] batch = requests.toArray(new CommRequest[requests.size()]);
        CommBatchRequest batchRequest = new CommBatchRequest(batch);
        return batchRequest;
    }
}

