/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.ContentElementInfoData;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;

public class GetContentRequestSerialization
extends Serialization {
    public static final GetContentRequestSerialization INSTANCE = new GetContentRequestSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        GetContentRequest gcr = (GetContentRequest)object;
        if (gcr.getValidateOnly()) {
            context.writeAttribute("validateOnly", Util.toBooleanString(Boolean.TRUE));
        }
        ContentRequest[] batch = gcr.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ContentRequest request = batch[i];
            context.enterElement("ContentRequest", null);
            context.writeAttribute("id", request.getCorrelationId());
            context.writeAttribute("cacheAllowed", Util.toBooleanString(request.getCacheAllowed()));
            context.writeAttribute("continueFrom", request.getContinueFrom());
            context.writeAttribute("startOffset", Util.toUnsignedLongString(request.getStartOffset()));
            context.writeAttribute("maxBytes", Util.toIntString(request.getMaxBytes()));
            context.serializeReference("SourceSpecification", request.getObjectReference());
            context.enterElement("ElementSpecification", null);
            context.writeAttribute("itemIndex", Util.toIntString(request.getItemIndex()));
            context.writeAttribute("elementSequenceNumber", Util.toIntString(request.getElementSequenceNumber()));
            context.leaveElement();
            ContentElementInfoData ceiData = request.getContentElementInfoData();
            if (ceiData != null) {
                context.enterElement("ContentElementInfoData", null);
                context.writeAttribute("contentId", Util.toIdString(ceiData.getUploadId()));
                context.writeAttribute("size", Util.toUnsignedLongString(ceiData.getSize()));
                context.writeAttribute("signature", Util.toBase64BinaryString(ceiData.getSignature()));
                context.writeAttribute("isTrueSHA", Util.toBooleanString(ceiData.getIsTrueSHA()));
                context.writeAttribute("isSiS", Util.toBooleanString(ceiData.getSingleInstanced()));
                context.writeAttribute("keyIndex", Util.toIntString(ceiData.getKeyIndex()));
                context.writeAttribute("nonce", Util.toBase64BinaryString(ceiData.getNonce()));
                context.writeAttribute("compressedSize", Util.toUnsignedLongString(ceiData.getCompressedSize()));
                context.writeAttribute("databaseType", Util.toIntString(ceiData.getDatabaseType()));
                context.writeAttribute("storageAreaId", Util.toIdString(ceiData.getStorageAreaId()));
                context.writeAttribute("isUpgraded", Util.toBooleanString(ceiData.getIsUpgradedObject()));
                context.writeAttribute("classId", Util.toIdString(ceiData.getClassId()));
                context.writeAttribute("referralBlob", Util.toBase64BinaryString(ceiData.getReferralBlob()));
                if (ceiData.getRetrievalName() != null) {
                    context.writeAttribute("retrievalName", Util.toBase64BinaryString(ceiData.getRetrievalName().getBytes("UTF8")));
                }
                context.leaveElement();
            }
            context.leaveElement();
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Boolean validateOnly = Util.parseBoolean(context.getAttribute("validateOnly"));
        ArrayList<ContentRequest> requests = new ArrayList<ContentRequest>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) break;
            String correlationId = context.getAttribute("id");
            Boolean cacheAllowed = Util.parseBoolean(context.getAttribute("cacheAllowed"));
            String continueFrom = context.getAttribute("continueFrom");
            Long startOffset = Util.parseLong(context.getAttribute("startOffset"));
            Integer maxBytes = Util.parseInteger(context.getAttribute("maxBytes"));
            context.nextElementToken();
            ObjectReferenceBase reference = (ObjectReferenceBase)context.deserializeObject("SourceSpecification", ObjectReferenceSerialization.INSTANCE, null);
            Integer itemIndex = null;
            Integer elementSequenceNumber = null;
            if (!context.isStartToken("ElementSpecification")) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "ElementSpecification");
            }
            itemIndex = Util.parseInteger(context.getAttribute("itemIndex"));
            elementSequenceNumber = Util.parseInteger(context.getAttribute("elementSequenceNumber"));
            context.nextElementToken();
            context.checkEndToken();
            context.nextElementToken();
            ContentElementInfoData ceiData = null;
            if (context.isStartToken("ContentElementInfoData")) {
                Id uploadId = Util.parseId(context.getAttribute("contentId"));
                Long size = Util.parseLong(context.getAttribute("size"));
                byte[] signature = Util.parseBase64Binary(context.getAttribute("signature"));
                Boolean isTrueSHA = Util.parseBoolean(context.getAttribute("isTrueSHA"));
                Boolean singleInstanced = Util.parseBoolean(context.getAttribute("isSiS"));
                Integer keyIndex = Util.parseInteger(context.getAttribute("keyIndex"));
                byte[] nonce = Util.parseBase64Binary(context.getAttribute("nonce"));
                Long compressedSize = Util.parseLong(context.getAttribute("compressedSize"));
                Integer databaseType = Util.parseInteger(context.getAttribute("databaseType"));
                Id storageAreaId = Util.parseId(context.getAttribute("storageAreaId"));
                Boolean isUpgradedObject = Util.parseBoolean(context.getAttribute("isUpgraded"));
                Id classId = Util.parseId(context.getAttribute("classId"));
                byte[] referralBlob = Util.parseBase64Binary(context.getAttribute("referralBlob"));
                byte[] retrievalNameBytes = Util.parseBase64Binary(context.getAttribute("retrievalName"));
                ceiData = new ContentElementInfoData();
                ceiData.setUploadId(uploadId);
                ceiData.setSize(size);
                ceiData.setSignature(signature, isTrueSHA);
                ceiData.setSingleInstanced(singleInstanced);
                ceiData.setKeyIndex(keyIndex);
                ceiData.setNonce(nonce);
                ceiData.setCompressedSize(compressedSize);
                ceiData.setDatabaseType(databaseType);
                ceiData.setStorageAreaId(storageAreaId);
                ceiData.setIsUpgradedObject(isUpgradedObject);
                ceiData.setClassId(classId);
                ceiData.setReferralBlob(referralBlob);
                if (retrievalNameBytes != null) {
                    ceiData.setRetrievalName(new String(retrievalNameBytes, "UTF8"));
                }
                context.nextElementToken();
                context.checkEndToken();
                context.nextElementToken();
            }
            context.checkEndToken();
            ContentRequest request = new ContentRequest(reference, cacheAllowed, correlationId, elementSequenceNumber, itemIndex, startOffset, maxBytes, continueFrom);
            if (ceiData != null) {
                request.setContentElementInfoData(ceiData);
            }
            requests.add(request);
        }
        context.checkEndToken();
        ContentRequest[] batch = requests.toArray(new ContentRequest[requests.size()]);
        GetContentRequest request = new GetContentRequest(batch);
        if (validateOnly != null) {
            request.setValidateOnly(validateOnly);
        }
        return request;
    }
}

