/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.DateTimeListImpl;
import com.filenet.apiimpl.property.PropertyDateTimeListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.util.ArrayList;
import java.util.Date;

public class DateTimeListSerialization
extends PropertySerialization {
    public static final DateTimeListSerialization INSTANCE = new DateTimeListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfDateTime", context.getOptionalXsdType("dateTime"), object, context);
    }

    @Override
    protected String toString(Object value) {
        return Util.toDateTimeString((Date)value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyDateTimeListImpl property = new PropertyDateTimeListImpl(call.propertyId, new DateTimeListImpl(this.readList(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<Date> values = new ArrayList<Date>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseDateTime(jsonVals.getString(i)));
            }
        }
        PropertyDateTimeListImpl property = new PropertyDateTimeListImpl(call.propertyId, new DateTimeListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseDateTime(text);
    }
}

