/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.property.PropertyDateTimeImpl;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;

public class DateTimeSerialization
extends PropertySerialization {
    public static final DateTimeSerialization INSTANCE = new DateTimeSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        PropertySerializerCall call = this.enter("SingletonDateTime", object, context);
        context.writeOptionalElement("Value", context.getOptionalXsdType("dateTime"), Util.toDateTimeString(call.property.getDateTimeValue()));
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyDateTimeImpl property = new PropertyDateTimeImpl(call.propertyId, Util.parseDateTime(this.getValueText(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        String value = json.getString("value");
        PropertyDateTimeImpl property = new PropertyDateTimeImpl(call.propertyId, Util.parseDateTime(value), call.propertyAccess);
        return this.respond(property, call);
    }
}

