/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.collection.Float64ListImpl;
import com.filenet.apiimpl.property.PropertyFloat64ListImpl;
import com.filenet.apiimpl.util.json.JSONArray;
import com.filenet.apiimpl.util.json.JSONObject;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import java.util.ArrayList;

public class Float64ListSerialization
extends PropertySerialization {
    public static final Float64ListSerialization INSTANCE = new Float64ListSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        this.serializeList("ListOfFloat64", context.getOptionalXsdType("double"), object, context);
    }

    @Override
    protected String toString(Object value) {
        return Util.toDoubleString((Double)value);
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        PropertyDeserializerCall call = this.enter(object, context);
        PropertyFloat64ListImpl property = new PropertyFloat64ListImpl(call.propertyId, new Float64ListImpl(this.readList(context)), call.propertyAccess);
        return this.leave(property, call, context);
    }

    @Override
    public Object deserializeJson(Connection connection, JSONObject json, String name, boolean hasDeltas, PropertyDeserializerCall call) {
        this.prepare(call, name, json, hasDeltas);
        ArrayList<Double> values = new ArrayList<Double>();
        JSONArray jsonVals = (JSONArray)json.get("value");
        if (jsonVals != null) {
            for (int i = 0; i < jsonVals.size(); ++i) {
                values.add(Util.parseDouble(jsonVals.getString(i)));
            }
        }
        PropertyFloat64ListImpl property = new PropertyFloat64ListImpl(call.propertyId, new Float64ListImpl(values), call.propertyAccess);
        return this.respond(property, call);
    }

    @Override
    protected Object parseValue(String text) {
        return Util.parseDouble(text);
    }
}

