/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.property;

import com.filenet.api.core.ObjectReference;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.meta.SearchScopeIdentity;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;

public class UnevaluatedCollectionSerialization
extends PropertySerialization {
    public static final UnevaluatedCollectionSerialization INSTANCE = new UnevaluatedCollectionSerialization();

    public void serialize(String propertyType, String collectionType, PropertySerializerCall call, SerializerContext context) throws Exception {
        if (context.getVersion() < 400) {
            this.enter(propertyType, call, context);
            context.leaveElement();
            return;
        }
        this.enter("UnevaluatedCollection", call, context);
        context.writeAttribute("collectionType", collectionType);
        if (call.parent == null) {
            UnevaluatedPropertyValue unevaluated = (UnevaluatedPropertyValue)call.property.getObjectReference();
            ObjectReference parent = unevaluated.getParentReference();
            context.serializeObject("ParentReference", Util.objectClass(parent), (Object)parent);
        }
        context.leaveElement();
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ObjectReferenceBase candidate;
        String objectStore;
        String collectionType = context.getAttribute("collectionType");
        boolean listType = "List".equals(collectionType);
        PropertyDeserializerCall call = this.enter(object, context);
        ObjectReferenceBase parent = null;
        boolean metaSearch = false;
        if (call.parent != null) {
            parent = (ObjectReferenceBase)call.parent.getObjectReference();
            metaSearch = parent instanceof SearchScopeIdentity;
        }
        String string = objectStore = (candidate = (ObjectReferenceBase)context.deserializeObject("ParentReference", ObjectReferenceSerialization.INSTANCE, null)) == null ? null : candidate.getObjectStoreIdentity();
        if (!(candidate == null || objectStore == null && metaSearch)) {
            parent = candidate;
        }
        UnevaluatedPropertyValue unevaluated = new UnevaluatedPropertyValue(parent, call.propertyId);
        PropertyImpl property = listType ? new PropertyEngineObjectListImpl(unevaluated, context.getConnection(), call.propertyAccess) : new PropertyEngineObjectSetImpl(unevaluated, context.getConnection(), call.propertyAccess);
        return this.leave(property, call, context);
    }
}

