/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.reference;

import com.filenet.apiimpl.core.ObjectByPath;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.wsi.serialization.Context;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ReferenceValues;

public class UnevaluatedPropertyValueSerialization
extends ObjectReferenceSerialization {
    public static final UnevaluatedPropertyValueSerialization INSTANCE = new UnevaluatedPropertyValueSerialization();

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        UnevaluatedPropertyValue reference = (UnevaluatedPropertyValue)object;
        ReferenceValues values = this.getValues(reference, context);
        context.writeSchemaType(this.getTypeName(reference, context));
        context.writeAttribute("classId", values.classId);
        context.writeAttribute("objectId", values.objectId);
        context.writeAttribute("objectStore", values.objectStore);
        context.writeAttribute("path", values.path);
        context.writeAttribute("propertyId", values.propertyId);
        context.writeAttribute("itemIndex", Util.toIntString(values.itemIndex));
        context.leaveElement();
    }

    @Override
    public String getTypeName(ObjectReferenceBase reference, Context context) {
        return "ObjectSpecification";
    }

    @Override
    public String getClassId(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        return parent != null ? parent.getClassIdentity() : null;
    }

    @Override
    public String getObjectId(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        if (parent == null || parent instanceof ObjectByPath) {
            return null;
        }
        return parent.getObjectIdentity();
    }

    @Override
    public String getObjectStore(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        if (parent == null || UnevaluatedPropertyValueSerialization.isObjectStore(parent.getClassIdentity())) {
            return null;
        }
        return parent.getObjectStoreIdentity();
    }

    @Override
    public String getPath(ObjectReferenceBase reference, Context context) {
        ObjectReferenceBase parent = this.getParent(reference);
        return parent instanceof ObjectByPath ? parent.getObjectIdentity() : null;
    }

    @Override
    public String getPropertyId(ObjectReferenceBase reference, Context context) {
        return ((UnevaluatedPropertyValue)reference).getPropertyName();
    }

    @Override
    public Integer getItemIndex(ObjectReferenceBase reference, Context context) {
        return ((UnevaluatedPropertyValue)reference).getIndex();
    }

    @Override
    public ReferenceValues getValues(ObjectReferenceBase reference, Context context) {
        UnevaluatedPropertyValue unevaluated = (UnevaluatedPropertyValue)reference;
        ObjectReferenceBase parent = (ObjectReferenceBase)unevaluated.getParentReference();
        ReferenceValues values = new ReferenceValues();
        if (parent != null) {
            values.classId = parent.getClassIdentity();
            if (parent instanceof ObjectByPath) {
                values.path = parent.getObjectIdentity();
            } else {
                values.objectId = parent.getObjectIdentity();
            }
            if (!UnevaluatedPropertyValueSerialization.isObjectStore(values.classId)) {
                values.objectStore = parent.getObjectStoreIdentity();
            }
        }
        values.propertyId = unevaluated.getPropertyName();
        values.itemIndex = unevaluated.getIndex();
        return values;
    }

    @Override
    public ObjectReferenceBase getParent(ObjectReferenceBase reference) {
        return (ObjectReferenceBase)((UnevaluatedPropertyValue)reference).getParentReference();
    }
}

